package com.ejianc.business.pro.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.UpdateLevelEnum;
import com.ejianc.business.pro.income.bean.*;
import com.ejianc.business.pro.income.mapper.ClaimMapper;
import com.ejianc.business.pro.income.mapper.ContractRegisterMapper;
import com.ejianc.business.pro.income.service.*;
import com.ejianc.business.pro.income.utils.CommonUtils;
import com.ejianc.business.pro.income.utils.MathUtil;
import com.ejianc.business.pro.income.vo.ClaimRecordVO;
import com.ejianc.business.pro.income.vo.ClaimVO;
import com.ejianc.business.pro.income.vo.ReportVO;
import com.ejianc.business.pro.other.bean.OtherContractEntity;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.sun.org.apache.regexp.internal.RE;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 洽商签证索赔
 * 
 * @author generator
 * 
 */
@Service("claimService")
public class ClaimServiceImpl extends BaseServiceImpl<ClaimMapper, ClaimEntity> implements IClaimService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IContractRegisterService registerService;

    @Autowired
    private IClaimService claimService;

    @Autowired
    private IProductionService productionService;

    @Autowired
    private IQuoteService quoteService;

    @Autowired
    private IFinalizedService finalizedService;
    @Autowired
    private ContractRegisterMapper contractRegisterMapper;





    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private IContractRegisterService contractRegisterService;
    
    @Override
    public ClaimRecordVO queryRecordByContractId(Long contractId) {
        ContractRegisterEntity entity = registerService.selectById(contractId);
        ClaimRecordVO claimRecordVO = new ClaimRecordVO();
        claimRecordVO.setChangeStatus(entity.getChangeStatus());
        claimRecordVO.setIsFinish(entity.getIsFinish());
        claimRecordVO.setIsRelieve(entity.getIsRelieve());
        claimRecordVO.setIsSuspend(entity.getIsSuspend());

        LambdaUpdateWrapper<ClaimEntity> wrapper = new LambdaUpdateWrapper();
        wrapper.eq(ClaimEntity::getContractId,contractId);
        wrapper.eq(ClaimEntity::getDr,0);
        wrapper.in(ClaimEntity::getBillState,1,3);
        wrapper.eq(ClaimEntity::getTenantId, InvocationInfoProxy.getTenantid());
        List<ClaimEntity> list = this.list(wrapper);

        BigDecimal sumNegotiateMny = BigDecimal.ZERO; //变更洽商总金额(无税)
        BigDecimal sumNegotiateTaxMny = BigDecimal.ZERO; //变更洽商总金额

        BigDecimal sumVisaMny = BigDecimal.ZERO; //经济签证总金额(无税)
        BigDecimal sumVisaTaxMny= BigDecimal.ZERO; //经济签证总金额

        BigDecimal sumClaimMny = BigDecimal.ZERO; //索赔总金额(无税)
        BigDecimal sumClaimTaxMny = BigDecimal.ZERO; //索赔总金额

        BigDecimal sumMny = BigDecimal.ZERO; //二次经营总金额(无税)
        BigDecimal sumTaxMny = BigDecimal.ZERO; //二次经营总金额

        List<ClaimVO> claimVOS = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)){
            claimVOS = BeanMapper.mapList(list, ClaimVO.class);

            for (ClaimVO vo: claimVOS){
                if ("QS".equals(vo.getBillType())){
                    vo.setBillType("变更洽商单");
                    sumNegotiateMny = MathUtil.safeAdd(sumNegotiateMny,vo.getClaimMny());
                    sumNegotiateTaxMny = MathUtil.safeAdd(sumNegotiateTaxMny,vo.getClaimTaxMny());
                }else if("QZ".equals(vo.getBillType())){
                    vo.setBillType("经济签证单");
                    sumVisaMny = MathUtil.safeAdd(sumVisaMny,vo.getClaimMny());
                    sumVisaTaxMny = MathUtil.safeAdd(sumVisaTaxMny,vo.getClaimTaxMny());
                }else if("SP".equals(vo.getBillType())){
                    vo.setBillType("索赔单");
                    sumClaimMny = MathUtil.safeAdd(sumClaimMny,vo.getClaimMny());
                    sumClaimTaxMny = MathUtil.safeAdd(sumClaimTaxMny,vo.getClaimTaxMny());
                }
                sumMny = MathUtil.safeAdd(sumMny,vo.getClaimMny());
                sumTaxMny = MathUtil.safeAdd(sumTaxMny,vo.getClaimTaxMny());
            }
        }
        claimRecordVO.setContractId(contractId);

        claimRecordVO.setSumNegotiateMny(sumNegotiateMny);
        claimRecordVO.setSumNegotiateTaxMny(sumNegotiateTaxMny);

        claimRecordVO.setSumVisaMny(sumVisaMny);
        claimRecordVO.setSumVisaTaxMny(sumVisaTaxMny);

        claimRecordVO.setSumClaimMny(sumClaimMny);
        claimRecordVO.setSumClaimTaxMny(sumClaimTaxMny);

        claimRecordVO.setSumMny(sumMny);
        claimRecordVO.setSumTaxMny(sumTaxMny);

        claimRecordVO.setClaimRecord(claimVOS);
        return claimRecordVO;
    }


    /**
     * 更新合同池
     *
     * @param claimEntity
     * @return
     */
    @Override
    public boolean updateContract(ClaimEntity claimEntity,Boolean flag){
        ContractPoolVO data = new ContractPoolVO();
        try {

            LambdaQueryWrapper<ClaimEntity> queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(ClaimEntity::getContractId,claimEntity.getContractId());
            queryWrapper.ne(ClaimEntity::getId,claimEntity.getId());
            queryWrapper.in(ClaimEntity::getBillState,1,3);
            queryWrapper.eq(ClaimEntity::getDr,0);
            //queryWrapper.eq(ClaimEntity::getTenantId,InvocationInfoProxy.getTenantid());
            List<ClaimEntity> list = claimService.list(queryWrapper);

            BigDecimal totalClaimTaxMny = BigDecimal.ZERO;
            BigDecimal totalClaimMny = BigDecimal.ZERO;
            BigDecimal totalClaimTax = BigDecimal.ZERO;

            BigDecimal totalReplyTaxMny = BigDecimal.ZERO;
            BigDecimal totalReplyMny = BigDecimal.ZERO;
            BigDecimal totalReplyTax = BigDecimal.ZERO;

            if (CollectionUtils.isNotEmpty(list)){
                totalClaimTaxMny = list.stream().map(ClaimEntity::getClaimTaxMny).reduce(BigDecimal::add).get();
                totalClaimMny = list.stream().map(ClaimEntity::getClaimMny).reduce(BigDecimal::add).get();
                totalClaimTax = list.stream().map(ClaimEntity::getClaimTax).reduce(BigDecimal::add).get();

                List<ClaimEntity> collect = list.stream().filter(e -> "1".equals(e.getReplyStatus())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(collect)){
                    totalReplyTaxMny = collect.stream().map(ClaimEntity::getReplyTaxMny).reduce(BigDecimal::add).get();
                    totalReplyMny = collect.stream().map(ClaimEntity::getReplyMny).reduce(BigDecimal::add).get();
                    totalReplyTax = collect.stream().map(ClaimEntity::getReplyTax).reduce(BigDecimal::add).get();
                }
            }

            if (flag){
                totalClaimTaxMny = MathUtil.safeAdd(totalClaimTaxMny,claimEntity.getClaimTaxMny());
                totalClaimMny = MathUtil.safeAdd(totalClaimMny,claimEntity.getClaimMny());
                totalClaimTax = MathUtil.safeAdd(totalClaimTax,claimEntity.getClaimTax());

                if ("1".equals(claimEntity.getReplyStatus())){
                    totalReplyTaxMny = MathUtil.safeAdd(totalReplyTaxMny,claimEntity.getReplyTaxMny());
                    totalReplyMny = MathUtil.safeAdd(totalReplyMny,claimEntity.getReplyMny());
                    totalReplyTax = MathUtil.safeAdd(totalReplyTax,claimEntity.getReplyTax());
                }
            }

            data.setId(claimEntity.getContractId());

            data.setUpdateLevel(UpdateLevelEnum.更新非空字段.getLevelCode());
            data.setSourceId(claimEntity.getContractId());

            data.setTotalClaimTaxMny(totalClaimTaxMny);
            data.setTotalClaimMny(totalClaimMny);
            data.setTotalClaimTax(totalClaimTax);

            data.setTotalTeplyTaxMny(totalReplyTaxMny);
            data.setTotalTeplyMny(totalReplyMny);
            data.setTotalTeplyTax(totalReplyTax);
            CommonResponse<ContractPoolVO> transDataResp = contractPoolApi.saveOrUpdateContract(data);

            if(transDataResp.isSuccess()) {
                return true;
            } else {
                logger.error("合同id-{}更新合同池失败，{}",claimEntity.getContractId(), transDataResp.getMsg());
            }
        } catch (Exception e) {
            logger.error("合同-{}更新合同池失败，", claimEntity.getContractId(), e);
        }

        return false;

    }

    @Override
    public Boolean updateCostAdjustId(Long costAdjustId, List<Long> claimIdsList) {

        LambdaUpdateWrapper<ClaimEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(ClaimEntity::getCostAdjustId, costAdjustId);
        updateWrapper.set(ClaimEntity::getCostAdjustId, null);
        this.update(updateWrapper);

        if (ListUtil.isNotEmpty(claimIdsList)) {
            LambdaUpdateWrapper<ClaimEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.in(ClaimEntity::getId, claimIdsList);
            wrapper.set(ClaimEntity::getCostAdjustId, costAdjustId);
            this.update(wrapper);
        }

        return true;
    }

    @Override
    public ReportVO queryDataByProjectId(Long projectId) {
        ReportVO reportVO = new ReportVO();

        //获取施工合同总额
        LambdaQueryWrapper<ContractRegisterEntity> lambdaContract = Wrappers.<ContractRegisterEntity>lambdaQuery();
        lambdaContract.in(ContractRegisterEntity::getBillState,1,3);
        lambdaContract.eq(ContractRegisterEntity::getProjectId,projectId);
        List<ContractRegisterEntity> contractRegisterEntities = contractRegisterService.list(lambdaContract);
        if (CollectionUtils.isNotEmpty(contractRegisterEntities)){
            BigDecimal sghtMny = contractRegisterEntities.stream().filter(s->s.getBaseMoney() != null).map(ContractRegisterEntity::getBaseMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
            reportVO.setSghtMny(sghtMny);
        }

        //签证索赔金额
        LambdaQueryWrapper<ClaimEntity> lambdaClaim = Wrappers.<ClaimEntity>lambdaQuery();
        lambdaClaim.in(ClaimEntity::getBillState,1,3);
        lambdaClaim.eq(ClaimEntity::getProjectId,projectId);
        List<ClaimEntity> claimEntities = super.list(lambdaClaim);
        BigDecimal qzspMny = BigDecimal.ZERO;
        for (ClaimEntity entity : claimEntities) {
            // 优先取 eplyTaxMny，若为空则取 claimTaxMny
            BigDecimal taxMny = entity.getReplyTaxMny();
            if (taxMny == null) {
                taxMny = entity.getClaimTaxMny();
            }

            // 处理可能为 null 的情况（若两个字段均为空则视为0）
            if (taxMny != null) {
                qzspMny = qzspMny.add(taxMny);
            }
        }
        reportVO.setQzspMny(qzspMny);

        //产值金额
        LambdaQueryWrapper<ProductionEntity> lambdaProduction = Wrappers.<ProductionEntity>lambdaQuery();
        lambdaProduction.in(ProductionEntity::getBillState,1,3);
        lambdaProduction.eq(ProductionEntity::getProjectId,projectId);
        List<ProductionEntity> productionEntities = productionService.list(lambdaProduction);
        if (CollectionUtils.isNotEmpty(productionEntities)){
            BigDecimal czMny = productionEntities.stream().filter(s->s.getProductionTaxMny() != null).map(ProductionEntity::getProductionTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            reportVO.setCzMny(czMny);
        }

        //甲方批复金额
        LambdaQueryWrapper<QuoteEntity> lambdaQuote = Wrappers.<QuoteEntity>lambdaQuery();
        lambdaQuote.in(QuoteEntity::getBillState,1,3);
        lambdaQuote.eq(QuoteEntity::getProjectId,projectId);
        List<QuoteEntity> quoteEntityList = quoteService.list(lambdaQuote);
        BigDecimal jfpfMny = BigDecimal.ZERO;
        for (QuoteEntity entity : quoteEntityList) {
            // 优先取 eplyTaxMny，若为空则取 claimTaxMny
            BigDecimal taxMny = entity.getReplyTaxMny();
            if (taxMny == null) {
                taxMny = entity.getQuoteTaxMny();
            }

            // 处理可能为 null 的情况（若两个字段均为空则视为0）
            if (taxMny != null) {
                jfpfMny = jfpfMny.add(taxMny);
            }
        }
        reportVO.setJfpfMny(jfpfMny);

        //竣工结算金额
        LambdaQueryWrapper<FinalizedEntity> lambdaFinalized = Wrappers.<FinalizedEntity>lambdaQuery();
        lambdaFinalized.in(FinalizedEntity::getBillState,1,3);
        lambdaFinalized.eq(FinalizedEntity::getProjectId,projectId);
        List<FinalizedEntity> FinalizedEntityList = finalizedService.list(lambdaFinalized);
        BigDecimal jgjsMny = BigDecimal.ZERO;
        for (FinalizedEntity entity : FinalizedEntityList) {
            // 优先取 eplyTaxMny，若为空则取 claimTaxMny
            BigDecimal taxMny = entity.getFinalInstanceMny();
            if (taxMny == null) {
                taxMny = entity.getFirstInstanceMny();
            }
            if (taxMny == null) {
                taxMny = entity.getReportSettleMny ();
            }

            // 处理可能为 null 的情况（若两个字段均为空则视为0）
            if (taxMny != null) {
                jgjsMny = jgjsMny.add(taxMny);
            }
        }
        reportVO.setJgjsMny(jgjsMny);

        //回款金额
        BigDecimal sumHkMny = contractRegisterMapper.getSumHkMny(projectId);
        reportVO.setHkMny(sumHkMny);
        //产值与回款差额
        reportVO.setCzhkDiffMny(ComputeUtil.safeSub(reportVO.getCzMny(),reportVO.getHkMny()));
        reportVO.setCzhkRate(CommonUtils.calculateRate2(reportVO.getHkMny(),reportVO.getCzMny()));

        //产值与批复差额
//        private BigDecimal czpfDiffMny;
        //批复与产值比例
//        private BigDecimal pfczRate;
        reportVO.setCzpfDiffMny(ComputeUtil.safeSub(reportVO.getCzMny(),reportVO.getJfpfMny()));
        reportVO.setPfczRate(CommonUtils.calculateRate2(reportVO.getJfpfMny(),reportVO.getCzMny()));
        //批复与回款差额
//        private BigDecimal pfhkDiffMny;
        //回款与批复比例
//        private BigDecimal hkpfRate;

        reportVO.setPfhkDiffMny(ComputeUtil.safeSub(reportVO.getJfpfMny(),reportVO.getHkMny()));
        reportVO.setHkpfRate(CommonUtils.calculateRate2(reportVO.getHkMny(),reportVO.getJfpfMny()));
        return reportVO;
    }

}
