package com.ejianc.business.pro.income.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pro.income.bean.ClaimEntity;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.ProductionEntity;
import com.ejianc.business.pro.income.service.IClaimService;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IProductionService;
import com.ejianc.business.pro.income.vo.ClaimVO;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.business.pro.income.vo.ProductionVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/api/proincomeContrantApi/")
public class ProincomeContrantApi {

    @Autowired
    private IContractRegisterService service;

    @Autowired
    private IProductionService productionService;

    @Autowired
    private IClaimService claimService;

    @PostMapping("updateRegistrationUseFlag")
    public CommonResponse<String> updateRegistrationUseFlag(@RequestBody ClaimVO claimVO) {
        ClaimEntity entity = claimService.selectById(claimVO.getId());
        entity.setRegistrationUseFlag(claimVO.getRegistrationUseFlag());
        claimService.saveOrUpdate(entity, false);

        return CommonResponse.success("操作成功！");
    }

    /**
     * 根据项目ID(projectID)查询该项目最新生效的施工合同
     * @param projectId
     * @return
     */
    @GetMapping("/queryContranct")
    public CommonResponse<BigDecimal> queryContranct(@RequestParam(value = "projectId") Long projectId) {
        LambdaQueryWrapper<ContractRegisterEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ContractRegisterEntity::getProjectId,projectId);
        queryWrapper.eq(ContractRegisterEntity::getDr,0);
        queryWrapper.eq(ContractRegisterEntity::getSupplementFlag,0);
        queryWrapper.eq(ContractRegisterEntity::getTenantId, InvocationInfoProxy.getTenantid());
//        queryWrapper.eq(ContractRegisterEntity::getIsEstimation,0);
        queryWrapper.in(ContractRegisterEntity::getBillState, 1, 3);
        List<ContractRegisterEntity> contractRegisterEntities = service.list(queryWrapper);
        BigDecimal totalContractTaxMny = new BigDecimal("0.00");
        if(ListUtil.isNotEmpty(contractRegisterEntities)){
            totalContractTaxMny = contractRegisterEntities.stream().map(ContractRegisterEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalContractTaxMny = totalContractTaxMny.setScale(2,BigDecimal.ROUND_HALF_UP);
        }else {
            return CommonResponse.error("查询失败,没有查询到该项目下的施工合同！");
        }
        return CommonResponse.success("查询成功！", totalContractTaxMny);
    }

    /**
     * 根据项目部组织ID(orgId)查询该项目部下已生效的产值金额(含税)汇总
     * @param orgId
     * @return
     */
    @GetMapping("/queryProduction")
    public CommonResponse<BigDecimal> queryProduction(@RequestParam(value = "orgId",required = false) Long orgId) {
        Map<String, BigDecimal> totalMny = new HashMap<>();
        //项目部下已生效的产值金额(含税)汇总
        QueryWrapper<ProductionEntity> query = new QueryWrapper<>();
        query.select("IFNULL(SUM(production_tax_mny), 0) AS totalProductionMny");
        if (orgId != null){
            query.eq("org_id", orgId);
        }else {
            query.eq("org_id", InvocationInfoProxy.getOrgId());
        }
        query.eq("dr",0);
        query.eq("tenant_id",InvocationInfoProxy.getTenantid());
        query.in("bill_state",  Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()));
        Map resultMap = productionService.getMap(query);
        totalMny.put("totalProductionMny", null != resultMap && null != resultMap.get("totalProductionMny") ? new BigDecimal(resultMap.get("totalProductionMny").toString()) : BigDecimal.ZERO);
        return CommonResponse.success("查询成功！",totalMny.get("totalProductionMny"));
    }

    /**
     * 查询已生效的产值金额(含税)汇总
     * @return
     */
    @GetMapping("/queryTotalProduction")
    public CommonResponse<Map<Long,ProductionVO>> queryTotalProduction() {
        QueryWrapper<ProductionEntity> query = new QueryWrapper<>();
        query.eq("dr",0);
        query.eq("tenant_id",InvocationInfoProxy.getTenantid());
        query.in("bill_state",  Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()));
        List<ProductionEntity> list = productionService.list(query);
        if (CollectionUtils.isEmpty(list)){
            return CommonResponse.error("查询失败,没有查询到产值报量！");
        }
        Map<Long,List<ProductionEntity>> map = list.stream().collect(Collectors.groupingBy(ProductionEntity::getProjectId));
        Map<Long,ProductionVO> pMap = new HashMap<>();
        map.forEach((k,v)->{
            ProductionVO vo = new ProductionVO();
            vo.setProductionTaxMny(v.stream().filter(x -> x.getProductionTaxMny() != null)
                    .map(ProductionEntity::getProductionTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            vo.setProjectId(k);
            vo.setProjectName(v.get(0).getProjectName());
            vo.setProjectCode(v.get(0).getProjectCode());
            pMap.put(k,vo);
        });
        return CommonResponse.success("查询成功！",pMap);
    }

    /**
     * 根据项目ID(projectID)查询该项目最新生效的施工合同
     * @param projectId
     * @return
     */
    @GetMapping("/queryContranctMny")
    public CommonResponse<ContractRegisterVO> queryContranctMny(@RequestParam(value = "projectId") Long projectId) {
        LambdaQueryWrapper<ContractRegisterEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ContractRegisterEntity::getProjectId, projectId);
        queryWrapper.eq(ContractRegisterEntity::getDr, 0);
        queryWrapper.eq(ContractRegisterEntity::getTenantId, InvocationInfoProxy.getTenantid());
        queryWrapper.in(ContractRegisterEntity::getBillState, 1, 3);
        queryWrapper.eq(ContractRegisterEntity::getSupplementFlag,0);
        //queryWrapper.eq(ContractRegisterEntity::getIsEstimation,0);
        queryWrapper.orderByDesc(ContractRegisterEntity::getCreateTime);
        List<ContractRegisterEntity> contractRegisterEntities = service.list(queryWrapper);
        ContractRegisterVO vo = new ContractRegisterVO();
        if (ListUtil.isNotEmpty(contractRegisterEntities)) {
            vo.setContractTaxMny(contractRegisterEntities.stream().map(ContractRegisterEntity::getContractTaxMny).filter(Objects::nonNull).reduce(BigDecimal.ZERO,BigDecimal::add));
        }else {
            vo.setContractTaxMny(BigDecimal.ZERO);
        }
        return CommonResponse.success("查询成功！", vo);
    }

    /**
     * 根据项目ID查询该项目部下已生效的产值金额(含税)汇总
     * @param projectId
     * @return
     */
    @GetMapping("/queryProductionByProject")
    public CommonResponse<BigDecimal> queryProductionByProject(@RequestParam(value = "projectId") Long projectId) {
        Map<String, BigDecimal> totalMny = new HashMap<>();
        //根据项目ID查询该项目部下已生效的产值金额(含税)汇总
        QueryWrapper<ProductionEntity> query = new QueryWrapper<>();
        query.select("IFNULL(SUM(production_tax_mny), 0) AS totalProductionMny");
        query.eq("project_id", projectId);
        query.eq("dr",0);
        query.eq("tenant_id",InvocationInfoProxy.getTenantid());
        query.in("bill_state",  Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()));
        Map resultMap = productionService.getMap(query);
        totalMny.put("totalProductionMny", null != resultMap && null != resultMap.get("totalProductionMny") ? new BigDecimal(resultMap.get("totalProductionMny").toString()) : BigDecimal.ZERO);
        return CommonResponse.success("查询成功！",totalMny.get("totalProductionMny"));
    }
}
