package com.ejianc.business.pro.change.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.change.mapper.DesignChangeMapper;
import com.ejianc.business.pro.change.bean.DesignChangeEntity;
import com.ejianc.business.pro.change.service.IDesignChangeService;

import java.util.List;

/**
 * 设计变更单
 * 
 * @author generator
 * 
 */
@Service("designChangeService")
public class DesignChangeServiceImpl extends BaseServiceImpl<DesignChangeMapper, DesignChangeEntity> implements IDesignChangeService{

    @Autowired
    private IDesignChangeService service;


    @Override
    public void deleteBillCode(List<String> billCode) {
        service.lambdaUpdate()
                .in(DesignChangeEntity::getContractorVisaRecord,billCode)
                .set(DesignChangeEntity::getContractorVisaRecord,null)
                .update();
    }
}
