package com.ejianc.business.pro.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.income.bean.*;
import com.ejianc.business.pro.income.cons.CommonConstants;
import com.ejianc.business.pro.income.service.*;
import com.ejianc.business.pro.income.utils.MathUtil;
import com.ejianc.business.pro.income.vo.QuoteHistoryVO;
import com.ejianc.business.pro.income.vo.QuoteVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 对甲报量
 * 
 * @author generator
 * 
 */
@RestController
@RequestMapping("quote")
public class QuoteController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IQuoteService service;

    @Autowired
    private IBudgetService budgetService;

    @Autowired
    private IProductionService productionService;

    @Autowired
    private IQuoteProductionService quoteProductionService;

    @Autowired
    private IQuoteClaimService quoteClaimService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<QuoteVO> saveOrUpdate(@RequestBody QuoteVO saveorUpdateVO) {
        QuoteVO vo = service.saveOrUpdate(saveorUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<QuoteVO> queryDetail(Long id) {
        QuoteVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<QuoteVO> vos) {
        if(CollectionUtils.isEmpty(vos)){
            return CommonResponse.success("删除成功！");
        }
        // 修改引用状态
        List<Long> ids = vos.stream().map(QuoteVO::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("pid", new Parameter(QueryParam.IN, ids));
        List<QuoteProductionEntity> productionList = quoteProductionService.queryList(queryParam);
        List<QuoteClaimEntity> claimList = quoteClaimService.queryList(queryParam);
        List<Long> claimIds = claimList.stream().map(x->x.getClaimId()).collect(Collectors.toList());
        service.updateClaimsUseFlag(claimIds, false);
        List<Long> productIds = productionList.stream().map(x->x.getProductionId()).collect(Collectors.toList());
        productionService.updateProductsUseFlag(productIds, null, false);

        service.removeByIds(ids,true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<QuoteVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        // 单据编号、所属单位、项目名称、发包方、经办人
        param.getFuzzyFields().add("billCode");
        param.getFuzzyFields().add("parentOrgName");
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("customerName");
        param.getFuzzyFields().add("employeeName");
        param.getFuzzyFields().add("deptName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 默认根据创建时间排序
        param.getOrderMap().put("createTime", param.getOrderMap().containsKey("quoteDate") ? param.getOrderMap().get("quoteDate") : QueryParam.DESC);

        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<QuoteEntity> page = service.queryPage(param,false);
        IPage<QuoteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<QuoteVO> records = BeanMapper.mapList(page.getRecords(), QuoteVO.class);
        records.forEach(e -> {
            String replyStatusName = CommonConstants.ReplyStatusMap.get(e.getReplyStatus());
            long days = DateUtil.daysBetween(e.getQuoteDate(), new Date());
            if (new Integer(0).equals(e.getReplyStatus()) && days >= 10){
                replyStatusName = replyStatusName + "(已过" + days + "天)";
            }
            e.setReplyStatusName(replyStatusName);
        });
  		pageData.setRecords(records);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("billCode");
        param.getFuzzyFields().add("parentOrgName");
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("customerName");
        param.getFuzzyFields().add("employeeName");
        param.getFuzzyFields().add("deptName");
        /** 租户隔离 */
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        // 默认根据创建时间排序
        param.getOrderMap().put("createTime", param.getOrderMap().containsKey("quoteDate") ? param.getOrderMap().get("quoteDate") : QueryParam.DESC);
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        List<QuoteEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<QuoteVO> voList = BeanMapper.mapList(list, QuoteVO.class);
        voList.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
        });
        beans.put("records", voList);
        ExcelExport.getInstance().export("quote-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refQuoteData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<QuoteVO>> refQuoteData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        if(StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            //JSONObject _con = JSONObject.parseObject(condition);
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("contractId")) {
                Long contractId = Long.valueOf(conditionMap.get("contractId").toString());
                param.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
            }
        }
        param.getParams().put("reply_status", new Parameter(QueryParam.EQ, 1));
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        param.getParams().put("bill_state", new Parameter(QueryParam.IN, billStatus));
        param.getOrderMap().put("createTime", "desc");
        IPage<QuoteEntity> page = service.queryPage(param,false);
        IPage<QuoteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<QuoteVO> vos = BeanMapper.mapList(page.getRecords(), QuoteVO.class);
        List<QuoteVO> voList = new ArrayList<>();
        vos.forEach(e->{
            e.setResidueTaxMny(MathUtil.safeSub(e.getReplyTaxMny(),e.getAppliedTaxMny()));
            if (e.getResidueTaxMny().compareTo(BigDecimal.ZERO)==1){
                voList.add(e);
            }
        });
        pageData.setRecords(voList);

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description validateContract 校验合同
     * @param id
     */
    @RequestMapping(value = "/validateContract", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> validateContract(Long id) {
        String msg = service.validateContract(id);
        return CommonResponse.success("校验成功！", msg);
    }

    /**
     * 对甲报量历史记录
     * @param id 合同ID
     * @return
     */
    @RequestMapping(value = "/queryQuoteHistory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<QuoteHistoryVO> queryQuoteHistory(@RequestParam Long id) {
        QuoteHistoryVO vo = service.queryQuoteHistory(id);
        return CommonResponse.success(vo);
    }

    @PostMapping("saveReply")
    @ResponseBody
    public CommonResponse<String> saveReply(@RequestBody QuoteVO vo){
        QuoteEntity entity = service.selectById(vo.getId());
        if (entity!=null){
            LambdaUpdateWrapper<QuoteEntity> wrapper = new LambdaUpdateWrapper();
            wrapper.eq(QuoteEntity::getId, vo.getId());
            wrapper.set(QuoteEntity::getReplyDate,vo.getReplyDate());
            wrapper.set(QuoteEntity::getReplyStatus,vo.getReplyStatus());
            wrapper.set(QuoteEntity::getReplyMny,vo.getReplyMny());
            wrapper.set(QuoteEntity::getReplyTaxMny,vo.getReplyTaxMny());
            wrapper.set(QuoteEntity::getReplyMemo, vo.getReplyMemo());
            service.update(wrapper);
            // 重新查询
            entity = service.selectById(vo.getId());
            // 已批复时推送结算池
            if(new Integer(1).equals(vo.getReplyStatus())){
                boolean pool = service.pushSettleToPool(BeanMapper.map(entity, QuoteVO.class));
                if(!pool){
                    return CommonResponse.error("推送结算池失败");
                }
            }
            return CommonResponse.success();
        }else{
            return CommonResponse.error("单据不存在！");
        }
    }

    /**
     * 上传财务会计凭条
     *
     * @return
     */
    @PostMapping(value = "/uploadFinancial")
    @ResponseBody
    public CommonResponse<String> uploadFinancial(@RequestBody Long id) {

        service.uploadFinancial(id);

        return CommonResponse.success("操作成功！");
    }

    /**
     * 同步结算池
     * @param id
     * @return
     */
    @GetMapping(value = "/syncPushSettlePool")
    @ResponseBody
    public CommonResponse<Boolean> syncPushSettlePool(@RequestParam(value = "id") Long id) {
        QuoteEntity quoteEntity = service.selectById(id);
        QuoteVO vo = BeanMapper.map(quoteEntity, QuoteVO.class);
        // 已批复时推送结算池
        if(new Integer(1).equals(vo.getReplyStatus())){
            boolean pool = service.pushSettleToPool(vo);
            if(!pool){
                return CommonResponse.error("推送结算池失败");
            }
        } else {
            return CommonResponse.success("无需推送！", true);
        }
        return CommonResponse.success("同步结算池成功！", true);
    }

    /**
     * @Description validateProjectId 校验项目
     * @param id 合同ID
     */
    @RequestMapping(value = "/validateProjectOrPeriod", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> validateProjectOrPeriod(@RequestParam("projectId") Long projectId, @RequestParam(value = "id", required = false) Long id,
                                                          @RequestParam(value = "period", required = false) String period) {
        String msg = service.validateProjectOrPeriod(projectId, id, period);
        return CommonResponse.success("校验成功！", msg);
    }

    /**
     * @param projectId
     * @Description queryProductionVO 根据项目查询对甲报量数据
     */
    @RequestMapping(value = "/queryQuoteVO", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<QuoteVO> queryQuoteVO(Long projectId) {
        QuoteVO result = new QuoteVO();
        QueryParam param = new QueryParam();
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        param.getOrderMap().put("createTime", QueryParam.DESC);
        List<BudgetEntity> budgetList = budgetService.queryList(param);
        List<QuoteEntity> list = service.queryList(param);
        if(CollectionUtils.isNotEmpty(list)){
            result = BeanMapper.map(list.get(0), QuoteVO.class);
        }
        result.setBudgetMny(budgetList.stream().map(x->x.getBudgetMny()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd));
        result.setBudgetTaxMny(budgetList.stream().map(x->x.getBudgetTaxMny()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd));
        BigDecimal sumQuoteMny = list.stream().map(x->x.getQuoteMny()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
        BigDecimal sumQuoteTaxMny = list.stream().map(x->x.getQuoteTaxMny()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
        BigDecimal sumFinishMny = list.stream().map(x->x.getFinishMny()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
        BigDecimal sumFinishTaxMny = list.stream().map(x->x.getFinishTaxMny()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
        result.setLastQuoteMny(sumQuoteMny);
        result.setLastQuoteTaxMny(sumQuoteTaxMny);
        result.setSumQuoteMny(sumQuoteMny);
        result.setSumQuoteTaxMny(sumQuoteTaxMny);
        result.setLastFinishMny(sumFinishMny);
        result.setLastFinishTaxMny(sumFinishTaxMny);
        result.setSumFinishMny(sumFinishMny);
        result.setSumFinishTaxMny(sumFinishTaxMny);
        return CommonResponse.success("查询详情数据成功！", result);
    }
}
