package com.ejianc.business.pro.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pro.income.bean.BudgetMeasureEntity;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.income.mapper.BudgetOtherMapper;
import com.ejianc.business.pro.income.bean.BudgetOtherEntity;
import com.ejianc.business.pro.income.service.IBudgetOtherService;

import java.util.List;

/**
 * 其他项清单
 * 
 * @author generator
 * 
 */
@Service("budgetOtherService")
public class BudgetOtherServiceImpl extends BaseServiceImpl<BudgetOtherMapper, BudgetOtherEntity> implements IBudgetOtherService{

    @Override
    public void delOtherByBudgetId(Long budgetId) {
        baseMapper.delete(new QueryWrapper<BudgetOtherEntity>().eq("budget_id", budgetId));
    }

    @Override
    public void delOtherBatchByBudgetId(List<Long> ids) {
        baseMapper.delete(new QueryWrapper<BudgetOtherEntity>().in("budget_id", ids));
    }

    @Override
    public List<BudgetOtherEntity> queryOtherByBudgetIds(List<Long> budegtIds) {
        return baseMapper.selectList(new QueryWrapper<BudgetOtherEntity>()
                .eq("dr",0)
                .in("budget_id", budegtIds));
    }
}
