package com.ejianc.business.pro.other.enums;

import com.ejianc.business.pro.income.enums.ContractStatusEnum;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 合同履约状态
 */
public enum OtherContractStatusEnum {

    未签订("1", "未签订"),
    履约中("2", "履约中"),
    已封账("3", "已封账"),
    已冻结("4", "已冻结"),

    已解除("5", "已解除");


    private String code;
    private String description;
    private static Map<String, ContractStatusEnum> enumMap = new HashMap<>();

    OtherContractStatusEnum(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    static {
        enumMap = EnumSet.allOf(ContractStatusEnum.class).stream().collect(Collectors.toMap(ContractStatusEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static ContractStatusEnum getEnumByCode(String billStateCode) {
        return enumMap.get(billStateCode);
    }
}
