/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.controller.api;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pro.deskTop.vo.ProincomeDynamicVO;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.ContractReviewEntity;
import com.ejianc.business.pro.income.bean.ProductionEntity;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IContractReviewService;
import com.ejianc.business.pro.income.service.IProductionService;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.business.pro.income.vo.CustomerCountWithYearVO;
import com.ejianc.business.pro.income.vo.ProductionVO;
import com.ejianc.foundation.support.vo.CustomerIncomeInfoVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/proincomeContrantApi/"})
public class ProincomeContrantApi {
    @Autowired
    private IContractRegisterService service;
    @Autowired
    private IProductionService productionService;
    @Autowired
    private IContractReviewService contractReviewService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @GetMapping(value={"/queryContranct"})
    public CommonResponse<BigDecimal> queryContranct(@RequestParam(value="projectId") Long projectId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ContractRegisterEntity::getProjectId, (Object)projectId);
        queryWrapper.eq(BaseEntity::getDr, (Object)0);
        queryWrapper.eq(ContractRegisterEntity::getSupplementFlag, (Object)0);
        queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.in(ContractRegisterEntity::getBillState, new Object[]{1, 3});
        List contractRegisterEntities = this.service.list((Wrapper)queryWrapper);
        BigDecimal totalContractTaxMny = new BigDecimal("0.00");
        if (!ListUtil.isNotEmpty((List)contractRegisterEntities)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25,\u6ca1\u6709\u67e5\u8be2\u5230\u8be5\u9879\u76ee\u4e0b\u7684\u65bd\u5de5\u5408\u540c\uff01");
        }
        totalContractTaxMny = contractRegisterEntities.stream().filter(e -> e.getNicContractMny() != null).map(ContractRegisterEntity::getNicContractMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        totalContractTaxMny = totalContractTaxMny.setScale(2, 4);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)totalContractTaxMny);
    }

    @GetMapping(value={"/queryProduction"})
    public CommonResponse<BigDecimal> queryProduction(@RequestParam(value="orgId", required=false) Long orgId) {
        HashMap<String, BigDecimal> totalMny = new HashMap<String, BigDecimal>();
        QueryWrapper query = new QueryWrapper();
        query.select(new String[]{"IFNULL(SUM(production_tax_mny), 0) AS totalProductionMny"});
        if (orgId != null) {
            query.eq((Object)"org_id", (Object)orgId);
        } else {
            query.eq((Object)"org_id", (Object)InvocationInfoProxy.getOrgId());
        }
        query.eq((Object)"dr", (Object)0);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        Map resultMap = this.productionService.getMap((Wrapper)query);
        totalMny.put("totalProductionMny", null != resultMap && null != resultMap.get("totalProductionMny") ? new BigDecimal(resultMap.get("totalProductionMny").toString()) : BigDecimal.ZERO);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", totalMny.get("totalProductionMny"));
    }

    @GetMapping(value={"/queryTotalProduction"})
    public CommonResponse<Map<Long, ProductionVO>> queryTotalProduction() {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"dr", (Object)0);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List list = this.productionService.list((Wrapper)query);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25,\u6ca1\u6709\u67e5\u8be2\u5230\u4ea7\u503c\u62a5\u91cf\uff01");
        }
        Map<Long, List<ProductionEntity>> map = list.stream().collect(Collectors.groupingBy(ProductionEntity::getProjectId));
        HashMap pMap = new HashMap();
        map.forEach((k, v) -> {
            ProductionVO vo = new ProductionVO();
            vo.setProductionTaxMny(v.stream().filter(x -> x.getProductionTaxMny() != null).map(ProductionEntity::getProductionTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            vo.setProjectId(k);
            vo.setProjectName(((ProductionEntity)((Object)((Object)v.get(0)))).getProjectName());
            vo.setProjectCode(((ProductionEntity)((Object)((Object)v.get(0)))).getProjectCode());
            pMap.put(k, vo);
        });
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", pMap);
    }

    @GetMapping(value={"/queryContranctMny"})
    public CommonResponse<ContractRegisterVO> queryContranctMny(@RequestParam(value="projectId") Long projectId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ContractRegisterEntity::getProjectId, (Object)projectId);
        queryWrapper.eq(BaseEntity::getDr, (Object)0);
        queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.in(ContractRegisterEntity::getBillState, new Object[]{1, 3});
        queryWrapper.eq(ContractRegisterEntity::getSupplementFlag, (Object)0);
        queryWrapper.orderByDesc(BaseEntity::getCreateTime);
        List contractRegisterEntities = this.service.list((Wrapper)queryWrapper);
        ContractRegisterVO vo = null;
        if (ListUtil.isNotEmpty((List)contractRegisterEntities)) {
            List zsht = contractRegisterEntities.stream().filter(x -> x.getIsEstimation() == 0 && x.getContractTaxMny() != null).collect(Collectors.toList());
            List zght = contractRegisterEntities.stream().filter(x -> x.getIsEstimation() == 1 && x.getContractTaxMny() != null).collect(Collectors.toList());
            if (CollUtil.isEmpty(zsht) && CollUtil.isEmpty(zght)) {
                vo = new ContractRegisterVO();
                vo.setContractTaxMny(BigDecimal.ZERO);
            } else {
                vo = new ContractRegisterVO();
                if (CollUtil.isNotEmpty(zsht)) {
                    vo.setContractTaxMny(zsht.stream().map(ContractRegisterEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                } else {
                    vo.setContractTaxMny(zght.stream().map(ContractRegisterEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                }
            }
        }
        if (vo == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25,\u6ca1\u6709\u67e5\u8be2\u5230\u8be5\u9879\u76ee\u4e0b\u7684\u65bd\u5de5\u5408\u540c\uff01");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", vo);
    }

    @GetMapping(value={"/queryProductionByProject"})
    public CommonResponse<BigDecimal> queryProductionByProject(@RequestParam(value="projectId") Long projectId) {
        HashMap<String, BigDecimal> totalMny = new HashMap<String, BigDecimal>();
        QueryWrapper query = new QueryWrapper();
        query.select(new String[]{"IFNULL(SUM(production_tax_mny), 0) AS totalProductionMny"});
        query.eq((Object)"project_id", (Object)projectId);
        query.eq((Object)"dr", (Object)0);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        Map resultMap = this.productionService.getMap((Wrapper)query);
        totalMny.put("totalProductionMny", null != resultMap && null != resultMap.get("totalProductionMny") ? new BigDecimal(resultMap.get("totalProductionMny").toString()) : BigDecimal.ZERO);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", totalMny.get("totalProductionMny"));
    }

    @GetMapping(value={"/queryCountByCustomerId"})
    CommonResponse<List<CustomerCountWithYearVO>> queryCountByCustomerId(@RequestParam(value="customerId") Long customerId, @RequestParam(value="dateIn") String dateIn) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", this.service.queryCountByCustomerId(customerId, dateIn));
    }

    @RequestMapping(value={"/queryCustomerSum"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<JSONObject>> queryCustomerSum(@RequestBody QueryParam param) {
        QueryWrapper queryWrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<CustomerIncomeInfoVO> vos = this.service.queryCustomerSum(queryWrapper);
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        long lowCustom = vos.stream().filter(s -> s.getSum() != null && s.getSum().compareTo(new BigDecimal(500000000)) < 0).count();
        JSONObject lowCustomJSON = new JSONObject();
        lowCustomJSON.put("name", (Object)"\u666e\u901a\u5ba2\u6237");
        lowCustomJSON.put("value", (Object)lowCustom);
        list.add(lowCustomJSON);
        long middleCustom = vos.stream().filter(s -> s.getSum() != null && s.getSum().compareTo(new BigDecimal(500000000)) >= 0 && s.getSum().compareTo(new BigDecimal(1000000000)) < 0).count();
        JSONObject middleCustomJSON = new JSONObject();
        middleCustomJSON.put("name", (Object)"\u5927\u5ba2\u6237");
        middleCustomJSON.put("value", (Object)middleCustom);
        list.add(middleCustomJSON);
        long heightCustom = vos.stream().filter(s -> s.getSum() != null && s.getSum().compareTo(new BigDecimal(1000000000)) >= 0).count();
        JSONObject heightCustomJSON = new JSONObject();
        heightCustomJSON.put("name", (Object)"\u6218\u7565\u5ba2\u6237");
        heightCustomJSON.put("value", (Object)heightCustom);
        list.add(heightCustomJSON);
        return CommonResponse.success((String)"\u67e5\u8be2\u5ba2\u6237\u6570\u636e\u60c5\u51b5\u6570\u636e\u6210\u529f\uff01", list);
    }

    @RequestMapping(value={"/queryDynamic"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<ProincomeDynamicVO>> queryDynamic(@RequestBody QueryParam param) {
        List<ProincomeDynamicVO> proincomeDynamicVOS = this.service.queryDynamic();
        return CommonResponse.success((String)"\u67e5\u8be2\u5ba2\u6237\u6570\u636e\u60c5\u51b5\u6570\u636e\u6210\u529f\uff01", proincomeDynamicVOS);
    }

    @GetMapping(value={"/updateJzs"})
    public CommonResponse<BigDecimal> updateJzs(@RequestParam(value="projectId") Long projectId, @RequestParam(value="userId") Long userId, @RequestParam(value="userName") String userName) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ContractReviewEntity::getProjectId, (Object)projectId);
        queryWrapper.eq(BaseEntity::getDr, (Object)0);
        queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.in(ContractReviewEntity::getBillState, new Object[]{1, 3});
        List list = this.contractReviewService.list((Wrapper)queryWrapper);
        this.logger.info("list=====================:{}", (Object)JSON.toJSONString((Object)list));
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            for (ContractReviewEntity contractReviewEntity : list) {
                contractReviewEntity.setArchitectId(userId);
                contractReviewEntity.setArchitectName(userName);
                this.contractReviewService.saveOrUpdate((Object)contractReviewEntity);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01");
    }
}

