/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.service.impl;

import com.ejianc.business.pro.income.bean.BudgetEntity;
import com.ejianc.business.pro.income.bean.QuoteDetailEntity;
import com.ejianc.business.pro.income.mapper.QuoteDetailMapper;
import com.ejianc.business.pro.income.service.IBudgetService;
import com.ejianc.business.pro.income.service.IQuoteDetailService;
import com.ejianc.business.pro.income.service.IQuoteService;
import com.ejianc.business.pro.income.utils.DetailListUtil;
import com.ejianc.business.pro.income.utils.IncomeSortUtil;
import com.ejianc.business.pro.income.utils.TreeNodeBUtil;
import com.ejianc.business.pro.income.vo.LastVO;
import com.ejianc.business.pro.income.vo.QuoteDetailCostVO;
import com.ejianc.business.pro.income.vo.QuoteDetailFeeVO;
import com.ejianc.business.pro.income.vo.QuoteDetailMeasureVO;
import com.ejianc.business.pro.income.vo.QuoteDetailOtherVO;
import com.ejianc.business.pro.income.vo.QuoteDetailPubVO;
import com.ejianc.business.pro.income.vo.QuoteDetailSubVO;
import com.ejianc.business.pro.income.vo.QuoteDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="quoteDetailService")
public class QuoteDetailServiceImpl
extends BaseServiceImpl<QuoteDetailMapper, QuoteDetailEntity>
implements IQuoteDetailService {
    @Autowired
    private IQuoteService quoteService;
    @Autowired
    private IBudgetService budgetService;
    @Autowired
    private DetailListUtil detailListUtil;

    @Override
    public QuoteDetailVO queryBudgetDetail(Long id) {
        QuoteDetailPubVO pub;
        Map<Long, QuoteDetailPubVO> pubMap = this.getPubVOSumMap(id);
        BudgetEntity entity = (BudgetEntity)((Object)this.budgetService.selectById(id));
        QuoteDetailVO vo = (QuoteDetailVO)BeanMapper.map((Object)((Object)entity), QuoteDetailVO.class);
        List costList = BeanMapper.mapList(entity.getCostVos(), QuoteDetailCostVO.class);
        List subList = BeanMapper.mapList(entity.getSubVos(), QuoteDetailSubVO.class);
        List measureList = BeanMapper.mapList(entity.getMeasureVos(), QuoteDetailMeasureVO.class);
        List otherList = BeanMapper.mapList(entity.getOtherVos(), QuoteDetailOtherVO.class);
        List feeList = BeanMapper.mapList(entity.getFeeVos(), QuoteDetailFeeVO.class);
        LastVO lastVO = new LastVO();
        if (CollectionUtils.isNotEmpty((Collection)costList)) {
            for (QuoteDetailCostVO dvo : costList) {
                dvo.setTid(dvo.getId().toString());
                dvo.setTpid(dvo.getParentId() != null && dvo.getParentId() > 0L ? dvo.getParentId().toString() : "");
                dvo.setRowState("edit");
                if (!pubMap.containsKey(dvo.getId())) continue;
                pub = pubMap.get(dvo.getId());
                dvo.setLastQuoteNum(pub.getQuoteNum());
                dvo.setLastQuoteMny(pub.getQuoteMny());
                dvo.setLastQuoteTaxMny(pub.getQuoteTaxMny());
                if (!dvo.getLeafFlag().booleanValue()) continue;
                this.computeLast(lastVO, pub);
            }
            new IncomeSortUtil().entryListToSort(costList);
            vo.setCostList(TreeNodeBUtil.buildTree((List)costList));
        }
        if (CollectionUtils.isNotEmpty((Collection)subList)) {
            for (QuoteDetailCostVO dvo : subList) {
                dvo.setTid(dvo.getId().toString());
                dvo.setTpid(dvo.getParentId() != null && dvo.getParentId() > 0L ? dvo.getParentId().toString() : "");
                dvo.setRowState("edit");
                if (!pubMap.containsKey(dvo.getId())) continue;
                pub = pubMap.get(dvo.getId());
                dvo.setLastQuoteNum(pub.getQuoteNum());
                dvo.setLastQuoteMny(pub.getQuoteMny());
                dvo.setLastQuoteTaxMny(pub.getQuoteTaxMny());
                if (!dvo.getLeafFlag().booleanValue()) continue;
                this.computeLast(lastVO, pub);
            }
            new IncomeSortUtil().entryListToSort(subList);
            vo.setSubList(TreeNodeBUtil.buildTree((List)subList));
        }
        if (CollectionUtils.isNotEmpty((Collection)measureList)) {
            for (QuoteDetailCostVO dvo : measureList) {
                dvo.setTid(dvo.getId().toString());
                dvo.setTpid(dvo.getParentId() != null && dvo.getParentId() > 0L ? dvo.getParentId().toString() : "");
                dvo.setRowState("edit");
                if (!pubMap.containsKey(dvo.getId())) continue;
                pub = pubMap.get(dvo.getId());
                dvo.setLastQuoteNum(pub.getQuoteNum());
                dvo.setLastQuoteMny(pub.getQuoteMny());
                dvo.setLastQuoteTaxMny(pub.getQuoteTaxMny());
                if (!dvo.getLeafFlag().booleanValue()) continue;
                this.computeLast(lastVO, pub);
            }
            new IncomeSortUtil().entryListToSort(measureList);
            vo.setMeasureList(TreeNodeBUtil.buildTree((List)measureList));
        }
        if (CollectionUtils.isNotEmpty((Collection)otherList)) {
            for (QuoteDetailCostVO dvo : otherList) {
                dvo.setTid(dvo.getId().toString());
                dvo.setTpid(dvo.getParentId() != null && dvo.getParentId() > 0L ? dvo.getParentId().toString() : "");
                dvo.setRowState("edit");
                if (!pubMap.containsKey(dvo.getId())) continue;
                pub = pubMap.get(dvo.getId());
                dvo.setLastQuoteNum(pub.getQuoteNum());
                dvo.setLastQuoteMny(pub.getQuoteMny());
                dvo.setLastQuoteTaxMny(pub.getQuoteTaxMny());
                if (!dvo.getLeafFlag().booleanValue()) continue;
                this.computeLast(lastVO, pub);
            }
            new IncomeSortUtil().entryListToSort(otherList);
            vo.setOtherList(TreeNodeBUtil.buildTree((List)otherList));
        }
        if (CollectionUtils.isNotEmpty((Collection)feeList)) {
            for (QuoteDetailCostVO dvo : feeList) {
                dvo.setTid(dvo.getId().toString());
                dvo.setTpid(dvo.getParentId() != null && dvo.getParentId() > 0L ? dvo.getParentId().toString() : "");
                dvo.setRowState("edit");
                if (!pubMap.containsKey(dvo.getId())) continue;
                pub = pubMap.get(dvo.getId());
                dvo.setLastQuoteNum(pub.getQuoteNum());
                dvo.setLastQuoteMny(pub.getQuoteMny());
                dvo.setLastQuoteTaxMny(pub.getQuoteTaxMny());
                if (!dvo.getLeafFlag().booleanValue()) continue;
                this.computeLast(lastVO, pub);
            }
            new IncomeSortUtil().entryListToSort(feeList);
            vo.setFeeList(TreeNodeBUtil.buildTree((List)feeList));
        }
        vo.setLastQuoteMny(lastVO.getLastMny());
        vo.setLastQuoteTaxMny(lastVO.getLastTaxMny());
        return vo;
    }

    private void computeLast(LastVO lastVO, QuoteDetailPubVO pub) {
        lastVO.setLastMny(ComputeUtil.safeAdd((BigDecimal)lastVO.getLastMny(), (BigDecimal)pub.getQuoteMny()));
        lastVO.setLastTaxMny(ComputeUtil.safeAdd((BigDecimal)lastVO.getLastTaxMny(), (BigDecimal)pub.getQuoteTaxMny()));
    }

    private Map<Long, QuoteDetailPubVO> getPubVOSumMap(Long id) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List quoteList = this.quoteService.queryList(queryParam);
        HashMap<Long, QuoteDetailPubVO> pubMap = new HashMap<Long, QuoteDetailPubVO>();
        if (CollectionUtils.isNotEmpty((Collection)quoteList)) {
            List quoteIds = quoteList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            QueryParam param = new QueryParam();
            param.getParams().put("quoteId", new Parameter("in", quoteIds));
            param.getParams().put("budgetId", new Parameter("eq", (Object)id));
            List detailList = super.queryList(param);
            this.detailListUtil.setDetailList(detailList);
            if (CollectionUtils.isNotEmpty((Collection)detailList)) {
                detailList.forEach(detail -> {
                    ArrayList pubList = new ArrayList();
                    if (CollectionUtils.isNotEmpty(detail.getCostList())) {
                        pubList.addAll(BeanMapper.mapList(detail.getCostList(), QuoteDetailPubVO.class));
                    }
                    if (CollectionUtils.isNotEmpty(detail.getSubList())) {
                        pubList.addAll(BeanMapper.mapList(detail.getSubList(), QuoteDetailPubVO.class));
                    }
                    if (CollectionUtils.isNotEmpty(detail.getMeasureList())) {
                        pubList.addAll(BeanMapper.mapList(detail.getMeasureList(), QuoteDetailPubVO.class));
                    }
                    if (CollectionUtils.isNotEmpty(detail.getOtherList())) {
                        pubList.addAll(BeanMapper.mapList(detail.getOtherList(), QuoteDetailPubVO.class));
                    }
                    if (CollectionUtils.isNotEmpty(detail.getFeeList())) {
                        pubList.addAll(BeanMapper.mapList(detail.getFeeList(), QuoteDetailPubVO.class));
                    }
                    pubList.forEach(vo -> {
                        QuoteDetailPubVO pub = new QuoteDetailPubVO();
                        if (!pubMap.containsKey(vo.getBudgetDetailId())) {
                            pub.setBudgetDetailId(vo.getBudgetDetailId());
                            pub.setQuoteNum(vo.getQuoteNum());
                            pub.setQuoteMny(vo.getQuoteMny());
                            pub.setQuoteTaxMny(vo.getQuoteTaxMny());
                            pubMap.put(vo.getBudgetDetailId(), pub);
                        } else {
                            pub = (QuoteDetailPubVO)pubMap.get(vo.getBudgetDetailId());
                            pub.setQuoteNum(ComputeUtil.safeAdd((BigDecimal)pub.getQuoteNum(), (BigDecimal)vo.getQuoteNum()));
                            pub.setQuoteMny(ComputeUtil.safeAdd((BigDecimal)pub.getQuoteMny(), (BigDecimal)vo.getQuoteMny()));
                            pub.setQuoteTaxMny(ComputeUtil.safeAdd((BigDecimal)pub.getQuoteTaxMny(), (BigDecimal)vo.getQuoteTaxMny()));
                        }
                    });
                });
            }
        }
        return pubMap;
    }
}

