package com.ejianc.business.pro.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cwdataexchange.PMContractPush.api.IPMContractApi;
import com.ejianc.business.cwdataexchange.PMContractPush.vo.PMContractVO;
import com.ejianc.business.hr.vo.TypeVO;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.ContractReviewEntity;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IContractReviewService;
import com.ejianc.business.pro.income.service.impl.ContractRegisterBpmServiceImpl;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.business.pro.income.vo.ContractReviewVO;
import com.ejianc.business.pro.income.vo.RegisterResVO;
import com.ejianc.business.pro.income.vo.RegisterSupplementHistoryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 施工合同登记
 *
 * @author generator
 */
@Controller
@RequestMapping("contractRegister")
public class ContractRegisterController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IContractRegisterService service;


    @Autowired
    private ContractRegisterBpmServiceImpl bpmService;

    @Autowired
    private IPMContractApi contractApi;

    @Autowired
    private IContractReviewService contractReviewService;

    @Autowired
    private IProjectSetApi projectSetApi;

    @Autowired
    private IOrgApi iOrgApi;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ContractRegisterVO> saveOrUpdate(@RequestBody ContractRegisterVO saveorUpdateVO) {

        return CommonResponse.success("保存或修改单据成功！", service.saveOrUpdate(saveorUpdateVO));
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractRegisterVO> queryDetail(Long id) {
        //bpmService.afterApprovalProcessor(id,1,"");

        ContractRegisterEntity entity = service.selectById(id);
        ContractRegisterVO vo = BeanMapper.map(entity, ContractRegisterVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    /**
     * @param projectId
     * @Description queryRegisterVO 根据项目查询施工合同+ 施工评审详情
     */
    @RequestMapping(value = "/queryRegisterVO", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RegisterResVO> queryRegisterVO(Long projectId) {
        LambdaQueryWrapper<ContractRegisterEntity> lambda = Wrappers.<ContractRegisterEntity>lambdaQuery();
        lambda.eq(ContractRegisterEntity::getTenantId,InvocationInfoProxy.getTenantid());
        lambda.eq(ContractRegisterEntity::getProjectId,projectId);
        lambda.in(ContractRegisterEntity::getBillState,1,3);
        List<ContractRegisterEntity> list = service.list(lambda);
        RegisterResVO registerResVO = new RegisterResVO();
        if(CollectionUtils.isNotEmpty(list)){
            registerResVO = BeanMapper.map(list.get(0),RegisterResVO.class);
            registerResVO.setContractBaseMny(list.get(0).getBaseMoney());
            registerResVO.setContractBaseTaxMny(list.get(0).getBaseTaxMoney());
            registerResVO.setContractId(list.get(0).getId());
        }
        LambdaQueryWrapper<ContractReviewEntity> lambda2 = Wrappers.<ContractReviewEntity>lambdaQuery();
        lambda2.eq(ContractReviewEntity::getTenantId,InvocationInfoProxy.getTenantid());
        lambda2.eq(ContractReviewEntity::getProjectId,projectId);
        lambda2.in(ContractReviewEntity::getBillState,1,3);
        List<ContractReviewEntity> list2 = contractReviewService.list(lambda2);
        if(CollectionUtils.isNotEmpty(list2)){
            ContractReviewEntity contractReviewEntity =  list2.get(0);
            registerResVO.setEngineeringTypeId(contractReviewEntity.getEngineeringTypeId());
            registerResVO.setEngineeringTypeName(contractReviewEntity.getEngineeringTypeName());
            registerResVO.setBuiltArea(contractReviewEntity.getBuiltArea());
            registerResVO.setContractualModel(contractReviewEntity.getContractualModel());
            registerResVO.setStartDate(contractReviewEntity.getStartDate());
            registerResVO.setEndDate(contractReviewEntity.getEndDate());
            registerResVO.setFundsSourceId(contractReviewEntity.getFundsSourceId());
            registerResVO.setFundsSource(contractReviewEntity.getFundsSource());
            registerResVO.setAddress(contractReviewEntity.getAddress());
        }
        return CommonResponse.success("查询详情数据成功！", registerResVO);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractRegisterVO> vos) {
        service.removeByIds(vos.stream().map(ContractRegisterVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {

        return CommonResponse.success("查询列表数据成功！", service.pageList(param));
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<ContractRegisterVO> list = service.excelExport(param);
        for (ContractRegisterVO contractRegisterVO : list) {
            if(contractRegisterVO.getSettlementType() != null){
                if("0".equals(contractRegisterVO.getSettlementType())){
                    contractRegisterVO.setSettlementType("月度结算");
                }
                if("2".equals(contractRegisterVO.getSettlementType())){
                    contractRegisterVO.setSettlementType("工程节点结算");
                }
                if("3".equals(contractRegisterVO.getSettlementType())){
                    contractRegisterVO.setSettlementType("竣工结算报审");
                }
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);

        ExcelExport.getInstance().export("contract-register-export.xlsx", beans, response);
    }

    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     * @Description 参照
     */
    @RequestMapping(value = "/refContractRegisterData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractRegisterVO>> refContractRegisterData(@RequestParam Integer pageNumber
            , @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("billCode");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("supplementFlag", new Parameter("eq", 0));
        /**
         * 工程定案终审不再推送结算池，取消结算状态过滤
         */
//        param.getParams().put("isFinish", new Parameter("eq", 0));
        param.getParams().put("isRelieve", new Parameter("eq", 0));
        param.getParams().put("isSuspend", new Parameter("eq", 0));


        List<String> changeStatusList = new ArrayList<>();
        changeStatusList.add("1");
        changeStatusList.add("3");
        param.getParams().put("changeStatus", new Parameter(QueryParam.IN, changeStatusList));

        if (StringUtils.isNotEmpty(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
            if (null != conditionMap.get("isFinish")) {
                boolean isFinish = Boolean.parseBoolean(conditionMap.get("isFinish").toString());
                if (!isFinish) {
                    param.getParams().remove("isFinish");
                }
            }
            if (!Objects.equals(conditionMap.get("isRelieve"), null)) {
                boolean isRelieve = Boolean.parseBoolean(conditionMap.get("isRelieve").toString());
                if (!isRelieve) {
                    param.getParams().remove("isRelieve");
                }
            }
            if (!Objects.equals(conditionMap.get("isBudget"), null)) {
                boolean isBudget = Boolean.parseBoolean(conditionMap.get("isBudget").toString());
                if (!isBudget) {
                    param.getParams().remove("changeStatus");
                }
            }
            if (null != conditionMap.get("isEstimation")) {
                Integer isEstimation = Integer.valueOf(conditionMap.get("isEstimation").toString());
                param.getParams().put("isEstimation", new Parameter("eq", isEstimation)); // 过滤1暂估合同，只查询0正式合同

            }
        }

        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        param.getParams().put("billState", new Parameter(QueryParam.IN, billStatus));
        param.getOrderMap().put("createTime", "desc");
        IPage<ContractRegisterEntity> page = service.queryPage(param, false);
        IPage<ContractRegisterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractRegisterVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     * @Description 参照
     */
    @RequestMapping(value = "/refContractRegisterDataMobile", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractRegisterVO>> refContractRegisterDataMobile(@RequestParam Integer pageNumber
            , @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("billCode");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getParams().put("supplementFlag", new Parameter("eq", 0));
        /**
         * 工程定案终审不再推送结算池，取消结算状态过滤
         */
//        param.getParams().put("isFinish", new Parameter("eq", 0));
        param.getParams().put("isRelieve", new Parameter("eq", 0));
        param.getParams().put("isSuspend", new Parameter("eq", 0));


        List<String> changeStatusList = new ArrayList<>();
        changeStatusList.add("1");
        changeStatusList.add("3");
        param.getParams().put("changeStatus", new Parameter(QueryParam.IN, changeStatusList));

        if (StringUtils.isNotEmpty(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
            if (null != conditionMap.get("isFinish")) {
                boolean isFinish = Boolean.parseBoolean(conditionMap.get("isFinish").toString());
                if (!isFinish) {
                    param.getParams().remove("isFinish");
                }
            }
            if (!Objects.equals(conditionMap.get("isRelieve"), null)) {
                boolean isRelieve = Boolean.parseBoolean(conditionMap.get("isRelieve").toString());
                if (!isRelieve) {
                    param.getParams().remove("isRelieve");
                }
            }
            if (!Objects.equals(conditionMap.get("isBudget"), null)) {
                boolean isBudget = Boolean.parseBoolean(conditionMap.get("isBudget").toString());
                if (!isBudget) {
                    param.getParams().remove("changeStatus");
                }
            }
            if (null != conditionMap.get("isEstimation")) {
                Integer isEstimation = Integer.valueOf(conditionMap.get("isEstimation").toString());
                param.getParams().put("isEstimation", new Parameter("eq", isEstimation)); // 过滤1暂估合同，只查询0正式合同

            }
        }

        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        param.getParams().put("billState", new Parameter(QueryParam.IN, billStatus));
        param.getOrderMap().put("createTime", "desc");
        IPage<ContractRegisterEntity> page = service.queryPage(param, false);
        IPage<ContractRegisterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractRegisterVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 新增补充协议时根据评审id查询详情
     *
     * @param reviewId
     * @return
     */
    @RequestMapping(value = "/addRegisterByRevId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractRegisterVO> addRegisterByRevId(Long reviewId) {
        return CommonResponse.success("新增转换数据成功！", service.addRegisterByRevId(reviewId));
    }

    /**
     * 新增补充协议时根据合同id查询详情
     *
     * @param mainContractId
     * @return
     */
    @RequestMapping(value = "/addSupplementByConId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractRegisterVO> addSupplementByConId(Long mainContractId) {
        ContractRegisterVO vo = service.addSupplementByConId(mainContractId);
        return CommonResponse.success("新增转换数据成功！", vo);
    }

    /**
     * 合同补充协议历史记录
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/querySupplementRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RegisterSupplementHistoryVO> querySupplementRecord(@RequestParam Long id) {
        RegisterSupplementHistoryVO vo = service.querySupplementRecord(id);
        return CommonResponse.success(vo);
    }

    /**
     * 新增补充协议评审时校验主合同是否做过登记，并且是审批通过态
     *
     * @param reviewId
     * @return
     */
    @RequestMapping(value = "/queryRegisterByReviewId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ContractRegisterEntity>> queryRegisterByReviewId(@RequestParam Long reviewId) {
        return CommonResponse.success("查询数据成功", service.queryRegisterByReviewId(reviewId));
    }

    /**
     * 同步合同池
     *
     * @param id
     * @return
     */
    @GetMapping(value = "/syncPushContract")
    @ResponseBody
    public CommonResponse<Boolean> syncPushContract(@RequestParam(value = "id") Long id) {
        ContractRegisterEntity registerEntity = service.selectById(id);
        ContractRegisterVO vo = BeanMapper.map(registerEntity, ContractRegisterVO.class);

        return CommonResponse.success("同步合同池成功！", service.pushContract(vo, false));
    }

    /**
     * 根据项目查询合同评审
     *
     * @param projectId
     * @return
     */
    @GetMapping(value = "/queryReviewByProject")
    @ResponseBody
    public CommonResponse<ContractReviewVO> queryReviewByProject(@RequestParam(value = "projectId") Long projectId) {
        return CommonResponse.success("同步合同池成功！", service.queryReviewByProject(projectId));
    }


    /**
     * 推送至财务中间库
     *
     * @param
     * @return
     */
    @GetMapping(value = "/pushToCw")
    @ResponseBody
    public CommonResponse<ContractRegisterVO> pushToCw(@RequestParam(value = "contractId") Long contractId) {
        ContractRegisterEntity entity = service.getById(contractId);
        CommonResponse<List<PMContractVO>> listCommonResponse = contractApi.queryDetail(String.valueOf(contractId), entity.getIsEstimation());
        if (listCommonResponse.getCode() == 0) {
            if (listCommonResponse.getData().size() > 0) {
                throw new BusinessException("此合同财务中间库中已存在！");
            }

            return service.pushToCw(entity);
        } else {
            return CommonResponse.error(listCommonResponse.getMsg());
        }
    }


    /**
     * 根据项目查询暂估合同是否存在
     *
     * @param projectId
     * @return
     */
    @GetMapping(value = "/queryEstimationByProject")
    @ResponseBody
    public CommonResponse<Boolean> queryEstimationByProject(@RequestParam(value = "projectId") Long projectId) {
        List<ContractRegisterEntity> list = service.list(Wrappers.<ContractRegisterEntity>lambdaQuery()
                .eq(ContractRegisterEntity::getProjectId, projectId)
                .eq(ContractRegisterEntity::getIsEstimation, 1)
                .eq(ContractRegisterEntity::getDr, 0)
        );
        boolean flag = false;
        if (list.size() != 0) {
            flag = true;
        }
        return CommonResponse.success("查询成功", flag);
    }


    /**
     * @param
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetailByCustomerId", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryDetailByCustomerId(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        // 项合同编号、项目名称、合同名称、经办人、合同甲方名称、施工联合方、合作乙方名称
        fuzzyFields.add("billCode");//单据编号
        fuzzyFields.add("contractName");//合同名称
        fuzzyFields.add("customerName");//合同甲方名称
        fuzzyFields.add("supplierName");//合作乙方名称

        /**
         *实现分页
         */
        Page<ContractRegisterVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
        List<ContractRegisterVO> vos = service.queryPageContractAndHistoryExport(page, wrapper);

        page.setRecords(vos);
        List<ContractRegisterVO> records = page.getRecords();
        for (ContractRegisterVO record : records) {
            //从项目池中获取数据获取
            CommonResponse<ProjectPoolSetVO> projectPoolSetVO = projectSetApi.getProjectId(record.getProjectId());
            if (projectPoolSetVO != null && projectPoolSetVO.getData() != null) {
                ProjectPoolSetVO data = projectPoolSetVO.getData();
                record.setOrgName("未知");
                if (data.getBusinessStatus() != null){
                    switch (data.getBusinessStatus()){
                        case "1":
                            record.setOrgName("在施");
                            break;
                        case "2":
                            record.setOrgName("停工");
                            break;
                        case "3":
                            record.setOrgName("在施");
                            break;
                        case "4":
                            record.setOrgName("待竣工");
                            break;
                        case "5":
                            record.setOrgName("项目中止");
                            break;
                        case "6":
                            record.setOrgName("竣工");
                            break;
                        case "7":
                            record.setOrgName("未决算");
                            break;
                        case "8":
                            record.setOrgName("决算中");
                            break;
                        case "9":
                            record.setOrgName("已决算");
                            break;
                        case "10":
                            record.setOrgName("资料未归档");
                            break;
                        case "11":
                            record.setOrgName("资料已归档");
                            break;
                        case "12":
                            record.setOrgName("缺陷责任期");
                            break;
                        case "13":
                            record.setOrgName("缺陷责任期结束");
                            break;
                        case "14":
                            record.setOrgName("开账正常");
                            break;
                        case "15":
                            record.setOrgName("资金冻结");
                            break;
                        case "16":
                            record.setOrgName("成本关门");
                            break;
                        case "17":
                            record.setOrgName("已销账");
                            break;
                        case "0":
                            record.setOrgName("未开工");
                            break;
                        default:
                            record.setOrgName("未知");
                            break;
                    }
                }
            }


        }

        JSONObject result = new JSONObject();
        result.put("records", BeanMapper.mapList(page.getRecords(), ContractRegisterVO.class));
        result.put("total", page.getTotal());
        result.put("current", page.getCurrent());
        result.put("size", page.getSize());
        result.put("pages", page.getPages());



        return CommonResponse.success("查询详情数据成功！", result);
    }



    public JSONObject pageList(QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        // 项合同编号、项目名称、合同名称、经办人、合同甲方名称、施工联合方、合作乙方名称
        fuzzyFields.add("billCode");//单据编号
        fuzzyFields.add("projectName");//工程名称
        fuzzyFields.add("contractName");//合同名称
        fuzzyFields.add("employeeName");//经办人
        fuzzyFields.add("customerName");//合同甲方名称
        fuzzyFields.add("constructionPartner");//施工联合方
        fuzzyFields.add("supplierName");//合作乙方名称

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //修改为能够查出补充协议（附加合同）
        //param.getParams().put("supplement_flag", new Parameter("eq", 0));
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1,3)));

        IPage<ContractRegisterEntity> pageData = service.queryPage(param, false);
        List<ContractRegisterEntity> records = pageData.getRecords();
        for (ContractRegisterEntity record : records) {
            //从项目池中获取数据获取
            CommonResponse<ProjectPoolSetVO> projectPoolSetVO = projectSetApi.getProjectId(record.getProjectId());
            if (projectPoolSetVO != null && projectPoolSetVO.getData() != null) {
                ProjectPoolSetVO data = projectPoolSetVO.getData();
//                if (data.getProjectManagementName() != null){
//                    record.setChangeReason(data.getProject));//项目负责人
//                }
                record.setOrgName("未知");
                if (data.getBusinessStatus() != null){
                    switch (data.getBusinessStatus()){
                        case "1":
                            record.setOrgName("在施");
                            break;
                        case "2":
                            record.setOrgName("停工");
                            break;
                        case "3":
                            record.setOrgName("在施");
                            break;
                        case "4":
                            record.setOrgName("待竣工");
                            break;
                        case "5":
                            record.setOrgName("项目中止");
                            break;
                        case "6":
                            record.setOrgName("竣工");
                            break;
                        case "7":
                            record.setOrgName("未决算");
                            break;
                        case "8":
                            record.setOrgName("决算中");
                            break;
                        case "9":
                            record.setOrgName("已决算");
                            break;
                        case "10":
                            record.setOrgName("资料未归档");
                            break;
                        case "11":
                            record.setOrgName("资料已归档");
                            break;
                        case "12":
                            record.setOrgName("缺陷责任期");
                            break;
                        case "13":
                            record.setOrgName("缺陷责任期结束");
                            break;
                        case "14":
                            record.setOrgName("开账正常");
                            break;
                        case "15":
                            record.setOrgName("资金冻结");
                            break;
                        case "16":
                            record.setOrgName("成本关门");
                            break;
                        case "17":
                            record.setOrgName("已销账");
                            break;
                        case "0":
                            record.setOrgName("未开工");
                            break;
                        default:
                            record.setOrgName("未知");
                            break;
                    }
                }

            }


        }

        //页面统计，查询原合同金额，现合同金额
        //Map<String, Object> contractAmountMap = service.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), ContractRegisterVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        //page.put("contractCount", contractAmountMap);

        return page;
    }

    /**
     * @param projectId
     * @Description queryRegisterVO 根据项目查询施工合同详情
     */
    @RequestMapping(value = "/queryRegisterVOByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractRegisterVO> queryRegisterVOByProjectId(Long projectId) {
        LambdaQueryWrapper<ContractRegisterEntity> lambda = Wrappers.<ContractRegisterEntity>lambdaQuery();
        lambda.eq(ContractRegisterEntity::getTenantId,InvocationInfoProxy.getTenantid());
        lambda.eq(ContractRegisterEntity::getProjectId,projectId);
        lambda.in(ContractRegisterEntity::getBillState,1,3);
        List<ContractRegisterEntity> list = service.list(lambda);
        ContractRegisterVO registerResVO = new ContractRegisterVO();
        if(CollectionUtils.isNotEmpty(list)){
            registerResVO = BeanMapper.map(list.get(0),ContractRegisterVO.class);
        }

        return CommonResponse.success("查询详情数据成功！", registerResVO);
    }


    /**
     * @param
     * @Description queryList 查询工期大于90且金额大于1000的项目id列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryListByProjectId", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<Long>> queryListByProjectId(@RequestBody List<Long> ids) {

        return CommonResponse.success("查询列表数据成功！", service.queryListByProjectId(ids));
    }

    /**
     * 经营部门户查询定案阶段分类
     * @return
     */
    @RequestMapping(value = "/querySettleReportProgressType", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<TypeVO>> querySettleReportProgressType() {

        return CommonResponse.success("查询经营部门户查询定案阶段分类列表数据成功！", service.querySettleReportProgressType());
    }

}
