/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.pro.income.bean.ClaimEntity;
import com.ejianc.business.pro.income.bean.ClaimRecordsEntity;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.cons.CommonConstants;
import com.ejianc.business.pro.income.enums.BillPushStatusEnum;
import com.ejianc.business.pro.income.service.IClaimRecordsService;
import com.ejianc.business.pro.income.service.IClaimService;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.utils.MathUtil;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="claim")
public class ClaimBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IClaimService claimService;
    @Autowired
    private IContractRegisterService contractRegisterService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IClaimRecordsService claimRecordsService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ClaimEntity claimEntity = (ClaimEntity)((Object)this.claimService.selectById(billId));
        if (claimEntity.getIsReplayBill() == 1) {
            ClaimEntity claimEntityZhu = (ClaimEntity)((Object)this.claimService.selectById(claimEntity.getReplayBillId()));
            if (claimEntityZhu == null) return CommonResponse.error((String)"\u5355\u636e\u4e0d\u5b58\u5728\uff01");
            LambdaUpdateWrapper wrapper1 = new LambdaUpdateWrapper();
            wrapper1.eq(BaseEntity::getId, (Object)claimEntity.getReplayBillId());
            wrapper1.set(ClaimEntity::getReplyDate, (Object)claimEntity.getReplyDate());
            wrapper1.set(ClaimEntity::getReplyStatus, (Object)claimEntity.getReplyStatus());
            wrapper1.set(ClaimEntity::getReplyMny, (Object)claimEntity.getReplyMny());
            wrapper1.set(ClaimEntity::getReplyTaxMny, (Object)claimEntity.getReplyTaxMny());
            wrapper1.set(ClaimEntity::getReplyTax, (Object)claimEntity.getReplyTax());
            wrapper1.set(ClaimEntity::getReplyDuration, (Object)claimEntity.getReplyDuration());
            ContractRegisterEntity contractRegisterEntity1 = (ContractRegisterEntity)((Object)this.contractRegisterService.selectById(claimEntityZhu.getContractId()));
            if (BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus().equals(contractRegisterEntity1.getBillPushFlag())) {
                claimEntityZhu.setReplyTaxMny(claimEntity.getReplyTaxMny());
                claimEntityZhu.setReplyMny(claimEntity.getReplyMny());
                claimEntityZhu.setReplyTax(claimEntity.getReplyTax());
                claimEntityZhu.setReplyStatus(claimEntity.getReplyStatus());
                boolean pushResult = this.claimService.updateContract(claimEntityZhu, true);
                if (pushResult) {
                    wrapper1.set(ClaimEntity::getBillPushFlag, (Object)BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
                } else {
                    wrapper1.set(ClaimEntity::getBillPushFlag, (Object)BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
                }
            }
            this.claimService.update((Wrapper)wrapper1);
            LambdaUpdateWrapper updateWrapperRecords = new LambdaUpdateWrapper();
            updateWrapperRecords.eq(ClaimRecordsEntity::getClaimId, (Object)claimEntityZhu.getId());
            updateWrapperRecords.set(ClaimRecordsEntity::getReplyStatus, (Object)claimEntityZhu.getReplyStatus());
            this.claimRecordsService.update((Wrapper)updateWrapperRecords);
            return CommonResponse.success();
        } else {
            ContractRegisterEntity contractRegisterEntity = (ContractRegisterEntity)((Object)this.contractRegisterService.selectById(claimEntity.getContractId()));
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            if ("QS".equals(claimEntity.getBillType())) {
                BigDecimal sumNegotiateMny = MathUtil.safeAdd(contractRegisterEntity.getSumNegotiateMny(), claimEntity.getClaimMny());
                BigDecimal sumNegotiateTaxMny = MathUtil.safeAdd(contractRegisterEntity.getSumNegotiateTaxMny(), claimEntity.getClaimTaxMny());
                wrapper.eq(BaseEntity::getId, (Object)claimEntity.getContractId());
                wrapper.set(ContractRegisterEntity::getSumNegotiateMny, (Object)sumNegotiateMny);
                wrapper.set(ContractRegisterEntity::getSumNegotiateTaxMny, (Object)sumNegotiateTaxMny);
            } else if ("QZ".equals(claimEntity.getBillType())) {
                BigDecimal sumVisaMny = MathUtil.safeAdd(contractRegisterEntity.getSumVisaMny(), claimEntity.getClaimMny());
                BigDecimal sumVisaTaxMny = MathUtil.safeAdd(contractRegisterEntity.getSumVisaTaxMny(), claimEntity.getClaimTaxMny());
                wrapper.eq(BaseEntity::getId, (Object)claimEntity.getContractId());
                wrapper.set(ContractRegisterEntity::getSumVisaMny, (Object)sumVisaMny);
                wrapper.set(ContractRegisterEntity::getSumVisaTaxMny, (Object)sumVisaTaxMny);
            } else if ("SP".equals(claimEntity.getBillType())) {
                BigDecimal sumClaimMny = MathUtil.safeAdd(contractRegisterEntity.getSumClaimMny(), claimEntity.getClaimMny());
                BigDecimal sumClaimTaxMny = MathUtil.safeAdd(contractRegisterEntity.getSumClaimTaxMny(), claimEntity.getClaimTaxMny());
                wrapper.eq(BaseEntity::getId, (Object)claimEntity.getContractId());
                wrapper.set(ContractRegisterEntity::getSumClaimMny, (Object)sumClaimMny);
                wrapper.set(ContractRegisterEntity::getSumClaimTaxMny, (Object)sumClaimTaxMny);
            }
            this.contractRegisterService.update((Wrapper)wrapper);
            LambdaUpdateWrapper lambda = new LambdaUpdateWrapper();
            BigDecimal sumOperateMny = MathUtil.safeAdd(contractRegisterEntity.getSumOperateMny(), claimEntity.getClaimMny());
            BigDecimal sumOperateTaxMny = MathUtil.safeAdd(contractRegisterEntity.getSumOperateTaxMny(), claimEntity.getClaimTaxMny());
            lambda.eq(BaseEntity::getId, (Object)claimEntity.getContractId());
            lambda.set(ContractRegisterEntity::getSumOperateMny, (Object)sumOperateMny);
            lambda.set(ContractRegisterEntity::getSumOperateTaxMny, (Object)sumOperateTaxMny);
            this.contractRegisterService.update((Wrapper)lambda);
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(ClaimEntity::getCommitDate, (Object)new Date());
            updateWrapper.eq(BaseEntity::getId, (Object)claimEntity.getId());
            if (BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus().equals(contractRegisterEntity.getBillPushFlag())) {
                contractRegisterEntity.setSumOperateTaxMny(sumOperateTaxMny);
                contractRegisterEntity.setSumOperateMny(sumOperateMny);
                boolean pushResult = this.claimService.updateContract(claimEntity, true);
                if (pushResult) {
                    updateWrapper.set(ClaimEntity::getBillPushFlag, (Object)BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
                } else {
                    updateWrapper.set(ClaimEntity::getBillPushFlag, (Object)BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
                }
            }
            LambdaUpdateWrapper claimRecordsWrapper = new LambdaUpdateWrapper();
            claimRecordsWrapper.eq(ClaimRecordsEntity::getClaimId, (Object)claimEntity.getId());
            claimRecordsWrapper.set(ClaimRecordsEntity::getQuoteStatus, (Object)CommonConstants.YSL);
            this.claimRecordsService.update((Wrapper)claimRecordsWrapper);
            this.claimService.update((Wrapper)updateWrapper);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (res.isSuccess()) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        boolean pushResult;
        ClaimEntity claimEntity = (ClaimEntity)((Object)this.claimService.selectById(billId));
        ContractRegisterEntity contractRegisterEntity = (ContractRegisterEntity)((Object)this.contractRegisterService.selectById(claimEntity.getContractId()));
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        if ("QS".equals(claimEntity.getBillType())) {
            BigDecimal sumNegotiateMny = MathUtil.safeSub(contractRegisterEntity.getSumNegotiateMny(), claimEntity.getClaimMny());
            BigDecimal sumNegotiateTaxMny = MathUtil.safeSub(contractRegisterEntity.getSumNegotiateTaxMny(), claimEntity.getClaimTaxMny());
            wrapper.eq(BaseEntity::getId, (Object)claimEntity.getContractId());
            wrapper.set(ContractRegisterEntity::getSumNegotiateMny, (Object)sumNegotiateMny);
            wrapper.set(ContractRegisterEntity::getSumNegotiateTaxMny, (Object)sumNegotiateTaxMny);
        } else if ("QZ".equals(claimEntity.getBillType())) {
            BigDecimal sumVisaMny = MathUtil.safeSub(contractRegisterEntity.getSumVisaMny(), claimEntity.getClaimMny());
            BigDecimal sumVisaTaxMny = MathUtil.safeSub(contractRegisterEntity.getSumVisaTaxMny(), claimEntity.getClaimTaxMny());
            wrapper.eq(BaseEntity::getId, (Object)claimEntity.getContractId());
            wrapper.set(ContractRegisterEntity::getSumVisaMny, (Object)sumVisaMny);
            wrapper.set(ContractRegisterEntity::getSumVisaTaxMny, (Object)sumVisaTaxMny);
        } else if ("SP".equals(claimEntity.getBillType())) {
            BigDecimal sumClaimMny = MathUtil.safeSub(contractRegisterEntity.getSumClaimMny(), claimEntity.getClaimMny());
            BigDecimal sumClaimTaxMny = MathUtil.safeSub(contractRegisterEntity.getSumClaimTaxMny(), claimEntity.getClaimTaxMny());
            wrapper.eq(BaseEntity::getId, (Object)claimEntity.getContractId());
            wrapper.set(ContractRegisterEntity::getSumClaimMny, (Object)sumClaimMny);
            wrapper.set(ContractRegisterEntity::getSumClaimTaxMny, (Object)sumClaimTaxMny);
        }
        this.contractRegisterService.update((Wrapper)wrapper);
        LambdaUpdateWrapper lambda = new LambdaUpdateWrapper();
        BigDecimal sumOperateMny = MathUtil.safeSub(contractRegisterEntity.getSumOperateMny(), claimEntity.getClaimMny());
        BigDecimal sumOperateTaxMny = MathUtil.safeSub(contractRegisterEntity.getSumOperateTaxMny(), claimEntity.getClaimTaxMny());
        lambda.eq(BaseEntity::getId, (Object)claimEntity.getContractId());
        lambda.set(ContractRegisterEntity::getSumOperateMny, (Object)sumOperateMny);
        lambda.set(ContractRegisterEntity::getSumOperateTaxMny, (Object)sumOperateTaxMny);
        this.contractRegisterService.update((Wrapper)lambda);
        if (BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus().equals(contractRegisterEntity.getBillPushFlag()) && (pushResult = this.claimService.updateContract(claimEntity, false))) {
            claimEntity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
            this.claimService.saveOrUpdate((Object)claimEntity);
        }
        return CommonResponse.success();
    }
}

