/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.airisk.api.RiskitemApi;
import com.ejianc.business.airisk.vo.RiskitemVO;
import com.ejianc.business.airisk.vo.RiskresultVO;
import com.ejianc.business.pro.income.bean.ContractReviewEntity;
import com.ejianc.business.pro.income.mapper.ContractReviewMapper;
import com.ejianc.business.pro.income.service.IContractReviewService;
import com.ejianc.business.pro.income.vo.ContractReviewVO;
import com.ejianc.foundation.ai.api.IAuditApi;
import com.ejianc.foundation.ai.vo.AuditContentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contractReviewService")
public class ContractReviewServiceImpl
extends BaseServiceImpl<ContractReviewMapper, ContractReviewEntity>
implements IContractReviewService {
    private static final String INCOME_CONTRACT_REVIEW = "INCOME_CONTRACT_REVIEW";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IAuditApi auditApi;
    @Autowired
    private RiskitemApi riskitemApi;

    @Override
    public ContractReviewVO saveOrUpdate(ContractReviewVO saveorUpdateVO) {
        ContractReviewEntity contractReviewEntity;
        ContractReviewEntity entity = (ContractReviewEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ContractReviewEntity.class));
        entity.setUseStatus(1);
        if (saveorUpdateVO.getOldReviewId() != null && (contractReviewEntity = (ContractReviewEntity)((Object)((ContractReviewMapper)this.baseMapper).selectById(saveorUpdateVO.getOldReviewId()))) != null) {
            contractReviewEntity.setUseStatus(2);
            this.saveOrUpdate((Object)contractReviewEntity);
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)INCOME_CONTRACT_REVIEW, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveorUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        return (ContractReviewVO)BeanMapper.map((Object)((Object)entity), ContractReviewVO.class);
    }

    @Override
    public ContractReviewVO reviewDetail(Long id) {
        AuditContentVO data;
        CommonResponse auditContentVOCommonResponse;
        ContractReviewEntity entity = (ContractReviewEntity)((Object)super.selectById((Serializable)id));
        if (entity.getAiState() == 1 && entity.getAiId() != null && (auditContentVOCommonResponse = this.auditApi.queryByParseId(entity.getAiId())).isSuccess() && (data = (AuditContentVO)auditContentVOCommonResponse.getData()) != null && data.getLoadingFinished() == 3) {
            if (data != null && CollectionUtils.isNotEmpty((Collection)data.getDetailList())) {
                data.getDetailList().forEach(detail -> {
                    RiskitemVO riskitemEntity = new RiskitemVO();
                    riskitemEntity.setBillId(id);
                    riskitemEntity.setItemId(detail.getItemId());
                    riskitemEntity.setItemContent(detail.getItemContent());
                    riskitemEntity.setItemName(detail.getItemName());
                    riskitemEntity.setItemProperty(detail.getItemProperty());
                    riskitemEntity.setSequence(detail.getSequence());
                    riskitemEntity.setAuditContentId(detail.getAuditContentId());
                    if (detail.getAuditResultList() != null && detail.getAuditResultList().size() > 0) {
                        ArrayList riskresultEntities = new ArrayList();
                        detail.getAuditResultList().forEach(riskresult -> {
                            this.logger.info("\u98ce\u9669\u9879\u4fdd\u5b58--riskresult", (Object)riskresult.getModifyReason());
                            RiskresultVO riskresultEntity = new RiskresultVO();
                            riskresultEntity.setCustomField(riskresult.getCustomField());
                            riskresultEntity.setRiskLevel(riskresult.getRiskLevel());
                            riskresultEntity.setRiskType(riskresult.getRiskType());
                            riskresultEntity.setModifyReason(riskresult.getModifyReason());
                            riskresultEntity.setModifySuggestion(riskresult.getModifySuggestion());
                            riskresultEntity.setAuditContentDetailId(riskresult.getAuditContentDetailId());
                            riskresultEntity.setAuditContentId(riskresult.getAuditContentId());
                            riskresultEntity.setSequence(riskresult.getSequence());
                            riskresultEntities.add(riskresultEntity);
                        });
                        riskitemEntity.setRiskresultList(riskresultEntities);
                    }
                    CommonResponse riskitemVOCommonResponse = this.riskitemApi.saveOrUpdate(riskitemEntity);
                    this.logger.info("\u98ce\u9669\u9879\u4fdd\u5b58--\u7ed3\u679c:{}", (Object)riskitemVOCommonResponse.getMsg());
                });
            }
            entity.setAiState(2);
            super.updateById((Object)entity);
        }
        return (ContractReviewVO)BeanMapper.map((Object)((Object)entity), ContractReviewVO.class);
    }

    @Override
    public ContractReviewVO addSupplementByConId(Long mainContractId) {
        ContractReviewVO vo = this.reviewDetail(mainContractId);
        ContractReviewVO resultVo = new ContractReviewVO();
        resultVo.setProjectId(vo.getProjectId());
        resultVo.setProjectName(vo.getProjectName());
        resultVo.setProjectCode(vo.getProjectCode());
        resultVo.setOrgId(vo.getOrgId());
        resultVo.setOrgCode(vo.getOrgCode());
        resultVo.setOrgName(vo.getOrgName());
        resultVo.setParentOrgId(vo.getParentOrgId());
        resultVo.setParentOrgCode(vo.getParentOrgCode());
        resultVo.setParentOrgName(vo.getParentOrgName());
        resultVo.setContractName(vo.getContractName());
        resultVo.setCustomerId(vo.getCustomerId());
        resultVo.setCustomerName(vo.getCustomerName());
        resultVo.setSupplierId(vo.getSupplierId());
        resultVo.setSupplierName(vo.getSupplierName());
        resultVo.setConstructionPartner(vo.getConstructionPartner());
        resultVo.setConstructionPartnerMember(vo.getConstructionPartnerMember());
        resultVo.setTaxRate(vo.getTaxRate());
        resultVo.setContractType(vo.getContractType());
        resultVo.setContractValuationType(vo.getContractValuationType());
        resultVo.setBuiltArea(vo.getBuiltArea());
        resultVo.setContractPartyc(vo.getContractPartyc());
        resultVo.setConjoinedContractTotalMny(vo.getConjoinedContractTotalMny());
        resultVo.setArchitectId(vo.getArchitectId());
        resultVo.setArchitectName(vo.getArchitectName());
        resultVo.setManagerId(vo.getManagerId());
        resultVo.setManagerName(vo.getManagerName());
        resultVo.setEngineeringTypeId(vo.getEngineeringTypeId());
        resultVo.setEngineeringTypeName(vo.getEngineeringTypeName());
        resultVo.setEmployeeId(this.sessionManager.getUserContext().getEmployeeId());
        resultVo.setEmployeeName(this.sessionManager.getUserContext().getUserName());
        resultVo.setDeptId(this.sessionManager.getUserContext().getDeptId());
        resultVo.setDeptName(this.sessionManager.getUserContext().getDeptName());
        resultVo.setAddress(vo.getAddress());
        resultVo.setMainContractId(mainContractId);
        resultVo.setMainContractName(vo.getContractName());
        resultVo.setMainContractCode(vo.getBillCode());
        resultVo.setBearType(vo.getBearType());
        resultVo.setContractualModel(vo.getContractualModel());
        return resultVo;
    }

    @Override
    public ContractReviewVO editContractByConId(Long oldId) {
        ContractReviewVO vo = this.reviewDetail(oldId);
        ContractReviewVO reviewVO = (ContractReviewVO)BeanMapper.map((Object)vo, ContractReviewVO.class);
        reviewVO.setBillCode(null);
        reviewVO.setBillState(null);
        reviewVO.setBillStateName(null);
        reviewVO.setId(null);
        reviewVO.setBillStateName(null);
        reviewVO.setChildren(null);
        if ("1".equals(vo.getSupplementFlag())) {
            reviewVO.setMainContractId(null);
            reviewVO.setMainContractCode(null);
            reviewVO.setMainContractName(null);
        }
        reviewVO.setUseStatus(Integer.valueOf(1));
        reviewVO.setCreateTime(null);
        reviewVO.setCreateUserCode(null);
        reviewVO.setUpdateTime(null);
        reviewVO.setUpdateUserCode(null);
        reviewVO.setOldReviewCode(vo.getBillCode());
        reviewVO.setOldReviewId(vo.getId());
        reviewVO.setSealDate(null);
        reviewVO.setSealId(null);
        reviewVO.setSealFlag(Integer.valueOf(0));
        reviewVO.setFilingDate(null);
        reviewVO.setFilingFlag(Integer.valueOf(0));
        reviewVO.setCancelFlag(Integer.valueOf(0));
        if (vo.getRevision() == null) {
            reviewVO.setRevision("V0");
        } else {
            String revision = vo.getRevision();
            String end = revision.substring(revision.length() - 1, revision.length());
            String result = String.valueOf(Integer.parseInt(end) + 1);
            String substring = revision.substring(0, revision.length() - 1);
            reviewVO.setRevision(substring + result);
        }
        return reviewVO;
    }

    @Override
    public JSONObject pageList(QueryParam param) {
        int pageIndex = param.getPageIndex();
        int pageSize = param.getPageSize();
        long total = 0L;
        long pages = 0L;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierId");
        fuzzyFields.add("constructId");
        fuzzyFields.add("managerId");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        QueryParam supplementParam = (QueryParam)Utils.deepCopy((Object)param);
        param.getParams().put("supplementFlag", new Parameter("eq", (Object)0));
        List entityList = this.queryList(param);
        total += (long)entityList.size();
        List list = entityList.stream().skip((pageIndex - 1) * pageSize).limit(pageSize).collect(Collectors.toList());
        List voList = BeanMapper.mapList(list, ContractReviewVO.class);
        List idList = voList.stream().map(BaseVO::getId).collect(Collectors.toList());
        List enList = entityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        QueryParam childrenParam = (QueryParam)Utils.deepCopy((Object)param);
        if (ListUtil.isNotEmpty((List)entityList)) {
            if (ListUtil.isNotEmpty(idList)) {
                childrenParam.getParams().put("mainContractId", new Parameter("in", idList));
                childrenParam.getParams().put("supplementFlag", new Parameter("in", Arrays.asList(1, 2)));
                List childrenList = this.queryList(childrenParam);
                List childrenVoList = BeanMapper.mapList((Iterable)childrenList, ContractReviewVO.class);
                Map<Long, List<ContractReviewVO>> childrenMap = childrenVoList.stream().collect(Collectors.groupingBy(ContractReviewVO::getMainContractId));
                if (param.getSearchText() != null && ListUtil.isNotEmpty((List)childrenVoList)) {
                    ArrayList<Long> childrenIdList = new ArrayList<Long>(childrenMap.keySet());
                    param.getParams().put("id", new Parameter("in", (Object)childrenIdList));
                    if (ListUtil.isEmpty((List)entityList)) {
                        param.setSearchText(null);
                    }
                    List newEntityList = this.queryList(param);
                    entityList.addAll(newEntityList);
                    entityList = entityList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ContractReviewEntity>(Comparator.comparing(BaseEntity::getId))), ArrayList::new));
                    entityList = entityList.stream().sorted(Comparator.comparing(BaseEntity::getCreateTime).reversed()).collect(Collectors.toList());
                    list = entityList.stream().skip((pageIndex - 1) * pageSize).limit(pageSize).collect(Collectors.toList());
                    voList = BeanMapper.mapList(list, ContractReviewVO.class);
                }
                if (ListUtil.isNotEmpty((List)voList)) {
                    for (ContractReviewVO vo : voList) {
                        if (!childrenMap.containsKey(vo.getId())) continue;
                        vo.setChildren(childrenMap.get(vo.getId()));
                    }
                }
                supplementParam.setPageIndex(1);
                supplementParam.setPageSize(pageSize - idList.size());
                supplementParam.getParams().put("mainContractId", new Parameter("not_in", enList));
                supplementParam.getParams().put("supplementFlag", new Parameter("in", Arrays.asList(1, 2)));
                IPage contractReviewEntityIPage1 = this.queryPage(supplementParam);
                total += contractReviewEntityIPage1.getTotal();
                if (idList.size() < pageSize) {
                    List records = contractReviewEntityIPage1.getRecords();
                    List contractReviewVOS = BeanMapper.mapList((Iterable)records, ContractReviewVO.class);
                    voList.addAll(contractReviewVOS);
                }
            } else {
                supplementParam.getParams().put("mainContractId", new Parameter("not_in", enList));
                supplementParam.getParams().put("supplementFlag", new Parameter("in", Arrays.asList(1, 2)));
                List contractReviewEntities = this.queryList(supplementParam);
                total += (long)contractReviewEntities.size();
                List collect = contractReviewEntities.stream().skip((pageIndex - 1) * pageSize - entityList.size()).limit(pageSize).collect(Collectors.toList());
                List contractReviewVOS = BeanMapper.mapList(collect, ContractReviewVO.class);
                voList.addAll(contractReviewVOS);
            }
        } else {
            supplementParam.getParams().put("supplementFlag", new Parameter("in", Arrays.asList(1, 2)));
            IPage contractReviewEntityIPage1 = this.queryPage(supplementParam);
            total += contractReviewEntityIPage1.getTotal();
            List records = contractReviewEntityIPage1.getRecords();
            List contractReviewVOS = BeanMapper.mapList((Iterable)records, ContractReviewVO.class);
            voList.addAll(contractReviewVOS);
        }
        if (total % (long)pageSize > 0L) {
            pages = total / (long)pageSize + 1L;
        } else if (total % (long)pageSize == 0L) {
            pages = total / (long)pageSize;
        }
        JSONObject page = new JSONObject();
        page.put("records", (Object)voList);
        page.put("total", (Object)total);
        page.put("current", (Object)pageIndex);
        page.put("size", (Object)pageSize);
        page.put("pages", (Object)pages);
        return page;
    }

    @Override
    public List<ContractReviewVO> excelExport(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierId");
        fuzzyFields.add("constructId");
        fuzzyFields.add("managerId");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        QueryParam supplementParam = (QueryParam)Utils.deepCopy((Object)param);
        param.getParams().put("supplementFlag", new Parameter("eq", (Object)0));
        List entityList = this.queryList(param);
        List voList = BeanMapper.mapList((Iterable)entityList, ContractReviewVO.class);
        List idList = voList.stream().map(BaseVO::getId).collect(Collectors.toList());
        List enList = entityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        QueryParam childrenParam = (QueryParam)Utils.deepCopy((Object)param);
        if (ListUtil.isNotEmpty((List)entityList)) {
            if (ListUtil.isNotEmpty(idList)) {
                childrenParam.getParams().put("mainContractId", new Parameter("in", idList));
                childrenParam.getParams().put("supplementFlag", new Parameter("in", Arrays.asList(1, 2)));
                List childrenList = this.queryList(childrenParam);
                List childrenVoList = BeanMapper.mapList((Iterable)childrenList, ContractReviewVO.class);
                Map<Long, List<ContractReviewVO>> childrenMap = childrenVoList.stream().collect(Collectors.groupingBy(ContractReviewVO::getMainContractId));
                if (param.getSearchText() != null && ListUtil.isNotEmpty((List)childrenVoList)) {
                    ArrayList<Long> childrenIdList = new ArrayList<Long>(childrenMap.keySet());
                    param.getParams().put("id", new Parameter("in", (Object)childrenIdList));
                    if (ListUtil.isEmpty((List)entityList)) {
                        param.setSearchText(null);
                    }
                    List newEntityList = this.queryList(param);
                    entityList.addAll(newEntityList);
                    entityList = entityList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ContractReviewEntity>(Comparator.comparing(BaseEntity::getId))), ArrayList::new));
                    entityList = entityList.stream().sorted(Comparator.comparing(BaseEntity::getCreateTime).reversed()).collect(Collectors.toList());
                    voList = BeanMapper.mapList(entityList, ContractReviewVO.class);
                }
                if (ListUtil.isNotEmpty(voList)) {
                    for (ContractReviewVO vo : voList) {
                        if (!childrenMap.containsKey(vo.getId())) continue;
                        vo.setChildren(childrenMap.get(vo.getId()));
                    }
                }
                supplementParam.getParams().put("mainContractId", new Parameter("not_in", enList));
                supplementParam.getParams().put("supplementFlag", new Parameter("in", Arrays.asList(1, 2)));
                List records = this.queryList(supplementParam);
                List contractReviewVOS = BeanMapper.mapList((Iterable)records, ContractReviewVO.class);
                voList.addAll(contractReviewVOS);
            } else {
                supplementParam.getParams().put("mainContractId", new Parameter("not_in", enList));
                supplementParam.getParams().put("supplementFlag", new Parameter("in", Arrays.asList(1, 2)));
                List contractReviewEntities = this.queryList(supplementParam);
                List contractReviewVOS = BeanMapper.mapList((Iterable)contractReviewEntities, ContractReviewVO.class);
                voList.addAll(contractReviewVOS);
            }
        } else {
            supplementParam.getParams().put("supplementFlag", new Parameter("in", Arrays.asList(1, 2)));
            List records = this.queryList(supplementParam);
            List contractReviewVOS = BeanMapper.mapList((Iterable)records, ContractReviewVO.class);
            voList.addAll(contractReviewVOS);
        }
        voList = voList.stream().sorted(Comparator.comparing(BaseVO::getCreateTime).reversed()).collect(Collectors.toList());
        return voList;
    }

    @Override
    public String relationProject(ContractReviewVO vo) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.set(ContractReviewEntity::getProjectId, (Object)vo.getProjectId());
        wrapper.set(ContractReviewEntity::getProjectCode, (Object)vo.getProjectCode());
        wrapper.set(ContractReviewEntity::getProjectName, (Object)vo.getProjectName());
        wrapper.set(ContractReviewEntity::getOrgId, (Object)vo.getOrgId());
        wrapper.set(ContractReviewEntity::getOrgCode, (Object)vo.getOrgCode());
        wrapper.set(ContractReviewEntity::getOrgName, (Object)vo.getOrgName());
        wrapper.set(ContractReviewEntity::getParentOrgId, (Object)vo.getParentOrgId());
        wrapper.set(ContractReviewEntity::getParentOrgCode, (Object)vo.getParentOrgCode());
        wrapper.set(ContractReviewEntity::getParentOrgName, (Object)vo.getParentOrgName());
        wrapper.eq(BaseEntity::getId, (Object)vo.getId());
        this.update((Wrapper)wrapper);
        return "\u5173\u8054\u9879\u76ee\u6210\u529f\uff01";
    }

    @Override
    public Boolean validateReview(Long projectId, Long id) {
        List list;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ContractReviewEntity::getProjectId, (Object)projectId);
        wrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        wrapper.eq(ContractReviewEntity::getUseStatus, (Object)1);
        if (id != null) {
            wrapper.ne(BaseEntity::getId, (Object)id);
        }
        if (ListUtil.isNotEmpty((List)(list = this.list((Wrapper)wrapper)))) {
            throw new BusinessException("\u5f53\u524d\u9879\u76ee\u5b58\u5728\u5176\u4ed6\u8bc4\u5ba1\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e/\u4fee\u6539!");
        }
        return true;
    }
}

