/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.income.bean.BudgetCategoryEntity;
import com.ejianc.business.pro.income.bean.BudgetEntity;
import com.ejianc.business.pro.income.service.IBudgetCategoryService;
import com.ejianc.business.pro.income.service.IBudgetService;
import com.ejianc.business.pro.income.vo.BudgetCategoryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"budgetCategory"})
public class BudgetCategoryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IBudgetCategoryService service;
    @Autowired
    private IBudgetService budgetService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BudgetCategoryVO> saveOrUpdate(@RequestBody BudgetCategoryVO saveorUpdateVO) {
        BudgetCategoryEntity entity = (BudgetCategoryEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, BudgetCategoryEntity.class));
        this.recalibration(entity);
        this.service.saveOrUpdate((Object)entity, false);
        BudgetCategoryVO vo = (BudgetCategoryVO)BeanMapper.map((Object)((Object)entity), BudgetCategoryVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BudgetCategoryVO> queryDetail(Long id) {
        BudgetCategoryEntity entity = (BudgetCategoryEntity)((Object)this.service.selectById(id));
        BudgetCategoryVO vo = (BudgetCategoryVO)BeanMapper.map((Object)((Object)entity), BudgetCategoryVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetCategoryVO> vos) {
        List entityList;
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        boolean flag = false;
        for (BudgetCategoryVO vo : vos) {
            if (vo.getIncomeFlag() == 1) {
                flag = true;
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(BudgetEntity::getBudgetCategoryId, (Object)vo.getId());
                queryWrapper.eq(BaseEntity::getDr, (Object)0);
                queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
                queryWrapper.eq(BudgetEntity::getIncomeFlag, (Object)1);
                List entities = this.budgetService.list((Wrapper)queryWrapper);
                if (CollectionUtils.isNotEmpty((Collection)entities)) {
                    throw new BusinessException("\u5220\u9664\u5931\u8d25\uff01\u8be5\u9884\u7b97\u5206\u7c7b\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
                }
            }
            query.eq(BaseEntity::getDr, (Object)0);
            query.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        if (flag && CollectionUtils.isNotEmpty((Collection)(entityList = this.service.list((Wrapper)query)))) {
            ((BudgetCategoryEntity)((Object)entityList.get(0))).setIncomeFlag(1);
            this.service.updateById(entityList.get(0));
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BudgetCategoryVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BudgetCategoryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BudgetCategory-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refBudgetCategoryData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BudgetCategoryVO>> refBudgetCategoryData(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="condition", required=false) String condition) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List BudgetCategoryVOS = BeanMapper.mapList((Iterable)page.getRecords(), BudgetCategoryVO.class);
        BudgetCategoryVOS.forEach(e -> {
            if (e.getIncomeFlag() == 1) {
                e.setIncomeFlagName("\u662f");
            } else {
                e.setIncomeFlagName("\u5426");
            }
        });
        pageData.setRecords(BudgetCategoryVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"updateReplyDate"})
    @ResponseBody
    public CommonResponse<String> updateReplyDate(@RequestBody BudgetCategoryVO budgetCategory) {
        BudgetCategoryEntity entity = (BudgetCategoryEntity)((Object)BeanMapper.map((Object)budgetCategory, BudgetCategoryEntity.class));
        BudgetCategoryEntity budgetCategoryEntity = (BudgetCategoryEntity)((Object)this.service.selectById(budgetCategory.getId()));
        if (budgetCategory.getIncomeFlag() == 1) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(BudgetEntity::getBudgetCategoryId, (Object)budgetCategory.getId());
            queryWrapper.eq(BaseEntity::getDr, (Object)0);
            queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            queryWrapper.eq(BudgetEntity::getIncomeFlag, (Object)1);
            List entityList = this.budgetService.list((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)entityList)) {
                throw new BusinessException("\u7f16\u8f91\u5931\u8d25\uff01\u8be5\u9884\u7b97\u5206\u7c7b\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u7f16\u8f91");
            }
        }
        this.recalibration(entity);
        if (budgetCategoryEntity != null) {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.eq(BaseEntity::getId, (Object)budgetCategory.getId());
            wrapper.set(BudgetCategoryEntity::getCode, (Object)budgetCategory.getCode());
            wrapper.set(BudgetCategoryEntity::getName, (Object)budgetCategory.getName());
            wrapper.set(BudgetCategoryEntity::getMemo, (Object)budgetCategory.getMemo());
            this.service.update((Wrapper)wrapper);
            return CommonResponse.success();
        }
        return CommonResponse.error((String)"\u5355\u636e\u4e0d\u5b58\u5728\uff01");
    }

    @RequestMapping(value={"/flag"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BudgetCategoryVO> flag(@RequestBody BudgetCategoryVO vos) {
        BudgetCategoryEntity entity = (BudgetCategoryEntity)((Object)BeanMapper.map((Object)vos, BudgetCategoryEntity.class));
        if (vos.getIncomeFlag() != 1) {
            throw new BusinessException("\u662f\u5426\u6536\u5165\u81f3\u5c11\u4e00\u4e2a\u4e3a\u662f");
        }
        LambdaUpdateWrapper updateData = new LambdaUpdateWrapper();
        updateData.set(BudgetCategoryEntity::getIncomeFlag, (Object)0);
        updateData.ne(BaseEntity::getId, (Object)vos.getId());
        this.service.update((Wrapper)updateData);
        this.service.saveOrUpdate((Object)entity, false);
        BudgetCategoryVO vo = (BudgetCategoryVO)BeanMapper.map((Object)((Object)entity), BudgetCategoryVO.class);
        return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/getIncome"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BudgetCategoryVO> getIncome() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEntity::getDr, (Object)0);
        queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.eq(BudgetCategoryEntity::getIncomeFlag, (Object)1);
        queryWrapper.last("LIMIT 1");
        BudgetCategoryEntity entity = (BudgetCategoryEntity)((Object)this.service.getOne((Wrapper)queryWrapper));
        BudgetCategoryVO vo = null;
        if (entity != null) {
            vo = (BudgetCategoryVO)BeanMapper.map((Object)((Object)entity), BudgetCategoryVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", vo);
    }

    public void recalibration(BudgetCategoryEntity entity) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(BaseEntity::getDr, (Object)0);
        lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambda.eq(BudgetCategoryEntity::getCode, (Object)entity.getCode());
        List entities1 = this.service.list((Wrapper)lambda);
        if (entities1.size() != 0) {
            throw new BusinessException("\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BaseEntity::getDr, (Object)0);
        wrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        wrapper.eq(BudgetCategoryEntity::getName, (Object)entity.getName());
        List entities = this.service.list((Wrapper)wrapper);
        if (entities.size() != 0) {
            throw new BusinessException("\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
    }
}

