package com.ejianc.business.pro.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.enums.BusinessStatusEnum;
import com.ejianc.business.enums.SettleStatusEnum;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.FinalizedEntity;
import com.ejianc.business.pro.income.enums.BillStateEnum;
import com.ejianc.business.pro.income.enums.FinalStageEnum;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IFinalizedService;
import com.ejianc.business.pro.income.vo.FinalizedHistoryVO;
import com.ejianc.business.pro.income.vo.FinalizedVO;
import com.ejianc.business.pro.income.vo.SettleReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 工程定案
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("finalized")
public class FinalizedController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    
    @Autowired
    private IOrgApi iOrgApi;
    
    @Autowired
    private IFinalizedService service;

    @Autowired
    private IContractRegisterService registerService;
    @Autowired
    private IProjectSetApi projectSetApi;

    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<FinalizedVO> saveOrUpdate(@RequestBody FinalizedVO saveOrUpdateVO) {
    	return CommonResponse.success("保存或修改单据成功！", service.saveOrUpdate(saveOrUpdateVO));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FinalizedVO> queryDetail(Long id) {
    	FinalizedEntity entity = service.selectById(id);
    	FinalizedVO vo = BeanMapper.map(entity, FinalizedVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FinalizedVO> vos) {
        List<Long> ids = vos.stream().map(FinalizedVO::getId).collect(Collectors.toList());
        
        LambdaQueryWrapper<FinalizedEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(FinalizedEntity::getId, ids);
        List<FinalizedEntity> list = service.list(wrapper);
        if(ListUtil.isNotEmpty(list)){
            List<Long> contractIds = list.stream().filter(e -> e.getFinalStage().equals(FinalStageEnum.终审.getCode())).map(FinalizedEntity::getContractId).collect(Collectors.toList());
            if(ListUtil.isNotEmpty(contractIds)){
                // 删除终审单据后回写合同终审状态
                LambdaUpdateWrapper<ContractRegisterEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.set(ContractRegisterEntity::getIsFinish, 0);
                updateWrapper.set(ContractRegisterEntity::getContractStatus, 1);
                updateWrapper.in(ContractRegisterEntity::getId, contractIds);
                registerService.update(updateWrapper);
            }
        }
        service.removeByIds(ids,true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FinalizedVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
//        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<FinalizedEntity> page = service.queryPage(param,false);
        IPage<FinalizedVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), FinalizedVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");

        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        
        List<FinalizedEntity> list = service.queryList(param);
        List<FinalizedVO> voList = BeanMapper.mapList(list, FinalizedVO.class);
        for (FinalizedVO vo : voList) {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            if (Objects.equals(vo.getFinalStage(), FinalStageEnum.一审.getCode())) {
                vo.setFinalStageName("一审");
            }
            if (Objects.equals(vo.getFinalStage(), FinalStageEnum.二审.getCode())) {
                vo.setFinalStageName("二审");
            }
            if (Objects.equals(vo.getFinalStage(), FinalStageEnum.三审.getCode())) {
                vo.setFinalStageName("三审");
            }
            if (Objects.equals(vo.getFinalStage(), FinalStageEnum.终审.getCode())) {
                vo.setFinalStageName("终审");
            }
        }
        
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("finalized-export.xlsx", beans, response);
    }
    
    /**
     * 参照
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refFinalizedData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<FinalizedVO>> refFinalizedData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize
            , String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<FinalizedEntity> page = service.queryPage(param,false);
        IPage<FinalizedVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), FinalizedVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    
    /**
     * 根据项目id、合同id查询结算报审单数据
     * @param projectId
     * @param contractId
     * @return
     */
    @RequestMapping(value = "/querySettleReport", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettleReportVO> querySettleReport(@RequestParam(required = false) Long projectId, @RequestParam Long contractId) {
        return CommonResponse.success("查询数据成功！", service.querySettleReport(projectId, contractId));
    }
    
    /**
     * 根据项目id、合同id查询工程定案单数据
     * @param projectId
     * @param contractId
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryFinalizedList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FinalizedVO> queryFinalizedList(@RequestParam(required = false) Long projectId, @RequestParam Long contractId
            , @RequestParam(required = false) Long id) {
        return CommonResponse.success("查询数据成功！", service.queryFinalizedList(projectId, contractId, id));
    }

    /**
     * 根据项目id、合同id查询工程定案单数据
     * @param projectId
     * @param contractId
     * @param id
     * @return
     */
    @RequestMapping(value = "/validateFinalStage", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> validateFinalStage(@RequestParam(required = false) Long projectId, @RequestParam Long contractId
            , String finalStage, @RequestParam(required = false) Long id) {
        return CommonResponse.success("查询数据成功！", service.validateFinalStage(projectId, contractId, finalStage, id));
    }

    /**
     * 合同补充协议历史记录
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryFinalizedRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FinalizedHistoryVO> queryFinalizedRecord(@RequestParam Long id) {
        return CommonResponse.success("查询数据成功！", service.queryFinalizedRecord(id));
    }

    /**
     * 同步结算池
     * @param id
     * @return
     */
    @GetMapping(value = "/syncPushSettlePool")
    @ResponseBody
    public CommonResponse<Boolean> syncPushSettlePool(@RequestParam(value = "id") Long id) {
        FinalizedEntity finalizedEntity = service.selectById(id);
        FinalizedVO vo = BeanMapper.map(finalizedEntity, FinalizedVO.class);
        if ("4".equals(vo.getFinalStage())){
            boolean pool = service.pushSettleToPool(vo);
            if(!pool){
                return CommonResponse.error("推送结算池失败");
            }
        } else {
            return CommonResponse.success("无需推送！", true);
        }
        return CommonResponse.success("同步结算池成功！", true);
    }
    /**
     * @Description adjustGd 更改归档
     * @Param [ids]
     */
    @RequestMapping(value = "/adjustGd", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> adjustGd(@RequestBody List<FinalizedVO> vos) {
        List<Long> ids = vos.stream().map(FinalizedVO::getId).collect(Collectors.toList());
        service.update(Wrappers.<FinalizedEntity>lambdaUpdate()
                .set(FinalizedEntity::getGdDate,new Date())
                .set(FinalizedEntity::getGdStatus,1)
                .in(FinalizedEntity::getId,ids)
        );

        boolean sendFlag = service.sendMsg(vos);

        for (FinalizedVO vo : vos) {
            CommonResponse<String> res = projectSetApi.changeProjectStatus(vo.getProjectId(), null, null, SettleStatusEnum.已决算.getCode(), null, null);
            service.updateProjectSettleStatus(vo.getProjectId(), SettleStatusEnum.已决算.getCode());
            if (!res.isSuccess()) {
                logger.info("工程定案【{}】更新【项目池】结算状态为已决算失败，失败原因：{}", vo.getBillCode(), res.getMsg());
                throw new BusinessException("工程定案【" + vo.getBillCode() + "】更新【项目池】结算状态为已决算失败，失败原因：" + res.getMsg());
            }
        }

        return CommonResponse.success("修改已归档状态成功！");
    }
    /**
     * @Description adjustUnGd 更改未归档
     * @Param [ids]
     */
    @RequestMapping(value = "/adjustUnGd", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> adjustUnGd(@RequestBody List<FinalizedVO> vos) {
        List<Long> ids = vos.stream().map(FinalizedVO::getId).collect(Collectors.toList());
        List<Long> projectIds = vos.stream().map(FinalizedVO::getProjectId).collect(Collectors.toList());


        service.update(Wrappers.<FinalizedEntity>lambdaUpdate()
                .set(FinalizedEntity::getGdDate,new Date())
                .set(FinalizedEntity::getGdStatus,2)
                .in(FinalizedEntity::getId,ids)
        );
        List<FinalizedEntity> list = service.list(Wrappers.<FinalizedEntity>lambdaQuery()
                .notIn(FinalizedEntity::getId)
                .in(FinalizedEntity::getProjectId, projectIds)
                .in(FinalizedEntity::getBillState, Arrays.asList(1, 3))
                .eq(FinalizedEntity::getGdStatus,1)

        );
        if(ListUtil.isEmpty(list)){
            for (FinalizedVO vo : vos) {
                CommonResponse<String> res = projectSetApi.changeProjectStatus(vo.getProjectId(), null, null, SettleStatusEnum.决算中.getCode(), null, null);
                service.updateProjectSettleStatus(vo.getProjectId(), SettleStatusEnum.决算中.getCode());
                if (!res.isSuccess()) {
                    logger.info("工程定案【{}】更新【项目池】结算状态为决算中失败，失败原因：{}", vo.getBillCode(), res.getMsg());
                    throw new BusinessException("工程定案【" + vo.getBillCode() + "】更新【项目池】结算状态为决算中失败，失败原因：" + res.getMsg());
                }
            }
        }
        return CommonResponse.success("修改未归档状态成功！");
    }


    /**
     * @Description queryFinalizedMnyByProjectId 根据项目id获取定案金额
     * @param projectId
     */
    @RequestMapping(value = "/queryFinalizedMnyByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BigDecimal> queryFinalizedMnyByProjectId(Long projectId) {
        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //`gd_status` '归档状态(1-已归档 2-未归档)'
        param.getParams().put("gdStatus", new Parameter(QueryParam.EQ, "1"));

        //projectId
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));

        List<FinalizedEntity> finalizedEntities = service.queryList(param);

        //审定金额求和
        BigDecimal reduce = finalizedEntities.stream().map(FinalizedEntity::getCheckTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);

        return CommonResponse.success("查询审定金额数据成功！",reduce);
    }
}
