package com.ejianc.business.pro.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.pro.income.bean.ClaimRecordsEntity;
import com.ejianc.business.pro.income.cons.CommonConstants;
import com.ejianc.business.pro.income.mapper.ClaimRecordsMapper;
import com.ejianc.business.pro.income.service.IClaimRecordsService;
import com.ejianc.business.pro.income.vo.ClaimRecordsVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * 洽商签证索赔记录
 * 
 * @author generator
 * 
 */
@Service("claimRecordsService")
public class ClaimRecordsServiceImpl extends BaseServiceImpl<ClaimRecordsMapper, ClaimRecordsEntity> implements IClaimRecordsService{


    @Override
    public void updateClaimRecords(Long claimId, String replyStatus, List<Long> claimRecordIds) {
        LambdaUpdateWrapper<ClaimRecordsEntity> wrapper = new LambdaUpdateWrapper();
        wrapper.eq(ClaimRecordsEntity::getClaimId, claimId);
        wrapper.set(ClaimRecordsEntity::getClaimId, null);
//        wrapper.set(ClaimRecordsEntity::getReplyStatus, CommonConstants.WU);
        wrapper.set(ClaimRecordsEntity::getQuoteStatus, CommonConstants.WYY);
        this.update(wrapper);
        if (CollectionUtils.isNotEmpty(claimRecordIds)) {
            claimRecordIds.forEach(e -> {
                LambdaUpdateWrapper<ClaimRecordsEntity> lambda = new LambdaUpdateWrapper();
                lambda.eq(ClaimRecordsEntity::getId, e);
                lambda.set(ClaimRecordsEntity::getClaimId, claimId);
                lambda.set(ClaimRecordsEntity::getReplyStatus, replyStatus);
                lambda.set(ClaimRecordsEntity::getQuoteStatus, CommonConstants.SLZ);
                this.update(lambda);
            });
        }
    }

    @Override
    public List<ClaimRecordsVO> selectByClaimId(Long claimId) {
        LambdaUpdateWrapper<ClaimRecordsEntity> wrapper = new LambdaUpdateWrapper();
        wrapper.eq(ClaimRecordsEntity::getClaimId, claimId);
        wrapper.eq(ClaimRecordsEntity::getDr, 0);
        wrapper.eq(ClaimRecordsEntity::getTenantId, InvocationInfoProxy.getTenantid());
        List<ClaimRecordsEntity> list = this.list(wrapper);
        List<ClaimRecordsVO> budgetVOS = BeanMapper.mapList(list, ClaimRecordsVO.class);
        return budgetVOS;
    }

    @Override
    public void deleteClaimId(List<Long> claimIds) {
        LambdaUpdateWrapper<ClaimRecordsEntity> wrapper = new LambdaUpdateWrapper<>();
        wrapper.in(ClaimRecordsEntity::getClaimId, claimIds);
        wrapper.set(ClaimRecordsEntity::getClaimId, null);
        wrapper.set(ClaimRecordsEntity::getReplyStatus, null);
        wrapper.set(ClaimRecordsEntity::getQuoteStatus, CommonConstants.WYY);
        this.update(wrapper);
    }

    @Override
    public Date getLastRecordByContractId(Long contractId) {
        return baseMapper.getLastRecordByContractId(contractId);
    }

}
