package com.ejianc.business.pro.income.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.cwdataexchange.PMContractPush.api.IPMContractApi;
import com.ejianc.business.cwdataexchange.PMContractPush.vo.PMContractVO;
import com.ejianc.business.pro.income.bean.ContractRegisterChangeEntity;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.mapper.ContractRegisterChangeMapper;
import com.ejianc.business.pro.income.service.IContractRegisterChangeService;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.vo.*;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 合同登记变更
 * 
 * @author generator
 * 
 */
@Service("contractRegisterChangeService")
public class ContractRegisterChangeServiceImpl extends BaseServiceImpl<ContractRegisterChangeMapper, ContractRegisterChangeEntity> implements IContractRegisterChangeService{

    private static final String INCOME_CONTRACT_REGISTER_CHANGE = "INCOME_CONTRACT_REGISTER_CHANGE";//此处需要根据实际修改
    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IBillCodeApi billCodeApi;
    
    @Autowired
    private IContractRegisterService registerService;

    @Autowired
    private IPMContractApi contractApi;

    @Autowired
    private IProjectSetApi projectSetApi;

    @Autowired
    private IDefdocApi defdocApi;
    
    
    @Override
    public ContractRegisterChangeVO saveOrUpdate(ContractRegisterChangeVO saveorUpdateVO) {

        //保存时校验联合体相关金额是否相等
        if (saveorUpdateVO.getConjoinedManageType() != null ){
            if (saveorUpdateVO.getConjoinedManageType().equals(1)
                    && saveorUpdateVO.getThisChangeTaxMny() != null
                    && saveorUpdateVO.getContractBaseTaxMnyNoConjoined() != null
                    && saveorUpdateVO.getThisChangeTaxMny().compareTo(saveorUpdateVO.getContractBaseTaxMnyNoConjoined()) != 0 ){
                throw new BusinessException("并列关系时，‘本次变更金额’与‘含税合同签订金额（不含联合体）’应相等！");
            }
            if (saveorUpdateVO.getConjoinedManageType().equals(2)
                    && saveorUpdateVO.getThisChangeTaxMny() != null
                    && saveorUpdateVO.getContractBaseTaxMny() != null
                    && saveorUpdateVO.getThisChangeTaxMny().compareTo(saveorUpdateVO.getContractBaseTaxMny()) != 0 ){
                throw new BusinessException("合并关系时，‘本次变更金额’与‘含税合同签订总金额’应相等！");
            }
        }


        ContractRegisterChangeEntity entity = BeanMapper.map(saveorUpdateVO, ContractRegisterChangeEntity.class);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(entity.getId() == null || entity.getId() == 0){
            // 新增
            if (null == entity.getChangeVersion() || entity.getChangeVersion() == 0) {
                entity.setChangeVersion(1);//第一次变更
            } else {
                entity.setChangeVersion(entity.getChangeVersion() + 1);//版本号+1
            }
            if("2".equals(saveorUpdateVO.getChangeStatus())){
                throw new BusinessException("合同存在变更中单据，不允许保存!");
            }

//            BillCodeParam billCodeParam = BillCodeParam.build(INCOME_CONTRACT_REGISTER_CHANGE, InvocationInfoProxy.getTenantid(),saveorUpdateVO);
//            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
//            if(billCode.isSuccess()) {
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
//            }else{
//                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//            }

            if(entity.getChangeVersion() < 10){
                entity.setBillCode(entity.getMainContractCode() + "-1-" + "0" + entity.getChangeVersion());
            } else {
                entity.setBillCode(entity.getMainContractCode() + "-1-" + entity.getChangeVersion());
            }

            //校验合同编号是否重复
            LambdaQueryWrapper<ContractRegisterChangeEntity> lambda = new LambdaQueryWrapper<>();
            lambda.eq(ContractRegisterChangeEntity::getTenantId, tenantId);
            lambda.eq(ContractRegisterChangeEntity::getBillCode, entity.getBillCode());
            lambda.ne(ContractRegisterChangeEntity::getRegisterId, entity.getRegisterId());
            List<ContractRegisterChangeEntity> entityList = super.list(lambda);
            if (ListUtil.isNotEmpty(entityList)) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }else {
            // 修改
            if(StringUtils.isEmpty(entity.getBillCode())){
                entity.setBillCode(null);
            }

            // 校验合同编号是否重复
            LambdaQueryWrapper<ContractRegisterChangeEntity> lambda = new LambdaQueryWrapper<>();
            lambda.eq(ContractRegisterChangeEntity::getBillCode, entity.getBillCode());
            lambda.eq(ContractRegisterChangeEntity::getTenantId, tenantId);
            lambda.ne(ContractRegisterChangeEntity::getId, entity.getId());
            lambda.ne(ContractRegisterChangeEntity::getRegisterId, entity.getRegisterId());
            List<ContractRegisterChangeEntity> entityList = super.list(lambda);
            if (ListUtil.isNotEmpty(entityList)) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }

        entity.setContractTaxMny(ComputeUtil.safeAdd(entity.getContractTaxMnyNew(), entity.getThisChangeTaxMny()));
        entity.setContractMny(ComputeUtil.safeAdd(entity.getContractMnyNew(), entity.getThisChangeMny()));
        entity.setTaxMny(ComputeUtil.safeAdd(entity.getTaxMnyNew(), entity.getThisChangeTax()));


        super.saveOrUpdate(entity, false);


        // 回写主表
        LambdaUpdateWrapper<ContractRegisterEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(ContractRegisterEntity::getChangingTaxMny, entity.getContractTaxMny());
        updateWrapper.set(ContractRegisterEntity::getChangingMny, entity.getContractMny());
        updateWrapper.set(ContractRegisterEntity::getChangeId, entity.getId());
        updateWrapper.set(ContractRegisterEntity::getChangeStatus, "2");
        updateWrapper.set(ContractRegisterEntity::getChangeCode, entity.getBillCode());
        updateWrapper.eq(ContractRegisterEntity::getId, entity.getRegisterId());
        registerService.update(updateWrapper);

        return BeanMapper.map(this.selectById(entity.getId()), ContractRegisterChangeVO.class);
    }

    @Override
    public void deleteChange(List<ContractRegisterChangeVO> vos) {
        for (ContractRegisterChangeVO vo : vos) {
            ContractRegisterChangeEntity changeEntity = super.selectById(vo.getId());
            LambdaUpdateWrapper<ContractRegisterEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.set(ContractRegisterEntity::getChangingTaxMny,BigDecimal.ZERO);
            wrapper.set(ContractRegisterEntity::getChangingMny,BigDecimal.ZERO);
            if (changeEntity.getChangeVersion() == 1) {
                wrapper.set(ContractRegisterEntity::getChangeStatus, 1);
            }else {
                wrapper.set(ContractRegisterEntity::getChangeStatus, 3);
            }
            wrapper.eq(ContractRegisterEntity::getId, changeEntity.getRegisterId());
            registerService.update(wrapper);
            super.removeById(vo, false);
        }
    }

    @Override
    public ContractRegisterChangeVO addChangeByConId(Long registerId) {
        ContractRegisterEntity entity = registerService.selectById(registerId);
        ContractRegisterChangeVO vo = BeanMapper.map(entity, ContractRegisterChangeVO.class);
        vo.setCwNatureAccounting("3");
        vo.setCostAccounting(2);
        vo.setId(null);
        vo.setRegisterId(entity.getId());
        vo.setChangeTime(new Date());
        vo.setBeforeChangeTaxMny(entity.getContractTaxMny());
        vo.setBeforeChangeMny(entity.getContractMny());
        vo.setMainContractId(entity.getId());
        vo.setMainContractCode(entity.getBillCode());
        vo.setMainContractName(entity.getContractName());
        vo.setContractTaxMnyNew(entity.getContractTaxMny());
        vo.setContractMnyNew(entity.getContractMny());
        vo.setTaxMnyNew(entity.getTaxMny());
        vo.setBillState(null);
        vo.setCreateUserCode(null);
        vo.setCreateTime(null);
        vo.setUpdateUserCode(null);
        vo.setUpdateTime(null);
        vo.setChangeReason(null);
        vo.setContractBaseMny(null);
        vo.setContractBaseTaxMny(null);
        vo.setContractBaseMnyConjoined(null);
        vo.setContractBaseTaxMnyConjoined(null);
        vo.setContractBaseMnyNoConjoined(null);
        vo.setContractBaseTaxMnyNoConjoined(null);
        vo.setConjoinedManageType(null);

        //质保金、付款节点
        List<ContractChangePayRemarkVO> payRemarkVOS = BeanMapper.mapList(entity.getContractRegisterPayRemarkList(), ContractChangePayRemarkVO.class);
        List<ContractChangePayNodeVO> payNodeVOS = BeanMapper.mapList(entity.getContractRegisterPayNodeList(), ContractChangePayNodeVO.class);

        for (ContractChangePayRemarkVO payRemarkVO : payRemarkVOS) {
//            payRemarkVO.setId(null);
            payRemarkVO.setBillState(null);
            payRemarkVO.setCreateUserCode(null);
            payRemarkVO.setCreateTime(null);
            payRemarkVO.setUpdateUserCode(null);
            payRemarkVO.setUpdateTime(null);
        }
        for (ContractChangePayNodeVO  payNodeVO: payNodeVOS) {
//            payNodeVO.setId(null);
            payNodeVO.setBillState(null);
            payNodeVO.setCreateUserCode(null);
            payNodeVO.setCreateTime(null);
            payNodeVO.setUpdateUserCode(null);
            payNodeVO.setUpdateTime(null);
        }
        vo.setContractChangePayRemarkList(payRemarkVOS);
        vo.setContractChangePayNodeList(payNodeVOS);

        return vo;
    }

    @Override
    public RegisterChangeHistoryVO queryChangeRecord(Long id) {
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        LambdaQueryWrapper<ContractRegisterChangeEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ContractRegisterChangeEntity::getRegisterId, id);
        wrapper.in(ContractRegisterChangeEntity::getBillState, billStatus);
        wrapper.orderByDesc(ContractRegisterChangeEntity::getUsedTime);
        List<ContractRegisterChangeEntity> changeEntityList = this.list(wrapper);

        // 原合同
        ContractRegisterEntity registerEntity = registerService.selectById(id);

        RegisterChangeHistoryVO vo = new RegisterChangeHistoryVO();
        vo.setRegisterId(registerEntity.getId());
        vo.setContractTaxMny(registerEntity.getContractTaxMny()== null ? BigDecimal.ZERO : registerEntity.getContractTaxMny());
        vo.setContractMny(registerEntity.getContractMny()== null ? BigDecimal.ZERO : registerEntity.getContractMny());
        vo.setBaseTaxMoney(registerEntity.getBaseTaxMoney()== null ? BigDecimal.ZERO : registerEntity.getBaseTaxMoney());
        vo.setBaseMoney(registerEntity.getBaseMoney()== null ? BigDecimal.ZERO : registerEntity.getBaseMoney());
        vo.setChangeStatus(registerEntity.getChangeStatus());
        vo.setIsFinish(registerEntity.getIsFinish());
        vo.setIsRelieve(registerEntity.getIsRelieve());
        vo.setIsSuspend(registerEntity.getIsSuspend());

        BigDecimal changeMny = ComputeUtil.safeSub(vo.getContractTaxMny(), vo.getBaseTaxMoney());
        vo.setSumChangeMny(changeMny);
        BigDecimal sumChangeRate = BigDecimal.ZERO;
        if (vo.getBaseTaxMoney().compareTo(BigDecimal.ZERO) != 0) {
            sumChangeRate = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(vo.getSumChangeMny(), vo.getBaseTaxMoney()), new BigDecimal("100"));
        }
        vo.setSumScale(sumChangeRate);

        List<ContractRegisterChangeVO> changeVOList = BeanMapper.mapList(changeEntityList, ContractRegisterChangeVO.class);
        int index = 1;
        for (ContractRegisterChangeVO changeVO : changeVOList) {
            changeVO.setHistoryBillCode(registerEntity.getBillCode() + "-" + index);
            BigDecimal subtract = ComputeUtil.safeSub(changeVO.getContractTaxMny(), changeVO.getBeforeChangeTaxMny());
            BigDecimal changeRate = BigDecimal.ZERO;
            if (changeVO.getBeforeChangeTaxMny() != null && changeVO.getBeforeChangeTaxMny().compareTo(BigDecimal.ZERO) != 0) {
                changeRate = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(subtract, changeVO.getBeforeChangeTaxMny()), new BigDecimal("100"));
            }
            changeVO.setScale(changeRate);
            index++;
        }
        vo.setChangeRecord(changeVOList);
        
        return vo;
    }

    @Override
    public CommonResponse<ContractRegisterChangeVO> pushToCw(ContractRegisterChangeEntity changeEntity) {
        /**
         * 推送财务中间表  ------------------------开始
         * 变更合同
         */
        logger.info("推送财务中间表  ------------------------开始");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");


        //从项目池中获取数据获取
        CommonResponse<ProjectPoolSetVO> projectPoolSetVO = projectSetApi.getProjectId(changeEntity.getProjectId());
        PMContractVO pmContractVO = BeanMapper.map(changeEntity, PMContractVO.class);

        pmContractVO.setZgbz(0);//是否是暂估合同  不是
        pmContractVO.setBslx("变更合同");
        pmContractVO.setContractStatus(null);//变更合同都是不赋值


        pmContractVO.setContractId(String.valueOf(changeEntity.getId()));//合同id
        if (changeEntity.getChangeTime() != null) {
            pmContractVO.setDjrq(sdf.format(changeEntity.getChangeTime()));//单据日期
        }
        if (changeEntity.getSignDate() != null) {
            pmContractVO.setSignDate(sdf.format(changeEntity.getSignDate()));//合同签订日期
        }
        pmContractVO.setContractCode(changeEntity.getBillCode());//合同编号

        if(changeEntity.getBaseTaxMoney() != null) {
            pmContractVO.setHtljhsje(changeEntity.getBaseTaxMoney());//合同累计含税金额字段取 合同签订金额字段
        }
        pmContractVO.setContractTypeName("施工合同");//合同类型2
        /**
         * 项目池中获取数据
         */
        if (projectPoolSetVO != null && projectPoolSetVO.getData() != null){
            ProjectPoolSetVO data = projectPoolSetVO.getData();
            if (data.getAreaName() != null){
                pmContractVO.setSzs(data.getAreaName());//所在地区
            }
            if (data.getAddress() != null){
                pmContractVO.setXxdz(data.getAddress());//详细地址
            }
            if (data.getEngineeringType() != null){
                CommonResponse<DefdocDetailVO> defDocById = defdocApi.getDefDocById(data.getEngineeringType());
                if (defDocById.getCode() == 0 && defDocById.getData() != null) {
                    pmContractVO.setGclb(defDocById.getData().getName());//工程类别
                }
            }
            if (data.getMeasureType() != null  && data.getMeasureType().equals(1506803511994617857L) && data.getMeasureValue() != null){
                pmContractVO.setJzmj(data.getMeasureValue());//建筑面积
            }
            if (data.getPlanStartDate() != null){
                pmContractVO.setKgrq(sdf.format(data.getPlanStartDate()));//开工日期
            }
            if (data.getPlanEndDate() != null){
                pmContractVO.setJgrq(sdf.format(data.getPlanEndDate()));//竣工日期
            }
            if (data.getProjectManagementName() != null){
                pmContractVO.setXmfzr(data.getProjectManagementName());//项目负责人
            }
            if (data.getProjectManagementPhone() != null){
                pmContractVO.setXmfzedh(data.getProjectManagementPhone());//项目负责人电话
            }
        }
        if (changeEntity.getThisChangeTaxMny() != null){
            pmContractVO.setBcbgje(changeEntity.getThisChangeTaxMny());//本次变更金额
        }

        CommonResponse<PMContractVO> pmContractVOCommonResponse = contractApi.saveContract(pmContractVO);



        logger.info("推送财务中间表  ------------------------结束"+ JSON.toJSONString(pmContractVOCommonResponse));
        /**
         * 推送财务中间表  ------------------------结束
         */

        return CommonResponse.success("推送财务中间表成功！", BeanMapper.map(changeEntity, ContractRegisterChangeVO.class));
    }
}
