package com.ejianc.business.pro.income.service.impl;

import com.ejianc.business.pro.income.bean.BudgetEntity;
import com.ejianc.business.pro.income.bean.QuoteDetailEntity;
import com.ejianc.business.pro.income.bean.QuoteEntity;
import com.ejianc.business.pro.income.mapper.QuoteDetailMapper;
import com.ejianc.business.pro.income.service.IBudgetService;
import com.ejianc.business.pro.income.service.IQuoteDetailService;
import com.ejianc.business.pro.income.service.IQuoteService;
import com.ejianc.business.pro.income.utils.DetailListUtil;
import com.ejianc.business.pro.income.utils.IncomeSortUtil;
import com.ejianc.business.pro.income.utils.TreeNodeBUtil;
import com.ejianc.business.pro.income.vo.*;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 对甲报量子表
 * 
 * @author generator
 * 
 */
@Service("quoteDetailService")
public class QuoteDetailServiceImpl extends BaseServiceImpl<QuoteDetailMapper, QuoteDetailEntity> implements IQuoteDetailService{

    @Autowired
    private IQuoteService quoteService;

    @Autowired
    private IBudgetService budgetService;

    @Autowired
    private DetailListUtil detailListUtil;

    @Override
    public QuoteDetailVO queryBudgetDetail(Long id) {
        Map<Long, QuoteDetailPubVO> pubMap = this.getPubVOSumMap(id);// 已生效预算书明细累计值
        BudgetEntity entity = budgetService.selectById(id);
        QuoteDetailVO vo = BeanMapper.map(entity, QuoteDetailVO.class);
        List<QuoteDetailCostVO> costList = BeanMapper.mapList(entity.getCostVos(), QuoteDetailCostVO.class);
        List<QuoteDetailSubVO> subList = BeanMapper.mapList(entity.getSubVos(), QuoteDetailSubVO.class);
        List<QuoteDetailMeasureVO> measureList = BeanMapper.mapList(entity.getMeasureVos(), QuoteDetailMeasureVO.class);
        List<QuoteDetailOtherVO> otherList = BeanMapper.mapList(entity.getOtherVos(), QuoteDetailOtherVO.class);
        List<QuoteDetailFeeVO> feeList = BeanMapper.mapList(entity.getFeeVos(), QuoteDetailFeeVO.class);
        LastVO lastVO = new LastVO();
        if (CollectionUtils.isNotEmpty(costList)) {
            for (QuoteDetailCostVO dvo : costList) {
                dvo.setTid(dvo.getId().toString());
                dvo.setTpid(dvo.getParentId() != null && dvo.getParentId() > 0 ? dvo.getParentId().toString() : "");
                dvo.setRowState("edit");
                if(pubMap.containsKey(dvo.getId())){
                    QuoteDetailPubVO pub = pubMap.get(dvo.getId());
                    dvo.setLastQuoteNum(pub.getQuoteNum());
                    dvo.setLastQuoteMny(pub.getQuoteMny());
                    dvo.setLastQuoteTaxMny(pub.getQuoteTaxMny());
                    if(dvo.getLeafFlag()) this.computeLast(lastVO, pub);// 汇总截止上期累计
                }
            }
            new IncomeSortUtil<QuoteDetailCostVO>().entryListToSort(costList);
            vo.setCostList(TreeNodeBUtil.buildTree(costList));
        }
        if (CollectionUtils.isNotEmpty(subList)) {
            for (QuoteDetailSubVO dvo : subList) {
                dvo.setTid(dvo.getId().toString());
                dvo.setTpid(dvo.getParentId() != null && dvo.getParentId() > 0 ? dvo.getParentId().toString() : "");
                dvo.setRowState("edit");
                if(pubMap.containsKey(dvo.getId())){
                    QuoteDetailPubVO pub = pubMap.get(dvo.getId());
                    dvo.setLastQuoteNum(pub.getQuoteNum());
                    dvo.setLastQuoteMny(pub.getQuoteMny());
                    dvo.setLastQuoteTaxMny(pub.getQuoteTaxMny());
                    if(dvo.getLeafFlag()) this.computeLast(lastVO, pub);// 汇总截止上期累计
                }
            }
            new IncomeSortUtil<QuoteDetailSubVO>().entryListToSort(subList);
            vo.setSubList(TreeNodeBUtil.buildTree(subList));
        }
        if (CollectionUtils.isNotEmpty(measureList)) {
            for (QuoteDetailMeasureVO dvo : measureList) {
                dvo.setTid(dvo.getId().toString());
                dvo.setTpid(dvo.getParentId() != null && dvo.getParentId() > 0 ? dvo.getParentId().toString() : "");
                dvo.setRowState("edit");
                if(pubMap.containsKey(dvo.getId())){
                    QuoteDetailPubVO pub = pubMap.get(dvo.getId());
                    dvo.setLastQuoteNum(pub.getQuoteNum());
                    dvo.setLastQuoteMny(pub.getQuoteMny());
                    dvo.setLastQuoteTaxMny(pub.getQuoteTaxMny());
                    if(dvo.getLeafFlag()) this.computeLast(lastVO, pub);// 汇总截止上期累计
                }
            }
            new IncomeSortUtil<QuoteDetailMeasureVO>().entryListToSort(measureList);
            vo.setMeasureList(TreeNodeBUtil.buildTree(measureList));
        }
        if (CollectionUtils.isNotEmpty(otherList)) {
            for (QuoteDetailOtherVO dvo : otherList) {
                dvo.setTid(dvo.getId().toString());
                dvo.setTpid(dvo.getParentId() != null && dvo.getParentId() > 0 ? dvo.getParentId().toString() : "");
                dvo.setRowState("edit");
                if(pubMap.containsKey(dvo.getId())){
                    QuoteDetailPubVO pub = pubMap.get(dvo.getId());
                    dvo.setLastQuoteNum(pub.getQuoteNum());
                    dvo.setLastQuoteMny(pub.getQuoteMny());
                    dvo.setLastQuoteTaxMny(pub.getQuoteTaxMny());
                    if(dvo.getLeafFlag()) this.computeLast(lastVO, pub);// 汇总截止上期累计
                }
            }
            new IncomeSortUtil<QuoteDetailOtherVO>().entryListToSort(otherList);
            vo.setOtherList(TreeNodeBUtil.buildTree(otherList));
        }
        if (CollectionUtils.isNotEmpty(feeList)) {
            for (QuoteDetailFeeVO dvo : feeList) {
                dvo.setTid(dvo.getId().toString());
                dvo.setTpid(dvo.getParentId() != null && dvo.getParentId() > 0 ? dvo.getParentId().toString() : "");
                dvo.setRowState("edit");
                if(pubMap.containsKey(dvo.getId())){
                    QuoteDetailPubVO pub = pubMap.get(dvo.getId());
                    dvo.setLastQuoteNum(pub.getQuoteNum());
                    dvo.setLastQuoteMny(pub.getQuoteMny());
                    dvo.setLastQuoteTaxMny(pub.getQuoteTaxMny());
                    if(dvo.getLeafFlag()) this.computeLast(lastVO, pub);// 汇总截止上期累计
                }
            }
            new IncomeSortUtil<QuoteDetailFeeVO>().entryListToSort(feeList);
            vo.setFeeList(TreeNodeBUtil.buildTree(feeList));
        }
        vo.setLastQuoteMny(lastVO.getLastMny());
        vo.setLastQuoteTaxMny(lastVO.getLastTaxMny());
        return vo;
    }

    /**
     * 汇总截止上期累计
     * @param lastVO
     * @param pub
     */
    private void computeLast(LastVO lastVO, QuoteDetailPubVO pub) {
        lastVO.setLastMny(ComputeUtil.safeAdd(lastVO.getLastMny(), pub.getQuoteMny()));
        lastVO.setLastTaxMny(ComputeUtil.safeAdd(lastVO.getLastTaxMny(), pub.getQuoteTaxMny()));
    }

    /**
     * 已生效预算书明细累计值
     * @param id
     * @return
     */
    private Map<Long, QuoteDetailPubVO> getPubVOSumMap(Long id) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<QuoteEntity> quoteList = quoteService.queryList(queryParam);
        Map<Long, QuoteDetailPubVO> pubMap = new HashMap<>();// key-预算书明细主键，value-截止本期累计值
        if(CollectionUtils.isNotEmpty(quoteList)){
            List<Long> quoteIds = quoteList.stream().map(QuoteEntity::getId).collect(Collectors.toList());
            QueryParam param = new QueryParam();
            param.getParams().put("quoteId", new Parameter(QueryParam.IN, quoteIds));
            param.getParams().put("budgetId", new Parameter(QueryParam.EQ, id));
            List<QuoteDetailEntity> detailList = super.queryList(param);
            detailListUtil.setDetailList(detailList);
            if(CollectionUtils.isNotEmpty(detailList)){
                detailList.forEach(detail->{
                    List<QuoteDetailPubVO> pubList = new ArrayList<>();
                    if(CollectionUtils.isNotEmpty(detail.getCostList())){
                        pubList.addAll(BeanMapper.mapList(detail.getCostList(), QuoteDetailPubVO.class));
                    }
                    if(CollectionUtils.isNotEmpty(detail.getSubList())){
                        pubList.addAll(BeanMapper.mapList(detail.getSubList(), QuoteDetailPubVO.class));
                    }
                    if(CollectionUtils.isNotEmpty(detail.getMeasureList())){
                        pubList.addAll(BeanMapper.mapList(detail.getMeasureList(), QuoteDetailPubVO.class));
                    }
                    if(CollectionUtils.isNotEmpty(detail.getOtherList())){
                        pubList.addAll(BeanMapper.mapList(detail.getOtherList(), QuoteDetailPubVO.class));
                    }
                    if(CollectionUtils.isNotEmpty(detail.getFeeList())){
                        pubList.addAll(BeanMapper.mapList(detail.getFeeList(), QuoteDetailPubVO.class));
                    }
                    pubList.forEach(vo->{
                        QuoteDetailPubVO pub = new QuoteDetailPubVO();
                        if(!pubMap.containsKey(vo.getBudgetDetailId())){
                            pub.setBudgetDetailId(vo.getBudgetDetailId());
                            pub.setQuoteNum(vo.getQuoteNum());
                            pub.setQuoteMny(vo.getQuoteMny());
                            pub.setQuoteTaxMny(vo.getQuoteTaxMny());
                            pubMap.put(vo.getBudgetDetailId(), pub);
                        } else {
                            pub = pubMap.get(vo.getBudgetDetailId());
                            pub.setQuoteNum(ComputeUtil.safeAdd(pub.getQuoteNum(), vo.getQuoteNum()));
                            pub.setQuoteMny(ComputeUtil.safeAdd(pub.getQuoteMny(), vo.getQuoteMny()));
                            pub.setQuoteTaxMny(ComputeUtil.safeAdd(pub.getQuoteTaxMny(), vo.getQuoteTaxMny()));
                        }
                    });
                });
            }
        }
        return pubMap;
    }
}
