/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.constructor.api.IZjllApi;
import com.ejianc.business.constructor.vo.ZjllVO;
import com.ejianc.business.cwdataexchange.PMContractPush.api.IPMContractApi;
import com.ejianc.business.cwdataexchange.PMContractPush.vo.PMContractVO;
import com.ejianc.business.market.api.IProjectPartApi;
import com.ejianc.business.market.vo.ProjectPartVO;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.ContractReviewEntity;
import com.ejianc.business.pro.income.enums.BillPushStatusEnum;
import com.ejianc.business.pro.income.enums.ContractStatusEnum;
import com.ejianc.business.pro.income.mapper.ContractRegisterMapper;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IContractReviewService;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.IShareCustomerApi;
import com.ejianc.foundation.support.vo.CustomerIncomeInfoVO;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contractRegister")
public class ContractRegisterBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IContractRegisterService service;
    @Autowired
    private IPMContractApi contractApi;
    @Autowired
    private IProjectSetApi projectSetApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IContractReviewService reviewService;
    @Autowired
    private IShareCustomerApi customerApi;
    @Autowired
    private ContractRegisterMapper contractRegisterMapper;
    @Autowired
    private IProjectPartApi projectPartApi;
    @Autowired
    private IZjllApi zjllApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u63d0\u4ea4\u56de\u5199\u5408\u540c\u72b6\u6001\u5f00\u59cb");
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.set(ContractRegisterEntity::getContractStatus, (Object)ContractStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
        wrapper.eq(BaseEntity::getId, (Object)billId);
        this.service.update((Wrapper)wrapper);
        this.logger.info("\u63d0\u4ea4\u56de\u5199\u5408\u540c\u72b6\u6001\u7ed3\u675f");
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ContractRegisterEntity contractEntity = (ContractRegisterEntity)((Object)this.service.selectById(billId));
        boolean pushResult = this.service.pushContract((ContractRegisterVO)BeanMapper.map((Object)((Object)contractEntity), ContractRegisterVO.class), false);
        if (pushResult) {
            contractEntity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
        } else {
            contractEntity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        }
        Long projectId = contractEntity.getProjectId();
        List list = this.service.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ContractRegisterEntity::getProjectId, (Object)projectId)).in(ContractRegisterEntity::getBillState, new Object[]{1, 3})).eq(BaseEntity::getDr, (Object)0)).eq(ContractRegisterEntity::getSupplementFlag, (Object)0)).eq(ContractRegisterEntity::getIsEstimation, (Object)0)).ne(BaseEntity::getId, (Object)contractEntity.getId()));
        if (ListUtil.isEmpty((List)list)) {
            Boolean b = this.contractRegisterMapper.updatePlanDate(projectId, contractEntity.getStartDate(), contractEntity.getEndDate(), contractEntity.getSchedule(), contractEntity.getCwProjectCode(), contractEntity.getCwProjectName(), contractEntity.getContractValuationType());
            if (b.booleanValue()) {
                this.logger.info("\u540c\u6b65\u9879\u76ee\u57fa\u672c\u4fe1\u606f\u6210\u529f\uff01{}", (Object)projectId);
            } else {
                this.logger.info("\u540c\u6b65\u9879\u76ee\u57fa\u672c\u4fe1\u606f\u5931\u8d25\uff01");
            }
            CommonResponse projectVOCommonResponse = this.projectSetApi.getProjectId(projectId);
            if (projectVOCommonResponse.isSuccess()) {
                this.logger.info("\u540c\u6b65\u9879\u76ee\u6c60\u5f00\u59cb\uff01");
                ProjectPoolSetVO projectPoolSetVO = (ProjectPoolSetVO)projectVOCommonResponse.getData();
                projectPoolSetVO.setPlanStartDate(contractEntity.getStartDate());
                projectPoolSetVO.setPlanEndDate(contractEntity.getEndDate());
                projectPoolSetVO.setPlanDateNum(contractEntity.getSchedule());
                this.logger.info("\u540c\u6b65\u9879\u76ee\u6c60\u7ed3\u675f\uff01{}", (Object)projectPoolSetVO);
                this.projectSetApi.pushProjectPoolSetNoInitial(JSONObject.toJSONString((Object)projectPoolSetVO).getBytes(StandardCharsets.UTF_8));
            }
        } else {
            this.logger.info("\u540c\u6b65\u9879\u76ee\u57fa\u672c\u4fe1\u606f\u5931\u8d25\uff01\u5df2\u5b58\u5728\u5ba1\u6279\u901a\u8fc7\u7684\u6b63\u5f0f\u65bd\u5de5\u5408\u540c\uff01");
        }
        this.service.saveOrUpdate((Object)contractEntity);
        if (contractEntity.getReviewId() != null && contractEntity.getIsEstimation() != 1) {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.set(ContractReviewEntity::getFilingFlag, (Object)1);
            wrapper.set(ContractReviewEntity::getFilingId, (Object)contractEntity.getId());
            wrapper.set(ContractReviewEntity::getFilingDate, (Object)new Date());
            wrapper.eq(BaseEntity::getId, (Object)contractEntity.getReviewId());
            this.reviewService.update((Wrapper)wrapper);
        }
        CustomerIncomeInfoVO customerInfoVO = this.service.queryCustomerInfo(contractEntity.getCustomerId());
        customerInfoVO.setCustomerId(contractEntity.getCustomerId());
        CommonResponse stringCommonResponse = this.customerApi.updateIncomeMny(customerInfoVO);
        this.logger.info("\u4fee\u6539\u5ba2\u6237\u4fe1\u606f\u8fd4\u56de\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)stringCommonResponse));
        this.logger.info("\u6267\u884c\u6807\u6bb5\u63a8\u9001\u5f00\u59cb===============");
        ProjectPartVO projectPartVO = new ProjectPartVO();
        projectPartVO.setBidSummaryId(contractEntity.getSummaryId());
        projectPartVO.setEnrollId(contractEntity.getEnrollId());
        projectPartVO.setProjectId(contractEntity.getProjectId());
        projectPartVO.setProjectName(contractEntity.getProjectName());
        projectPartVO.setContractName(contractEntity.getContractName());
        projectPartVO.setContractId(contractEntity.getId());
        projectPartVO.setContractMny(contractEntity.getContractMny());
        projectPartVO.setContractType(contractEntity.getContractType());
        CommonResponse defDocBy = this.defdocApi.getDefDocById(contractEntity.getContractType());
        if (defDocBy.getCode() == 0 && defDocBy.getData() != null) {
            projectPartVO.setContractTypeName(((DefdocDetailVO)defDocBy.getData()).getName());
        }
        projectPartVO.setCwProjectCode(contractEntity.getCwProjectCode());
        projectPartVO.setCwProjectName(contractEntity.getCwProjectName());
        projectPartVO.setCwAccountCode(contractEntity.getCwAccountCode());
        projectPartVO.setCwProjectTypeName(contractEntity.getContractTypeName());
        projectPartVO.setSourceType("\u65bd\u5de5\u5408\u540c");
        CommonResponse poolSetVOCommonResponse = this.projectSetApi.getProjectId(contractEntity.getProjectId());
        if (poolSetVOCommonResponse.getCode() == 0 && poolSetVOCommonResponse.getData() != null) {
            CommonResponse defDocById;
            ProjectPoolSetVO projectPoolSetVO = (ProjectPoolSetVO)poolSetVOCommonResponse.getData();
            if (projectPoolSetVO.getEngineeringTypeId() != null && (defDocById = this.defdocApi.getDefDocById(projectPoolSetVO.getEngineeringTypeId())).getCode() == 0 && defDocById.getData() != null) {
                projectPartVO.setContractualModel(projectPoolSetVO.getEngineeringTypeId());
                projectPartVO.setContractualModelName(((DefdocDetailVO)defDocById.getData()).getName());
            }
            projectPartVO.setProjectType(projectPoolSetVO.getProjectType());
        }
        projectPartVO.setBidSummaryId(contractEntity.getSummaryId());
        CommonResponse partVOCommonResponse = this.projectPartApi.saveOrUpdate(projectPartVO);
        if (!partVOCommonResponse.isSuccess()) {
            this.logger.info("\u751f\u6210\u6267\u884c\u6807\u6bb5\u5931\u8d25");
        }
        this.logger.info("\u6267\u884c\u6807\u6bb5\u63a8\u9001\u7ed3\u675f===============");
        this.logger.info("\u63a8\u9001\u5728\u5efa\u5c65\u5386\u5f00\u59cb===============");
        ProjectPartVO partVO = (ProjectPartVO)partVOCommonResponse.getData();
        Long summaryId = partVO.getBidSummaryId();
        Long enrollId = partVO.getEnrollId();
        QueryParam queryParam = new QueryParam();
        if (enrollId == null) {
            throw new BusinessException("\u6295\u6807\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)enrollId));
        queryParam.getParams().put("yxzt", new Parameter("eq", (Object)0));
        CommonResponse commonResponse = this.zjllApi.queryListByParam(queryParam);
        if (!commonResponse.isSuccess()) {
            throw new BusinessException("\u5728\u5efa\u5c65\u5386\u67e5\u8be2\u5931\u8d25!");
        }
        JSONArray data = (JSONArray)commonResponse.getData();
        List zjllVOS = data.toJavaList(ZjllVO.class);
        for (ZjllVO zjllVO : zjllVOS) {
            zjllVO.setYxzt(Integer.valueOf(1));
            zjllVO.setJssj(new Date());
            zjllVO.setXmId(zjllVO.getXmId());
            zjllVO.setChangeId(partVO.getId());
            zjllVO.setChangeType("\u6267\u884c\u6807\u6bb5");
            this.zjllApi.updateWrapper(zjllVO);
            ZjllVO newZjllVO = new ZjllVO();
            newZjllVO.setXmId(zjllVO.getXmId());
            newZjllVO.setXmName(zjllVO.getXmName());
            newZjllVO.setGwId(zjllVO.getGwId());
            newZjllVO.setGw(zjllVO.getGw());
            newZjllVO.setProjectId(zjllVO.getProjectId());
            newZjllVO.setProjectName(zjllVO.getProjectName());
            newZjllVO.setKssj(new Date());
            newZjllVO.setZt(Integer.valueOf(1));
            newZjllVO.setYxzt(Integer.valueOf(0));
            newZjllVO.setSfgs(zjllVO.getSfgs());
            newZjllVO.setOrgId(zjllVO.getOrgId());
            newZjllVO.setOrgName(zjllVO.getOrgName());
            newZjllVO.setTags("\u5728\u5efa\u5c65\u5386");
            newZjllVO.setRemark("\u6267\u884c\u6807\u6bb5");
            newZjllVO.setProPid(partVO.getProjectId());
            newZjllVO.setProPname(partVO.getProjectName());
            newZjllVO.setProjectPartId(partVO.getId());
            newZjllVO.setContractId(partVO.getContractId());
            this.zjllApi.save(newZjllVO);
            this.logger.info("\u6267\u884c\u6807\u6bb5\u5199\u5165\u72b6\u6001\u4e3a2\u5230 \u5728\u5efa\u4eba\u5458\u5c65\u5386\uff01");
        }
        this.logger.info("\u63a8\u9001\u5728\u5efa\u5c65\u5386\u7ed3\u675f===============");
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ContractRegisterEntity entity = (ContractRegisterEntity)((Object)this.service.selectById(billId));
        if (entity.getSupplementFlag() == 1) {
            return CommonResponse.error((String)"\u8865\u5145\u534f\u8bae\u6682\u4e0d\u652f\u6301\u56de\u9000\u529f\u80fd!");
        }
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (res.isSuccess()) {
            CommonResponse listCommonResponse;
            Boolean b;
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.set(ContractRegisterEntity::getContractStatus, (Object)ContractStatusEnum.\u672a\u7b7e\u8ba2.getCode());
            wrapper.eq(BaseEntity::getId, (Object)billId);
            boolean delResult = this.service.delContractFromPool(billId);
            if (delResult) {
                wrapper.set(ContractRegisterEntity::getBillPushFlag, (Object)BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
                this.service.update((Wrapper)wrapper);
            }
            CustomerIncomeInfoVO customerInfoVO = this.service.queryCustomerInfo(entity.getCustomerId());
            customerInfoVO.setCustomerId(entity.getCustomerId());
            CommonResponse stringCommonResponse = this.customerApi.updateIncomeMny(customerInfoVO);
            this.logger.info("\u4fee\u6539\u5ba2\u6237\u4fe1\u606f\u8fd4\u56de\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)stringCommonResponse));
            if (entity.getReviewId() != null && entity.getIsEstimation() != 1) {
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.set(ContractReviewEntity::getFilingFlag, (Object)0);
                updateWrapper.set(ContractReviewEntity::getFilingId, null);
                updateWrapper.set(ContractReviewEntity::getFilingDate, null);
                updateWrapper.eq(BaseEntity::getId, (Object)entity.getReviewId());
                this.reviewService.update((Wrapper)updateWrapper);
            }
            if ((b = this.contractRegisterMapper.updatePlanDate(entity.getProjectId(), null, null, null, null, null, null)).booleanValue()) {
                this.logger.info("\u540c\u6b65\u9879\u76ee\u57fa\u672c\u4fe1\u606f\u6210\u529f\uff01{}", (Object)entity.getProjectId());
            } else {
                this.logger.info("\u540c\u6b65\u9879\u76ee\u57fa\u672c\u4fe1\u606f\u5931\u8d25\uff01");
            }
            CommonResponse projectVOCommonResponse = this.projectSetApi.getProjectId(entity.getProjectId());
            if (projectVOCommonResponse.isSuccess()) {
                this.logger.info("\u540c\u6b65\u9879\u76ee\u6c60\u5f00\u59cb\uff01");
                ProjectPoolSetVO projectPoolSetVO = (ProjectPoolSetVO)projectVOCommonResponse.getData();
                projectPoolSetVO.setPlanStartDate(null);
                projectPoolSetVO.setPlanEndDate(null);
                projectPoolSetVO.setPlanDateNum(null);
                this.logger.info("\u540c\u6b65\u9879\u76ee\u6c60\u7ed3\u675f\uff01{}", (Object)projectPoolSetVO);
                this.projectSetApi.pushProjectPoolSetNoInitial(JSONObject.toJSONString((Object)projectPoolSetVO).getBytes(StandardCharsets.UTF_8));
            }
            if ((listCommonResponse = this.contractApi.queryDetail(String.valueOf(billId), entity.getIsEstimation())).getCode() == 0) {
                List data = (List)listCommonResponse.getData();
                for (PMContractVO contractVO : data) {
                    if (contractVO.getYybs() != 1) continue;
                    return CommonResponse.error((String)"\u5df2\u88ab\u8d22\u52a1\u7cfb\u7edf\u4f7f\u7528\uff01");
                }
            }
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

