package com.ejianc.business.pro.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.airisk.api.RiskitemApi;
import com.ejianc.business.airisk.vo.RiskitemVO;
import com.ejianc.business.airisk.vo.RiskresultVO;
import com.ejianc.business.pro.income.bean.ContractReviewEntity;
import com.ejianc.business.pro.income.enums.BillStateEnum;
import com.ejianc.business.pro.income.mapper.ContractReviewMapper;
import com.ejianc.business.pro.income.service.IContractReviewService;
import com.ejianc.business.pro.income.vo.ContractReviewVO;
import com.ejianc.foundation.ai.api.IAuditApi;
import com.ejianc.foundation.ai.vo.AuditContentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 施工合同评审
 *
 * @author generator
 */
@Service("contractReviewService")
public class ContractReviewServiceImpl extends BaseServiceImpl<ContractReviewMapper, ContractReviewEntity> implements IContractReviewService {

    private static final String INCOME_CONTRACT_REVIEW = "INCOME_CONTRACT_REVIEW";//此处需要根据实际修改
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IAuditApi auditApi;
    @Autowired
    private RiskitemApi riskitemApi;
    @Override
    public ContractReviewVO saveOrUpdate(ContractReviewVO saveorUpdateVO) {
        ContractReviewEntity entity = BeanMapper.map(saveorUpdateVO, ContractReviewEntity.class);
        entity.setUseStatus(1);
//        // 补充协议不限制同一项目只能有一个
//        if (1 != saveorUpdateVO.getSupplementFlag()) {
//            validateReview(entity.getProjectId(), entity.getId());
//        }
        //保存时，将原评审记录（状态标识为已废除）
        if (saveorUpdateVO.getOldReviewId() != null) {
//            LambdaQueryWrapper<ContractReviewEntity> wrapper = Wrappers.<ContractReviewEntity>lambdaQuery();
//            wrapper.eq(ContractReviewEntity::getBillCode, saveorUpdateVO.getOldReviewCode());
//            wrapper.eq(ContractReviewEntity::getUseStatus,1);
//            wrapper.eq(ContractReviewEntity::getSupplementFlag,saveorUpdateVO.getSupplementFlag());
//            if(saveorUpdateVO.getId() != null){
//                wrapper.ne(ContractReviewEntity::getId,saveorUpdateVO.getId());
//            }
            ContractReviewEntity contractReviewEntity = this.baseMapper.selectById(saveorUpdateVO.getOldReviewId());
            if(contractReviewEntity != null){
                contractReviewEntity.setUseStatus(2);
                this.saveOrUpdate(contractReviewEntity);
            }
        }


        if (entity.getId() == null || entity.getId() == 0) {
            // 新增
            BillCodeParam billCodeParam = BillCodeParam.build(INCOME_CONTRACT_REVIEW, InvocationInfoProxy.getTenantid(), saveorUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }

            entity.setAiState(0);//默认未推送
        }

        super.saveOrUpdate(entity, false);

        return BeanMapper.map(entity, ContractReviewVO.class);
    }

    @Override
    public ContractReviewVO reviewDetail(Long id) {
        ContractReviewEntity entity = super.selectById(id);

        //如果ai解析状态为正在解析，则从益企联的接口获取解析数据
        if (entity.getAiState() == 1 && entity.getAiId() != null){
            //通过接口获取状态，如果解析完成，则将数据存到本地。并修改状态为已解析
            CommonResponse<AuditContentVO> auditContentVOCommonResponse = auditApi.queryByParseId(entity.getAiId());
            if (auditContentVOCommonResponse.isSuccess()) {
                AuditContentVO data = auditContentVOCommonResponse.getData();
                if (data != null && data.getLoadingFinished() == 3) { //审查完成
                    if (data != null && CollectionUtils.isNotEmpty(data.getDetailList())) {
                        data.getDetailList().forEach(detail -> {
                            RiskitemVO riskitemEntity = new RiskitemVO();
                            riskitemEntity.setBillId(id);
                            riskitemEntity.setItemId(detail.getItemId());
                            riskitemEntity.setItemContent(detail.getItemContent());
                            riskitemEntity.setItemName(detail.getItemName());
                            riskitemEntity.setItemProperty(detail.getItemProperty());
                            riskitemEntity.setSequence(detail.getSequence());
                            riskitemEntity.setAuditContentId(detail.getAuditContentId());

                            //风险项
                            if (detail.getAuditResultList() != null && detail.getAuditResultList().size() > 0) {
                                List<RiskresultVO> riskresultEntities = new ArrayList<>();
                                detail.getAuditResultList().forEach(riskresult -> {
                                    logger.info("风险项保存--riskresult", riskresult.getModifyReason());
                                    RiskresultVO riskresultEntity = new RiskresultVO();
                                    riskresultEntity.setCustomField(riskresult.getCustomField());
                                    riskresultEntity.setRiskLevel(riskresult.getRiskLevel());
                                    riskresultEntity.setRiskType(riskresult.getRiskType());
                                    riskresultEntity.setModifyReason(riskresult.getModifyReason());
                                    riskresultEntity.setModifySuggestion(riskresult.getModifySuggestion());
                                    riskresultEntity.setAuditContentDetailId(riskresult.getAuditContentDetailId());
                                    riskresultEntity.setAuditContentId(riskresult.getAuditContentId());
                                    riskresultEntity.setSequence(riskresult.getSequence());
    //                                    riskresultEntity.setBillId(riskitemEntity.getId());
                                    riskresultEntities.add(riskresultEntity);
                                });
                                riskitemEntity.setRiskresultList(riskresultEntities);
                            }
                            CommonResponse<RiskitemVO> riskitemVOCommonResponse = riskitemApi.saveOrUpdate(riskitemEntity);
                            logger.info("风险项保存--结果:{}", riskitemVOCommonResponse.getMsg());
                        });

                    }
                    entity.setAiState(2);
                    super.updateById(entity);
                }
            }
        }

        return BeanMapper.map(entity, ContractReviewVO.class);
    }

    @Override
    public ContractReviewVO addSupplementByConId(Long mainContractId) {
        ContractReviewVO vo = this.reviewDetail(mainContractId);
        ContractReviewVO resultVo = new ContractReviewVO();
        resultVo.setProjectId(vo.getProjectId());
        resultVo.setProjectName(vo.getProjectName());
        resultVo.setProjectCode(vo.getProjectCode());
        resultVo.setOrgId(vo.getOrgId());
        resultVo.setOrgCode(vo.getOrgCode());
        resultVo.setOrgName(vo.getOrgName());
        resultVo.setParentOrgId(vo.getParentOrgId());
        resultVo.setParentOrgCode(vo.getParentOrgCode());
        resultVo.setParentOrgName(vo.getParentOrgName());
        resultVo.setContractName(vo.getContractName());

        resultVo.setCustomerId(vo.getCustomerId());
        resultVo.setCustomerName(vo.getCustomerName());
        resultVo.setSupplierId(vo.getSupplierId());
        resultVo.setSupplierName(vo.getSupplierName());
        resultVo.setConstructionPartner(vo.getConstructionPartner());
        resultVo.setConstructionPartnerMember(vo.getConstructionPartnerMember());
        resultVo.setTaxRate(vo.getTaxRate());
        resultVo.setContractType(vo.getContractType());
        resultVo.setContractValuationType(vo.getContractValuationType());
        resultVo.setBuiltArea(vo.getBuiltArea());
        resultVo.setContractPartyc(vo.getContractPartyc());
        resultVo.setConjoinedContractTotalMny(vo.getConjoinedContractTotalMny());
        resultVo.setArchitectId(vo.getArchitectId());
        resultVo.setArchitectName(vo.getArchitectName());
        resultVo.setManagerId(vo.getManagerId());
        resultVo.setManagerName(vo.getManagerName());
        resultVo.setEngineeringTypeId(vo.getEngineeringTypeId());
        resultVo.setEngineeringTypeName(vo.getEngineeringTypeName());
//        resultVo.setSettlementType(vo.getSettlementType());
        resultVo.setEmployeeId(sessionManager.getUserContext().getEmployeeId());
        resultVo.setEmployeeName(sessionManager.getUserContext().getUserName());
        resultVo.setDeptId(sessionManager.getUserContext().getDeptId());
        resultVo.setDeptName(sessionManager.getUserContext().getDeptName());
        resultVo.setAddress(vo.getAddress());
        resultVo.setMainContractId(mainContractId);
        resultVo.setMainContractName(vo.getContractName());
        resultVo.setMainContractCode(vo.getBillCode());

        resultVo.setBearType(vo.getBearType());
        resultVo.setContractualModel(vo.getContractualModel());

        return resultVo;
    }

    @Override
    public ContractReviewVO editContractByConId(Long oldId) {
        ContractReviewVO vo = this.reviewDetail(oldId);
        ContractReviewVO reviewVO = BeanMapper.map(vo, ContractReviewVO.class);
        reviewVO.setBillCode(null);
        reviewVO.setBillState(null);
        reviewVO.setBillStateName(null);
        reviewVO.setId(null);
        reviewVO.setBillStateName(null);
        reviewVO.setChildren(null);
        if ("1".equals(vo.getSupplementFlag())) {
            reviewVO.setMainContractId(null);
            reviewVO.setMainContractCode(null);
            reviewVO.setMainContractName(null);
        }
        reviewVO.setUseStatus(1);
        reviewVO.setCreateTime(null);
        reviewVO.setCreateUserCode(null);
        reviewVO.setUpdateTime(null);
        reviewVO.setUpdateUserCode(null);
        reviewVO.setOldReviewCode(vo.getBillCode());
        reviewVO.setOldReviewId(vo.getId());
        //单据状态初始化
        reviewVO.setSealDate(null);
        reviewVO.setSealId(null);
        reviewVO.setSealFlag(0);
        reviewVO.setFilingDate(null);
        reviewVO.setFilingFlag(0);
        reviewVO.setCancelFlag(0);
        //修订版本自增长 V+x
        if (vo.getRevision() == null) {
            reviewVO.setRevision("V0");
        } else {
            //字符串最后一位自增长
            String revision = vo.getRevision();
            String end = revision.substring(revision.length() - 1, revision.length());
            String result = String.valueOf(Integer.parseInt(end) + 1);
            String substring = revision.substring(0, revision.length() - 1);
            reviewVO.setRevision(substring + result);
        }

        return reviewVO;
    }

    @Override
    public JSONObject pageList(QueryParam param) {
        int pageIndex = param.getPageIndex();
        int pageSize = param.getPageSize();
        long total = 0L; // 总条数
        long pages = 0; // 有几页

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierId");//责任承包方
        fuzzyFields.add("constructId");//建设单位
        fuzzyFields.add("managerId");//项目责任人


        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        //主表数据个数<页面显示个数时使用
        QueryParam supplementParam = Utils.deepCopy(param);

        param.getParams().put("supplementFlag", new Parameter(QueryParam.EQ, 0));

        // 查出来非补充协议的合同
        List<ContractReviewEntity> entityList = this.queryList(param);
//        IPage<ContractReviewEntity> contractReviewEntityIPage = this.queryPage(param);
//        total = total+contractReviewEntityIPage.getTotal();
//        List<ContractReviewEntity> entityList = contractReviewEntityIPage.getRecords();
        total = total+entityList.size();
        List<ContractReviewEntity> list = entityList.stream().skip((pageIndex - 1) * pageSize).limit(pageSize).collect(Collectors.toList());
        List<ContractReviewVO> voList = BeanMapper.mapList(list, ContractReviewVO.class);
        List<Long> idList = voList.stream().map(BaseVO::getId).collect(Collectors.toList());
        List<Long> enList= entityList.stream().map(BaseEntity::getId).collect(Collectors.toList());

        // 根据合同查出来补充协议
        QueryParam childrenParam = Utils.deepCopy(param);
        //只有子表符合条件，父表不符合条件的单独筛选出来显示------------------------------------------
//        QueryParam otherParam = Utils.deepCopy(param);

        //主非空且以满足个数
        //主非空且不满足个数
        //主为空
        if (ListUtil.isNotEmpty(entityList)) {
           // if (idList.size()>=pageSize){
            if (ListUtil.isNotEmpty(idList)) {
                //主合同数量已经饱和
                childrenParam.getParams().put("mainContractId", new Parameter(QueryParam.IN, idList));
                childrenParam.getParams().put("supplementFlag", new Parameter(QueryParam.IN, Arrays.asList(1, 2)));
                List<ContractReviewEntity> childrenList = this.queryList(childrenParam);
                List<ContractReviewVO> childrenVoList = BeanMapper.mapList(childrenList, ContractReviewVO.class);
                Map<Long, List<ContractReviewVO>> childrenMap = childrenVoList.stream().collect(Collectors.groupingBy(ContractReviewVO::getMainContractId));

                if (param.getSearchText() != null && ListUtil.isNotEmpty(childrenVoList)) {
                    List<Long> childrenIdList = new ArrayList<>(childrenMap.keySet());
                    param.getParams().put("id", new Parameter(QueryParam.IN, childrenIdList));
                    // 搜索补充协议编码，主合同为空。清空搜索条件
                    if (ListUtil.isEmpty(entityList)) {
                        param.setSearchText(null);
                    }
                    List<ContractReviewEntity> newEntityList = this.queryList(param);
                    // 搜索非补充协议编码，两个结果合并
                    entityList.addAll(newEntityList);
                    entityList = entityList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() ->
                            new TreeSet<>(Comparator.comparing(ContractReviewEntity::getId))), ArrayList::new));
                    entityList = entityList.stream().sorted(Comparator.comparing(ContractReviewEntity::getCreateTime).reversed()).collect(Collectors.toList());
                    list = entityList.stream().skip((pageIndex - 1) * pageSize).limit(pageSize).collect(Collectors.toList());
                    voList = BeanMapper.mapList(list, ContractReviewVO.class);
                }

                if (ListUtil.isNotEmpty(voList)) {
                    // 拼装数据
                    for (ContractReviewVO vo : voList) {
                        if (childrenMap.containsKey(vo.getId())) {
                            vo.setChildren(childrenMap.get(vo.getId()));
                        }
                    }

                }
                //主合同数量未饱和
                supplementParam.setPageIndex(1);
                supplementParam.setPageSize(pageSize - idList.size());
                supplementParam.getParams().put("mainContractId", new Parameter(QueryParam.NOT_IN, enList));
                supplementParam.getParams().put("supplementFlag", new Parameter(QueryParam.IN, Arrays.asList(1, 2)));
                IPage<ContractReviewEntity> contractReviewEntityIPage1 = this.queryPage(supplementParam);
                total = total + contractReviewEntityIPage1.getTotal();
                // }else {
                if (idList.size() < pageSize) {
                    //主合同数量未饱和
//                supplementParam.setPageIndex(1);
//                supplementParam.setPageSize(pageSize-idList.size());
//                childrenParam.getParams().put("mainContractId", new Parameter(QueryParam.NOT_IN, idList));
//                supplementParam.getParams().put("supplementFlag", new Parameter(QueryParam.IN, Arrays.asList(1, 2)));
//                IPage<ContractReviewEntity> contractReviewEntityIPage1 = this.queryPage(supplementParam);
//                total = total+ contractReviewEntityIPage1.getTotal();
                    List<ContractReviewEntity> records = contractReviewEntityIPage1.getRecords();
                    List<ContractReviewVO> contractReviewVOS = BeanMapper.mapList(records, ContractReviewVO.class);
                    voList.addAll(contractReviewVOS);
                }
            }else {
                supplementParam.getParams().put("mainContractId", new Parameter(QueryParam.NOT_IN, enList));
                supplementParam.getParams().put("supplementFlag", new Parameter(QueryParam.IN, Arrays.asList(1, 2)));
                List<ContractReviewEntity> contractReviewEntities = this.queryList(supplementParam);
                total = total + contractReviewEntities.size();
                List<ContractReviewEntity> collect = contractReviewEntities.stream().skip(((pageIndex - 1) * pageSize) - entityList.size()).limit(pageSize).collect(Collectors.toList());
                List<ContractReviewVO> contractReviewVOS = BeanMapper.mapList(collect, ContractReviewVO.class);
                voList.addAll(contractReviewVOS);
            }
        }else {
            //查询补充协议满足条件的
            supplementParam.getParams().put("supplementFlag", new Parameter(QueryParam.IN, Arrays.asList(1, 2)));
            IPage<ContractReviewEntity> contractReviewEntityIPage1 = this.queryPage(supplementParam);
            total = total+contractReviewEntityIPage1.getTotal();
            List<ContractReviewEntity> records = contractReviewEntityIPage1.getRecords();
            List<ContractReviewVO> contractReviewVOS = BeanMapper.mapList(records, ContractReviewVO.class);
            voList.addAll(contractReviewVOS);

        }

//        total = entityList.size();
        if (total % pageSize > 0) {
            pages = (total / pageSize) + 1;
        } else if (total % pageSize == 0) {
            pages = total / pageSize;
        }

        JSONObject page = new JSONObject();
        page.put("records", voList);
        page.put("total", total);
        page.put("current", pageIndex);
        page.put("size", pageSize);
        page.put("pages", pages);


        return page;
    }

    @Override
    public List<ContractReviewVO> excelExport(QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierId");//责任承包方
        fuzzyFields.add("constructId");//建设单位
        fuzzyFields.add("managerId");//项目责任人

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        //主表数据个数<页面显示个数时使用
        QueryParam supplementParam = Utils.deepCopy(param);

        param.getParams().put("supplementFlag", new Parameter(QueryParam.EQ, 0));

        // 查出来非补充协议的合同
        List<ContractReviewEntity> entityList = this.queryList(param);
//        IPage<ContractReviewEntity> contractReviewEntityIPage = this.queryPage(param);
//        total = total+contractReviewEntityIPage.getTotal();
//        List<ContractReviewEntity> entityList = contractReviewEntityIPage.getRecords();

        //List<ContractReviewEntity> list = entityList.stream().skip((pageIndex - 1) * pageSize).limit(pageSize).collect(Collectors.toList());
        List<ContractReviewVO> voList = BeanMapper.mapList(entityList, ContractReviewVO.class);
        List<Long> idList = voList.stream().map(BaseVO::getId).collect(Collectors.toList());
        List<Long> enList= entityList.stream().map(BaseEntity::getId).collect(Collectors.toList());

        // 根据合同查出来补充协议
        QueryParam childrenParam = Utils.deepCopy(param);
        //只有子表符合条件，父表不符合条件的单独筛选出来显示------------------------------------------
//        QueryParam otherParam = Utils.deepCopy(param);

        //主非空且以满足个数
        //主非空且不满足个数
        //主为空
        if (ListUtil.isNotEmpty(entityList)) {
            // if (idList.size()>=pageSize){
            if (ListUtil.isNotEmpty(idList)) {
                //主合同数量已经饱和
                childrenParam.getParams().put("mainContractId", new Parameter(QueryParam.IN, idList));
                childrenParam.getParams().put("supplementFlag", new Parameter(QueryParam.IN, Arrays.asList(1, 2)));
                List<ContractReviewEntity> childrenList = this.queryList(childrenParam);
                List<ContractReviewVO> childrenVoList = BeanMapper.mapList(childrenList, ContractReviewVO.class);
                Map<Long, List<ContractReviewVO>> childrenMap = childrenVoList.stream().collect(Collectors.groupingBy(ContractReviewVO::getMainContractId));

                if (param.getSearchText() != null && ListUtil.isNotEmpty(childrenVoList)) {
                    List<Long> childrenIdList = new ArrayList<>(childrenMap.keySet());
                    param.getParams().put("id", new Parameter(QueryParam.IN, childrenIdList));
                    // 搜索补充协议编码，主合同为空。清空搜索条件
                    if (ListUtil.isEmpty(entityList)) {
                        param.setSearchText(null);
                    }
                    List<ContractReviewEntity> newEntityList = this.queryList(param);
                    // 搜索非补充协议编码，两个结果合并
                    entityList.addAll(newEntityList);
                    entityList = entityList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() ->
                            new TreeSet<>(Comparator.comparing(ContractReviewEntity::getId))), ArrayList::new));
                    entityList = entityList.stream().sorted(Comparator.comparing(ContractReviewEntity::getCreateTime).reversed()).collect(Collectors.toList());
                    //list = entityList.stream().skip((pageIndex - 1) * pageSize).limit(pageSize).collect(Collectors.toList());
                    voList = BeanMapper.mapList(entityList, ContractReviewVO.class);
                }

                if (ListUtil.isNotEmpty(voList)) {
                    // 拼装数据
                    for (ContractReviewVO vo : voList) {
                        if (childrenMap.containsKey(vo.getId())) {
                            vo.setChildren(childrenMap.get(vo.getId()));
                        }
                    }

                }
                //主合同数量未饱和
                supplementParam.getParams().put("mainContractId", new Parameter(QueryParam.NOT_IN, enList));
                supplementParam.getParams().put("supplementFlag", new Parameter(QueryParam.IN, Arrays.asList(1, 2)));

                List<ContractReviewEntity> records = this.queryList(supplementParam);
                List<ContractReviewVO> contractReviewVOS = BeanMapper.mapList(records, ContractReviewVO.class);
                voList.addAll(contractReviewVOS);

            }else {
                supplementParam.getParams().put("mainContractId", new Parameter(QueryParam.NOT_IN, enList));
                supplementParam.getParams().put("supplementFlag", new Parameter(QueryParam.IN, Arrays.asList(1, 2)));
                List<ContractReviewEntity> contractReviewEntities = this.queryList(supplementParam);
                //total = total + contractReviewEntities.size();
                //List<ContractReviewEntity> collect = contractReviewEntities.stream().skip(((pageIndex - 1) * pageSize) - entityList.size()).limit(pageSize).collect(Collectors.toList());
                List<ContractReviewVO> contractReviewVOS = BeanMapper.mapList(contractReviewEntities, ContractReviewVO.class);
                voList.addAll(contractReviewVOS);
            }
        }else {
            //查询补充协议满足条件的
            supplementParam.getParams().put("supplementFlag", new Parameter(QueryParam.IN, Arrays.asList(1, 2)));
            //IPage<ContractReviewEntity> contractReviewEntityIPage1 = this.queryPage(supplementParam);
            //total = total+contractReviewEntityIPage1.getTotal();
            List<ContractReviewEntity> records = this.queryList(supplementParam);
            List<ContractReviewVO> contractReviewVOS = BeanMapper.mapList(records, ContractReviewVO.class);
            voList.addAll(contractReviewVOS);

        }

        voList = voList.stream().sorted(Comparator.comparing(ContractReviewVO::getCreateTime).reversed()).collect(Collectors.toList());

        return voList;
    }

    @Override
    public String relationProject(ContractReviewVO vo) {

        LambdaUpdateWrapper<ContractReviewEntity> wrapper = new LambdaUpdateWrapper<>();
        wrapper.set(ContractReviewEntity::getProjectId, vo.getProjectId());
        wrapper.set(ContractReviewEntity::getProjectCode, vo.getProjectCode());
        wrapper.set(ContractReviewEntity::getProjectName, vo.getProjectName());
        wrapper.set(ContractReviewEntity::getOrgId, vo.getOrgId());
        wrapper.set(ContractReviewEntity::getOrgCode, vo.getOrgCode());
        wrapper.set(ContractReviewEntity::getOrgName, vo.getOrgName());
        wrapper.set(ContractReviewEntity::getParentOrgId, vo.getParentOrgId());
        wrapper.set(ContractReviewEntity::getParentOrgCode, vo.getParentOrgCode());
        wrapper.set(ContractReviewEntity::getParentOrgName, vo.getParentOrgName());
        wrapper.eq(ContractReviewEntity::getId, vo.getId());

        this.update(wrapper);

        return "关联项目成功！";
    }

    @Override
    public Boolean validateReview(Long projectId, Long id) {
        LambdaQueryWrapper<ContractReviewEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ContractReviewEntity::getProjectId, projectId);
        wrapper.eq(ContractReviewEntity::getTenantId, InvocationInfoProxy.getTenantid());
        wrapper.eq(ContractReviewEntity::getUseStatus, 1);
        if (id != null) {
            wrapper.ne(ContractReviewEntity::getId, id);
        }
        List<ContractReviewEntity> list = this.list(wrapper);
        if (ListUtil.isNotEmpty(list)) {
            throw new BusinessException("当前项目存在其他评审，不允许新增/修改!");
        }

        return true;
    }


}
