package com.ejianc.business.pro.income.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 结算报审
 *
 * @author generator
 *
 */
 @TableName("ejc_income_settle_report")
public class SettleReportEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="contract_id")
    private Long contractId; // 合同
    @TableField(value="contract_code")
    private String contractCode; // 合同编号
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 父级组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value="start_date")
    private Date startDate; // 合同开工日期
    @TableField(value="end_date")
    private Date endDate; // 合同竣工日期
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同(签订)金额(不含税)
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同(签订)金额
    @TableField(value="contract_valuation_type")
    private String contractValuationType; // 合同计价形式
    @TableField(value="contract_promise_payment_rate")
    private BigDecimal contractPromisePaymentRate; // 合同约定收款比例
    @TableField(value="sum_production_mny")
    private BigDecimal sumProductionMny; // 累计产值(无税)
    @TableField(value="sum_production_tax_mny")
    private BigDecimal sumProductionTaxMny; // 累计产值
    @TableField(value="sum_cost_mny")
    private BigDecimal sumCostMny; // 累计成本(无税)
    @TableField(value="sum_cost_tax_mny")
    private BigDecimal sumCostTaxMny; // 累计成本
    @TableField(value="sum_receipt_mny")
    private BigDecimal sumReceiptMny; // 累计收款金额(无税)
    @TableField(value="sum_receipt_tax_mny")
    private BigDecimal sumReceiptTaxMny; // 累计收款金额
    @TableField(value="report_settle_mny")
    private BigDecimal reportSettleMny; // 报审结算金额
    @TableField(value="report_date")
    private Date reportDate; // 报审日期
    @TableField(value="subtract_tax_rate")
    private BigDecimal subtractTaxRate; // 合同约定审减率
    @TableField(value="predict_check_mny")
    private BigDecimal predictCheckMny; // 预计审定金额
    @TableField(value="predict_check_date")
    private Date predictCheckDate; // 预计审定日期
    @TableField(value="material_mny")
    private BigDecimal materialMny; // 其中甲供材金额
    @TableField(value="check_unit")
    private String checkUnit; // 审核单位
    @TableField(value="settlement_type")
    private String settlementType; // 结算方式：0-过程结算，1-竣工结算
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="dept_id")
    private Long deptId; // 经办部门
    @TableField(value="dept_name")
    private String deptName; // 经办部门名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="report_settle_tax_Mny")
    private BigDecimal reportSettleTaxMny; // 报审结算金额
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 税率
    @TableField(value="tax")
    private BigDecimal tax; // 税额
    @TableField(value="settle_name")
    private String settleName; // 结算名称
    @TableField(value="real_start_date")
    private Date realStartDate; // 实际开工日期
    @TableField(value="real_end_date")
    private Date realEndDate; // 实际竣工日期
    @TableField(value="report_settle_name")
    private String reportSettleName; // 报审名称
    @TableField(value = "gd_status")
    private String gdStatus;
    @TableField(value = "gd_date")
    private Date gdDate;
    @TableField(value = "close_flag")
    private String closeFlag;//是否已成本关门(1-是 2-否)
    @TableField(value = "pre_total_cost")
    private BigDecimal preTotalCost;//预计总成本
    @TableField(value = "report_progress")
    private String reportProgress;//报审阶段
    @TableField(value = "project_part_id")
    private Long projectPartId;//执行标段id
    @TableField(value = "follow_remark")
    private String followRemark;//跟踪进展
    @TableField(value = "total_report_settle_tax_mny")
    private BigDecimal totalReportSettleTaxMny;//累计报审结算金额

    @TableField(exist=false)
    @SubEntity(serviceName="settleReportDetailService",pidName = "reportId")
    private List<SettleReportDetailEntity> unitProjectDetailList = new ArrayList<>(); // 单位工程明细


    public String getReportSettleName() {
        return reportSettleName;
    }

    public void setReportSettleName(String reportSettleName) {
        this.reportSettleName = reportSettleName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public String getContractValuationType() {
        return contractValuationType;
    }

    public void setContractValuationType(String contractValuationType) {
        this.contractValuationType = contractValuationType;
    }
    public BigDecimal getContractPromisePaymentRate() {
        return contractPromisePaymentRate;
    }

    public void setContractPromisePaymentRate(BigDecimal contractPromisePaymentRate) {
        this.contractPromisePaymentRate = contractPromisePaymentRate;
    }
    public BigDecimal getSumProductionMny() {
        return sumProductionMny;
    }

    public void setSumProductionMny(BigDecimal sumProductionMny) {
        this.sumProductionMny = sumProductionMny;
    }
    public BigDecimal getSumProductionTaxMny() {
        return sumProductionTaxMny;
    }

    public void setSumProductionTaxMny(BigDecimal sumProductionTaxMny) {
        this.sumProductionTaxMny = sumProductionTaxMny;
    }
    public BigDecimal getSumCostMny() {
        return sumCostMny;
    }

    public void setSumCostMny(BigDecimal sumCostMny) {
        this.sumCostMny = sumCostMny;
    }
    public BigDecimal getSumCostTaxMny() {
        return sumCostTaxMny;
    }

    public void setSumCostTaxMny(BigDecimal sumCostTaxMny) {
        this.sumCostTaxMny = sumCostTaxMny;
    }
    public BigDecimal getSumReceiptMny() {
        return sumReceiptMny;
    }

    public void setSumReceiptMny(BigDecimal sumReceiptMny) {
        this.sumReceiptMny = sumReceiptMny;
    }
    public BigDecimal getSumReceiptTaxMny() {
        return sumReceiptTaxMny;
    }

    public void setSumReceiptTaxMny(BigDecimal sumReceiptTaxMny) {
        this.sumReceiptTaxMny = sumReceiptTaxMny;
    }
    public BigDecimal getReportSettleMny() {
        return reportSettleMny;
    }

    public void setReportSettleMny(BigDecimal reportSettleMny) {
        this.reportSettleMny = reportSettleMny;
    }
    public Date getReportDate() {
        return reportDate;
    }

    public void setReportDate(Date reportDate) {
        this.reportDate = reportDate;
    }
    public BigDecimal getSubtractTaxRate() {
        return subtractTaxRate;
    }

    public void setSubtractTaxRate(BigDecimal subtractTaxRate) {
        this.subtractTaxRate = subtractTaxRate;
    }
    public BigDecimal getPredictCheckMny() {
        return predictCheckMny;
    }

    public void setPredictCheckMny(BigDecimal predictCheckMny) {
        this.predictCheckMny = predictCheckMny;
    }
    public Date getPredictCheckDate() {
        return predictCheckDate;
    }

    public void setPredictCheckDate(Date predictCheckDate) {
        this.predictCheckDate = predictCheckDate;
    }
    public BigDecimal getMaterialMny() {
        return materialMny;
    }

    public void setMaterialMny(BigDecimal materialMny) {
        this.materialMny = materialMny;
    }
    public String getCheckUnit() {
        return checkUnit;
    }

    public void setCheckUnit(String checkUnit) {
        this.checkUnit = checkUnit;
    }
    public String getSettlementType() {
        return settlementType;
    }

    public void setSettlementType(String settlementType) {
        this.settlementType = settlementType;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public BigDecimal getReportSettleTaxMny() {
        return reportSettleTaxMny;
    }

    public void setReportSettleTaxMny(BigDecimal reportSettleTaxMny) {
        this.reportSettleTaxMny = reportSettleTaxMny;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public String getSettleName() {
        return settleName;
    }

    public void setSettleName(String settleName) {
        this.settleName = settleName;
    }

    public Date getRealStartDate() {
        return realStartDate;
    }

    public void setRealStartDate(Date realStartDate) {
        this.realStartDate = realStartDate;
    }

    public Date getRealEndDate() {
        return realEndDate;
    }

    public void setRealEndDate(Date realEndDate) {
        this.realEndDate = realEndDate;
    }

    public List<SettleReportDetailEntity> getUnitProjectDetailList() {
        return unitProjectDetailList;
    }

    public void setUnitProjectDetailList(List<SettleReportDetailEntity> unitProjectDetailList) {
        this.unitProjectDetailList = unitProjectDetailList;
    }

    public String getGdStatus() {
        return gdStatus;
    }

    public void setGdStatus(String gdStatus) {
        this.gdStatus = gdStatus;
    }

    public Date getGdDate() {
        return gdDate;
    }

    public void setGdDate(Date gdDate) {
        this.gdDate = gdDate;
    }

    public String getCloseFlag() {
        return closeFlag;
    }

    public void setCloseFlag(String closeFlag) {
        this.closeFlag = closeFlag;
    }

    public BigDecimal getPreTotalCost() {
        return preTotalCost;
    }

    public void setPreTotalCost(BigDecimal preTotalCost) {
        this.preTotalCost = preTotalCost;
    }

    public String getReportProgress() {
        return reportProgress;
    }

    public void setReportProgress(String reportProgress) {
        this.reportProgress = reportProgress;
    }

    public Long getProjectPartId() {
        return projectPartId;
    }

    public void setProjectPartId(Long projectPartId) {
        this.projectPartId = projectPartId;
    }

    public String getFollowRemark() {
        return followRemark;
    }

    public void setFollowRemark(String followRemark) {
        this.followRemark = followRemark;
    }

    public BigDecimal getTotalReportSettleTaxMny() {
        return totalReportSettleTaxMny;
    }

    public void setTotalReportSettleTaxMny(BigDecimal totalReportSettleTaxMny) {
        this.totalReportSettleTaxMny = totalReportSettleTaxMny;
    }
}
