package com.ejianc.business.market.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.market.hystrix.WorkReportHystrix;
import com.ejianc.business.market.vo.CompletionWorkReportVO;
import com.ejianc.business.market.vo.WorkReportQueryVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@FeignClient(name= "ejc-promarket-web", url="${common.env.feign-client-url}", path="ejc-promarket-web", fallback = WorkReportHystrix.class)
public interface IWorkReportApi {


    @RequestMapping(value = "/api/workReport/queryCompletionWorkReports", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<List<CompletionWorkReportVO>> queryCompletionWorkReports(@RequestBody WorkReportQueryVO workReportQueryVO);


    /**
     * 查询项目状态信息及距离成本关门倒计时统计
     *
     * @param projectId
     * @return
     */
    @GetMapping(value = "/api/workReport/getProjectInfo")
    @ResponseBody
    CommonResponse<JSONObject> getProjectInfo(@RequestParam Long projectId);
}
