package com.ejianc.business.market.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 成本关门
 *
 * @author baipengyan
 */
public class CloseCostVO extends BaseVO {
	private static final long serialVersionUID = -9068693354207301798L;

	private Date commitDate; // 提交日期
	private String commitUserName; // 提交人名称
	private String commitUserCode; // 提交人账号
	private Date effectiveDate; // 生效日期
	private String billCode; // 单据编号
	private String billName; // 单据名称
	private Integer billState; // 单据状态
	private String billStateName; // 单据状态名称
	private Long orgId; // 项目部id
	private String orgCode; // 项目部编码
	private String orgName; // 项目部名称
	private Long parentOrgId; // 项目部所属组织id
	private String parentOrgCode; // 项目部所属组织编码
	private String parentOrgName; // 项目部所属组织名称
	private Long projectId; // 项目id
	private String projectCode; // 项目编码
	private String projectName; // 项目名称
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private Date closeDate; // 关门日期
	private Long employeeId; // 经办人id
	private String employeeName; // 经办人名称
	private Long departmentId; // 经办部门id
	private String departmentCode; // 经办部门编码
	private String departmentName; // 经办部门名称
	private String closeMemo; // 成本关门说明

	private List<CloseCostInfoVO> closeCostInfoList = new ArrayList<>(); // 成本关门-金额信息

	public Date getCommitDate() {
		return commitDate;
	}

	public void setCommitDate(Date commitDate) {
		this.commitDate = commitDate;
	}

	public String getCommitUserName() {
		return commitUserName;
	}

	public void setCommitUserName(String commitUserName) {
		this.commitUserName = commitUserName;
	}

	public String getCommitUserCode() {
		return commitUserCode;
	}

	public void setCommitUserCode(String commitUserCode) {
		this.commitUserCode = commitUserCode;
	}

	public Date getEffectiveDate() {
		return effectiveDate;
	}

	public void setEffectiveDate(Date effectiveDate) {
		this.effectiveDate = effectiveDate;
	}

	public String getBillCode() {
		return billCode;
	}

	public void setBillCode(String billCode) {
		this.billCode = billCode;
	}

	public String getBillName() {
		return billName;
	}

	public void setBillName(String billName) {
		this.billName = billName;
	}

	public Integer getBillState() {
		return billState;
	}

	public void setBillState(Integer billState) {
		this.billState = billState;
	}

	public String getBillStateName() {
		return billStateName;
	}

	public void setBillStateName(String billStateName) {
		this.billStateName = billStateName;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public String getOrgCode() {
		return orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public Long getParentOrgId() {
		return parentOrgId;
	}

	public void setParentOrgId(Long parentOrgId) {
		this.parentOrgId = parentOrgId;
	}

	public String getParentOrgCode() {
		return parentOrgCode;
	}

	public void setParentOrgCode(String parentOrgCode) {
		this.parentOrgCode = parentOrgCode;
	}

	public String getParentOrgName() {
		return parentOrgName;
	}

	public void setParentOrgName(String parentOrgName) {
		this.parentOrgName = parentOrgName;
	}

	public Long getProjectId() {
		return projectId;
	}

	@ReferDeserialTransfer
	public void setProjectId(Long projectId) {
		this.projectId = projectId;
	}

	public String getProjectCode() {
		return projectCode;
	}

	public void setProjectCode(String projectCode) {
		this.projectCode = projectCode;
	}

	public String getProjectName() {
		return projectName;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	public Date getCloseDate() {
		return closeDate;
	}

	public void setCloseDate(Date closeDate) {
		this.closeDate = closeDate;
	}

	public Long getEmployeeId() {
		return employeeId;
	}

	@ReferDeserialTransfer
	public void setEmployeeId(Long employeeId) {
		this.employeeId = employeeId;
	}

	public String getEmployeeName() {
		return employeeName;
	}

	public void setEmployeeName(String employeeName) {
		this.employeeName = employeeName;
	}

	public Long getDepartmentId() {
		return departmentId;
	}

	@ReferDeserialTransfer
	public void setDepartmentId(Long departmentId) {
		this.departmentId = departmentId;
	}

	public String getDepartmentCode() {
		return departmentCode;
	}

	public void setDepartmentCode(String departmentCode) {
		this.departmentCode = departmentCode;
	}

	public String getDepartmentName() {
		return departmentName;
	}

	public void setDepartmentName(String departmentName) {
		this.departmentName = departmentName;
	}

	public String getCloseMemo() {
		return closeMemo;
	}

	public void setCloseMemo(String closeMemo) {
		this.closeMemo = closeMemo;
	}

	public List<CloseCostInfoVO> getCloseCostInfoList() {
		return closeCostInfoList;
	}

	public void setCloseCostInfoList(List<CloseCostInfoVO> closeCostInfoList) {
		this.closeCostInfoList = closeCostInfoList;
	}
}
