package com.ejianc.business.market.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 完工报告
 * 
 * @author generator
 * 
 */
@ApiModel("完工报告")
public class FinishWorkReportVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("所属项目Id")
    private Long projectId;
    @ApiModelProperty("所属项目名称")
    private String projectName;
    @ApiModelProperty("单据编码")
    private String billCode;
    @ApiModelProperty("所属项目部Id")
    private Long orgId;
    @ApiModelProperty("所属项目部名称")
    private String orgName;
    @ApiModelProperty("项目组织编码")
    private String orgCode;
    @ApiModelProperty("单据状态")
    private Integer billState;
    @ApiModelProperty("经办人id")
    private Long employeeId;
    @ApiModelProperty("经办人")
    private String employeeName;
    @ApiModelProperty("经办人电话")
    private String employeePhone;
    @ApiModelProperty("经办人单位id")
    private Long departmentId;
    @ApiModelProperty("经办单位")
    private String departmentName;
    @ApiModelProperty("项目部上级组织id")
    private Long parentOrgId;
    @ApiModelProperty("项目部上级组织名称")
    private String parentOrgName;
    @ApiModelProperty("项目部上级组织编码")
    private String parentOrgCode;
    @ApiModelProperty("开工日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startWorkCreateDate;
    @ApiModelProperty("实际完工日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date realityFinishWorkDate;
    @ApiModelProperty("实际工期")
    private Integer realityWorkEften;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("单据状态名称")
    private String billStateName;
    

    /**
     * 所属项目Id
     */
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 所属项目Id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 所属项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 所属项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 单据编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 所属项目部Id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属项目部Id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属项目部名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属项目部名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目组织编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 项目组织编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 经办人id
     */
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人id
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办人电话
     */
    public String getEmployeePhone() {
        return employeePhone;
    }

    /**
     * 经办人电话
     */
    public void setEmployeePhone(String employeePhone) {
        this.employeePhone = employeePhone;
    }
    /**
     * 经办人单位id
     */
    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办人单位id
     */
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办单位
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办单位
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 项目部上级组织id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部上级组织id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目部上级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 项目部上级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 项目部上级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 项目部上级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 开工日期
     */
    public Date getStartWorkCreateDate() {
        return startWorkCreateDate;
    }

    /**
     * 开工日期
     */
    public void setStartWorkCreateDate(Date startWorkCreateDate) {
        this.startWorkCreateDate = startWorkCreateDate;
    }
    /**
     * 实际完工日期
     */
    public Date getRealityFinishWorkDate() {
        return realityFinishWorkDate;
    }

    /**
     * 实际完工日期
     */
    public void setRealityFinishWorkDate(Date realityFinishWorkDate) {
        this.realityFinishWorkDate = realityFinishWorkDate;
    }
    /**
     * 实际工期
     */
    public Integer getRealityWorkEften() {
        return realityWorkEften;
    }

    /**
     * 实际工期
     */
    public void setRealityWorkEften(Integer realityWorkEften) {
        this.realityWorkEften = realityWorkEften;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
}
