package com.ejianc.business.market.service.impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.market.bean.CloseCostEntity;
import com.ejianc.business.market.enums.CapitalStatusEnum;
import com.ejianc.business.market.mapper.CloseCostMapper;
import com.ejianc.business.market.service.ICloseCostService;
import com.ejianc.business.market.service.IFinishWorkReportService;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.google.common.base.Stopwatch;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

/**
 * 成本关门
 *
 * @author baipengyan
 */
@Service("closeCostService")
public class CloseCostServiceImpl extends BaseServiceImpl<CloseCostMapper, CloseCostEntity> implements ICloseCostService {
	private final Logger logger = LoggerFactory.getLogger(this.getClass());
	private final IProjectPoolApi projectPoolApi;
	private final IProjectSetApi projectSetApi;
	private final IFinishWorkReportService finishWorkReportService;
	@Value("${common.env.base-host}")
	private String BaseHost;

	public CloseCostServiceImpl(IProjectPoolApi projectPoolApi, IProjectSetApi projectSetApi, IFinishWorkReportService finishWorkReportService) {
		this.projectPoolApi = projectPoolApi;
		this.projectSetApi = projectSetApi;
		this.finishWorkReportService = finishWorkReportService;
	}

	@Override
	public void autoCloseCost() {
		HttpServletRequest request = ((ServletRequestAttributes) Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
		HashMap<String, String> headers = new HashMap<>();
		headers.put("authority", request.getHeader("authority"));
		headers.put("ejc-token", request.getHeader("ejc-token"));

		ExecutorService executorService = Executors.newFixedThreadPool(1);
		CompletableFuture.runAsync(() -> {
			Stopwatch stopwatch = Stopwatch.createStarted();

			QueryParam param = new QueryParam();
			param.setPageIndex(1);
			param.setPageSize(-1);
			param.getParams().put("capitalStatus", new Parameter(QueryParam.NE, CapitalStatusEnum.成本关门.getCode()));
			String body = HttpRequest.post(BaseHost + "ejc-share-web/api/projectPool/queryProjectIPage")
					.addHeaders(headers)
					.body(JSON.toJSONString(param))
					.timeout(60000)
					.execute().body();
			JSONObject jsonObject = JSON.parseObject(body, JSONObject.class);
			JSONObject data = (JSONObject) jsonObject.get("data");
			JSONArray records = (JSONArray) data.get("records");
			logger.info("查询项目池用时「{}」秒", stopwatch.stop().elapsed(TimeUnit.SECONDS));

			stopwatch.reset().start();

			if (CollectionUtils.isNotEmpty(records)) {
				List<Long> projectIds = new ArrayList<>();
				for (Object record : records) {
					JSONObject json = (JSONObject) record;
					projectIds.add(Long.parseLong(String.valueOf(json.get("id"))));
				}
				List<Long> ids = finishWorkReportService.queryCanCloseCostProjectIds(projectIds);
				if (CollectionUtils.isNotEmpty(ids)) {
					logger.info("ids：{}", ids);
					for (Long projectId : ids) {
						HashMap<String, Object> paramMaps = new HashMap<>();
						paramMaps.put("projectId", projectId);
						paramMaps.put("capitalStatus", CapitalStatusEnum.成本关门.getCode());
						String responseBody = HttpUtil.createGet(BaseHost + "ejc-share-web/api/projectPoolSetApi/changeProjectStatus")
								.addHeaders(headers)
								.form(paramMaps)
								.execute()
								.body();
						CommonResponse res = JSON.parseObject(responseBody, CommonResponse.class);
						if (!res.isSuccess()) {
							logger.info("自动成本关门更新【项目池】项目【{}】资金管控状态为【{}】失败，失败原因：{}", projectId, CapitalStatusEnum.成本关门, res.getMsg());
						}
					}
				}
			}
			logger.info("自动关门处理完成共用时「{}」秒", stopwatch.stop().elapsed(TimeUnit.SECONDS));
		}, executorService);
		executorService.shutdown();
	}
}
