/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.market.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.market.bean.FinishWorkReportEntity;
import com.ejianc.business.market.enums.ArchiveStatusEnum;
import com.ejianc.business.market.enums.BusinessStatusEnum;
import com.ejianc.business.market.enums.CapitalStatusEnum;
import com.ejianc.business.market.enums.ProjectStatusEnum;
import com.ejianc.business.market.enums.SettleStatusEnum;
import com.ejianc.business.market.service.ICompletionWorkReportService;
import com.ejianc.business.market.service.IFinishWorkReportService;
import com.ejianc.business.market.vo.CompletionWorkReportVO;
import com.ejianc.business.market.vo.WorkReportQueryVO;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class WorkReportApi {
    @Autowired
    private ICompletionWorkReportService completionWorkReportService;
    @Autowired
    private IProjectSetApi projectSetApi;
    @Autowired
    private IFinishWorkReportService finishWorkReportService;

    @PostMapping(value={"/api/workReport/queryCompletionWorkReports"})
    CommonResponse<List<CompletionWorkReportVO>> queryCompletionWorkReports(@RequestBody WorkReportQueryVO workReportQueryVO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in(CollectionUtils.isNotEmpty((Collection)workReportQueryVO.getOrgIds()), (Object)"org_id", (Collection)workReportQueryVO.getOrgIds());
        queryWrapper.in(CollectionUtils.isNotEmpty((Collection)workReportQueryVO.getProjectIds()), (Object)"project_id", (Collection)workReportQueryVO.getProjectIds());
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List list = this.completionWorkReportService.list((Wrapper)queryWrapper);
        List completionWorkReportVOS = BeanMapper.mapList((Iterable)list, CompletionWorkReportVO.class);
        return CommonResponse.success((Object)completionWorkReportVOS);
    }

    @GetMapping(value={"/api/workReport/getProjectInfo"})
    CommonResponse<JSONObject> getProjectInfo(@RequestParam Long projectId) {
        CommonResponse projectPoolSetResp = this.projectSetApi.getProjectId(projectId);
        if (!projectPoolSetResp.isSuccess()) {
            return CommonResponse.error((String)"\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ProjectPoolSetVO projectPoolVo = (ProjectPoolSetVO)projectPoolSetResp.getData();
        JSONObject respData = JSONObject.parseObject((String)JSONObject.toJSONString((Object)projectPoolVo));
        respData.put("projectStatusName", (Object)ProjectStatusEnum.getNameByCode(projectPoolVo.getProjectStatus()));
        respData.put("businessStatusName", BusinessStatusEnum.getNameByCode(projectPoolVo.getBusinessStatus()));
        respData.put("settleStatusName", SettleStatusEnum.getNameByCode(projectPoolVo.getSettleStatus()));
        respData.put("archiveStatusName", ArchiveStatusEnum.getNameByCode(projectPoolVo.getArchiveStatus()));
        respData.put("capitalStatusName", CapitalStatusEnum.getNameByCode(projectPoolVo.getCapitalStatus()));
        respData.put("daysBeforeCostClose", (Object)-999999);
        if (!CapitalStatusEnum.\u5df2\u9500\u8d26.getCode().equals(projectPoolVo.getCapitalStatus()) && !CapitalStatusEnum.\u6210\u672c\u5173\u95e8.getCode().equals(projectPoolVo.getCapitalStatus())) {
            QueryWrapper finishReportQuery = new QueryWrapper();
            finishReportQuery.eq((Object)"project_id", (Object)projectId);
            finishReportQuery.in((Object)"bill_state", (Object[])new Integer[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
            FinishWorkReportEntity finishWorkReport = (FinishWorkReportEntity)((Object)this.finishWorkReportService.getOne((Wrapper)finishReportQuery));
            if (null != finishWorkReport) {
                respData.put("daysBeforeCostClose", (Object)DateUtil.daysBetween((Date)new Date(), (Date)DateUtils.addDays((Date)finishWorkReport.getRealityFinishWorkDate(), (int)90)));
            }
        }
        return CommonResponse.success((Object)respData);
    }
}

