/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.market.controller;

import com.ejianc.business.market.service.IProjectTeamService;
import com.ejianc.business.market.vo.ProjectTeamVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"projectTeam"})
public class ProjectTeamController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProjectTeamService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IUserApi userApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> saveOrUpdate(@RequestBody List<ProjectTeamVO> projectTeamVOList) {
        this.service.saveOrUpdates(projectTeamVOList);
        Long projectDepartmentId = 0L;
        if (CollectionUtils.isNotEmpty(projectTeamVOList)) {
            projectDepartmentId = projectTeamVOList.get(0).getProjectDepartmentId();
        }
        CommonResponse commonResponse = this.userApi.getEmployeeList(projectDepartmentId);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)commonResponse.getData());
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> queryList(@RequestBody Long projectDepartmentId) {
        CommonResponse commonResponse = this.userApi.getEmployeeList(Long.valueOf(projectDepartmentId));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)commonResponse.getData());
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/updateType"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> updateType(@RequestBody Map<String, Object> map) {
        this.service.updateType(map);
        return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }
}

