package com.ejianc.business.market.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.framework.core.exception.BusinessException;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.market.mapper.CompletionWorkReportMapper;
import com.ejianc.business.market.bean.CompletionWorkReportEntity;
import com.ejianc.business.market.service.ICompletionWorkReportService;

import java.util.List;

/**
 * 竣工报告
 * 
 * @author generator
 * 
 */
@Service("completionWorkReportService")
public class CompletionWorkReportServiceImpl extends BaseServiceImpl<CompletionWorkReportMapper, CompletionWorkReportEntity> implements ICompletionWorkReportService{


	/**
	 * 一个项目只有一个验收报告是否竣工验收为是
	 *
	 * @param id        主键
	 * @param projectId 项目id
	 */
	@Override
	public void checkOnlyCompletionAcceptance(Long id, Long projectId) {
		LambdaQueryWrapper<CompletionWorkReportEntity> lambdaQuery = Wrappers.lambdaQuery();
		if (null != id) {
			lambdaQuery.ne(CompletionWorkReportEntity::getId, id);
		}
		lambdaQuery.eq(CompletionWorkReportEntity::getProjectId, projectId);
		lambdaQuery.eq(CompletionWorkReportEntity::isCompletionAcceptanceFlag, true);
		List<CompletionWorkReportEntity> entityList = super.list(lambdaQuery);
		if (CollectionUtils.isNotEmpty(entityList)) {
			throw new BusinessException("一个项目只有一个验收报告是否竣工验收为是");
		}
	}
}
