package com.ejianc.business.market.utils;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import net.sf.jxls.transformer.XLSTransformer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.springframework.core.io.ClassPathResource;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class CommonUtils {

    /** 默认异常信息 */
    public static final String defaultErrMsg = "推送数据失败！";

    /** 无权访问 */
    private static final String noPower = "无权限访问该服务，请先联系管理员进行授权！";

    private CommonUtils() {
    }

    /**
     * 校验返回的commonResponse是否是正常的，正常返回true，否则抛出异常
     *
     * @param commonResponse 接口调用结果
     * @param <T>            泛型
     * @return 校验结果  true，正常；false，异常
     */
    public static <T> boolean checkCommonResponse(CommonResponse<T> commonResponse) {
        return checkCommonResponse(commonResponse, true, null, null);
    }

    /**
     * 校验返回的commonResponse是否是正常的，正常无结果，否则抛出异常
     *
     * @param <T>            泛型
     * @param commonResponse 接口调用结果
     * @param logger         日志
     */
    public static <T> boolean checkCommonResponse(CommonResponse<T> commonResponse, Logger logger) {
        return checkCommonResponse(commonResponse, true, null, logger);
    }

    /**
     * 校验返回的commonResponse是否是正常的
     *
     * @param commonResponse 返回结果
     * @param isThrow        是否抛出异常。true抛出异常；false，不抛出异常，返回false
     * @param errMsg         抛出异常时异常信息
     * @param logger         日志
     * @param <T>            泛型
     * @return 校验结果  true，正常；false，异常
     */
    public static <T> boolean checkCommonResponse(CommonResponse<T> commonResponse, boolean isThrow, String errMsg,
                                                  Logger logger) {
        if (!commonResponse.isSuccess()) {
            if (logger != null) {
                logger.info("调用接口失败，调用结果：{}，失败原因：{}", commonResponse.isSuccess(), commonResponse.getMsg());
            }
            if (isThrow) {
                throw new BusinessException(StringUtils.isNotEmpty(errMsg) ? errMsg : commonResponse.getMsg());
            }
            return false;
        }
        try {
            T data = commonResponse.getData();
            String dataString;
            if (data instanceof String) {
                dataString = String.valueOf(data);
                if (noPower.equals(dataString)) {
                    throw new BusinessException(dataString);
                }
            }
            else {
                dataString = JSONObject.toJSONString(data);
            }
            JSONObject jsonObject = JSONObject.parseObject(dataString);
            // 如果返回的结果包含code
            if (StringUtils.isNotEmpty(dataString) && jsonObject.containsKey("code")) {
                CommonResponse check = JSONObject.toJavaObject(jsonObject, CommonResponse.class);
                if (isThrow && !check.isSuccess()) {
                    if (logger != null) {
                        logger.error("调用接口失败，返回结果：{}", check.getMsg());
                    }
                    throw new BusinessException(StringUtils.isNotEmpty(errMsg) ? errMsg : check.getMsg());
                }
                return check.isSuccess();
            }else {
                throw new BusinessException(defaultErrMsg);
            }
        }
        // 业务异常抛出
        catch (BusinessException be) {
            if (logger != null) {
                logger.error(be.getErrorMsg());
            }
            throw be;
        }
        // 其他异常做特殊处理
        catch (Exception e) {
            if (logger != null) {
                logger.error("类型转换失败！返回结果不是json或CommonResponse");
            }
            if (isThrow){
                throw new BusinessException(defaultErrMsg);
            }
            // 异常情况按照true处理
            return true;
        }
    }

    /**
     * BigDecimal默认赋值0
     *
     * @param v 需要赋值的字段
     * @return 赋值结果
     */
    public static BigDecimal setBigDecimalDefaultValue(BigDecimal v) {
        if (v == null) {
            return BigDecimal.ZERO;
        }
        return v;
    }

    public static Integer isIntNull(Integer v) {
        if (v == null) {
            return 0;
        }
        return v;
    }

    //除法判断除数为0的情况
    public static BigDecimal parseCsValue(BigDecimal a, BigDecimal b) {
        //计算单价
        if (b.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }else {
            return a.divide(b,8,BigDecimal.ROUND_HALF_UP);
        }
    }
    //就算比例 然后乘100
    public static BigDecimal calculateRate(BigDecimal a, BigDecimal b) {
        //计算单价
        if (a == null || b == null){
            return BigDecimal.ZERO;
        }
        if (b.compareTo(BigDecimal.ZERO) == 0 ) {
            return BigDecimal.ZERO;
        }else {
            return a.divide(b,8,BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100));
        }
    }

    //就算比例 然后乘100
    public static BigDecimal calculateRate2(BigDecimal a, BigDecimal b) {
        //计算单价
        if (a == null || b == null){
            return BigDecimal.ZERO;
        }
        if (b.compareTo(BigDecimal.ZERO) == 0 ) {
            return BigDecimal.ZERO;
        }else {
            return a.divide(b,4,BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100));
        }
    }


    /**
     * 元转亿元，并保留2位小数
     */
    public static BigDecimal parseYuanToYi(BigDecimal a) {
        //计算单价
        if (a == null) {
            return BigDecimal.ZERO;
        }else {
            return a.divide(new BigDecimal(100000000),2,BigDecimal.ROUND_HALF_UP);
        }
    }

    /**
     * 元转万元
     */
    public static BigDecimal parseYuanToWan(BigDecimal a) {
        //计算单价
        if (a == null) {
            return BigDecimal.ZERO;
        }else {
            return a.divide(new BigDecimal(10000),0,BigDecimal.ROUND_HALF_UP);
        }
    }

    /**
     * 元转万元,取整
     */
    public static BigDecimal parseYuanToWanZ(BigDecimal a) {
        //计算单价
        if (a == null) {
            return BigDecimal.ZERO;
        }else {
            return a.divide(new BigDecimal(10000),0,BigDecimal.ROUND_HALF_UP);
        }
    }

    /**
     * 元转万元
     */
    public static BigDecimal parseYuanToWan2(BigDecimal a) {
        //计算单价
        if (a == null) {
            return BigDecimal.ZERO;
        }else {
            return a.divide(new BigDecimal(10000),2,BigDecimal.ROUND_HALF_UP);
        }
    }

    public static BigDecimal parseNullValue(BigDecimal value) {
        return value == null ? BigDecimal.ZERO : value;
    }
    public static String getEndDate(Integer inAdvanceFlag, String day,  List<Long> projectIdList) {

        String endDate = null;
        //定时任务 day 获取当前月上个月份的年月数据
        if (StringUtils.isNotEmpty(day)){
            if (!day.equals(DateFormatUtils.format(new Date(), "d"))) {
                throw new BusinessException("当前日期，不匹配设置日期");
            }
            endDate = getEndDate();
        }
        //新节点 -- 传参: projectIDList 后台自动自动生成 上月日期
        if (CollectionUtils.isNotEmpty(projectIdList)){
            endDate = getEndDate();
        }

        //当前页面按钮-- inAdvanceFlag == 1  后台自动自动生成 本月日期
        if (inAdvanceFlag != null && inAdvanceFlag == 1){
            endDate = getEndDateNow();
        }

        return endDate;
    }
    public static void main(String[] args) {
        getEndDateLast();
    }

    private static String getEndDateNow() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Calendar ca = Calendar.getInstance();
//      ca.add(Calendar.MONTH, -1);
        Date d = ca.getTime();
        String endDate = format.format(d);
        return endDate;
    }

    private static String getEndDate() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Calendar ca = Calendar.getInstance();
        ca.add(Calendar.MONTH, -1);
        Date d = ca.getTime();
        String endDate = format.format(d);
        return endDate;

    }
    //获取当前日期上一个年的最后一月
//    public static String getLastEndDate() {
//        SimpleDateFormat format = new SimpleDateFormat("yyyy");
//        Calendar ca = Calendar.getInstance();
//        ca.add(Calendar.YEAR, -1);
//        Date d = ca.getTime();
//        String endDate = format.format(d);
//        endDate = endDate + "12";
//        return endDate;
//
//    }

    //获取当年月初的年月
    public static String getSysYearAndFirstMonth() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy");
        Calendar ca = Calendar.getInstance();
        ca.add(Calendar.MONTH, -1);
        Date d = ca.getTime();
        String endDate = format.format(d);
        return endDate +"-01";
    }

    //取值上一年末年月
    public static String getEndDateLast() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy");
        Calendar ca = Calendar.getInstance();
        ca.add(Calendar.MONTH, -1);
        Date d = ca.getTime();
        String endDate = format.format(d);
        int parseInt = Integer.parseInt(endDate);
        parseInt = parseInt - 1;
        return parseInt +"-12";
    }


    /**
     *
     * 根据项目状态获取排序的值
     * 未开工-1,在建-2,完工-3,停缓建-4,竣工未结算-5,竣工已结算-6(项目中的状态)
     * 排序：项目状态（未开工-1、在建-2、停缓建-3、完工未竣-4（对应完工状态）、竣工未结算-5、竣工已结算-6
     */
    public static Integer getProjectOrderNum(Integer status) {
        Integer projectStatusOrder = null;
        if (status == 1){
            projectStatusOrder = 1;
        }
        if (status == 2){
            projectStatusOrder = 2;
        }
        if (status == 3){
            projectStatusOrder = 4;
        }
        if (status == 4){
            projectStatusOrder = 3;
        }
        if (status == 5){
            projectStatusOrder = 5;
        }
        if (status == 6){
            projectStatusOrder = 6;
        }
        if (status == 7){
            projectStatusOrder = 7;
        }
        return projectStatusOrder;
    }
    /**
     *
     * 根据项目状态转换状态名称
     * 未开工-1,在建-2,完工-3,停缓建-4,竣工未结算-5,竣工已结算-6(项目中的状态)
     * 排序：项目状态（未开工-1、在建-2、停缓建-3、完工未竣-4（对应完工状态）、竣工未结算-5、竣工已结算-6
     */
    public static String getProjectStatusName(Integer status) {
        String projectStatusName = null;
        if (status == 1){
            projectStatusName = "未开工";
        }
        if (status == 2){
            projectStatusName = "在建";
        }
        if (status == 3){
            projectStatusName = "完工未竣";
        }
        if (status == 4){
            projectStatusName = "停缓建";
        }
        if (status == 5){
            projectStatusName = "竣工未结算";
        }
        if (status == 6){
            projectStatusName = "竣工已结算";
        }
        if (status == 7){
            projectStatusName = "其他";
        }
        return projectStatusName;
    }
    /**
     *
     * 根据项目状态转换状态名称
     * 未开工-1,在建-2,完工-3,停缓建-4,竣工未结算-5,竣工已结算-6(项目中的状态)

     * 排序：项目状态（未开工-1、在建-2、停缓建-3、完工未竣-4（对应完工状态）、竣工未结算-5、竣工已结算-6
     专门针对项目状态合计使用
     */
    public static String getProjectStatusNameProject(Integer status) {
        String projectStatusName = null;
        if (status == 1){
            projectStatusName = "未开工";
        }
        if (status == 2){
            projectStatusName = "在建";
        }
        if (status == 3){
            projectStatusName = "停缓建";
        }
        if (status == 4){
            projectStatusName = "完工未竣";
        }
        if (status == 5){
            projectStatusName = "竣工未结算";
        }
        if (status == 6){
            projectStatusName = "竣工已结算";
        }
        if (status == 7){
            projectStatusName = "其他";
        }
        return projectStatusName;
    }
    /**
     *
     * 根据二级组织名称获取排序的值
     * 中建科技集团有限公司-1,中建科技集团华南有限公司-2,中建科技集团华东有限公司-3,中建科技集团华北有限公司-4,中建科技集团西部有限公司-5,中建集成建筑有限公司-6
     */
//    public static Integer getOrgOrderNum(String twoOrgName) {
//        Integer orgStatusOrder = null;
//        if ("中建科技集团有限公司".equals(twoOrgName)){
//            orgStatusOrder = 1;
//        }else if ("中建科技集团华南有限公司".equals(twoOrgName)){
//            orgStatusOrder = 2;
//        }else if ("中建科技集团华东有限公司".equals(twoOrgName)){
//            orgStatusOrder = 3;
//        }else if ("中建科技集团华北有限公司".equals(twoOrgName)){
//            orgStatusOrder = 4;
//        }else if ("中建科技集团西部有限公司".equals(twoOrgName)){
//            orgStatusOrder = 5;
//        }else if ("中建集成建筑有限公司".equals(twoOrgName)){
//            orgStatusOrder = 6;
//        }else {
//            orgStatusOrder = 7;
//        }
//        return orgStatusOrder;
//    }

    /**
     * 修改表名
     * @param response
     * @param reportingMonth
     * @param nodeName
     * @param beans
     */

    public static void setExcelName(HttpServletResponse response, String reportingMonth,String nodeName, String excelName, Map<String, Object> beans) {
        XLSTransformer transformer = new XLSTransformer();
        ServletOutputStream outputStream = null;

        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            beans.put("dateFormat", dateFormat);
            beans.put("timeFormat", timeFormat);
            ClassPathResource resource = new ClassPathResource(excelName);
            outputStream = response.getOutputStream();
            Workbook workbook = transformer.transformXLS(resource.getInputStream(), beans);
            Sheet sheet = workbook.getSheetAt(0);
            sheet.getRow(0).getCell(0).setCellValue("截至"+ getdate(reportingMonth)+nodeName);
            workbook.write(outputStream);
        } catch (Exception var18) {
            var18.printStackTrace();
        } finally {
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                } catch (IOException var17) {
                    var17.printStackTrace();
                }
            }
        }
    }

    public static String getdate(String date) {
        String[] datel = date.split(" ");
        String[] date2 = datel[0].split("-");
        String date4 = date2[0] + "年" + date2[1] + "月";
        return date4;
    }
}
