/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.market.service.impl;

import com.ejianc.business.market.service.IProjectTeamService;
import com.ejianc.business.market.vo.ProjectTeamVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectTeamService")
public class ProjectTeamServiceImpl
implements IProjectTeamService {
    @Autowired
    private IEmployeeApi employeeApi;

    @Override
    public boolean saveOrUpdates(List<ProjectTeamVO> projectTeamEntityList) {
        CommonResponse resp;
        Map<String, Object> memberMap = this.getMemberMap(projectTeamEntityList);
        if (!memberMap.isEmpty() && !(resp = this.employeeApi.manageProjectMembers(memberMap)).isSuccess()) {
            throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u65b0\u589e\u6210\u5458\u51fa\u9519: " + resp.getMsg());
        }
        return true;
    }

    @Override
    public void updateType(Map<String, Object> map) {
        CommonResponse resp;
        if (!map.isEmpty() && !(resp = this.employeeApi.updateJobType(map)).isSuccess()) {
            throw new BusinessException("\u4fee\u6539\u4eba\u5458\u7c7b\u578b\u51fa\u9519: " + resp.getMsg());
        }
    }

    private Map<String, Object> getMemberMap(List<ProjectTeamVO> projectTeamVOList) {
        Long orgId = null;
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty(projectTeamVOList)) {
            orgId = projectTeamVOList.get(0).getOrgId();
            HashMap<String, ArrayList<RoleUserRelationVO>> moveMap = new HashMap<String, ArrayList<RoleUserRelationVO>>();
            HashMap<String, ArrayList<RoleUserRelationVO>> parttimeMap = new HashMap<String, ArrayList<RoleUserRelationVO>>();
            List<Object> relationList = null;
            RoleUserRelationVO tmp = null;
            for (ProjectTeamVO member : projectTeamVOList) {
                tmp = new RoleUserRelationVO();
                tmp.setUserId(null != member.getUserId() ? Long.valueOf(member.getUserId().toString()) : null);
                tmp.setJobId(null != member.getJobId() ? Long.valueOf(member.getJobId().toString()) : null);
                tmp.setAuthOrgId(orgId);
                tmp.setEmployeeId(null != member.getEmployeeId() ? Long.valueOf(member.getEmployeeId().toString()) : null);
                tmp.setRoleId(null != member.getRoleId() ? Long.valueOf(member.getRoleId().toString()) : null);
                tmp.setRoleName(member.getRoleName());
                tmp.setProjectPost(null != member.getProjectPost() ? member.getProjectPost().toString() : null);
                if ("move".equals(member.getType().toString())) {
                    relationList = (ArrayList<RoleUserRelationVO>)moveMap.get(tmp.getEmployeeId().toString());
                    if (null == relationList) {
                        relationList = new ArrayList<RoleUserRelationVO>();
                    }
                    relationList.add(tmp);
                    moveMap.put(tmp.getEmployeeId().toString(), (ArrayList<RoleUserRelationVO>)relationList);
                    continue;
                }
                relationList = (List)parttimeMap.get(tmp.getEmployeeId().toString());
                if (null == relationList) {
                    relationList = new ArrayList();
                }
                relationList.add(tmp);
                parttimeMap.put(tmp.getEmployeeId().toString(), (ArrayList<RoleUserRelationVO>)relationList);
            }
            if (!moveMap.isEmpty()) {
                HashMap<String, Serializable> moveData = new HashMap<String, Serializable>();
                moveData.put("orgId", orgId);
                moveData.put("detail", moveMap);
                dataMap.put("moveMembers", moveData);
            }
            if (!parttimeMap.isEmpty()) {
                HashMap<String, Serializable> parttimeData = new HashMap<String, Serializable>();
                parttimeData.put("orgId", orgId);
                parttimeData.put("detail", parttimeMap);
                dataMap.put("parttimeMembers", parttimeData);
            }
        }
        return dataMap;
    }
}

