package com.ejianc.business.project.mapper;

import com.ejianc.business.project.vo.ProjectChangeNumVO;
import com.ejianc.business.project.vo.ProjectInfoVO;
import com.ejianc.business.project.vo.UserInfoVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.project.bean.ProjectInfoEntity;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 项目信息统计表
 * 
 * @author generator
 * 
 */
@Mapper
public interface ProjectInfoMapper extends BaseCrudMapper<ProjectInfoEntity> {

    //查询报别人员情况
    List<UserInfoVO> getUserInfoByProjectId(Long project);


    //查询产值进度数据
    ProjectInfoVO getOutputvalueInfoByProjectId(Long project);

    //方案信息
    @Select("SELECT count(*) FROM `ejc-technologymanage`.`v_technologymanage_all`\n" +
            "where gcxmmc_id = #{project}")
    Long getTechnologyNumByProjectId(Long project);


    //劳务分包合同金额,份数
    @Select("SELECT case when isnull(SUM(contract_tax_mny)) then 0 else SUM(contract_tax_mny) end as labsub_contract_tax_mny,COUNT(*) labsub_count FROM `ejc-prosub`.`ejc_prosub_contract`\n" +
            "where project_id = #{project}\n" +
            "and dr=0\n" +
            "and bill_state in (1,3)\n" +
            "and contract_type = 0")
    ProjectInfoVO getLabsubByProjectId(Long project);
    //专业分包合同金额,份数
    @Select("SELECT case when isnull(SUM(contract_tax_mny)) then 0 else SUM(contract_tax_mny) end as prosub_contract_tax_mny,COUNT(*) prosub_count FROM `ejc-prosub`.`ejc_prosub_contract`\n" +
            "where project_id = #{project}\n" +
            "and dr=0\n" +
            "and bill_state in (1,3)\n" +
            "and contract_type = 1")
    ProjectInfoVO getProsubByProjectId(Long project);
    //设备租赁合同金额，份数
    @Select("SELECT case when isnull(SUM(contract_tax_mny)) then 0 else SUM(contract_tax_mny) end as rent_contract_tax_mny,COUNT(*) rent_count FROM `ejc-proequipment`.`ejc_proequipment_rent_contract`\n" +
            "where project_id =  #{project}\n" +
            "and dr=0\n" +
            "and bill_state in (1,3)")
    ProjectInfoVO getRentByProjectId(Long project);
    //监理纪要个数
    @Select("SELECT COUNT(*) meeting_count FROM `zzyj-outputvalcount`.`t_outputvalcount_meeting_minutes`\n" +
            "where department_id =  #{project}\n" +
            "and dr=0\n" +
            "and bill_state in (1,3)")
    ProjectInfoVO getMeetCountByProjectId(Long project);
    //施工日志个人个数，施工日志项目个数
    @Select("SELECT COUNT(*) build_person_count ,(SELECT COUNT(*) build_project_count FROM `ejc-probuilddiary`.`ejc_probuilddiary_project_log`\n" +
            "where project_id =  #{project}\n" +
            "and dr=0\n" +
            "and bill_state in (1,3)) as build_project_count FROM `ejc-probuilddiary`.`ejc_probuilddiary_person`\n" +
            "where project_id =  #{project}\n" +
            "and dr=0\n" +
            "and bill_state in (1,3)")
    ProjectInfoVO getBuildPersonCountByProjectId(Long project);


    //工程部获取项目状态数据
    ProjectChangeNumVO queryProjectStateChangeNum();


    //工程部获取产值信息
    ProjectChangeNumVO queryProjectOutputValueInfo();
    //获取小于100万的项目
    List<ProjectChangeNumVO> queryProjectOutputValueUnder100();

    ProjectChangeNumVO queryProjectLogInfo();

    //查询个人施工日志个数
    @Select("select count(*) from `ejc-probuilddiary`.`ejc_probuilddiary_person` where dr = 0 and bill_state in (1,3)")
    String queryTotalPersonNum();
    //查询项目施工日志个数
    @Select("select count(*) from `ejc-probuilddiary`.`ejc_probuilddiary_project_log` where dr = 0 and bill_state in (1,3)")
    String queryTotalProjectNum();
}
