package com.ejianc.business.market.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.constructor.api.IAnnualOperatingIndicatorsApi;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.market.service.ProjectSurveyService;
import com.ejianc.business.market.vo.ProjectCountVO;
import com.ejianc.business.market.vo.ProjectDataVO;
import com.ejianc.business.market.vo.ProjectVo;
import com.ejianc.business.market.vo.consts.ProjectSurveyEnum;
import com.ejianc.business.market.vo.util.EJCDateUtil;
import com.ejianc.business.profinance.api.IReceiptAndPaymentRegisterApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.ProjectSurveyTreeVO;
import com.ejianc.foundation.share.vo.ProjectSurveyVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import io.micrometer.core.instrument.util.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import static com.ejianc.business.market.vo.util.AddressResolutionUtil.*;
@Service("projectSurveyService")
public class ProjectSurveyServiceImpl implements ProjectSurveyService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IContractPoolApi iContractPoolApi;
    @Autowired
    private IAnnualOperatingIndicatorsApi indicatorsApi;
    @Autowired
    private IProjectPoolApi projectSetApi;
    @Autowired
    private IReceiptAndPaymentRegisterApi receiptAndPaymentRegisterApi;

    @Value("${pro.param.currentProvince}")
    private String currentProvince;

    @Override
    public CommonResponse<JSONObject> projectCount(String range, String name, String dateIn, Long orgId) {
        String projectStatus=null;
        //在建
        if (ProjectSurveyEnum.RANGE_BUILDING.getCode().equals(range)){
            projectStatus="1";
        }
        //今年
        if (ProjectSurveyEnum.THISYEAR.getCode().equals(dateIn)){
            dateIn = EJCDateUtil.getYear()+"";
        }

        List<ProjectCountVO> list=new ArrayList<>();
        List<ProjectSurveyTreeVO> listTree = new ArrayList<>();
        CommonResponse<List<ProjectSurveyVO>> listCommonResponse = projectSetApi.queryProjectList(projectStatus,dateIn, orgId,currentProvince);
        if (listCommonResponse.isSuccess()){
            //edit by sunyj 项目返回的数据需要根据父子项目过滤
            List<ProjectSurveyVO> data = listCommonResponse.getData();
            List<ProjectSurveyTreeVO> dataTree =BeanMapper.mapList(data, ProjectSurveyTreeVO.class);
            listTree = TreeNodeBUtil.buildTree(dataTree);// 主子项目的返回数据
            List<ProjectCountVO> projectCountVOS = BeanMapper.mapList(listTree, ProjectCountVO.class);
            list.addAll(projectCountVOS);
        }

        List<Long> ids = new ArrayList<>();
        Set<String> provinceSet = new HashSet<>();
        Set<String> citySet = new HashSet<>();
        Set<String> countySet = new HashSet<>();
        String pname = null;
        for (ProjectCountVO vo : list) {
            ids.add(vo.getId());
            if (org.apache.commons.lang3.StringUtils.isNotEmpty(vo.getArea())) {
                if (vo.getArea().equals("台湾省")) {
                    vo.setProvince("台湾省");
                    vo.setCity("台湾省");
                    vo.setCounty("台湾省");

                    provinceSet.add("台湾省");
                    citySet.add("台湾省");
                    countySet.add("台湾省");
                } else {
                    Map<String, String> areaMmap = addressResolution(vo.getArea());
                    if (areaMmap != null) {
                        String province = areaMmap.get("province") == null ? "其他" : areaMmap.get("province");
                        String city = areaMmap.get("city") == null ? "其他" : areaMmap.get("city");
                        String county = areaMmap.get("county") == null ? "其他" : areaMmap.get("county");
                        vo.setProvince(province);
                        vo.setCity(city);
                        vo.setCounty(county);
                        provinceSet.add(province);
                        citySet.add(city);
                        countySet.add(county);
                        if (org.apache.commons.lang3.StringUtils.isNotBlank(name) && city.equals(name)) {
                            pname = province;
                        }
                    } else {
                        vo.setProvince("其他");
                        vo.setCity("其他");
                        vo.setCounty("其他");
                        provinceSet.add("其他");
                        citySet.add("其他");
                        countySet.add("其他");
                    }
                }
            } else {
                vo.setProvince("其他");
                vo.setCity("其他");
                vo.setCounty("其他");
                provinceSet.add("其他");
                citySet.add("其他");
                countySet.add("其他");
            }

        }

        String rangeType = null;
        List<ProjectDataVO> dataVOS = new ArrayList<>();

        if (org.apache.commons.lang3.StringUtils.isNotBlank(name)) {
            if (provinceSet.contains(name)) {// 如果选择省
                rangeType = getProvincePinYin(name);
                dataVOS = projectCountByName(name, list, 0);
            } else if (citySet.contains(name)) {
                rangeType = getProvincePinYin(pname) + "-" + getNamePinYinChar(name, 1);
                dataVOS = projectCountByName(name, list, 1);
            }

        } else {
            if (provinceSet.size() == 1) {//同一省份
                if (citySet.size() == 1) {// 如果是同一市
                    rangeType = getProvincePinYin(provinceSet.iterator().next()) + "-" + getNamePinYinChar(citySet.iterator().next(), 1);
                    Map<String, ProjectDataVO> countyMap = new HashMap<>();
                    for (ProjectCountVO vo : list) {
                        String county = vo.getCounty();
                        BigDecimal contractTaxMny = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny();
                        if (!countyMap.containsKey(county)) {
                            ProjectDataVO pvo = new ProjectDataVO();
                            pvo.setName(county);
                            pvo.setValue(1);
                            pvo.setContractMoney(contractTaxMny);
                            countyMap.put(county, pvo);
                        } else {
                            ProjectDataVO projectDataVO = countyMap.get(county);
                            projectDataVO.setValue(projectDataVO.getValue() + 1);
                            projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(contractTaxMny));
                            countyMap.put(county, projectDataVO);
                        }
                    }
                    dataVOS = new ArrayList<ProjectDataVO>(countyMap.values());
                    Map<String, List<ProjectCountVO>> map = list.stream().collect(Collectors.groupingBy(ProjectCountVO::getCounty));
                    for (ProjectDataVO dataVO : dataVOS) {
                        if (map.containsKey(dataVO.getName())) {
                            List<ProjectCountVO> projectCountVOS = map.get(dataVO.getName());
                            List<ProjectVo> projectVos = new ArrayList<>();
                            for (ProjectCountVO projectCountVO : projectCountVOS) {
                                ProjectVo projectVo = new ProjectVo();
                                projectVo.setId(projectCountVO.getId());
                                projectVo.setName(projectCountVO.getProjectName());
                                projectVo.setOrgId(projectCountVO.getOrgId());
                                projectVo.setProjectDepartmentId(projectCountVO.getProjectDepartmentId());
                                projectVos.add(projectVo);
                            }
                            dataVO.setProjectList(projectVos);
                        }
                    }
                } else {
                    rangeType = getProvincePinYin(provinceSet.iterator().next());
                    Map<String, ProjectDataVO> cityMap = new HashMap<>();
                    for (ProjectCountVO vo : list) {
                        String city = vo.getCity();
                        BigDecimal contractTaxMny = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny();
                        if (!cityMap.containsKey(city)) {
                            ProjectDataVO pvo = new ProjectDataVO();
                            pvo.setName(city);
                            pvo.setValue(1);
                            pvo.setContractMoney(contractTaxMny);
                            cityMap.put(city, pvo);
                        } else {
                            ProjectDataVO projectDataVO = cityMap.get(city);
                            projectDataVO.setValue(projectDataVO.getValue() + 1);
                            projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(contractTaxMny));
                            cityMap.put(city, projectDataVO);
                        }
                    }
                    dataVOS = new ArrayList<ProjectDataVO>(cityMap.values());
                    Map<String, List<ProjectCountVO>> map = list.stream().collect(Collectors.groupingBy(ProjectCountVO::getCity));
                    for (ProjectDataVO dataVO : dataVOS) {
                        if (map.containsKey(dataVO.getName())) {
                            List<ProjectCountVO> projectCountVOS = map.get(dataVO.getName());
                            List<ProjectVo> projectVos = new ArrayList<>();
                            for (ProjectCountVO projectCountVO : projectCountVOS) {
                                ProjectVo projectVo = new ProjectVo();
                                projectVo.setId(projectCountVO.getId());
                                projectVo.setName(projectCountVO.getProjectName());
                                projectVo.setOrgId(projectCountVO.getOrgId());
                                projectVo.setProjectDepartmentId(projectCountVO.getProjectDepartmentId());
                                projectVos.add(projectVo);
                            }
                            dataVO.setProjectList(projectVos);
                        }
                    }
                }

            } else {//不同省份
                rangeType = "China";
                Map<String, ProjectDataVO> provinceMap = new HashMap<>();
                for (ProjectCountVO vo : list) {
                    String province = vo.getProvince();
                    BigDecimal contractTaxMny = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny();
                    if (!provinceMap.containsKey(province)) {
                        ProjectDataVO pvo = new ProjectDataVO();
                        pvo.setName(province);
                        pvo.setValue(1);
                        pvo.setContractMoney(contractTaxMny);
                        provinceMap.put(province, pvo);
                    } else {
                        ProjectDataVO projectDataVO = provinceMap.get(province);
                        projectDataVO.setValue(projectDataVO.getValue() + 1);
                        projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(contractTaxMny));
                        provinceMap.put(province, projectDataVO);
                    }
                }
                Map<String, List<ProjectCountVO>> map = list.stream().collect(Collectors.groupingBy(ProjectCountVO::getProvince));
                dataVOS = new ArrayList<ProjectDataVO>(provinceMap.values());
                for (ProjectDataVO dataVO : dataVOS) {
                    if (map.containsKey(dataVO.getName())) {
                        List<ProjectCountVO> projectCountVOS = map.get(dataVO.getName());
                        List<ProjectVo> projectVos = new ArrayList<>();
                        for (ProjectCountVO projectCountVO : projectCountVOS) {
                            ProjectVo projectVo = new ProjectVo();
                            projectVo.setId(projectCountVO.getId());
                            projectVo.setName(projectCountVO.getProjectName());
                            projectVo.setOrgId(projectCountVO.getOrgId());
                            projectVo.setProjectDepartmentId(projectCountVO.getProjectDepartmentId());
                            projectVos.add(projectVo);
                        }
                        dataVO.setProjectList(projectVos);
                    }
                }
            }
        }
        int allProjectNumber = list.size();//总项目数
        BigDecimal allInMoney = BigDecimal.ZERO ;//总收入
        BigDecimal allOutMoney = BigDecimal.ZERO;//总收入
        BigDecimal outPutValueTarget=BigDecimal.ZERO;//年度目标
        BigDecimal allContractMoney=BigDecimal.ZERO;//总合同额
        BigDecimal targetCompletionRate=BigDecimal.ZERO;
        List<Long> projectIds = list.stream().map(ProjectCountVO::getId).collect(Collectors.toList());
        if (dateIn!=null){
            CommonResponse<BigDecimal> contraction = iContractPoolApi.queryThisYearContractMny("contraction", dateIn,orgId);
            if (contraction.isSuccess()){
                if (contraction.getData()!=null){
                    allContractMoney=contraction.getData();
                }
            }
        }else {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("sourceType",new Parameter(QueryParam.EQ,"contraction"));
//            List<Long> projectIds = list.stream().map(ProjectCountVO::getId).collect(Collectors.toList());
            queryParam.getParams().put("projectId",new Parameter(QueryParam.IN,projectIds));
            CommonResponse<BigDecimal> bigDecimalCommonResponse = iContractPoolApi.queryContractMny(queryParam);
            if(bigDecimalCommonResponse.isSuccess()){
                allContractMoney=bigDecimalCommonResponse.getData();
            }
        }
        //总收入 总收入
        if (CollectionUtils.isNotEmpty(projectIds)){
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("billState", new Parameter(QueryParam.IN,
                    Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode()})));
            queryParam.getParams().put("projectId", new Parameter(QueryParam.IN, projectIds));
            CommonResponse<JSONObject>  receiptAndPaymentCommonResponse = receiptAndPaymentRegisterApi.queryReceiptAndPaymentMny(queryParam);
            if (receiptAndPaymentCommonResponse.isSuccess()){
                JSONObject data = receiptAndPaymentCommonResponse.getData();
                allInMoney= new BigDecimal(data.get("sumReceivedMny").toString());
                allOutMoney =  new BigDecimal(data.get("payMny").toString());
            }
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("allProjectNumber", allProjectNumber);
        jsonObject.put("allContractMoney", allContractMoney);
        jsonObject.put("allInMoney", allInMoney);
        jsonObject.put("allOutMoney", allOutMoney);
        //本年新增 请求郑州一建的接口获取 年度目标
        logger.info("本年新增 请求郑州一建的接口获取 年度目标");
        if (StringUtils.isNotEmpty(dateIn)) {
            logger.info("本年新增 请求郑州一建的接口获取 进入");
            Long _orgId = orgId!= null ? orgId : InvocationInfoProxy.getOrgId();
            Integer  year = EJCDateUtil.getYear();
            logger.info("本年新增 请求郑州一建的接口获取 调用参数orgId"+_orgId);
            logger.info("本年新增 请求郑州一建的接口获取 调用参数year"+year);
            CommonResponse<BigDecimal> commonResponse = indicatorsApi.getDetailByOrgId(_orgId, year);
            logger.info("本年新增 请求郑州一建的接口获取 调用"+commonResponse.isSuccess());
            if (commonResponse.isSuccess()){
                BigDecimal data = commonResponse.getData();
                logger.info("本年新增 请求郑州一建的接口获取 结果"+data);
                if (data!=null){
                    //给的是万元 前端是前端转换
                    outPutValueTarget =ComputeUtil.safeMultiply(data,new BigDecimal(10000));
                    targetCompletionRate= ComputeUtil.safeDiv(allContractMoney,outPutValueTarget);
                }
            }
        }
        jsonObject.put("outPutValueTarget", outPutValueTarget);
        //目标达成率
        jsonObject.put("targetCompletionRate", targetCompletionRate);
        if (CollectionUtils.isNotEmpty(dataVOS)){
            Collections.sort(dataVOS, new Comparator<ProjectDataVO>() {
                @Override
                public int compare(ProjectDataVO o1, ProjectDataVO o2) {
                    int a = "其他".equals(o1.getName()) ? 100000:o1.getValue();
                    int b = "其他".equals(o2.getName()) ? 100000:o1.getValue();
                    return a-b;
                }
            });
        }
        jsonObject.put("data", dataVOS);
        //在这个地方处理四个直辖市
        if (rangeType!=null){
            if (rangeType.contains("beijing")){
                rangeType="beijing";
            }
            else if (rangeType.contains("shanghai")){
                rangeType="beijing";
            }
            else if(rangeType.contains("chongqing")){
                rangeType="chongqing";
            }
            else if (rangeType.contains("tianjin")){
                rangeType="tianjin";
            }
        }
        jsonObject.put("range", rangeType == null || rangeType.contains("null") ? "China" : rangeType);
        return CommonResponse.success("查询数据成功！", jsonObject);
    }

    @Override
    public CommonResponse<JSONObject> getProjectColumnarInfo(String range, String name, String dateIn, Long orgId) {
        String projectStatus=null;
        //在建
        if (ProjectSurveyEnum.RANGE_BUILDING.getCode().equals(range)){
            projectStatus="1";
        }
        //今年
        if (ProjectSurveyEnum.THISYEAR.getCode().equals(dateIn)){
            dateIn = EJCDateUtil.getYear()+"";
        }

        List<ProjectCountVO> list=new ArrayList<>();
        CommonResponse<List<ProjectSurveyVO>> listCommonResponse = projectSetApi.queryProjectList(projectStatus,dateIn, orgId,currentProvince);
        if (listCommonResponse.isSuccess()){
            List<ProjectSurveyVO> data = listCommonResponse.getData();
            List<ProjectCountVO> projectCountVOS = BeanMapper.mapList(data, ProjectCountVO.class);
            list.addAll(projectCountVOS);
        }

        List<Long> ids = new ArrayList<>();
        Set<String> provinceSet = new HashSet<>();
        Set<String> citySet = new HashSet<>();
        Set<String> countySet = new HashSet<>();
        String pname = null;
        for (ProjectCountVO vo : list) {
            ids.add(vo.getId());
            if (org.apache.commons.lang3.StringUtils.isNotEmpty(vo.getArea())) {
                if (vo.getArea().equals("台湾省")) {
                    vo.setProvince("台湾省");
                    vo.setCity("台湾省");
                    vo.setCounty("台湾省");

                    provinceSet.add("台湾省");
                    citySet.add("台湾省");
                    countySet.add("台湾省");
                } else {
                    Map<String, String> areaMmap = addressResolution(vo.getArea());
                    if (areaMmap != null) {
                        String province = areaMmap.get("province") == null ? "其他" : areaMmap.get("province");
                        String city = areaMmap.get("city") == null ? "其他" : areaMmap.get("city");
                        String county = areaMmap.get("county") == null ? "其他" : areaMmap.get("county");
                        vo.setProvince(province);
                        vo.setCity(city);
                        vo.setCounty(county);
                        provinceSet.add(province);
                        citySet.add(city);
                        countySet.add(county);
                        if (org.apache.commons.lang3.StringUtils.isNotBlank(name) && city.equals(name)) {
                            pname = province;
                        }
                    } else {
                        vo.setProvince("其他");
                        vo.setCity("其他");
                        vo.setCounty("其他");
                        provinceSet.add("其他");
                        citySet.add("其他");
                        countySet.add("其他");
                    }
                }
            } else {
                vo.setProvince("其他");
                vo.setCity("其他");
                vo.setCounty("其他");
                provinceSet.add("其他");
                citySet.add("其他");
                countySet.add("其他");
            }

        }

        String rangeType = null;
        List<ProjectDataVO> dataVOS = new ArrayList<>();

        if (org.apache.commons.lang3.StringUtils.isNotBlank(name)) {
            if (provinceSet.contains(name)) {// 如果选择省
                rangeType = getProvincePinYin(name);
                dataVOS = projectCountByName(name, list, 0);
            } else if (citySet.contains(name)) {
                rangeType = getProvincePinYin(pname) + "-" + getNamePinYinChar(name, 1);
                dataVOS = projectCountByName(name, list, 1);
            }

        } else {
            if (provinceSet.size() == 1) {//同一省份
                if (citySet.size() == 1) {// 如果是同一市
                    rangeType = getProvincePinYin(provinceSet.iterator().next()) + "-" + getNamePinYinChar(citySet.iterator().next(), 1);
                    Map<String, ProjectDataVO> countyMap = new HashMap<>();
                    for (ProjectCountVO vo : list) {
                        String county = vo.getCounty();
                        BigDecimal contractTaxMny = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny();
                        if (!countyMap.containsKey(county)) {
                            ProjectDataVO pvo = new ProjectDataVO();
                            pvo.setName(county);
                            pvo.setValue(1);
                            pvo.setContractMoney(contractTaxMny);
                            countyMap.put(county, pvo);
                        } else {
                            ProjectDataVO projectDataVO = countyMap.get(county);
                            projectDataVO.setValue(projectDataVO.getValue() + 1);
                            projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(contractTaxMny));
                            countyMap.put(county, projectDataVO);
                        }
                    }
                    dataVOS = new ArrayList<ProjectDataVO>(countyMap.values());
                    Map<String, List<ProjectCountVO>> map = list.stream().collect(Collectors.groupingBy(ProjectCountVO::getCounty));
                    for (ProjectDataVO dataVO : dataVOS) {
                        if (map.containsKey(dataVO.getName())) {
                            List<ProjectCountVO> projectCountVOS = map.get(dataVO.getName());
                            List<ProjectVo> projectVos = new ArrayList<>();
                            for (ProjectCountVO projectCountVO : projectCountVOS) {
                                ProjectVo projectVo = new ProjectVo();
                                projectVo.setId(projectCountVO.getId());
                                projectVo.setName(projectCountVO.getProjectName());
                                projectVo.setOrgId(projectCountVO.getOrgId());
                                projectVo.setProjectDepartmentId(projectCountVO.getProjectDepartmentId());
                                projectVos.add(projectVo);
                            }
                            dataVO.setProjectList(projectVos);
                        }
                    }
                } else {
                    rangeType = getProvincePinYin(provinceSet.iterator().next());
                    Map<String, ProjectDataVO> cityMap = new HashMap<>();
                    for (ProjectCountVO vo : list) {
                        String city = vo.getCity();
                        BigDecimal contractTaxMny = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny();
                        if (!cityMap.containsKey(city)) {
                            ProjectDataVO pvo = new ProjectDataVO();
                            pvo.setName(city);
                            pvo.setValue(1);
                            pvo.setContractMoney(contractTaxMny);
                            cityMap.put(city, pvo);
                        } else {
                            ProjectDataVO projectDataVO = cityMap.get(city);
                            projectDataVO.setValue(projectDataVO.getValue() + 1);
                            projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(contractTaxMny));
                            cityMap.put(city, projectDataVO);
                        }
                    }
                    dataVOS = new ArrayList<ProjectDataVO>(cityMap.values());
                    Map<String, List<ProjectCountVO>> map = list.stream().collect(Collectors.groupingBy(ProjectCountVO::getCity));
                    for (ProjectDataVO dataVO : dataVOS) {
                        if (map.containsKey(dataVO.getName())) {
                            List<ProjectCountVO> projectCountVOS = map.get(dataVO.getName());
                            List<ProjectVo> projectVos = new ArrayList<>();
                            for (ProjectCountVO projectCountVO : projectCountVOS) {
                                ProjectVo projectVo = new ProjectVo();
                                projectVo.setId(projectCountVO.getId());
                                projectVo.setName(projectCountVO.getProjectName());
                                projectVo.setOrgId(projectCountVO.getOrgId());
                                projectVo.setProjectDepartmentId(projectCountVO.getProjectDepartmentId());
                                projectVos.add(projectVo);
                            }
                            dataVO.setProjectList(projectVos);
                        }
                    }
                }

            } else {//不同省份
                rangeType = "China";
                Map<String, ProjectDataVO> provinceMap = new HashMap<>();
                for (ProjectCountVO vo : list) {
                    String province = vo.getProvince();
                    BigDecimal contractTaxMny = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny();
                    if (!provinceMap.containsKey(province)) {
                        ProjectDataVO pvo = new ProjectDataVO();
                        pvo.setName(province);
                        pvo.setValue(1);
                        pvo.setContractMoney(contractTaxMny);
                        provinceMap.put(province, pvo);
                    } else {
                        ProjectDataVO projectDataVO = provinceMap.get(province);
                        projectDataVO.setValue(projectDataVO.getValue() + 1);
                        projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(contractTaxMny));
                        provinceMap.put(province, projectDataVO);
                    }
                }
                Map<String, List<ProjectCountVO>> map = list.stream().collect(Collectors.groupingBy(ProjectCountVO::getProvince));
                dataVOS = new ArrayList<ProjectDataVO>(provinceMap.values());
                for (ProjectDataVO dataVO : dataVOS) {
                    if (map.containsKey(dataVO.getName())) {
                        List<ProjectCountVO> projectCountVOS = map.get(dataVO.getName());
                        List<ProjectVo> projectVos = new ArrayList<>();
                        for (ProjectCountVO projectCountVO : projectCountVOS) {
                            ProjectVo projectVo = new ProjectVo();
                            projectVo.setId(projectCountVO.getId());
                            projectVo.setName(projectCountVO.getProjectName());
                            projectVo.setOrgId(projectCountVO.getOrgId());
                            projectVo.setProjectDepartmentId(projectCountVO.getProjectDepartmentId());
                            projectVos.add(projectVo);
                        }
                        dataVO.setProjectList(projectVos);
                    }
                }
            }
        }
        JSONObject jsonObject = new JSONObject();
        if (CollectionUtils.isNotEmpty(dataVOS)){
            Collections.sort(dataVOS, new Comparator<ProjectDataVO>() {
                @Override
                public int compare(ProjectDataVO o1, ProjectDataVO o2) {
                    int a = "其他".equals(o1.getName()) ? 100000:o1.getValue();
                    int b = "其他".equals(o2.getName()) ? 100000:o1.getValue();
                    return a-b;
                }
            });
        }
        //在这个地方处理四个直辖市
        if (rangeType!=null){
            if (rangeType.contains("beijing")){
                rangeType="beijing";
            }
            else if (rangeType.contains("shanghai")){
                rangeType="beijing";
            }
            else if(rangeType.contains("chongqing")){
                rangeType="chongqing";
            }
            else if (rangeType.contains("tianjin")){
                rangeType="tianjin";
            }
        }
        if (rangeType==null || rangeType.contains("null")){
            rangeType="China";
        }
        List<ProjectDataVO> projectDataVOS = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(dataVOS)){
            Map<String, ProjectDataVO> map = dataVOS.stream().collect(Collectors.toMap(k -> k.getName(), (k) -> k));
            if (rangeType.equals("China")){
                if (currentProvince.equals("henan")){
                    //河南的省 省内
                   if (map.containsKey("河南省")){
                       List<ProjectVo> projectList=new ArrayList<>();
                       ProjectDataVO vo = map.get("河南省");
                       if (vo!=null){
                           projectList.addAll(vo.getProjectList());
                       }
                       List<Long> projectIds = projectList.stream().map(ProjectVo::getId).collect(Collectors.toList());
                       BigDecimal totalContractMoney=BigDecimal.ZERO;

                       QueryParam queryParam = new QueryParam();
                       queryParam.getParams().put("sourceType",new Parameter(QueryParam.EQ,"contraction"));
                       queryParam.getParams().put("projectId",new Parameter(QueryParam.IN,projectIds));
                       CommonResponse<BigDecimal> bigDecimalCommonResponse = iContractPoolApi.queryContractMny(queryParam);
                       ProjectDataVO projectDataVO = new ProjectDataVO();
                       projectDataVO.setCurrentProvince("河南省");
                       projectDataVO.setName("省内");
                       if(bigDecimalCommonResponse.isSuccess()){
                           totalContractMoney=bigDecimalCommonResponse.getData();
                           projectDataVO.setContractMoney(totalContractMoney);
                       }
                       projectDataVO.setValue(projectIds.size());
                       projectDataVOS.add(projectDataVO);
                   }

                       //河南省的 省外 排除其他的
                      List<Long> projectIds = new ArrayList<>();
                      for (ProjectDataVO dataVO : dataVOS) {
                        if (!"其他".equals(dataVO.getName()) && !"河南省".equals(dataVO.getName()) ){
                            List<Long> pids = dataVO.getProjectList().stream().map(ProjectVo::getId).collect(Collectors.toList());
                            projectIds.addAll(pids);
                          }
                       }
                       QueryParam queryParam = new QueryParam();
                       queryParam.getParams().put("sourceType",new Parameter(QueryParam.EQ,"contraction"));
                       queryParam.getParams().put("projectId",new Parameter(QueryParam.IN,projectIds));
                       CommonResponse<BigDecimal> bigDecimalCommonResponse = iContractPoolApi.queryContractMny(queryParam);
                       ProjectDataVO projectDataVO = new ProjectDataVO();
                       projectDataVO.setName("省外");
                       BigDecimal totalContractMoney=BigDecimal.ZERO;
                       if(bigDecimalCommonResponse.isSuccess()){
                           totalContractMoney=bigDecimalCommonResponse.getData();
                           projectDataVO.setContractMoney(totalContractMoney);
                       }
                       projectDataVO.setValue(projectIds.size());
                       projectDataVOS.add(projectDataVO);

                }
                else {
                    //河南的省 省内
                    if (map.containsKey("云南省")){
                        List<ProjectVo> projectList  = new ArrayList<>();
                        ProjectDataVO vo = map.get("云南省");
                        if (vo!=null){
                            projectList.addAll(vo.getProjectList());
                        }
                        List<Long> projectIds = projectList.stream().map(ProjectVo::getId).collect(Collectors.toList());
                        BigDecimal totalContractMoney=BigDecimal.ZERO;

                        QueryParam queryParam = new QueryParam();
                        queryParam.getParams().put("sourceType",new Parameter(QueryParam.EQ,"contraction"));
                        queryParam.getParams().put("projectId",new Parameter(QueryParam.IN,projectIds));
                        CommonResponse<BigDecimal> bigDecimalCommonResponse = iContractPoolApi.queryContractMny(queryParam);
                        ProjectDataVO projectDataVO = new ProjectDataVO();
                        projectDataVO.setName("省内");
                        projectDataVO.setCurrentProvince("云南省");
                        if(bigDecimalCommonResponse.isSuccess()){
                            totalContractMoney=bigDecimalCommonResponse.getData();
                            projectDataVO.setContractMoney(totalContractMoney);
                        }
                        projectDataVO.setValue(projectIds.size());
                        projectDataVOS.add(projectDataVO);
                    }
                        //云南省 省外 排除其他的
                        List<Long> projectIds = new ArrayList<>();
                        for (ProjectDataVO dataVO : dataVOS) {
                        if (!"其他".equals(dataVO.getName()) && !"云南省".equals(dataVO.getName())){
                            List<Long> pids = dataVO.getProjectList().stream().map(ProjectVo::getId).collect(Collectors.toList());
                            projectIds.addAll(pids);
                         }
                      }
                        QueryParam queryParam = new QueryParam();
                        queryParam.getParams().put("sourceType",new Parameter(QueryParam.EQ,"contraction"));
                        queryParam.getParams().put("projectId",new Parameter(QueryParam.IN,projectIds));
                        CommonResponse<BigDecimal> bigDecimalCommonResponse = iContractPoolApi.queryContractMny(queryParam);
                        ProjectDataVO projectDataVO = new ProjectDataVO();
                        projectDataVO.setName("省外");
                        BigDecimal totalContractMoney=BigDecimal.ZERO;
                        if(bigDecimalCommonResponse.isSuccess()){
                            totalContractMoney=bigDecimalCommonResponse.getData();
                            projectDataVO.setContractMoney(totalContractMoney);
                        }
                        projectDataVO.setValue(projectIds.size());
                        projectDataVOS.add(projectDataVO);
                }
                jsonObject.put("data", projectDataVOS);
                return CommonResponse.success("查询数据成功！", jsonObject);
            }
            for (ProjectDataVO dataVO : dataVOS) {
                BigDecimal totalContractMoney=BigDecimal.ZERO;
                List<ProjectVo> projectList = dataVO.getProjectList();
                List<Long> projectIds = projectList.stream().map(ProjectVo::getId).collect(Collectors.toList());
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("sourceType",new Parameter(QueryParam.EQ,"contraction"));
                queryParam.getParams().put("projectId",new Parameter(QueryParam.IN,projectIds));
                CommonResponse<BigDecimal> bigDecimalCommonResponse = iContractPoolApi.queryContractMny(queryParam);
                if(bigDecimalCommonResponse.isSuccess()){
                    totalContractMoney=bigDecimalCommonResponse.getData();
                    dataVO.setContractMoney(totalContractMoney);
                }
                dataVO.setValue(projectIds.size());
                dataVO.setProjectList(null);
            }
        }
        jsonObject.put("data", dataVOS);
        return CommonResponse.success("查询数据成功！", jsonObject);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(org.apache.commons.lang3.StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    // type:0-省，1-市
    private List<ProjectDataVO> projectCountByName(String name, List<ProjectCountVO> list, Integer type) {
        List<ProjectDataVO> dataVOS = new ArrayList<>();
        Map<String, ProjectDataVO> map = new HashMap<>();
        for (ProjectCountVO vo : list) {
            String voName = null;
            String childrenName = null;
            if (type == 0) {
                voName = vo.getProvince();
                childrenName = vo.getCity();
            } else {
                voName = vo.getCity();
                childrenName = vo.getCounty();
            }
            if (voName.equals(name)) {
                BigDecimal contractTaxMny = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny();
                if (!map.containsKey(childrenName)) {
                    ProjectDataVO pvo = new ProjectDataVO();
                    pvo.setName(childrenName);
                    pvo.setValue(1);
                    pvo.setContractMoney(contractTaxMny);
                    map.put(childrenName, pvo);
                } else {
                    ProjectDataVO projectDataVO = map.get(childrenName);
                    projectDataVO.setValue(projectDataVO.getValue() + 1);
                    projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(contractTaxMny));
                    map.put(childrenName, projectDataVO);
                }
            }
        }
        Map<String, List<ProjectCountVO>> projectCountVOMap = null;
        if (type == 0) {
            projectCountVOMap = list.stream().collect(Collectors.groupingBy(ProjectCountVO::getCity));
        } else {
            projectCountVOMap = list.stream().collect(Collectors.groupingBy(ProjectCountVO::getCounty));
        }
        ArrayList<ProjectDataVO> projectDataVOS = new ArrayList<>(map.values());
        for (ProjectDataVO dataVO : projectDataVOS) {
            if (map.containsKey(dataVO.getName())) {
                List<ProjectCountVO> projectCountVOS = projectCountVOMap.get(dataVO.getName());
                List<ProjectVo> projectVos = new ArrayList<>();
                for (ProjectCountVO projectCountVO : projectCountVOS) {
                    ProjectVo projectVo = new ProjectVo();
                    projectVo.setId(projectCountVO.getId());
                    projectVo.setName(projectCountVO.getProjectName());
                    projectVo.setOrgId(projectCountVO.getOrgId());
                    projectVo.setProjectDepartmentId(projectCountVO.getProjectDepartmentId());
                    projectVos.add(projectVo);
                }
                dataVO.setProjectList(projectVos);
            }
        }
        return projectDataVOS;

    }
}
