package com.ejianc.business.market.service.impl;

import com.ejianc.business.constructor.api.IZjllApi;
import com.ejianc.business.constructor.vo.ZjllVO;
import com.ejianc.business.market.bean.CompletionPersonEntity;
import com.ejianc.business.market.bean.ReleasePersonEntity;
import com.ejianc.business.market.bean.ReleasePersonZiEntity;
import com.ejianc.business.market.service.IReleasePersonService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;

@Service("releasePerson") 
public class ReleasePersonBpmServiceImpl implements ICommonBusinessService {


	@Autowired
	private IZjllApi zjllApi;
	@Autowired
	private IReleasePersonService releasePersonService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		ReleasePersonEntity releasePersonEntity = releasePersonService.selectById(billId);
		List<ReleasePersonZiEntity> personList = releasePersonEntity.getReleasePersonZiList();
		if(ListUtil.isNotEmpty(personList)){
			for (ReleasePersonZiEntity personEntity : personList) {
				//竣工释放人员
				ZjllVO zjllVO = new ZjllVO();
				zjllVO.setProjectId(personEntity.getEnrollId());
				zjllVO.setXmId(personEntity.getRyId());
				zjllVO.setYxzt(1);
				zjllVO.setJssj(releasePersonEntity.getCreateTime());
				zjllVO.setChangeId(billId);
				zjllVO.setChangeType("竣工报告补录");
				zjllApi.updateWrapper(zjllVO);
			}

		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("本单据不允许撤回!");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
