/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.market.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.constructor.api.IZjllApi;
import com.ejianc.business.constructor.vo.ZjllVO;
import com.ejianc.business.enums.BusinessStatusEnum;
import com.ejianc.business.enums.ProjectStatusEnum;
import com.ejianc.business.market.bean.CompletionPersonEntity;
import com.ejianc.business.market.bean.CompletionWorkReportEntity;
import com.ejianc.business.market.bean.ProjectSetEntity;
import com.ejianc.business.market.service.ICompletionWorkReportService;
import com.ejianc.business.market.service.IProjectSetService;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="completionWorkReport")
public class CompletionWorkReportBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IProjectSetApi iProjectSetApi;
    @Autowired
    private ICompletionWorkReportService service;
    @Autowired
    private IProjectSetService projectSetService;
    @Autowired
    private IZjllApi zjllApi;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        CompletionWorkReportEntity completionWorkReportEntity = (CompletionWorkReportEntity)((Object)this.service.selectById(billId));
        if (completionWorkReportEntity != null) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.eq((Object)"id", (Object)billId);
            updateWrapper.set((Object)"effective_time", (Object)new Date());
            this.service.update((Wrapper)updateWrapper);
            if ("\u662f".equals(completionWorkReportEntity.getFinishFlag())) {
                ProjectSetEntity setEntity = (ProjectSetEntity)((Object)this.projectSetService.getById(completionWorkReportEntity.getProjectId()));
                setEntity.setProjectStatus(ProjectStatusEnum.\u7ae3\u5de5.getCode());
                setEntity.setBusinessStatus(BusinessStatusEnum.\u7ae3\u5de5.getCode());
                setEntity.setChangeStatusDate(completionWorkReportEntity.getServiceDate());
                this.projectSetService.updateById((Object)setEntity);
                CommonResponse res = this.iProjectSetApi.changeProjectStatus(completionWorkReportEntity.getProjectId(), ProjectStatusEnum.\u7ae3\u5de5.getCode(), BusinessStatusEnum.\u7ae3\u5de5.getCode(), null, null, null);
                if (!res.isSuccess()) {
                    this.logger.info("\u9a8c\u6536\u62a5\u544a\u3010{}\u3011\u66f4\u65b0\u3010\u9879\u76ee\u6c60\u3011\u9879\u76ee\u72b6\u6001\u4e3a\u7ae3\u5de5\uff0c\u4e1a\u52a1\u72b6\u6001\u4e3a\u7ae3\u5de5\u9a8c\u6536\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)completionWorkReportEntity.getBillCode(), (Object)res.getMsg());
                    throw new BusinessException("\u9a8c\u6536\u62a5\u544a\u3010" + completionWorkReportEntity.getBillCode() + "\u3011\u66f4\u65b0\u3010\u9879\u76ee\u6c60\u3011\u7ed3\u7b97\u72b6\u6001\u4e3a\u7ed3\u7b97\u4e2d\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res.getMsg());
                }
                List<CompletionPersonEntity> personList = completionWorkReportEntity.getCompletionPersonList();
                if (ListUtil.isNotEmpty(personList)) {
                    for (CompletionPersonEntity personEntity : personList) {
                        ZjllVO zjllVO = new ZjllVO();
                        zjllVO.setProjectId(personEntity.getEnrollId());
                        zjllVO.setXmId(personEntity.getRyId());
                        zjllVO.setYxzt(Integer.valueOf(1));
                        zjllVO.setJssj(completionWorkReportEntity.getServiceDate());
                        zjllVO.setChangeId(billId);
                        zjllVO.setChangeType("\u7ae3\u5de5\u62a5\u544a");
                        this.zjllApi.updateWrapper(zjllVO);
                        this.logger.info("\u7ae3\u5de5\u91ca\u653e\u4eba\u5458\u7ed3\u675f");
                    }
                }
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other) {
        JSONArray arr = new JSONArray();
        this.logger.info("sign:{}", (Object)sign);
        if ("choseProjectUser".equals(sign)) {
            CompletionWorkReportEntity entity = (CompletionWorkReportEntity)((Object)this.service.selectById(billId));
            ProjectSetEntity projectSetEntity = (ProjectSetEntity)((Object)this.projectSetService.selectById(entity.getProjectId()));
            Long patrolManager = projectSetEntity.getPatrolManager();
            String patrolManagerName = projectSetEntity.getPatrolManagerName();
            this.logger.info("userId:{}", (Object)patrolManager);
            this.logger.info("userName:{}", (Object)patrolManagerName);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("userId", (Object)patrolManager);
            jsonObject.put("userName", (Object)patrolManagerName);
            arr.add((Object)jsonObject);
        }
        return CommonResponse.success((Object)arr);
    }
}

