package com.ejianc.business.projectOverView.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.constructor.vo.ZjllVO;
import com.ejianc.business.market.bean.ProjectSetEntity;
import com.ejianc.business.market.service.IProjectSetService;
import com.ejianc.business.outputvalcount.api.IOutputValueApi;
import com.ejianc.business.outputvalcount.vo.MonthlyStatisticsVO;
import com.ejianc.business.outputvalcount.vo.XmyxglVO;
import com.ejianc.business.project.vo.UserInfoVO;
import com.ejianc.business.projectOverView.service.IProjectOverViewService;
import com.ejianc.business.projectOverView.vo.*;

import com.ejianc.business.projectmanage.vo.PracticeVO;
import com.ejianc.business.quality.vo.GccymbsdVO;
import com.ejianc.business.riskManage.vo.RiskAssessLatestVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;

import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.*;
import java.util.*;
import java.util.Date;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 项目信息一览门户
 *
 * @author generator
 */
@Controller
@RequestMapping("projectOverView")
public class ProjectOverViewController implements Serializable {

    @Autowired
    private IProjectOverViewService projectOverViewService;

    @Autowired
    private IProjectSetService projectSetService;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private SessionManager sessionManager;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * @param projectId
     * @Description
     *      根据项目id，查询方案数量及计划数量、并分类展示
     * @Return
     */
    @RequestMapping(value = "/queryFaData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FaDataVO> queryFaData(Long projectId) {
        FaDataVO faDataVO = projectOverViewService.queryFaData(projectId);
        return CommonResponse.success("查询技术管理方案数量数据成功！", faDataVO);
    }

    /**
     * @param projectId
     * @Description
     *      根据项目id，查询质量检查打分情况
     * @Return
     */
    @RequestMapping(value = "/queryCheckData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<QualityAndSafeDataVO> queryCheckData(Long projectId) {
        QualityAndSafeDataVO qualityAndSafeDataVO = projectOverViewService.queryCheckData(projectId);
        return CommonResponse.success("查询质量检查打分情况数据成功！",qualityAndSafeDataVO);
    }
    /**
     * @param projectId
     * @Description
     *      根据项目id，查询监理会议纪要数据
     * @Return
     */
    @RequestMapping(value = "/queryMeetingMinutesData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MeetingMinutesDataVO> queryMeetingMinutesData(Long projectId) {
        MeetingMinutesDataVO meetingMinutesDataVO = projectOverViewService.queryMeetingMinutesData(projectId);
        return CommonResponse.success("查询监理会议纪要数据成功！",meetingMinutesDataVO);
    }

    /**
     * @param projectId
     * @Description
     *      根据项目id,查询工程创优目标审定
     * @Return
     */
    @RequestMapping(value = "/queryTargetData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<GccymbsdVO> queryTargetData(Long projectId) {
        GccymbsdVO gccymbsdVO = projectOverViewService.queryTarget(projectId);
        return CommonResponse.success("查询工程创优目标审定数据成功！",gccymbsdVO);
    }

    /**
     * @param projectId
     * @param dateStr
     * @Description
     *      根据项目id，日期月份查询工程项目影像管理图片数据
     * @Return
     */
    @RequestMapping(value = "/queryImageData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ImageDataVO> queryImageData(Long projectId, String dateStr) {
        ImageDataVO imageDataVO = projectOverViewService.queryImageData(projectId,dateStr);
        return CommonResponse.success("按月查询项目影像管理图片成功！",imageDataVO);
    }

    /**
     * @param projectId
     * @Description
     *      根据项目id，查询所有项目影像管理图片数据
     * @Return
     */
    @RequestMapping(value = "/queryAllImageData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ImageDataVO> queryImageData(Long projectId) {
        ImageDataVO imageDataVO = projectOverViewService.queryAllImageData(projectId);
        return CommonResponse.success("查询所有项目影像管理图片成功！",imageDataVO);
    }
    /**
     * @param projectId
     * @param startDate
     * @param endDate
     * @Description
     *      根据项目id，项目起止时间计算项目影像管理列表展示页面
     * @Return
     */
    @RequestMapping(value = "/queryImageList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ImageListVO>> queryImageList(Long projectId, String startDate, String endDate) {

        List<ImageListVO> imageListVOS = projectOverViewService.queryImageList(projectId, startDate, endDate);
        return CommonResponse.success("查询项目影像列表数据成功！",imageListVOS);
    }

    /**
     *
     * @param projectId
     * @param orgId
     * @return
     *      根据项目id，组织id查询施工日志数据
     */
    @RequestMapping(value = "/queryLogInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<LogDataVO> queryLogInfo(Long projectId,Long orgId) {

        LogDataVO logDataVO = projectOverViewService.queryLogInfo(projectId,orgId);
        return CommonResponse.success("查询施工日志数量数据成功！",logDataVO);
    }

    /**
     *
     * @param projectId
     * @return
     *      根据项目id，查询计划数据
     */
    @RequestMapping(value = "/queryPlanData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PlanDataVO> queryPlanData(Long projectId) {
        PlanDataVO planDataVO = projectOverViewService.queryPlanData(projectId);
        return CommonResponse.success("查询计划数据成功！",planDataVO);
    }

    /**
     *
     * @param param
     * @return
     *      列表查询项目报备人员
     */
    @RequestMapping(value = "/queryUserInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ZjllVO>> queryUserInfo(@RequestBody QueryParam param) {


        QueryParam projectParam = new QueryParam();
//        if (param.getParams().containsKey("orgId")) {
//            projectParam.getParams().put("projectDepartmentId", new Parameter(QueryParam.EQ, param.getParams().get("orgId").getValue()));
//            param.getParams().remove("orgId");
//        }
//        /** 租户隔离 */
//        projectParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//        projectParam.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1,3)));
//
//        List<ProjectSetEntity> projectSetEntities = projectSetService.queryList(projectParam);
//        if(ListUtil.isNotEmpty(projectSetEntities)){
//            param.getParams().put("xmlxId",new Parameter(QueryParam.EQ,projectSetEntities.get(0).getId()));
//        }
        Page<ZjllVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<ZjllVO> userInfoVO = projectOverViewService.queryUserInfo(page,param);
        page.setRecords(userInfoVO);
        return CommonResponse.success("查询报备人员数据成功！",page);
    }

    /**
     *
     * @param projectId
     * @return
     *      根据项目id，查询各奖项数量
     */
    @RequestMapping(value = "/queryAchieveData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AchieveData> queryAchieveData(Long projectId) {
        AchieveData achieveData = projectOverViewService.queryAchieveData(projectId);
        return CommonResponse.success("查询成果管理奖项数据成功！",achieveData);
    }

    /**
     *
     * @param projectId
     * @return
     *      根据项目id，查询各类支付
     */
    @RequestMapping(value = "/queryPaymentRegisterData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PaymentRegisterData> queryPaymentRegisterData(Long projectId) {
        PaymentRegisterData paymentRegisterData = projectOverViewService.queryPaymentRegisterData(projectId);
        return CommonResponse.success("查询查询各类支付数据成功！",paymentRegisterData);
    }
    /**
     * @param projectId
     * @Description
     *      根据项目id，查询进度管理总计划开始时间、结束时间、项目实际开始时间
     * @Return
     * @return
     */
    @RequestMapping(value = "/queryStartDate", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse queryStartDate(Long projectId) {
        Map map = projectOverViewService.queryStartDate(projectId);
        return CommonResponse.success("查询进度管理总计划开始时间、结束时间、项目实际开始时间成功！",map);
    }

    /**
     * @param projectId
     * @Description
     *      根据项目id，查询整改通知单、回复单数据
     * @Return
     * @return
     */
    @RequestMapping(value = "/queryRectificationData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RectificationVO> queryRectificationData(Long projectId) {
        RectificationVO rectificationVO = projectOverViewService.queryRectificationData(projectId);
        return CommonResponse.success("查询整改通知单、回复单数据成功！",rectificationVO);
    }
    /**
     * @param projectId
     * @Description
     *      根据项目id，查询相关方每日信息填报
     * @Return
     * @return
     */
    @RequestMapping(value = "/queryProjectRelateInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String, Object>> queryProjectRelateInfo(Long projectId) {
        Map<String, Object> map = projectOverViewService.queryProjectRelateInfo(projectId);
        return CommonResponse.success("查询相关方每日信息填报数据成功！",map);
    }

    /**
     * @param projectId
     * @Description
     *      根据项目id，查询施工风险综合评价风险级别
     * @Return
     * @return
     */
    @RequestMapping(value = "/queryProjectRiskLevel", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RiskAssessLatestVO> queryProjectRiskLevel(Long projectId) {
        RiskAssessLatestVO latestVO = projectOverViewService.queryProjectRiskLevel(projectId);
        return CommonResponse.success("查询施工风险综合评价风险级别成功！",latestVO);
    }

    /**
     * @param projectId
     * @Description
     *      根据项目id，查询危大工程数据
     * @Return
     * @return
     */
    @RequestMapping(value = "/queryDangerProjectData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse queryDangerProjectData(Long projectId) {
        Map map = projectOverViewService.queryDangerProjectData(projectId);
        return CommonResponse.success("查询施工风险综合评价风险级别成功！",map);
    }

    /**
     * @param projectId
     * @Description
     *      根据项目id，查询劳务分包结算数据、材料结算数据
     * @Return
     * @return
     */
    @RequestMapping(value = "/querySettleData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse querySettleData(Long projectId) {
        Map map = projectOverViewService.querySettleData(projectId);
        return CommonResponse.success("查询施工风险综合评价风险级别成功！",map);
    }



    private static final BigDecimal FIVE_MILLION = new BigDecimal(500_0000);//五百万
    private static final BigDecimal TEN_MILLION = new BigDecimal(1000_0000);//一千万

    /**
     * 根据范围查询月度计划产值
     * @param orgId
     * @param dateIn
     * @return
     */
    @RequestMapping(value = "/queryStatistics", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String,String>>> queryStatistics(@RequestParam(value = "orgId") Long orgId,
                                          @RequestParam(value = "dateIn") Integer dateIn) {

        //获取当前项目的所有单据
        //获取当前组织下的所有项目、组织
        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        /** 单据状态 */
        param.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));

        //param.getParams().put("projectDepartmentId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        //1539639347695513601
        //去除G9项目的值
        param.getParams().put("projectId",new Parameter(QueryParam.NE,643021352342790201L));

        String startDatePlan = DateFormatUtils.format(DateUtil.beginOfMonth(new Date()), "yyyy-MM-dd");
        String endDatePlan = DateFormatUtils.format(DateUtil.endOfMonth(new Date()),"yyyy-MM-dd");
        /** ywDate */
        param.getParams().put("statDatePlan", new Parameter(QueryParam.BETWEEN,
                startDatePlan + "," + endDatePlan));

        List<MonthlyStatisticsVO> monthlyStatistics = projectOverViewService.getStatisticsByOrgIdUnder(param);
        /**
         * G9产值计划
         */
        List<MonthlyStatisticsVO> G9OutputPlanList = getG9OutputPlanList(startDatePlan, endDatePlan);
        monthlyStatistics.addAll(G9OutputPlanList);

        /**
         * 计划产值区间
         */
        List<Map<String, String>> resultList = new ArrayList<>();
        BigDecimal rangeMny = monthlyStatistics.stream().map(MonthlyStatisticsVO::getByjhwcczPlan)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        HashMap<String, String> map = new HashMap<>();
        map.put("name","总计划产值");
        map.put("num",monthlyStatistics.size()+"");
        map.put("mny",rangeMny+"");
        resultList.add(map);
        //0到500万
        List<MonthlyStatisticsVO> listRange1 = monthlyStatistics.stream().filter(s -> s.getByjhwcczPlan() != null
                && s.getByjhwcczPlan().compareTo(BigDecimal.ZERO) >= 0
                && s.getByjhwcczPlan().compareTo(FIVE_MILLION) < 0).collect(Collectors.toList());
        BigDecimal rangeMny1 = listRange1.stream().map(MonthlyStatisticsVO::getByjhwcczPlan)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        HashMap<String, String> map1 = new HashMap<>();
        map1.put("name","0到500万");
        map1.put("num",listRange1.size()+"");
        map1.put("mny",rangeMny1+"");
        resultList.add(map1);
        //500万到1000万
        List<MonthlyStatisticsVO> listRange2 = monthlyStatistics.stream().filter(s -> s.getByjhwcczPlan() != null
                && s.getByjhwcczPlan().compareTo(FIVE_MILLION) >= 0
                && s.getByjhwcczPlan().compareTo(TEN_MILLION) < 0).collect(Collectors.toList());
        BigDecimal rangeMny2 = listRange2.stream().map(MonthlyStatisticsVO::getByjhwcczPlan)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        HashMap<String, String> map2 = new HashMap<>();
        map2.put("name","500到1000万");
        map2.put("num",listRange2.size()+"");
        map2.put("mny",rangeMny2+"");
        resultList.add(map2);
        //1000万以上
        List<MonthlyStatisticsVO> listRange3 = monthlyStatistics.stream().filter(s -> s.getByjhwcczPlan() != null
                && s.getByjhwcczPlan().compareTo(TEN_MILLION) >= 0).collect(Collectors.toList());
        BigDecimal rangeMny3 = listRange3.stream().map(MonthlyStatisticsVO::getByjhwcczPlan)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        HashMap<String, String> map3 = new HashMap<>();
        map3.put("name","1000万以上");
        map3.put("num",listRange3.size()+"");
        map3.put("mny",rangeMny3+"");
        resultList.add(map3);
        return CommonResponse.success("查询项目进度明细成功！",resultList);
    }

    //G9项目计划产值
    public List<MonthlyStatisticsVO> getG9OutputPlanList(String startDate, String endDate) {
        try{  Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            logger.info("连接成功1");
        }
        catch(Exception e) {
            logger.info("连接失败1");
        }
        String connectionUrl =
                "jdbc:sqlserver://172.16.1.242:1433;"
                        + "databaseName=master;"
                        + "user=sa;"
                        + "password=Zzyj2015;";
        Connection con;//处理与特定数据库的连接

        Statement stmt = null;
        ResultSet rs = null;

        List<MonthlyStatisticsVO> G9MonthlyPlanVOS = new ArrayList<>();
        try {
            con = DriverManager.getConnection(connectionUrl);
            logger.info("连接成功2");
            Calendar date = Calendar.getInstance();
            String SQL = "SELECT\n" +
                    "* \n" +
                    "FROM\n" +
                    "(\n" +
                    "SELECT\n" +
                    "DATEADD( mm, ( F_TJNF - 1900 ) * 12+F_YF - 1, 0 ) AS stat_date_plan,\n" +
                    "F_JE AS byjhwccz_plan \n" +
                    "FROM\n" +
                    "[gtp-default].[dbo].[PG7ZZ_XMGLZFGSYY_ZFGSCZJH] \n" +
                    "WHERE\n" +
                    "F_DEPT_ID NOT IN ( 22754 ) \n" +
                    "AND F_STATE IN ( 1, 3 ) \n" +
                    ") as x where stat_date_plan between " + "'" + startDate + "'" + " and " + "'" + endDate + "'";
//            String SQL = "SELECT SUM(F_JE) as je FROM [gtp-default].[dbo].[PG7ZZ_XMGLZFGSYY_ZFGSCZTJ]\n" +
//                    "where F_TJNF = 2023 \n"+
//                    "and F_STATE = 3\n" +
//                    "and F_DEPT_ID not in (22754)\n" +
//                    "GROUP BY F_TJNF ";
            stmt = con.createStatement();// 创建Statement
            rs = stmt.executeQuery(SQL);// 执行SQL语句----------- *1

            while (rs.next()) {
                MonthlyStatisticsVO G9MonthlyPlanVO = new MonthlyStatisticsVO();
                // 遍历result set 的结果并打印
                BigDecimal byjhwcczPlan = rs.getBigDecimal("byjhwccz_plan");
                Date statDatePlan = rs.getDate("stat_date_plan");
                G9MonthlyPlanVO.setByjhwcczPlan(byjhwcczPlan);
                G9MonthlyPlanVO.setStatDatePlan(statDatePlan);
                G9MonthlyPlanVOS.add(G9MonthlyPlanVO);
            }

            con.close();
        } catch(SQLException e) {
            logger.info("请输入正确的表名"+e+".连接失败2");
        }

        return  G9MonthlyPlanVOS;
    }


    /**
     * 根据季度查询实际产值
     * @param orgId
     * @param dateIn
     * @return
     */
    @RequestMapping(value = "/queryOutPutValueByQuarter", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String,String>>> queryOutPutValueByQuarter(@RequestParam(value = "orgId") Long orgId,
                                                                    @RequestParam(value = "dateIn") Integer dateIn) {

        //获取当前项目的所有单据
        //获取当前组织下的所有项目、组织
        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        /** 单据状态 */
        param.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));

        //param.getParams().put("projectDepartmentId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        //1539639347695513601
        //去除G9项目的值
        param.getParams().put("projectId",new Parameter(QueryParam.NE,643021352342790201L));

        /**
         * 查询本年的所有产值
         */
        String startMonth = "-01-01";
        String endMonth = "-12-31";
        String startDate = dateIn + startMonth;
        String endDate = dateIn + endMonth;
        /** ywDate */
        param.getParams().put("statDate", new Parameter(QueryParam.BETWEEN,
                startDate + "," + endDate));

        List<MonthlyStatisticsVO> monthlyStatistics = projectOverViewService.getStatisticsByOrgIdUnder(param);
        /**
         * G9产值计划
         */
        List<MonthlyStatisticsVO> G9OutputValueList = getG9OutputValueList(startDate, endDate);
        monthlyStatistics.addAll(G9OutputValueList);

        /**
         * 计划产值区间
         */
        List<Map<String, String>> resultList = new ArrayList<>();
        BigDecimal rangeMny = monthlyStatistics.stream().map(MonthlyStatisticsVO::getBywccz)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        HashMap<String, String> map = new HashMap<>();
        map.put("name","实际产值");
        map.put("num",monthlyStatistics.size()+"");
        map.put("mny",rangeMny+"");
        resultList.add(map);



        //第1季度
        List<MonthlyStatisticsVO> listRange1 = monthlyStatistics.stream().filter(s -> s.getStatDate() != null
                && getYearQuarterIndex(s.getStatDate()) == 1)
                .collect(Collectors.toList());
        BigDecimal rangeMny1 = listRange1.stream().map(MonthlyStatisticsVO::getBywccz)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        HashMap<String, String> map1 = new HashMap<>();
        map1.put("name","第1季度");
        map1.put("num",listRange1.size()+"");
        map1.put("mny",rangeMny1+"");
        resultList.add(map1);
        //第2季度
        List<MonthlyStatisticsVO> listRange2 = monthlyStatistics.stream().filter(s -> s.getStatDate() != null
                && getYearQuarterIndex(s.getStatDate()) == 2)
                .collect(Collectors.toList());
        BigDecimal rangeMny2 = listRange2.stream().map(MonthlyStatisticsVO::getBywccz)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        HashMap<String, String> map2 = new HashMap<>();
        map2.put("name","第2季度");
        map2.put("num",listRange2.size()+"");
        map2.put("mny",rangeMny2+"");
        resultList.add(map2);
        //第3季度
        List<MonthlyStatisticsVO> listRange3 = monthlyStatistics.stream().filter(s -> s.getStatDate() != null
                && getYearQuarterIndex(s.getStatDate()) == 3)
                .collect(Collectors.toList());
        BigDecimal rangeMny3 = listRange3.stream().map(MonthlyStatisticsVO::getBywccz)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        HashMap<String, String> map3 = new HashMap<>();
        map3.put("name","第3季度");
        map3.put("num",listRange3.size()+"");
        map3.put("mny",rangeMny3+"");
        resultList.add(map3);
        //第4季度
        List<MonthlyStatisticsVO> listRange4 = monthlyStatistics.stream().filter(s -> s.getStatDate() != null
                && getYearQuarterIndex(s.getStatDate()) == 4)
                .collect(Collectors.toList());
        BigDecimal rangeMny4 = listRange4.stream().map(MonthlyStatisticsVO::getBywccz)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        HashMap<String, String> map4 = new HashMap<>();
        map4.put("name","第4季度");
        map4.put("num",listRange4.size()+"");
        map4.put("mny",rangeMny4+"");
        resultList.add(map4);
        return CommonResponse.success("根据季度查询实际产值成功！",resultList);
    }

    //G9项目实际产值
    public List<MonthlyStatisticsVO> getG9OutputValueList(String startDate, String endDate) {
        try{  Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            logger.info("连接成功1");
        }
        catch(Exception e) {
            logger.info("连接失败1");
        }
        String connectionUrl =
                "jdbc:sqlserver://172.16.1.242:1433;"
                        + "databaseName=master;"
                        + "user=sa;"
                        + "password=Zzyj2015;";
        Connection con;//处理与特定数据库的连接

        Statement stmt = null;
        ResultSet rs = null;

        List<MonthlyStatisticsVO> G9MonthlyPlanVOS = new ArrayList<>();
        try {
            con = DriverManager.getConnection(connectionUrl);
            logger.info("连接成功2");
            Calendar date = Calendar.getInstance();
            String SQL = "SELECT\n" +
                    "* \n" +
                    "FROM\n" +
                    "(\n" +
                    "SELECT\n" +
                    "DATEADD( mm, ( F_TJNF - 1900 ) * 12+F_YF - 1, 0 ) AS stat_date,\n" +
                    "F_JE AS bywccz \n" +
                    "FROM\n" +
                    "[gtp-default].[dbo].[PG7ZZ_XMGLZFGSYY_ZFGSCZTJ] \n" +
                    "WHERE\n" +
                    "F_DEPT_ID NOT IN ( 22754 ) \n" +
                    "AND F_STATE IN ( 1, 3 ) \n" +
                    ") as x where stat_date between " + "'" + startDate + "'" + " and " + "'" + endDate + "'";
//            String SQL = "SELECT SUM(F_JE) as je FROM [gtp-default].[dbo].[PG7ZZ_XMGLZFGSYY_ZFGSCZTJ]\n" +
//                    "where F_TJNF = 2023 \n"+
//                    "and F_STATE = 3\n" +
//                    "and F_DEPT_ID not in (22754)\n" +
//                    "GROUP BY F_TJNF ";
            stmt = con.createStatement();// 创建Statement
            rs = stmt.executeQuery(SQL);// 执行SQL语句----------- *1

            while (rs.next()) {
                MonthlyStatisticsVO G9MonthlyPlanVO = new MonthlyStatisticsVO();
                // 遍历result set 的结果并打印
                BigDecimal byjhwcczPlan = rs.getBigDecimal("bywccz");
                Date statDate = rs.getDate("stat_date");
                G9MonthlyPlanVO.setBywccz(byjhwcczPlan);
                G9MonthlyPlanVO.setStatDate(statDate);
                G9MonthlyPlanVOS.add(G9MonthlyPlanVO);
            }

            con.close();
        } catch(SQLException e) {
            logger.info("请输入正确的表名"+e+".连接失败2");
        }

        return  G9MonthlyPlanVOS;
    }
    /**
     * 当前属于本年第几个季度
     *
     * @return
     */
    public static int getYearQuarterIndex(Date date) {
        int month = getYearMonthIndex(date);
        if (month <= 3)
            return 1;
        else if (month <= 6)
            return 2;
        else if (month <= 9)
            return 3;
        else
            return 4;
    }

    /**
     * 属于本年第几月
     *
     * @return
     */
    public static int getYearMonthIndex(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(Calendar.MONTH) + 1;
    }

    /**
     * @param projectId
     * @Description
     *      根据项目id，查询应急演练照片
     * @Return
     * @return
     */
    @RequestMapping(value = "/queryPracticeImgList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryPracticeImgList(Long projectId) {

//        List<XmyxglVO> xmyxglVOS = new ArrayList<>();
        ImageDataVO imageDataVO = new ImageDataVO();
        JSONObject resJSON = new JSONObject();

        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId",new Parameter(QueryParam.EQ,projectId));
        queryParam.getParams().put("billState",new Parameter(QueryParam.IN,Arrays.asList(1,3)));
        queryParam.getParams().put("dr",new Parameter(QueryParam.EQ,0));


        List<PracticeVO> practiceList = projectOverViewService.getPracticeList(queryParam);
        //图片sourceId
        List<Long> ids = practiceList.stream().map(PracticeVO::getId).collect(Collectors.toList());
        Map<Long, PracticeVO> voMap = practiceList.stream().collect(Collectors.toMap(PracticeVO::getId, Function.identity()));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sourceIds", ids);
        CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(jsonObject);
        if (listCommonResponse.isSuccess()) {
            List<AttachmentVO> data = listCommonResponse.getData();
            List<Map<String, String>> pathData = new ArrayList<>();
            for (PracticeVO vo : practiceList) {
                for (AttachmentVO attachmentVO : data) {
                    if(vo.getId().equals(attachmentVO.getSourceId()) && "practicePhotoFile".equals(attachmentVO.getSourceType())){
                        logger.info("影像id{},图片id{}",vo.getId(),attachmentVO.getSourceId());
                        String suffix = attachmentVO.getFileName().substring(attachmentVO.getFileName().lastIndexOf(".") + 1);
                        if ("jpg".equals(suffix) || "png".equals(suffix) ||
                                "JPG".equals(suffix) || "PNG".equals(suffix)
                        ) {
                            HashMap<String, String> pathMap = new HashMap<>();
                            pathMap.put("name", voMap.get(attachmentVO.getSourceId()).getId().toString());
                            pathMap.put("path", attachmentVO.getTruePath());
                            pathData.add(pathMap);
                        }

                    }
                }
            }
            imageDataVO.setPathMap(pathData);
//            imageDataVO.setXmyxglVOS(xmyxglVOS);
        }
        resJSON.put("imgData",imageDataVO);
        resJSON.put("total",practiceList.size());

        return CommonResponse.success("查询施工风险综合评价风险级别成功！",resJSON);
    }
}
