package com.ejianc.business.market.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.market.mapper.StartWorkReportMapper;
import com.ejianc.business.market.bean.StartWorkReportEntity;
import com.ejianc.business.market.service.IStartWorkReportService;

import java.util.List;

/**
 * 开工报告
 * 
 * @author generator
 * 
 */
@Service("startWorkReportService")
public class StartWorkReportServiceImpl extends BaseServiceImpl<StartWorkReportMapper, StartWorkReportEntity> implements IStartWorkReportService{

    @Override
    public CommonResponse checkProject(Long projectId) {
        QueryWrapper<StartWorkReportEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("project_id",projectId);
        List<StartWorkReportEntity> list = super.list(wrapper);
        if(list.size()>0){
            return CommonResponse.error("该项目下已存在开工报告！");
        }
        return CommonResponse.success();
    }
}
