package com.ejianc.business.promaterial.contract.vo;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.business.tools.refer.annotation.ReferJsonField;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 主合同明细实体
 * 
 * @author generator
 * 
 */
@ApiModel("主合同明细实体")
public class ContractDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("合同Id")
    private Long contractId;
    @ApiModelProperty("物料Id")
    private Long materialId;
    @ApiModelProperty("物资分类名称")
    private String materialTypeName;
    @ApiModelProperty("物资分类Id")
    private Long materialTypeId;
    @ApiModelProperty("物资名称")
    private String materialName;
    @ApiModelProperty("物资编码")
    private String materialCode;
    @ApiModelProperty("规则/型号")
    private String spec;
    @ApiModelProperty("计量单位主键")
    private Long unitId;
    @ApiModelProperty("计量单位")
    private String unitName;
    @ApiModelProperty("品牌")
    private String brand;
    @ApiModelProperty("产地")
    private String place;
    @ApiModelProperty("数量")
    private BigDecimal num;
    @ApiModelProperty("单价(无税)")
    private BigDecimal price;
    @ApiModelProperty("金额(无税)")
    private BigDecimal money;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("税率")
    private BigDecimal detailTaxRate;
    @ApiModelProperty("税额")
    private BigDecimal detailTax;
    @ApiModelProperty("金额(含税)")
    private BigDecimal detailTaxMny;
    @ApiModelProperty("单价(含税)")
    private BigDecimal detailTaxPrice;
    @ApiModelProperty("来源数据Id")
    private String sourceId;
    @ApiModelProperty("物资来源类型：1-物料档案，2-计划，3-定标结果带入")
    private String sourceType;
    @ApiModelProperty("变更主键")
    private Long changeId;
    @ApiModelProperty("变更子表主键")
    private Long changeBid;
    @ApiModelProperty("变更类型")
    private String changeType;
    @ApiModelProperty("是否来源补充协议(1:是，0：否)")
    private Integer srcSupplementFlag;
    @ApiModelProperty("来源补充协议主表ID")
    private Long srcSupplementId;
    @ApiModelProperty("来源补充协议明细ID")
    private Long srcSupplementDetailId;

    @ApiModelProperty("历史价格区间（无税）")
    private String historyPriceArea;
    @ApiModelProperty("历史价格区间（含税）")
    private String historyTaxPriceArea;
    @ApiModelProperty("可签订数量")
    private BigDecimal signNum;
    @ApiModelProperty("来源单价(无税)")
    private BigDecimal sourcePrice;
    @ApiModelProperty("来源单价(含税)")
    private BigDecimal sourceTaxPrice;
    @ApiModelProperty("定标总数量")
    private BigDecimal tenderNum;
    @ApiModelProperty("初始采购数量（合同变更前数量）")
    private BigDecimal initNum;
    @ApiModelProperty("自动称重设置（0：自动称重，1非自动称重）送货单参照用")
    private Integer automaticWeigh;

    //模板导出使用
    private String detailPriceStr;
    private String detailTaxPriceStr;
    private String detailMnyStr;
    private String detailTaxMnyStr;
    private String detailTaxStr;
    private String detailNumStr;
    private String detailTaxRateStr;
    private String guidePriceArea; // 公司指导价区间（无税）
    private String guideTaxPriceArea; // 公司指导价区间（含税）

    private String materialTypeCode; // 物资分类编码
    private String specif; // 项目特征
    private BigDecimal materialPrice; // 材料费单价(无税)
    private BigDecimal azPrice; // 安装费单价(无税)
    private BigDecimal otherPrice; // 其他单价(无税)
    private BigDecimal materialTaxPrice; // 材料费单价(含税)
    private BigDecimal azTaxPrice; // 安装费单价(含税)
    private BigDecimal otherTaxPrice; // 其他单价(含税)

    private String errorMsg;
    private String errorCode;

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String getSpecif() {
        return specif;
    }

    public void setSpecif(String specif) {
        this.specif = specif;
    }

    public BigDecimal getMaterialPrice() {
        return materialPrice;
    }

    public void setMaterialPrice(BigDecimal materialPrice) {
        this.materialPrice = materialPrice;
    }

    public BigDecimal getAzPrice() {
        return azPrice;
    }

    public void setAzPrice(BigDecimal azPrice) {
        this.azPrice = azPrice;
    }

    public BigDecimal getOtherPrice() {
        return otherPrice;
    }

    public void setOtherPrice(BigDecimal otherPrice) {
        this.otherPrice = otherPrice;
    }

    public BigDecimal getMaterialTaxPrice() {
        return materialTaxPrice;
    }

    public void setMaterialTaxPrice(BigDecimal materialTaxPrice) {
        this.materialTaxPrice = materialTaxPrice;
    }

    public BigDecimal getAzTaxPrice() {
        return azTaxPrice;
    }

    public void setAzTaxPrice(BigDecimal azTaxPrice) {
        this.azTaxPrice = azTaxPrice;
    }

    public BigDecimal getOtherTaxPrice() {
        return otherTaxPrice;
    }

    public void setOtherTaxPrice(BigDecimal otherTaxPrice) {
        this.otherTaxPrice = otherTaxPrice;
    }

    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }

    public String getGuidePriceArea() {
        return guidePriceArea;
    }

    public void setGuidePriceArea(String guidePriceArea) {
        this.guidePriceArea = guidePriceArea;
    }

    public String getGuideTaxPriceArea() {
        return guideTaxPriceArea;
    }

    public void setGuideTaxPriceArea(String guideTaxPriceArea) {
        this.guideTaxPriceArea = guideTaxPriceArea;
    }
    public String getDetailPriceStr() {
        return detailPriceStr;
    }

    public void setDetailPriceStr(String detailPriceStr) {
        this.detailPriceStr = detailPriceStr;
    }

    public String getDetailTaxPriceStr() {
        return detailTaxPriceStr;
    }

    public void setDetailTaxPriceStr(String detailTaxPriceStr) {
        this.detailTaxPriceStr = detailTaxPriceStr;
    }

    public String getDetailMnyStr() {
        return detailMnyStr;
    }

    public void setDetailMnyStr(String detailMnyStr) {
        this.detailMnyStr = detailMnyStr;
    }

    public String getDetailTaxMnyStr() {
        return detailTaxMnyStr;
    }

    public void setDetailTaxMnyStr(String detailTaxMnyStr) {
        this.detailTaxMnyStr = detailTaxMnyStr;
    }

    public String getDetailTaxStr() {
        return detailTaxStr;
    }

    public void setDetailTaxStr(String detailTaxStr) {
        this.detailTaxStr = detailTaxStr;
    }

    public String getDetailNumStr() {
        return detailNumStr;
    }

    public void setDetailNumStr(String detailNumStr) {
        this.detailNumStr = detailNumStr;
    }

    public String getDetailTaxRateStr() {
        return detailTaxRateStr;
    }

    public void setDetailTaxRateStr(String detailTaxRateStr) {
        this.detailTaxRateStr = detailTaxRateStr;
    }

    public Integer getAutomaticWeigh() {
        return automaticWeigh;
    }

    public void setAutomaticWeigh(Integer automaticWeigh) {
        this.automaticWeigh = automaticWeigh;
    }

    public BigDecimal getInitNum() {
        return initNum;
    }

    public void setInitNum(BigDecimal initNum) {
        this.initNum = initNum;
    }

    public BigDecimal getTenderNum() {
        return tenderNum;
    }

    public void setTenderNum(BigDecimal tenderNum) {
        this.tenderNum = tenderNum;
    }

    public BigDecimal getSourcePrice() {
        return sourcePrice;
    }

    public void setSourcePrice(BigDecimal sourcePrice) {
        this.sourcePrice = sourcePrice;
    }

    public BigDecimal getSourceTaxPrice() {
        return sourceTaxPrice;
    }

    public void setSourceTaxPrice(BigDecimal sourceTaxPrice) {
        this.sourceTaxPrice = sourceTaxPrice;
    }

    public BigDecimal getSignNum() {
        return signNum;
    }

    public void setSignNum(BigDecimal signNum) {
        this.signNum = signNum;
    }

    public String getHistoryPriceArea() {
        return historyPriceArea;
    }

    public void setHistoryPriceArea(String historyPriceArea) {
        this.historyPriceArea = historyPriceArea;
    }

    public String getHistoryTaxPriceArea() {
        return historyTaxPriceArea;
    }

    public void setHistoryTaxPriceArea(String historyTaxPriceArea) {
        this.historyTaxPriceArea = historyTaxPriceArea;
    }

    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    /**
     * 合同Id
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同Id
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 物料Id
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 物料Id
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 物资分类名称
     */
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 物资分类名称
     */
    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 物资分类Id
     */
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    /**
     * 物资分类Id
     */
    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 物资编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 物资编码
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 规则/型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规则/型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 计量单位
     */
    public String getUnitName() {
        return unitName;
    }

    /**
     * 计量单位
     */
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    /**
     * 品牌
     */
    public String getBrand() {
        return brand;
    }

    /**
     * 品牌
     */
    public void setBrand(String brand) {
        this.brand = brand;
    }
    /**
     * 产地
     */
    public String getPlace() {
        return place;
    }

    /**
     * 产地
     */
    public void setPlace(String place) {
        this.place = place;
    }
    /**
     * 数量
     */
    public BigDecimal getNum() {
        return num;
    }

    /**
     * 数量
     */
    public void setNum(BigDecimal num) {
        this.num = num;
    }
    /**
     * 单价(无税)
     */
    public BigDecimal getPrice() {
        return price;
    }

    /**
     * 单价(无税)
     */
    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    /**
     * 金额(无税)
     */
    public BigDecimal getMoney() {
        return money;
    }

    /**
     * 金额(无税)
     */
    public void setMoney(BigDecimal money) {
        this.money = money;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 税率
     */
    public BigDecimal getDetailTaxRate() {
        return detailTaxRate;
    }

    /**
     * 税率
     */
    public void setDetailTaxRate(BigDecimal detailTaxRate) {
        this.detailTaxRate = detailTaxRate;
    }
    /**
     * 税额
     */
    public BigDecimal getDetailTax() {
        return detailTax;
    }

    /**
     * 税额
     */
    public void setDetailTax(BigDecimal detailTax) {
        this.detailTax = detailTax;
    }
    /**
     * 金额(含税)
     */
    public BigDecimal getDetailTaxMny() {
        return detailTaxMny;
    }

    /**
     * 金额(含税)
     */
    public void setDetailTaxMny(BigDecimal detailTaxMny) {
        this.detailTaxMny = detailTaxMny;
    }
    /**
     * 单价(含税)
     */
    public BigDecimal getDetailTaxPrice() {
        return detailTaxPrice;
    }

    /**
     * 单价(含税)
     */
    public void setDetailTaxPrice(BigDecimal detailTaxPrice) {
        this.detailTaxPrice = detailTaxPrice;
    }
    /**
     * 来源数据Id
     */
    public String getSourceId() {
        return sourceId;
    }

    /**
     * 来源数据Id
     */
    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 物资来源类型：1-物料档案，2-计划，3-定标结果带入
     */
    public String getSourceType() {
        return sourceType;
    }

    /**
     * 物资来源类型：1-物料档案，2-计划，3-定标结果带入
     */
    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }
    /**
     * 变更主键
     */
    public Long getChangeId() {
        return changeId;
    }

    /**
     * 变更主键
     */
    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    /**
     * 变更子表主键
     */
    public Long getChangeBid() {
        return changeBid;
    }

    /**
     * 变更子表主键
     */
    public void setChangeBid(Long changeBid) {
        this.changeBid = changeBid;
    }
    /**
     * 变更类型
     */
    public String getChangeType() {
        return changeType;
    }

    /**
     * 变更类型
     */
    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }
    /**
     * 是否来源补充协议(1:是，0：否)
     */
    public Integer getSrcSupplementFlag() {
        return srcSupplementFlag;
    }

    /**
     * 是否来源补充协议(1:是，0：否)
     */
    public void setSrcSupplementFlag(Integer srcSupplementFlag) {
        this.srcSupplementFlag = srcSupplementFlag;
    }
    /**
     * 来源补充协议主表ID
     */
    public Long getSrcSupplementId() {
        return srcSupplementId;
    }

    /**
     * 来源补充协议主表ID
     */
    public void setSrcSupplementId(Long srcSupplementId) {
        this.srcSupplementId = srcSupplementId;
    }
    /**
     * 来源补充协议明细ID
     */
    public Long getSrcSupplementDetailId() {
        return srcSupplementDetailId;
    }

    /**
     * 来源补充协议明细ID
     */
    public void setSrcSupplementDetailId(Long srcSupplementDetailId) {
        this.srcSupplementDetailId = srcSupplementDetailId;
    }
    
}
