package com.ejianc.business.promaterial.contract.vo;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.ejianc.business.promaterial.contract.vo.ContractRecordDetailVO;
import com.ejianc.business.promaterial.contract.vo.ContractRecordFeeVO;
import com.ejianc.business.promaterial.contract.vo.ContractRecordStageVO;
import com.ejianc.business.promaterial.contract.vo.ContractRecordClauseVO;

/**
 * 记录-合同实体
 *
 * @author generator
 *
 */
@ApiModel("记录-合同实体")
public class ContractRecordVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("合同ID")
    private Long contractId;
    @ApiModelProperty("采购类型 1-自采，2-集采")
    private String purchaseType;
    @ApiModelProperty("集采/自采")
    private String purchaseTypeName;
    @ApiModelProperty("项目Id")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("项目地点")
    private String projectPlace;
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("合同名称")
    private String contractName;
    @ApiModelProperty("甲方Id")
    private Long customerId;
    @ApiModelProperty("甲方名称")
    private String customerName;
    @ApiModelProperty("乙方Id")
    private Long supplierId;
    @ApiModelProperty("乙方名称")
    private String supplierName;
    @ApiModelProperty("签订日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate;
    @ApiModelProperty("签约地点")
    private String signPlace;
    @ApiModelProperty("合同履约状态：1、未签订；2、履约中；3、已封账；4、已解除；   默认为未签定，签章状态为已签章时，状态自动更改为【履约中】。当合同存在生效的最终结算时，状态自动改为【已封账】")
    private String performanceStatus;
    @ApiModelProperty("经办人")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    private String employeeName;
    @ApiModelProperty("合同税率")
    private BigDecimal taxRate;
    @ApiModelProperty("合同支付比例")
    private BigDecimal payScale;
    @ApiModelProperty("甲方经办人Id")
    private Long customerEmployeeId;
    @ApiModelProperty("甲方经办人名称")
    private String customerEmployeeName;
    @ApiModelProperty("甲方经办人电话")
    private String customerEmployeeMobile;
    @ApiModelProperty("乙方经办人名称")
    private String supplierEmployeeName;
    @ApiModelProperty("乙方经办人电话")
    private String supplierEmployeeMobile;
    @ApiModelProperty("计价方式：1-固定单价、2-浮动单价、3-固定总价")
    private String pricingType;
    @ApiModelProperty("合同金额")
    private BigDecimal contractTaxMny;
    @ApiModelProperty("合同金额（无税）")
    private BigDecimal contractMny;
    @ApiModelProperty("合同税额")
    private BigDecimal contractTax;
    @ApiModelProperty("清单金额")
    private BigDecimal detailTaxMny;
    @ApiModelProperty("清单金额（无税）")
    private BigDecimal detailMny;
    @ApiModelProperty("清单税额")
    private BigDecimal detailTax;
    @ApiModelProperty("其他费用金额")
    private BigDecimal freeTaxMny;
    @ApiModelProperty("其他费用金额（无税）")
    private BigDecimal freeMny;
    @ApiModelProperty("其他费用税额")
    private BigDecimal freeTax;
    @ApiModelProperty("单据状态")
    private Integer billState;
    @ApiModelProperty("提交日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date commitDate;
    @ApiModelProperty("提交人名称")
    private String commitUserName;
    @ApiModelProperty("提交人账号")
    private String commitUserCode;
    @ApiModelProperty("生效日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date effectiveDate;
    @ApiModelProperty("项目部Id")
    private Long orgId;
    @ApiModelProperty("项目部名称")
    private String orgName;
    @ApiModelProperty("项目部上级组织Id")
    private Long parentOrgId;
    @ApiModelProperty("项目部上级组织名称")
    private String parentOrgName;
    @ApiModelProperty("项目部上级组织编码")
    private String parentOrgCode;
    @ApiModelProperty("初始版本金额")
    private BigDecimal baseMoney;
    @ApiModelProperty("初始版本(含税)金额")
    private BigDecimal baseMoneyWithTax;
    @ApiModelProperty("变更前金额")
    private BigDecimal beforeChangeMny;
    @ApiModelProperty("变更前金额（含税）")
    private BigDecimal beforeChangeMnyWithTax;
    @ApiModelProperty("变更中金额")
    private BigDecimal changingMny;
    @ApiModelProperty("变更中金额（含税）")
    private BigDecimal changingMnyWithTax;
    @ApiModelProperty("变更单号")
    private String changeCode;
    @ApiModelProperty("变更版本")
    private Integer changeVersion;
    @ApiModelProperty("变更主键")
    private Long changeId;
    @ApiModelProperty("变更状态(1-未变更 2-变更中 3-已变更)")
    private Integer changeStatus;
    @ApiModelProperty("是否补充协议(1:是，0：否)")
    private Integer supplementFlag;
    @ApiModelProperty("主合同Id")
    private Long mainContractId;
    @ApiModelProperty("主合同编码")
    private String mainContractCode;
    @ApiModelProperty("主合同名称")
    private String mainContractName;
    @ApiModelProperty("补充项描述")
    private String supplementDescribe;
    @ApiModelProperty("主合同创建日期(用于合同、补充协议排序)")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date mainContractCreateDate;
    @ApiModelProperty("变更日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date changeDate;
    @ApiModelProperty("变更合同名称")
    private String changeContractName;
    @ApiModelProperty("累计预付款金额")
    private BigDecimal totalPrepayMny;
    @ApiModelProperty("累计付款金额")
    private BigDecimal totalPayMny;
    @ApiModelProperty("累计冲抵金额")
    private BigDecimal totalOffsetMny;
    @ApiModelProperty("累计结算金额(不含税)")
    private BigDecimal totalSettlementMny;
    @ApiModelProperty("累计结算金额")
    private BigDecimal totalSettlementTaxMny;
    @ApiModelProperty("累计收票金额(不含税)")
    private BigDecimal totalInvoiceMny;
    @ApiModelProperty("累计收票金额")
    private BigDecimal totalInvoiceTaxMny;
    @ApiModelProperty("备注")
    private String memo;

    @ApiModelProperty("合同类型（0-物资采购合同，1-混凝土合同）")
    private Integer contractType; // 合同类型（0-物资采购合同，1-混凝土合同）

    /**
     * 发票类型Id
     */
    private Long invoiceTypeId;

    /**
     * 发票类型名称
     */
    private String invoiceTypeName;

    private String orgCode; // 项目部编码
    private String purchaseId; // 供货内容id
    private String purchaseName; // 供货内容名称


    @ApiModelProperty("记录-合同明细实体")
    @SubEntity
    private List<ContractRecordDetailVO> contractDetailList = new ArrayList<>();
    @ApiModelProperty("记录-合同其他费用实体")
    private List<ContractRecordFeeVO> contractFeeList = new ArrayList<>();
    @ApiModelProperty("记录-合同付款阶段实体")
    private List<ContractRecordStageVO> contractStageList = new ArrayList<>();
    @ApiModelProperty("记录-合同条款实体")
    private List<ContractRecordClauseVO> contractClauseList = new ArrayList<>();
    // CDGW-add
    private Long frameContractId; // 框架协议主键ID
    private String frameContractCode; // 框架协议编码
    private String frameContractName; // 框架协议名称
    private Long frameCustomerId; // 框架协议甲方Id
    private String frameCustomerName; // 框架协议甲方名称
    private Long frameSupplierId; // 框架协议乙方Id
    private String frameSupplierName; // 框架协议乙方名称

    private Integer frameFlag; // 是否框架协议(1:是，0：否)
    private String agreementYear; // 协议年度
    private String servicePeriod; // 服务期限
    private Long cSupplierId; // 丙方Id
    private String cSupplierName; // 丙方名称
    private String cSupplierEmployeeName; // 丙方经办人名称
    private String cSupplierEmployeeMobile; // 丙方经办人电话
    private BigDecimal contractBidTaxMny; // 合同中标金额
    private BigDecimal contractCtrlTaxMny; // 合同控制金额


    public BigDecimal getContractBidTaxMny() {
        return contractBidTaxMny;
    }

    public void setContractBidTaxMny(BigDecimal contractBidTaxMny) {
        this.contractBidTaxMny = contractBidTaxMny;
    }

    public BigDecimal getContractCtrlTaxMny() {
        return contractCtrlTaxMny;
    }

    public void setContractCtrlTaxMny(BigDecimal contractCtrlTaxMny) {
        this.contractCtrlTaxMny = contractCtrlTaxMny;
    }
    public Integer getFrameFlag() {
        return frameFlag;
    }

    public void setFrameFlag(Integer frameFlag) {
        this.frameFlag = frameFlag;
    }

    public String getAgreementYear() {
        return agreementYear;
    }

    public void setAgreementYear(String agreementYear) {
        this.agreementYear = agreementYear;
    }

    public String getServicePeriod() {
        return servicePeriod;
    }

    public void setServicePeriod(String servicePeriod) {
        this.servicePeriod = servicePeriod;
    }

    @ReferSerialTransfer(referCode="support-supplier")
    public Long getcSupplierId() {
        return cSupplierId;
    }
    @ReferDeserialTransfer
    public void setcSupplierId(Long cSupplierId) {
        this.cSupplierId = cSupplierId;
    }

    public String getcSupplierName() {
        return cSupplierName;
    }

    public void setcSupplierName(String cSupplierName) {
        this.cSupplierName = cSupplierName;
    }

    public String getcSupplierEmployeeName() {
        return cSupplierEmployeeName;
    }

    public void setcSupplierEmployeeName(String cSupplierEmployeeName) {
        this.cSupplierEmployeeName = cSupplierEmployeeName;
    }

    public String getcSupplierEmployeeMobile() {
        return cSupplierEmployeeMobile;
    }

    public void setcSupplierEmployeeMobile(String cSupplierEmployeeMobile) {
        this.cSupplierEmployeeMobile = cSupplierEmployeeMobile;
    }


    public Long getFrameContractId() {
        return frameContractId;
    }

    public void setFrameContractId(Long frameContractId) {
        this.frameContractId = frameContractId;
    }

    public String getFrameContractCode() {
        return frameContractCode;
    }

    public void setFrameContractCode(String frameContractCode) {
        this.frameContractCode = frameContractCode;
    }

    public String getFrameContractName() {
        return frameContractName;
    }

    public void setFrameContractName(String frameContractName) {
        this.frameContractName = frameContractName;
    }

    public Long getFrameCustomerId() {
        return frameCustomerId;
    }

    public void setFrameCustomerId(Long frameCustomerId) {
        this.frameCustomerId = frameCustomerId;
    }

    public String getFrameCustomerName() {
        return frameCustomerName;
    }

    public void setFrameCustomerName(String frameCustomerName) {
        this.frameCustomerName = frameCustomerName;
    }

    public Long getFrameSupplierId() {
        return frameSupplierId;
    }

    public void setFrameSupplierId(Long frameSupplierId) {
        this.frameSupplierId = frameSupplierId;
    }

    public String getFrameSupplierName() {
        return frameSupplierName;
    }

    public void setFrameSupplierName(String frameSupplierName) {
        this.frameSupplierName = frameSupplierName;
    }
    public String getPurchaseId() {
        return purchaseId;
    }

    public void setPurchaseId(String purchaseId) {
        this.purchaseId = purchaseId;
    }

    public String getPurchaseName() {
        return purchaseName;
    }

    public void setPurchaseName(String purchaseName) {
        this.purchaseName = purchaseName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }

    public Long getInvoiceTypeId() {
        return invoiceTypeId;
    }
    @ReferDeserialTransfer
    public void setInvoiceTypeId(Long invoiceTypeId) {
        this.invoiceTypeId = invoiceTypeId;
    }

    public String getInvoiceTypeName() {
        return invoiceTypeName;
    }

    public void setInvoiceTypeName(String invoiceTypeName) {
        this.invoiceTypeName = invoiceTypeName;
    }

    /**
     * 合同ID
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同ID
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 采购类型 1-自采，2-集采
     */
    public String getPurchaseType() {
        return purchaseType;
    }

    /**
     * 采购类型 1-自采，2-集采
     */
    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }
    /**
     * 集采/自采
     */
    public String getPurchaseTypeName() {
        return purchaseTypeName;
    }

    /**
     * 集采/自采
     */
    public void setPurchaseTypeName(String purchaseTypeName) {
        this.purchaseTypeName = purchaseTypeName;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目地点
     */
    public String getProjectPlace() {
        return projectPlace;
    }

    /**
     * 项目地点
     */
    public void setProjectPlace(String projectPlace) {
        this.projectPlace = projectPlace;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 甲方Id
     */
    @ReferSerialTransfer(referCode="support-customer")
    public Long getCustomerId() {
        return customerId;
    }

    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    /**
     * 甲方名称
     */
    public String getCustomerName() {
        return customerName;
    }

    /**
     * 甲方名称
     */
    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    /**
     * 乙方Id
     */
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 乙方名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 乙方名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 签订日期
     */
    public Date getSignDate() {
        return signDate;
    }

    /**
     * 签订日期
     */
    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    /**
     * 签约地点
     */
    public String getSignPlace() {
        return signPlace;
    }

    /**
     * 签约地点
     */
    public void setSignPlace(String signPlace) {
        this.signPlace = signPlace;
    }
    /**
     * 合同履约状态：1、未签订；2、履约中；3、已封账；4、已解除；   默认为未签定，签章状态为已签章时，状态自动更改为【履约中】。当合同存在生效的最终结算时，状态自动改为【已封账】
     */
    public String getPerformanceStatus() {
        return performanceStatus;
    }

    /**
     * 合同履约状态：1、未签订；2、履约中；3、已封账；4、已解除；   默认为未签定，签章状态为已签章时，状态自动更改为【履约中】。当合同存在生效的最终结算时，状态自动改为【已封账】
     */
    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 合同税率
     */
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 合同税率
     */
    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 合同支付比例
     */
    public BigDecimal getPayScale() {
        return payScale;
    }

    /**
     * 合同支付比例
     */
    public void setPayScale(BigDecimal payScale) {
        this.payScale = payScale;
    }
    /**
     * 甲方经办人Id
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getCustomerEmployeeId() {
        return customerEmployeeId;
    }

    /**
     * 甲方经办人Id
     */
    @ReferDeserialTransfer
    public void setCustomerEmployeeId(Long customerEmployeeId) {
        this.customerEmployeeId = customerEmployeeId;
    }
    /**
     * 甲方经办人名称
     */
    public String getCustomerEmployeeName() {
        return customerEmployeeName;
    }

    /**
     * 甲方经办人名称
     */
    public void setCustomerEmployeeName(String customerEmployeeName) {
        this.customerEmployeeName = customerEmployeeName;
    }
    /**
     * 甲方经办人电话
     */
    public String getCustomerEmployeeMobile() {
        return customerEmployeeMobile;
    }

    /**
     * 甲方经办人电话
     */
    public void setCustomerEmployeeMobile(String customerEmployeeMobile) {
        this.customerEmployeeMobile = customerEmployeeMobile;
    }
    /**
     * 乙方经办人名称
     */
    public String getSupplierEmployeeName() {
        return supplierEmployeeName;
    }

    /**
     * 乙方经办人名称
     */
    public void setSupplierEmployeeName(String supplierEmployeeName) {
        this.supplierEmployeeName = supplierEmployeeName;
    }
    /**
     * 乙方经办人电话
     */
    public String getSupplierEmployeeMobile() {
        return supplierEmployeeMobile;
    }

    /**
     * 乙方经办人电话
     */
    public void setSupplierEmployeeMobile(String supplierEmployeeMobile) {
        this.supplierEmployeeMobile = supplierEmployeeMobile;
    }
    /**
     * 计价方式：1-固定单价、2-浮动单价、3-固定总价
     */
    public String getPricingType() {
        return pricingType;
    }

    /**
     * 计价方式：1-固定单价、2-浮动单价、3-固定总价
     */
    public void setPricingType(String pricingType) {
        this.pricingType = pricingType;
    }
    /**
     * 合同金额
     */
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    /**
     * 合同金额
     */
    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    /**
     * 合同金额（无税）
     */
    public BigDecimal getContractMny() {
        return contractMny;
    }

    /**
     * 合同金额（无税）
     */
    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    /**
     * 合同税额
     */
    public BigDecimal getContractTax() {
        return contractTax;
    }

    /**
     * 合同税额
     */
    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }
    /**
     * 清单金额
     */
    public BigDecimal getDetailTaxMny() {
        return detailTaxMny;
    }

    /**
     * 清单金额
     */
    public void setDetailTaxMny(BigDecimal detailTaxMny) {
        this.detailTaxMny = detailTaxMny;
    }
    /**
     * 清单金额（无税）
     */
    public BigDecimal getDetailMny() {
        return detailMny;
    }

    /**
     * 清单金额（无税）
     */
    public void setDetailMny(BigDecimal detailMny) {
        this.detailMny = detailMny;
    }
    /**
     * 清单税额
     */
    public BigDecimal getDetailTax() {
        return detailTax;
    }

    /**
     * 清单税额
     */
    public void setDetailTax(BigDecimal detailTax) {
        this.detailTax = detailTax;
    }
    /**
     * 其他费用金额
     */
    public BigDecimal getFreeTaxMny() {
        return freeTaxMny;
    }

    /**
     * 其他费用金额
     */
    public void setFreeTaxMny(BigDecimal freeTaxMny) {
        this.freeTaxMny = freeTaxMny;
    }
    /**
     * 其他费用金额（无税）
     */
    public BigDecimal getFreeMny() {
        return freeMny;
    }

    /**
     * 其他费用金额（无税）
     */
    public void setFreeMny(BigDecimal freeMny) {
        this.freeMny = freeMny;
    }
    /**
     * 其他费用税额
     */
    public BigDecimal getFreeTax() {
        return freeTax;
    }

    /**
     * 其他费用税额
     */
    public void setFreeTax(BigDecimal freeTax) {
        this.freeTax = freeTax;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 提交日期
     */
    public Date getCommitDate() {
        return commitDate;
    }

    /**
     * 提交日期
     */
    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    /**
     * 提交人名称
     */
    public String getCommitUserName() {
        return commitUserName;
    }

    /**
     * 提交人名称
     */
    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    /**
     * 提交人账号
     */
    public String getCommitUserCode() {
        return commitUserCode;
    }

    /**
     * 提交人账号
     */
    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    /**
     * 生效日期
     */
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    /**
     * 生效日期
     */
    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    /**
     * 项目部Id
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 项目部名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 项目部名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部上级组织Id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部上级组织Id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目部上级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 项目部上级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 项目部上级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 项目部上级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 初始版本金额
     */
    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    /**
     * 初始版本金额
     */
    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }
    /**
     * 初始版本(含税)金额
     */
    public BigDecimal getBaseMoneyWithTax() {
        return baseMoneyWithTax;
    }

    /**
     * 初始版本(含税)金额
     */
    public void setBaseMoneyWithTax(BigDecimal baseMoneyWithTax) {
        this.baseMoneyWithTax = baseMoneyWithTax;
    }
    /**
     * 变更前金额
     */
    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    /**
     * 变更前金额
     */
    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }
    /**
     * 变更前金额（含税）
     */
    public BigDecimal getBeforeChangeMnyWithTax() {
        return beforeChangeMnyWithTax;
    }

    /**
     * 变更前金额（含税）
     */
    public void setBeforeChangeMnyWithTax(BigDecimal beforeChangeMnyWithTax) {
        this.beforeChangeMnyWithTax = beforeChangeMnyWithTax;
    }
    /**
     * 变更中金额
     */
    public BigDecimal getChangingMny() {
        return changingMny;
    }

    /**
     * 变更中金额
     */
    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }
    /**
     * 变更中金额（含税）
     */
    public BigDecimal getChangingMnyWithTax() {
        return changingMnyWithTax;
    }

    /**
     * 变更中金额（含税）
     */
    public void setChangingMnyWithTax(BigDecimal changingMnyWithTax) {
        this.changingMnyWithTax = changingMnyWithTax;
    }
    /**
     * 变更单号
     */
    public String getChangeCode() {
        return changeCode;
    }

    /**
     * 变更单号
     */
    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    /**
     * 变更版本
     */
    public Integer getChangeVersion() {
        return changeVersion;
    }

    /**
     * 变更版本
     */
    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    /**
     * 变更主键
     */
    public Long getChangeId() {
        return changeId;
    }

    /**
     * 变更主键
     */
    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    public Integer getChangeStatus() {
        return changeStatus;
    }

    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    /**
     * 是否补充协议(1:是，0：否)
     */
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    /**
     * 是否补充协议(1:是，0：否)
     */
    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    /**
     * 主合同Id
     */
    public Long getMainContractId() {
        return mainContractId;
    }

    /**
     * 主合同Id
     */
    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }
    /**
     * 主合同编码
     */
    public String getMainContractCode() {
        return mainContractCode;
    }

    /**
     * 主合同编码
     */
    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }
    /**
     * 主合同名称
     */
    public String getMainContractName() {
        return mainContractName;
    }

    /**
     * 主合同名称
     */
    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }
    /**
     * 补充项描述
     */
    public String getSupplementDescribe() {
        return supplementDescribe;
    }

    /**
     * 补充项描述
     */
    public void setSupplementDescribe(String supplementDescribe) {
        this.supplementDescribe = supplementDescribe;
    }
    /**
     * 主合同创建日期(用于合同、补充协议排序)
     */
    public Date getMainContractCreateDate() {
        return mainContractCreateDate;
    }

    /**
     * 主合同创建日期(用于合同、补充协议排序)
     */
    public void setMainContractCreateDate(Date mainContractCreateDate) {
        this.mainContractCreateDate = mainContractCreateDate;
    }
    /**
     * 变更日期
     */
    public Date getChangeDate() {
        return changeDate;
    }

    /**
     * 变更日期
     */
    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }
    /**
     * 变更合同名称
     */
    public String getChangeContractName() {
        return changeContractName;
    }

    /**
     * 变更合同名称
     */
    public void setChangeContractName(String changeContractName) {
        this.changeContractName = changeContractName;
    }
    /**
     * 累计预付款金额
     */
    public BigDecimal getTotalPrepayMny() {
        return totalPrepayMny;
    }

    /**
     * 累计预付款金额
     */
    public void setTotalPrepayMny(BigDecimal totalPrepayMny) {
        this.totalPrepayMny = totalPrepayMny;
    }
    /**
     * 累计付款金额
     */
    public BigDecimal getTotalPayMny() {
        return totalPayMny;
    }

    /**
     * 累计付款金额
     */
    public void setTotalPayMny(BigDecimal totalPayMny) {
        this.totalPayMny = totalPayMny;
    }
    /**
     * 累计冲抵金额
     */
    public BigDecimal getTotalOffsetMny() {
        return totalOffsetMny;
    }

    /**
     * 累计冲抵金额
     */
    public void setTotalOffsetMny(BigDecimal totalOffsetMny) {
        this.totalOffsetMny = totalOffsetMny;
    }
    /**
     * 累计结算金额(不含税)
     */
    public BigDecimal getTotalSettlementMny() {
        return totalSettlementMny;
    }

    /**
     * 累计结算金额(不含税)
     */
    public void setTotalSettlementMny(BigDecimal totalSettlementMny) {
        this.totalSettlementMny = totalSettlementMny;
    }
    /**
     * 累计结算金额
     */
    public BigDecimal getTotalSettlementTaxMny() {
        return totalSettlementTaxMny;
    }

    /**
     * 累计结算金额
     */
    public void setTotalSettlementTaxMny(BigDecimal totalSettlementTaxMny) {
        this.totalSettlementTaxMny = totalSettlementTaxMny;
    }
    /**
     * 累计收票金额(不含税)
     */
    public BigDecimal getTotalInvoiceMny() {
        return totalInvoiceMny;
    }

    /**
     * 累计收票金额(不含税)
     */
    public void setTotalInvoiceMny(BigDecimal totalInvoiceMny) {
        this.totalInvoiceMny = totalInvoiceMny;
    }
    /**
     * 累计收票金额
     */
    public BigDecimal getTotalInvoiceTaxMny() {
        return totalInvoiceTaxMny;
    }

    /**
     * 累计收票金额
     */
    public void setTotalInvoiceTaxMny(BigDecimal totalInvoiceTaxMny) {
        this.totalInvoiceTaxMny = totalInvoiceTaxMny;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

    public List<ContractRecordDetailVO> getContractDetailList() {
        return contractDetailList;
    }

    public void setContractDetailList(List<ContractRecordDetailVO> contractDetailList) {
        this.contractDetailList = contractDetailList;
    }

    public List<ContractRecordFeeVO> getContractFeeList() {
        return contractFeeList;
    }

    public void setContractFeeList(List<ContractRecordFeeVO> contractFeeList) {
        this.contractFeeList = contractFeeList;
    }

    public List<ContractRecordStageVO> getContractStageList() {
        return contractStageList;
    }

    public void setContractStageList(List<ContractRecordStageVO> contractStageList) {
        this.contractStageList = contractStageList;
    }

    public List<ContractRecordClauseVO> getContractClauseList() {
        return contractClauseList;
    }

    public void setContractClauseList(List<ContractRecordClauseVO> contractClauseList) {
        this.contractClauseList = contractClauseList;
    }
}
