package com.ejianc.business.promaterial.settlement.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.tools.refer.annotation.ReferJsonField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 结算单明细表
 * 
 * @author generator
 * 
 */
@ApiModel("结算单明细表")
public class SettlementDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("结算主键ID")
    private Long settlementId;
    @ApiModelProperty("来源主键ID")
    private Long sourceId;
    @ApiModelProperty("来源明细主键ID")
    private Long sourceDetailId;
    @ApiModelProperty("对账主键ID")
    private Long reconciliationId;
    @ApiModelProperty("对账明细主键ID")
    private Long reconciliationDetailId;
    @ApiModelProperty("来源类型名称(对账—100231)")
    private String sourceName;
    @ApiModelProperty("来源类型（0-对账，1-验收，2-退货）")
    private Integer sourceType;
    @ApiModelProperty("来源编码")
    private String sourceCode;
    @ApiModelProperty("物资类别")
    private Long materialTypeId;
    @ApiModelProperty("物资类别名称")
    private String materialTypeName;
    @ApiModelProperty("材料分类编码")
    private String materialTypeCode;
    @ApiModelProperty("物资主键")
    private Long materialId;
    @ApiModelProperty("物资名称")
    private String materialName;
    @ApiModelProperty("物资编码")
    private String materialCode;
    @ApiModelProperty("结算数量")
    private BigDecimal num;
    @ApiModelProperty("结算单价(无税)")
    private BigDecimal price;
    @ApiModelProperty("结算单价)")
    private BigDecimal taxPrice;
    @ApiModelProperty("结算金额(无税)")
    private BigDecimal mny;
    @ApiModelProperty("结算金额")
    private BigDecimal taxMny;
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    @ApiModelProperty("税额")
    private BigDecimal tax;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("对账数量")
    private BigDecimal reconciliationNum; // 对账数量
    @ApiModelProperty("历史价格区间（无税）")
    private String historyPriceArea;
    @ApiModelProperty("历史价格区间（含税）")
    private String historyTaxPriceArea;
    private Integer contractFlag; // 是否有合同(1:是，2：否)
    private String guidePriceArea; // 公司指导价区间（无税）
    private String guideTaxPriceArea; // 公司指导价区间（含税）

    private String spec; // 规则/型号
    private Long unitId; // 计量单位主键
    private String unitName; // 计量单位
    private String brand; // 品牌
    private String place; // 产地
    private String specif; // 项目特征
    private Long treeId; // 树id

    public Long getTreeId() {
        return treeId;
    }

    public void setTreeId(Long treeId) {
        this.treeId = treeId;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getPlace() {
        return place;
    }

    public void setPlace(String place) {
        this.place = place;
    }

    public String getSpecif() {
        return specif;
    }

    public void setSpecif(String specif) {
        this.specif = specif;
    }

    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }

    public String getGuidePriceArea() {
        return guidePriceArea;
    }

    public void setGuidePriceArea(String guidePriceArea) {
        this.guidePriceArea = guidePriceArea;
    }

    public String getGuideTaxPriceArea() {
        return guideTaxPriceArea;
    }

    public void setGuideTaxPriceArea(String guideTaxPriceArea) {
        this.guideTaxPriceArea = guideTaxPriceArea;
    }
    public Integer getContractFlag() {
        return contractFlag;
    }

    public void setContractFlag(Integer contractFlag) {
        this.contractFlag = contractFlag;
    }


    public String getHistoryPriceArea() {
        return historyPriceArea;
    }

    public void setHistoryPriceArea(String historyPriceArea) {
        this.historyPriceArea = historyPriceArea;
    }

    public String getHistoryTaxPriceArea() {
        return historyTaxPriceArea;
    }

    public void setHistoryTaxPriceArea(String historyTaxPriceArea) {
        this.historyTaxPriceArea = historyTaxPriceArea;
    }

    public BigDecimal getReconciliationNum() {
        return reconciliationNum;
    }

    public void setReconciliationNum(BigDecimal reconciliationNum) {
        this.reconciliationNum = reconciliationNum;
    }

    /**
     * 结算主键ID
     */
    public Long getSettlementId() {
        return settlementId;
    }

    /**
     * 结算主键ID
     */
    public void setSettlementId(Long settlementId) {
        this.settlementId = settlementId;
    }
    /**
     * 来源主键ID
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源主键ID
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 来源明细主键ID
     */
    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    /**
     * 来源明细主键ID
     */
    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }
    /**
     * 对账主键ID
     */
    public Long getReconciliationId() {
        return reconciliationId;
    }

    /**
     * 对账主键ID
     */
    public void setReconciliationId(Long reconciliationId) {
        this.reconciliationId = reconciliationId;
    }
    /**
     * 对账明细主键ID
     */
    public Long getReconciliationDetailId() {
        return reconciliationDetailId;
    }

    /**
     * 对账明细主键ID
     */
    public void setReconciliationDetailId(Long reconciliationDetailId) {
        this.reconciliationDetailId = reconciliationDetailId;
    }
    /**
     * 来源类型名称(对账—100231)
     */
    public String getSourceName() {
        return sourceName;
    }

    /**
     * 来源类型名称(对账—100231)
     */
    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }
    /**
     * 来源类型（0-对账，1-验收，2-退货）
     */
    public Integer getSourceType() {
        return sourceType;
    }

    /**
     * 来源类型（0-对账，1-入库）
     */
    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }
    /**
     * 来源编码
     */
    public String getSourceCode() {
        return sourceCode;
    }

    /**
     * 来源编码
     */
    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }
    /**
     * 物资类别
     */
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    /**
     * 物资类别
     */
    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    /**
     * 物资类别名称
     */
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 物资类别名称
     */
    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 物资主键
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 物资主键
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 物资编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 物资编码
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 单位id
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 单位id
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 结算数量
     */
    public BigDecimal getNum() {
        return num;
    }

    /**
     * 结算数量
     */
    public void setNum(BigDecimal num) {
        this.num = num;
    }
    /**
     * 结算单价(无税)
     */
    public BigDecimal getPrice() {
        return price;
    }

    /**
     * 结算单价(无税)
     */
    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    /**
     * 结算单价)
     */
    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    /**
     * 结算单价)
     */
    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }
    /**
     * 结算金额(无税)
     */
    public BigDecimal getMny() {
        return mny;
    }

    /**
     * 结算金额(无税)
     */
    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    /**
     * 结算金额
     */
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 结算金额
     */
    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    /**
     * 税率
     */
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 税率
     */
    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 税额
     */
    public BigDecimal getTax() {
        return tax;
    }

    /**
     * 税额
     */
    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
