package com.ejianc.business.promaterial.check.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 不合格报告
 * 
 * @author generator
 * 
 */
public class UnqualifiedReportVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long commitId; // 提交人
    private String billCode; // 单据编号
    private Integer billState; // 单据状态（审批必须字段）
    private Long checkId; // 验收单Id
    private String checkCode; // 验收单编号
    private Long deliveryId; // 发货主键
    private String deliveryBillCode; // 发货单据编号
    private Long orderId; // 订单主键
    private String orderBillCode; // 订单单据编号
    private String orderName; // 订单名称
    private Long customerId; // 甲方Id（采购方）
    private String customerName; // 甲方名称（采购方）
    private Long supplierId; // 供应商id
    private String supplierName; // 供应商名称
    private Long projectId; // 项目
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private String orgCode; // 项目部编码
    private Long parentOrgId; // 上级组织
    private String parentOrgName; // 上级组织名称
    private String parentOrgCode; // 项目部上级组织编码
    private Long contractId; // 合同主键
    private String contractName; // 合同名称
    private String contractCode; // 合同编号
    private Long unqualifiedTypeId; // 不合格类型id
    private String unqualifiedTypeName; // 不合格类型名称
    private Long checkerId; // 验收人id
    private String checkerName; // 验收人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date checkDate; // 验收时间
    private BigDecimal checkTaxMny; // 验收金额
    private BigDecimal checkMny; // 验收金额（不含税）
    private String unqualifiedMemo; // 不合格情况描述
    private String disposeScheme; // 处置方案
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private String billStateName; // 单据状态名称

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Long getCommitId() {
        return commitId;
    }

    public void setCommitId(Long commitId) {
        this.commitId = commitId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode = "promaterial-check")
    public Long getCheckId() {
        return checkId;
    }
    @ReferDeserialTransfer
    public void setCheckId(Long checkId) {
        this.checkId = checkId;
    }
    public String getCheckCode() {
        return checkCode;
    }

    public void setCheckCode(String checkCode) {
        this.checkCode = checkCode;
    }
    public Long getDeliveryId() {
        return deliveryId;
    }

    public void setDeliveryId(Long deliveryId) {
        this.deliveryId = deliveryId;
    }
    public String getDeliveryBillCode() {
        return deliveryBillCode;
    }

    public void setDeliveryBillCode(String deliveryBillCode) {
        this.deliveryBillCode = deliveryBillCode;
    }
    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }
    public String getOrderBillCode() {
        return orderBillCode;
    }

    public void setOrderBillCode(String orderBillCode) {
        this.orderBillCode = orderBillCode;
    }
    public String getOrderName() {
        return orderName;
    }

    public void setOrderName(String orderName) {
        this.orderName = orderName;
    }
    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getUnqualifiedTypeId() {
        return unqualifiedTypeId;
    }
    @ReferDeserialTransfer
    public void setUnqualifiedTypeId(Long unqualifiedTypeId) {
        this.unqualifiedTypeId = unqualifiedTypeId;
    }
    public String getUnqualifiedTypeName() {
        return unqualifiedTypeName;
    }

    public void setUnqualifiedTypeName(String unqualifiedTypeName) {
        this.unqualifiedTypeName = unqualifiedTypeName;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getCheckerId() {
        return checkerId;
    }

    @ReferDeserialTransfer
    public void setCheckerId(Long checkerId) {
        this.checkerId = checkerId;
    }
    public String getCheckerName() {
        return checkerName;
    }

    public void setCheckerName(String checkerName) {
        this.checkerName = checkerName;
    }
    public Date getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }
    public BigDecimal getCheckTaxMny() {
        return checkTaxMny;
    }

    public void setCheckTaxMny(BigDecimal checkTaxMny) {
        this.checkTaxMny = checkTaxMny;
    }
    public BigDecimal getCheckMny() {
        return checkMny;
    }

    public void setCheckMny(BigDecimal checkMny) {
        this.checkMny = checkMny;
    }
    public String getUnqualifiedMemo() {
        return unqualifiedMemo;
    }

    public void setUnqualifiedMemo(String unqualifiedMemo) {
        this.unqualifiedMemo = unqualifiedMemo;
    }
    public String getDisposeScheme() {
        return disposeScheme;
    }

    public void setDisposeScheme(String disposeScheme) {
        this.disposeScheme = disposeScheme;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    
}
