package com.ejianc.business.promaterial.returnGoods.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.promaterial.returnGoods.vo.ReturnGoodsDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 退货单
 * 
 * @author generator
 * 
 */
public class ReturnGoodsVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态
    private String billCode; // 出库编号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date outDate; // 出库日期
    private Long projectId; // 出库项目id
    private String projectName; // 
    private String projectCode; // 所属项目编码
    private Long orgId; // 出库组织id
    private String orgName; // 
    private String orgCode; // 出库组织编码
    private Long parentOrgId; // 项目部上级组织Id
    private String parentOrgName; // 
    private String parentOrgCode; // 项目部上级组织编码
    private Long contractId; // 合同id
    private String contractName; // 
    private Long supplierId; // 供应商id
    private String supplierName; // 
    private BigDecimal returnMny; // 退货金额不含税
    private BigDecimal returnTaxMny; // 退货金额
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人
    private String materialNames; // 出库物资名称集合
    private String memo; // 备注
    private String returnReason; // 退货原因

    private Integer accountFlag; // 是否对账1是0否
    private Integer settleFlag; // 是否结算1是0否
    
    private List<ReturnGoodsDetailVO> returnGoodsDetailList = new ArrayList<>(); // 退货单明细

    public Integer getAccountFlag() {
        return accountFlag;
    }

    public void setAccountFlag(Integer accountFlag) {
        this.accountFlag = accountFlag;
    }

    public Integer getSettleFlag() {
        return settleFlag;
    }

    public void setSettleFlag(Integer settleFlag) {
        this.settleFlag = settleFlag;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Date getOutDate() {
        return outDate;
    }

    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }
    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    @ReferSerialTransfer(referCode = "contractMaterial")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public BigDecimal getReturnMny() {
        return returnMny;
    }

    public void setReturnMny(BigDecimal returnMny) {
        this.returnMny = returnMny;
    }
    public BigDecimal getReturnTaxMny() {
        return returnTaxMny;
    }

    public void setReturnTaxMny(BigDecimal returnTaxMny) {
        this.returnTaxMny = returnTaxMny;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getMaterialNames() {
        return materialNames;
    }

    public void setMaterialNames(String materialNames) {
        this.materialNames = materialNames;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getReturnReason() {
        return returnReason;
    }

    public void setReturnReason(String returnReason) {
        this.returnReason = returnReason;
    }
    
     public List<ReturnGoodsDetailVO> getReturnGoodsDetailList() {
        return returnGoodsDetailList;
     }

     public void setReturnGoodsDetailList(List<ReturnGoodsDetailVO> returnGoodsDetailList) {
        this.returnGoodsDetailList = returnGoodsDetailList;
     }
}
