package com.ejianc.business.promaterial.doc.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 废旧物资处置结果
 * 
 * @author generator
 * 
 */
public class WasteResultVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    private Long projectId; // 项目ID
    private String projectName; // 项目名称
    private String projectCode; // 项目编码
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 父组织ID
    private String parentOrgName; // 父组织名称
    private String parentOrgCode; // 父组织编码
    private Integer scrapType; // 废旧类型
    private String otherReason; // 其他原因
    private String mainMaterialName; // 主要物资名称
    private Long employeeId; // 经办人
    private String employeeName; // 经办人
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyTime; // 申请日期
    private Integer disposalType; // 处置方式
    private Integer disposalNumber; // 处置次数
    private Integer isNeedAssess; // 是否需要评估
    private Integer disposalPlatform; // 处置平台
    private Integer pricingType; // 定价方式
    private BigDecimal minLimitPrice; // 处置最低限价
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date disposalDate; // 处置日期
    private String superviseId; // 监督人
    private String superviseName; // 监督人
    private BigDecimal assessMny; // 评估价
    private BigDecimal actualMny; // 实际处置金额
    private String dealFlats; // 成交单位
    private String dealFlatsPeople; // 成交单位联系人
    private String dealFlatsPhone; // 联系方式
    private Integer contractFlag; // 是否签订合同
    private Integer invoiceFlag; // 是否开具发票
    private String invoiceNumber; // 发票号码
    private String financeNumber; // 财务收款凭证号
    
    private List<WasteResultDetailVO> wasteResultDetailList = new ArrayList<>(); // 废旧物资处置结果-详情
    private Long applicationId; // 申请单
    private String applicationName; // 申请单
    @ReferSerialTransfer(referCode = "scrap-material-application")
    public Long getApplicationId() {
        return applicationId;
    }
    @ReferDeserialTransfer
    public void setApplicationId(Long applicationId) {
        this.applicationId = applicationId;
    }
    private String scrapTypeName; // 废旧类型名称

    public String getScrapTypeName() {
        String name="";
        switch (this.getScrapType()){
            case 0:
                name= "毁损无法使用材料";
                break;
            case 1:
                name= "拆除修理旧材料配件";
                break;
            case 2:
                name= "各类包装物品";
                break;
            case 3:
                name= "闲置无法调剂物资";
                break;
            case 4:
                name= "其他废旧物资";
                break;
        }
        return name;
    }

    public void setScrapTypeName(String scrapTypeName) {
        this.scrapTypeName = scrapTypeName;
    }
    public String getApplicationName() {
        return applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Integer getScrapType() {
        return scrapType;
    }

    public void setScrapType(Integer scrapType) {
        this.scrapType = scrapType;
    }
    public String getOtherReason() {
        return otherReason;
    }

    public void setOtherReason(String otherReason) {
        this.otherReason = otherReason;
    }
    public String getMainMaterialName() {
        return mainMaterialName;
    }

    public void setMainMaterialName(String mainMaterialName) {
        this.mainMaterialName = mainMaterialName;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }
    public Integer getDisposalType() {
        return disposalType;
    }

    public void setDisposalType(Integer disposalType) {
        this.disposalType = disposalType;
    }
    public Integer getDisposalNumber() {
        return disposalNumber;
    }

    public void setDisposalNumber(Integer disposalNumber) {
        this.disposalNumber = disposalNumber;
    }
    public Integer getIsNeedAssess() {
        return isNeedAssess;
    }

    public void setIsNeedAssess(Integer isNeedAssess) {
        this.isNeedAssess = isNeedAssess;
    }
    public Integer getDisposalPlatform() {
        return disposalPlatform;
    }

    public void setDisposalPlatform(Integer disposalPlatform) {
        this.disposalPlatform = disposalPlatform;
    }
    public Integer getPricingType() {
        return pricingType;
    }

    public void setPricingType(Integer pricingType) {
        this.pricingType = pricingType;
    }
    public BigDecimal getMinLimitPrice() {
        return minLimitPrice;
    }

    public void setMinLimitPrice(BigDecimal minLimitPrice) {
        this.minLimitPrice = minLimitPrice;
    }
    public Date getDisposalDate() {
        return disposalDate;
    }

    public void setDisposalDate(Date disposalDate) {
        this.disposalDate = disposalDate;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public String getSuperviseId() {
        return superviseId;
    }
    @ReferDeserialTransfer
    public void setSuperviseId(String superviseId) {
        this.superviseId = superviseId;
    }
    public String getSuperviseName() {
        return superviseName;
    }

    public void setSuperviseName(String superviseName) {
        this.superviseName = superviseName;
    }
    public BigDecimal getAssessMny() {
        return assessMny;
    }

    public void setAssessMny(BigDecimal assessMny) {
        this.assessMny = assessMny;
    }
    public BigDecimal getActualMny() {
        return actualMny;
    }

    public void setActualMny(BigDecimal actualMny) {
        this.actualMny = actualMny;
    }
    public String getDealFlats() {
        return dealFlats;
    }

    public void setDealFlats(String dealFlats) {
        this.dealFlats = dealFlats;
    }
    public String getDealFlatsPeople() {
        return dealFlatsPeople;
    }

    public void setDealFlatsPeople(String dealFlatsPeople) {
        this.dealFlatsPeople = dealFlatsPeople;
    }
    public String getDealFlatsPhone() {
        return dealFlatsPhone;
    }

    public void setDealFlatsPhone(String dealFlatsPhone) {
        this.dealFlatsPhone = dealFlatsPhone;
    }
    public Integer getContractFlag() {
        return contractFlag;
    }

    public void setContractFlag(Integer contractFlag) {
        this.contractFlag = contractFlag;
    }
    public Integer getInvoiceFlag() {
        return invoiceFlag;
    }

    public void setInvoiceFlag(Integer invoiceFlag) {
        this.invoiceFlag = invoiceFlag;
    }
    public String getInvoiceNumber() {
        return invoiceNumber;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }
    public String getFinanceNumber() {
        return financeNumber;
    }

    public void setFinanceNumber(String financeNumber) {
        this.financeNumber = financeNumber;
    }
    
     public List<WasteResultDetailVO> getWasteResultDetailList() {
        return wasteResultDetailList;
     }

     public void setWasteResultDetailList(List<WasteResultDetailVO> wasteResultDetailList) {
        this.wasteResultDetailList = wasteResultDetailList;
     }
}
