package com.ejianc.business.promaterial.deBalance.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 物资收发耗用结存
 *
 * @author generator
 *
 */
public class DeBalanceVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String createUserName; // 创建人名称
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private String projectCode; // 项目编码
    private Long orgId; // 组织Id
    private String orgName; // 组织名称
    private String orgCode; // 组织编码
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date month; // 月份
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date organizeDate; // 编制日期
    private Long organizeId; // 编制人
    private String organizeName; // 编制人名称
    private String organizeCode; // 编制人编码
    private Long financialContractType; // 财务合同类型
    private String financialContractTypeName; // 财务合同类型名称
    private Long financialOrgId; // 财务组织
    private String financialOrgName; // 财务组织名称
    private String financialOrgCode; // 财务组织编码
    private String levyFlag; // 是否简易征收项目：(0：否，1:是)
    private String financialCrossFlag; // 是否传会计平台：(0：否，1:是)
    private String financialNumber; // 凭证号
    private String memo; // 备注
    private String billCode; // 单据编号
    private BigDecimal openingAmountMny; // 本月期初金额
    private BigDecimal totalAmountIncomeMny; // 收入总金额
    private BigDecimal totalAmountOutMny; // 支出总金额
    private BigDecimal balanceAmountMny; // 本期结余金额
    private Date approveDate; // 审批日期
    private Integer billState; // 单据状态（审批必须字段）

    private String billStateName;
    private String startDate;
    private String endDate;

    private List<DeBalanceDetailVO> deBalanceDetailList = new ArrayList<>(); // 物资收发耗用结存子表

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Date getMonth() {
        return month;
    }

    public void setMonth(Date month) {
        this.month = month;
    }
    public Date getOrganizeDate() {
        return organizeDate;
    }

    public void setOrganizeDate(Date organizeDate) {
        this.organizeDate = organizeDate;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getOrganizeId() {
        return organizeId;
    }
    @ReferDeserialTransfer
    public void setOrganizeId(Long organizeId) {
        this.organizeId = organizeId;
    }
    public String getOrganizeName() {
        return organizeName;
    }

    public void setOrganizeName(String organizeName) {
        this.organizeName = organizeName;
    }
    public String getOrganizeCode() {
        return organizeCode;
    }

    public void setOrganizeCode(String organizeCode) {
        this.organizeCode = organizeCode;
    }
    public Long getFinancialContractType() {
        return financialContractType;
    }

    public void setFinancialContractType(Long financialContractType) {
        this.financialContractType = financialContractType;
    }
    public String getFinancialContractTypeName() {
        return financialContractTypeName;
    }

    public void setFinancialContractTypeName(String financialContractTypeName) {
        this.financialContractTypeName = financialContractTypeName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getFinancialOrgId() {
        return financialOrgId;
    }
    @ReferDeserialTransfer
    public void setFinancialOrgId(Long financialOrgId) {
        this.financialOrgId = financialOrgId;
    }
    public String getFinancialOrgName() {
        return financialOrgName;
    }

    public void setFinancialOrgName(String financialOrgName) {
        this.financialOrgName = financialOrgName;
    }
    public String getFinancialOrgCode() {
        return financialOrgCode;
    }

    public void setFinancialOrgCode(String financialOrgCode) {
        this.financialOrgCode = financialOrgCode;
    }
    public String getLevyFlag() {
        return levyFlag;
    }

    public void setLevyFlag(String levyFlag) {
        this.levyFlag = levyFlag;
    }
    public String getFinancialCrossFlag() {
        return financialCrossFlag;
    }

    public void setFinancialCrossFlag(String financialCrossFlag) {
        this.financialCrossFlag = financialCrossFlag;
    }
    public String getFinancialNumber() {
        return financialNumber;
    }

    public void setFinancialNumber(String financialNumber) {
        this.financialNumber = financialNumber;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public BigDecimal getOpeningAmountMny() {
        return openingAmountMny;
    }

    public void setOpeningAmountMny(BigDecimal openingAmountMny) {
        this.openingAmountMny = openingAmountMny;
    }
    public BigDecimal getTotalAmountIncomeMny() {
        return totalAmountIncomeMny;
    }

    public void setTotalAmountIncomeMny(BigDecimal totalAmountIncomeMny) {
        this.totalAmountIncomeMny = totalAmountIncomeMny;
    }
    public BigDecimal getTotalAmountOutMny() {
        return totalAmountOutMny;
    }

    public void setTotalAmountOutMny(BigDecimal totalAmountOutMny) {
        this.totalAmountOutMny = totalAmountOutMny;
    }
    public BigDecimal getBalanceAmountMny() {
        return balanceAmountMny;
    }

    public void setBalanceAmountMny(BigDecimal balanceAmountMny) {
        this.balanceAmountMny = balanceAmountMny;
    }
    public Date getApproveDate() {
        return approveDate;
    }

    public void setApproveDate(Date approveDate) {
        this.approveDate = approveDate;
    }

     public List<DeBalanceDetailVO> getDeBalanceDetailList() {
        return deBalanceDetailList;
     }

     public void setDeBalanceDetailList(List<DeBalanceDetailVO> deBalanceDetailList) {
        this.deBalanceDetailList = deBalanceDetailList;
     }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }
}
