package com.ejianc.business.promaterial.pricelib.api;

import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceHistoryApiVO;
import com.ejianc.business.promaterial.pricelib.vo.PriceHistoryVO;
import com.ejianc.business.promaterial.pricelib.hystrix.MaterialPriceHistoryHystrix;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

@FeignClient(
        name = "ejc-promaterial-web",
        url = "${common.env.feign-client-url}",
        path = "ejc-promaterial-web",
        fallback = MaterialPriceHistoryHystrix.class
)
public interface IMaterialPriceHistoryApi {
    @ApiOperation("查询单个物资历史价格")
    @GetMapping(value = "/api/MaterialPriceHistoryApi/getMaterialPriceHistoryApiVO")
    CommonResponse<MaterialPriceHistoryApiVO> getMaterialPriceHistoryApiVO(@RequestParam("materialId") Long materialId);

    @ApiOperation("查询多个个物资历史价格")
    @PostMapping(value = "/api/MaterialPriceHistoryApi/getMaterialPriceHistoryApiVOS")
    CommonResponse<List<MaterialPriceHistoryApiVO>> getMaterialPriceHistoryApiVOS(@RequestBody List<Long> materialIds);

    @ApiOperation("查询多个个物资历史价格")
    @PostMapping("getMaterialPriceHistoryApiVOMap")
    CommonResponse<Map<Long,MaterialPriceHistoryApiVO>> getMaterialPriceHistoryApiVOMap(@RequestBody List<Long> materialIds);
}
