package com.ejianc.business.promaterial.pricelib.vo;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 物资价格库预警参数
 */
public enum MaterialPriceCheckTypeEnum {

    消耗材合同(1, "合同"),
    消耗材验收(2, "验收"),
    消耗材结算(3, "结算"),
    混凝土合同(4, "合同"),
    混凝土验收(5, "验收"),
    混凝土结算(6, "结算"),
    ;
    private Integer code;
    private String description;
    private static Map<Integer, MaterialPriceCheckTypeEnum> enumMap = new HashMap<>();

    MaterialPriceCheckTypeEnum(Integer code, String description){
        this.code = code;
        this.description = description;
    }
    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    static {
        enumMap = EnumSet.allOf(MaterialPriceCheckTypeEnum.class).stream().collect(Collectors.toMap(MaterialPriceCheckTypeEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static MaterialPriceCheckTypeEnum getEnumByCode(Integer billStateCode) {
        return enumMap.get(billStateCode);
    }
}

