package com.ejianc.business.promaterial.check.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 消耗材-验收主表
 *
 * @author generator
 *
 */
@ApiModel("消耗材-验收主表")
public class CheckVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("订单主键")
    private Long orderId;
    @ApiModelProperty("发货主键")
    private Long deliveryId;
    @ApiModelProperty("验收状态（0-未验收，1--已验收）")
    private Integer checkState;
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("合同主键")
    private Long contractId;
    @ApiModelProperty("合同名称")
    private String contractName;
    @ApiModelProperty("合同code")
    private String contractCode;
    @ApiModelProperty("项目")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("项目code")
    private String projectCode;
    @ApiModelProperty("供应商主键")
    private Long supplierId;
    @ApiModelProperty("供应商名称")
    private String supplierName;
    @ApiModelProperty("经办人")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    private String employeeName;
    @ApiModelProperty("验收人名称")
    private String checkerName;
    @ApiModelProperty("经办部门")
    private Long departmentId;
    @ApiModelProperty("经办部门名称")
    private String departmentName;
    @ApiModelProperty("验收日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date checkDate;
    @ApiModelProperty("车牌号")
    private String licensePlate;
    @ApiModelProperty("是否补录，0-否，1-是")
    private Integer recordFlag;
    @ApiModelProperty("是否补录，0-否，1-是")
    private String recordFlagName;
    @ApiModelProperty("补录原因")
    private String recordReson;

    @ApiModelProperty("组织")
    private Long orgId;
    @ApiModelProperty("组织名称")
    private String orgName;
    @ApiModelProperty("组织code")
    private String orgCode;
    @ApiModelProperty("验收类型，0-其他，1-采购验收,2-周转材租赁,3-MRO")
    private String checkType;
    @ApiModelProperty("入库方式，0-收料入库，1-直入直出")
    private Integer storeType;
    @ApiModelProperty("入库方式，0-收料入库，1-直入直出")
    private String storeTypeName;
    @ApiModelProperty("验收来源，0-自制验收,1-发货验收")
    private Integer sourceType;
    @ApiModelProperty("验收来源，0-自制验收,1-发货验收")
    private String sourceTypeName;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("仓库主键")
    private Long storeId;
    @ApiModelProperty("仓库名称")
    private String storeName;
    @ApiModelProperty("入库日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date instoreDate;
    @ApiModelProperty("分包合同主键")
    private Long subContractId;
    @ApiModelProperty("分包合同名称")
    private String subContractName;
    @ApiModelProperty("分包合同code")
    private String subContractCode;
    @ApiModelProperty("分包合同供应商主键")
    private Long subSupplierId;
    @ApiModelProperty("分包合同供应商名称")
    private String subSupplierName;
    @ApiModelProperty("分包负责人名称")
    private String subEmployeeName;
    @ApiModelProperty("联系电话")
    private String subEmployeePhone;
    @ApiModelProperty("使用部位")
    private String construction;
    @ApiModelProperty("父级组织名称")
    private String parentOrgName;
    @ApiModelProperty("父级组织")
    private Long parentOrgId;
    @ApiModelProperty("小票数量")
    private BigDecimal ticketNum;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("单据状态（审批必须字段）")
    private String billStateName;
    private String checkTypeName;
    private Long materialId; // 物料Id
    @ApiModelProperty("验收单价(无税)")
    private BigDecimal checkPrice;
    @ApiModelProperty("验收单价(含税)")
    private BigDecimal checkTaxPrice;
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    @ApiModelProperty("物资类别")
    private Long materialTypeId;
    @ApiModelProperty("合同物资数量")
    private BigDecimal contractNumsSum; //
    private String relationFlag; // 关联状态(1:是，0：否)
    private String proportionFlag; // 分摊状态(1:是，0：否)

    private Integer electronicFenceEnableStatus; //项目电子围栏开启状态：0-未开启，1-开启
    private Integer abnormalImgFlag; // 是否为验收异常区域：0-否，1-是


    /**
     * 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
     */
    @ApiModelProperty("单据推送标识")
    private String billPushFlag;
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 父级组织编码
    @ApiModelProperty("消耗材-验收明细子表")
    private List<CheckDetailVO> checkDetailList = new ArrayList<>();
    @TableField(value="sub_out_type")
    private Integer subOutType;//领料方式,1-内部领料,2-分包领料
    @TableField(value="sub_use")
    private String subUse;//用途
    private Integer automaticWeigh; // 自动称重设置（0：自动称重，1非自动称重）
    private Integer deliveryType; // 发货单类型 1-自制，2-供方推送（订单）
    private Integer checkWeighType; // 是否磅单验收  0-否  1-是
    private BigDecimal pushCostMny; // 推送实际成本总金额(无税)
    private BigDecimal pushCostTaxMny; // 推送实际成本总金额(含税)
    @ApiModelProperty("消耗材-验收磅单子表")
    private List<CheckWeighVO> checkWeighList = new ArrayList<>(); // 消耗材-磅单子表
    @ApiModelProperty("消耗材-验收图片子表表")
    private List<CheckImgDetailVO> checkImgList = new ArrayList<>(); // 消耗材-验收图片子表表

    public Integer getAbnormalImgFlag() {
        return abnormalImgFlag;
    }

    public void setAbnormalImgFlag(Integer abnormalImgFlag) {
        this.abnormalImgFlag = abnormalImgFlag;
    }

    public Integer getElectronicFenceEnableStatus() {
        return electronicFenceEnableStatus;
    }

    public void setElectronicFenceEnableStatus(Integer electronicFenceEnableStatus) {
        this.electronicFenceEnableStatus = electronicFenceEnableStatus;
    }

    public List<CheckImgDetailVO> getCheckImgList() {
        return checkImgList;
    }

    public void setCheckImgList(List<CheckImgDetailVO> checkImgList) {
        this.checkImgList = checkImgList;
    }

    public Integer getCheckWeighType() {
        return checkWeighType;
    }

    public void setCheckWeighType(Integer checkWeighType) {
        this.checkWeighType = checkWeighType;
    }

    public Integer getDeliveryType() {
        return deliveryType;
    }

    public void setDeliveryType(Integer deliveryType) {
        this.deliveryType = deliveryType;
    }

    public Integer getAutomaticWeigh() {
        return automaticWeigh;
    }

    public void setAutomaticWeigh(Integer automaticWeigh) {
        this.automaticWeigh = automaticWeigh;
    }

    public List<CheckWeighVO> getCheckWeighList() {
        return checkWeighList;
    }

    public void setCheckWeighList(List<CheckWeighVO> checkWeighList) {
        this.checkWeighList = checkWeighList;
    }

    public Integer getSubOutType() {
        return subOutType;
    }

    public void setSubOutType(Integer subOutType) {
        this.subOutType = subOutType;
    }

    public String getSubUse() {
        return subUse;
    }

    public void setSubUse(String subUse) {
        this.subUse = subUse;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getRecordFlagName() {
        return recordFlagName;
    }

    public void setRecordFlagName(String recordFlagName) {
        this.recordFlagName = recordFlagName;
    }

    public String getSourceTypeName() {
        return sourceTypeName;
    }

    public void setSourceTypeName(String sourceTypeName) {
        this.sourceTypeName = sourceTypeName;
    }

    public String getStoreTypeName() {
        return storeTypeName;
    }

    public void setStoreTypeName(String storeTypeName) {
        this.storeTypeName = storeTypeName;
    }

    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }

    /***  协同需要字段 START  ***/

    /**
     * 合同物资数量
     */
    public BigDecimal getContractNumsSum() {
        return contractNumsSum;
    }
    /**
     * 合同物资数量
     */
    public void setContractNumsSum(BigDecimal contractNumsSum) {
        this.contractNumsSum = contractNumsSum;
    }

    /**
     * 供方经办人名称
     */
    @TableField(value = "sup_operator_name")
    private String supOperatorName;

    /**
     * 供方经办人手机号
     */
    @TableField(value = "sup_operator_phone")
    private String supOperatorPhone;

    /**
     * 供方经办人账号
     */
    @TableField(value = "sup_operator_user_code")
    private String supOperatorUserCode;

    /**
     * 供方经办人签字时间
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value = "sup_operate_time")
    private Date supOperateTime;

    /**
     * 供方经办人签字文件id
     */
    @TableField(exist = false)
    private Long supOperateFileId;

    /**
     * 来源业务系统id
     */
    @TableField(exist = false)
    private String sourceSystemId;
    @TableField(value = "sign_status")
    private Integer signStatus; // 签字状态：0-未签字,1-已签字
    private String signStatusName; // 签字状态：0-未签字,1-已签字
    /**
     * 子表验收金额汇总
     */
    private BigDecimal checkAllTaxMny;
    /**
     * 子表验收金额汇总
     */
    private BigDecimal checkAllMny;
    /**
     * 计价方式：1-固定单价、2-浮动单价、3-固定总价
     */
    private String pricingType;
    private String deliveryCode; // 发货单编号
    private Long sourceDetailId; // 来源合同明细id
    @TableField(value = "attr_flag")
    private Integer attrFlag; // 仓库属性 1-自购材；2-甲供材
    private String attrFlagName; // 仓库属性 1-自购材；2-甲供材
    private String billCodeName;

    public String getSignStatusName() {
        return signStatusName;
    }

    public void setSignStatusName(String signStatusName) {
        this.signStatusName = signStatusName;
    }

    public String getBillCodeName() {
        return billCodeName;
    }

    public void setBillCodeName(String billCodeName) {
        this.billCodeName = billCodeName;
    }

    public String getAttrFlagName() {
        return attrFlagName;
    }

    public void setAttrFlagName(String attrFlagName) {
        this.attrFlagName = attrFlagName;
    }

    public Integer getAttrFlag() {
        return attrFlag;
    }

    public void setAttrFlag(Integer attrFlag) {
        this.attrFlag = attrFlag;
    }

    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public BigDecimal getCheckPrice() {
        return checkPrice;
    }

    public void setCheckPrice(BigDecimal checkPrice) {
        this.checkPrice = checkPrice;
    }

    public BigDecimal getCheckTaxPrice() {
        return checkTaxPrice;
    }

    public void setCheckTaxPrice(BigDecimal checkTaxPrice) {
        this.checkTaxPrice = checkTaxPrice;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getDeliveryCode() {
        return deliveryCode;
    }

    public void setDeliveryCode(String deliveryCode) {
        this.deliveryCode = deliveryCode;
    }

    public BigDecimal getCheckAllTaxMny() {
        return checkAllTaxMny;
    }

    public void setCheckAllTaxMny(BigDecimal checkAllTaxMny) {
        this.checkAllTaxMny = checkAllTaxMny;
    }

    public BigDecimal getCheckAllMny() {
        return checkAllMny;
    }

    public void setCheckAllMny(BigDecimal checkAllMny) {
        this.checkAllMny = checkAllMny;
    }

    public String getPricingType() {
        return pricingType;
    }

    public void setPricingType(String pricingType) {
        this.pricingType = pricingType;
    }

    public Integer getSignStatus() {
        return signStatus;
    }

    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }

    public String getSupOperatorName() {
        return supOperatorName;
    }

    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }

    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }

    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }

    public Date getSupOperateTime() {
        return supOperateTime;
    }

    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }

    public Long getSupOperateFileId() {
        return supOperateFileId;
    }

    public void setSupOperateFileId(Long supOperateFileId) {
        this.supOperateFileId = supOperateFileId;
    }

    public String getSourceSystemId() {
        return sourceSystemId;
    }

    public void setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
    }

    /***  协同需要字段 END  ***/


    public String getCheckTypeName() {
        return checkTypeName;
    }

    public void setCheckTypeName(String checkTypeName) {
        this.checkTypeName = checkTypeName;
    }

    /**
     * 订单主键
     */
    public Long getOrderId() {
        return orderId;
    }

    /**
     * 订单主键
     */
    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }
    /**
     * 发货主键
     */
    public Long getDeliveryId() {
        return deliveryId;
    }

    /**
     * 发货主键
     */
    public void setDeliveryId(Long deliveryId) {
        this.deliveryId = deliveryId;
    }
    /**
     * 验收状态（0-未验收，1--已验收）
     */
    public Integer getCheckState() {
        return checkState;
    }

    /**
     * 验收状态（0-未验收，1--已验收）
     */
    public void setCheckState(Integer checkState) {
        this.checkState = checkState;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同code
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同code
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目code
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目code
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 供应商主键
     */

    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商主键
     */
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 验收人名称
     */
    public String getCheckerName() {
        return checkerName;
    }

    /**
     * 验收人名称
     */
    public void setCheckerName(String checkerName) {
        this.checkerName = checkerName;
    }
    /**
     * 经办部门
     */
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办部门
     */
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办部门名称
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 验收日期
     */
    public Date getCheckDate() {
        return checkDate;
    }

    /**
     * 验收日期
     */
    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }
    /**
     * 车牌号
     */
    public String getLicensePlate() {
        return licensePlate;
    }

    /**
     * 车牌号
     */
    public void setLicensePlate(String licensePlate) {
        this.licensePlate = licensePlate;
    }
    /**
     * 是否补录，0-否，1-是
     */
    public Integer getRecordFlag() {
        return recordFlag;
    }

    /**
     * 是否补录，0-否，1-是
     */
    public void setRecordFlag(Integer recordFlag) {
        this.recordFlag = recordFlag;
    }
    /**
     * 补录原因
     */
    public String getRecordReson() {
        return recordReson;
    }

    /**
     * 补录原因
     */
    public void setRecordReson(String recordReson) {
        this.recordReson = recordReson;
    }

    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getCheckType() {
        return checkType;
    }

    public void setCheckType(String checkType) {
        this.checkType = checkType;
    }

    public Integer getStoreType() {
        return storeType;
    }

    public void setStoreType(Integer storeType) {
        this.storeType = storeType;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

    /**
     * 仓库名称
     */
    public String getStoreName() {
        return storeName;
    }

    /**
     * 仓库名称
     */
    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    /**
     * 入库日期
     */
    public Date getInstoreDate() {
        return instoreDate;
    }

    /**
     * 入库日期
     */
    public void setInstoreDate(Date instoreDate) {
        this.instoreDate = instoreDate;
    }

    /**
     * 分包合同名称
     */
    public String getSubContractName() {
        return subContractName;
    }

    /**
     * 分包合同名称
     */
    public void setSubContractName(String subContractName) {
        this.subContractName = subContractName;
    }
    /**
     * 分包合同code
     */
    public String getSubContractCode() {
        return subContractCode;
    }

    /**
     * 分包合同code
     */
    public void setSubContractCode(String subContractCode) {
        this.subContractCode = subContractCode;
    }
    /**
     * 分包合同供应商主键
     */
    public Long getSubSupplierId() {
        return subSupplierId;
    }

    /**
     * 分包合同供应商主键
     */
    public void setSubSupplierId(Long subSupplierId) {
        this.subSupplierId = subSupplierId;
    }
    /**
     * 分包合同供应商名称
     */
    public String getSubSupplierName() {
        return subSupplierName;
    }

    /**
     * 分包合同供应商名称
     */
    public void setSubSupplierName(String subSupplierName) {
        this.subSupplierName = subSupplierName;
    }
    /**
     * 分包负责人名称
     */
    public String getSubEmployeeName() {
        return subEmployeeName;
    }

    /**
     * 分包负责人名称
     */
    public void setSubEmployeeName(String subEmployeeName) {
        this.subEmployeeName = subEmployeeName;
    }
    /**
     * 联系电话
     */
    public String getSubEmployeePhone() {
        return subEmployeePhone;
    }

    /**
     * 联系电话
     */
    public void setSubEmployeePhone(String subEmployeePhone) {
        this.subEmployeePhone = subEmployeePhone;
    }
    /**
     * 使用部位
     */
    public String getConstruction() {
        return construction;
    }

    /**
     * 使用部位
     */
    public void setConstruction(String construction) {
        this.construction = construction;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 小票数量
     */
    public BigDecimal getTicketNum() {
        return ticketNum;
    }

    /**
     * 小票数量
     */
    public void setTicketNum(BigDecimal ticketNum) {
        this.ticketNum = ticketNum;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }

     /**
      * 消耗材-验收明细子表
      */
      public List<CheckDetailVO> getCheckDetailList() {
         return checkDetailList;
      }
     /**
      * 消耗材-验收明细子表
      */
     public void setCheckDetailList(List<CheckDetailVO> checkDetailList) {
         this.checkDetailList = checkDetailList;
     }
    @ReferSerialTransfer(referCode = "contractMaterial")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    @ReferSerialTransfer(referCode = "store-store")
    public Long getStoreId() {
        return storeId;
    }
    @ReferDeserialTransfer
    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    @ReferSerialTransfer(referCode = "proSubContract")
    public Long getSubContractId() {
        return subContractId;
    }
    @ReferDeserialTransfer
    public void setSubContractId(Long subContractId) {
        this.subContractId = subContractId;
    }

    public BigDecimal getPushCostMny() {
        return pushCostMny;
    }

    public void setPushCostMny(BigDecimal pushCostMny) {
        this.pushCostMny = pushCostMny;
    }

    public BigDecimal getPushCostTaxMny() {
        return pushCostTaxMny;
    }

    public void setPushCostTaxMny(BigDecimal pushCostTaxMny) {
        this.pushCostTaxMny = pushCostTaxMny;
    }
}
