package com.ejianc.business.promaterial.check.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.promaterial.check.hystrix.ICheckHystrix;
import com.ejianc.business.promaterial.check.vo.CheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

@FeignClient(
        name = "ejc-promaterial-web",
        url = "${common.env.feign-client-url}",
        path = "ejc-promaterial-web",
        fallback = ICheckHystrix.class
)
public interface ICheckApi {

    /**
     * 根据物资明细id 获取验收单详情
     *
     */
    @RequestMapping(
            value = {"/api/check/queryCheckByDetailId"},
            method = {RequestMethod.GET}
    )
    CommonResponse<CheckVO> queryCheckByDetailId(@RequestParam("detailId") Long detailId);

    /**
     * 根据物资明细id 获取混凝土验收单详情
     *
     */
    @RequestMapping(
            value = {"/api/check/queryConcreteCheckByDetailId"},
            method = {RequestMethod.GET}
    )
    CommonResponse<CheckVO> queryConcreteCheckByDetailId(@RequestParam("detailId") Long detailId);

    /**
     * 根据物资明细id 获取混凝土验收单详情
     *
     */
    @RequestMapping(
            value = {"/api/check/querycheckMnyById"},
            method = {RequestMethod.GET}
    )
    CommonResponse<JSONObject> querycheckMnyById(@RequestParam("projectId") Long projectId, @RequestParam("supplierId") Long supplierId);

    /**
     * 根据 项目无合同所有状态下材料、混凝土验收 验收金额之和
     *
     * @return
     */
    @RequestMapping(
            value = {"/api/check/queryCheckMnyProjectId"},
            method = {RequestMethod.GET}
    )
    CommonResponse<JSONObject> queryCheckMnyProjectId(@RequestParam("projectId") Long projectId);

    /**
     * 根据项目id、验收日期查询消耗材、混凝土单据数量
     *
     * @param jsonObject 参数
     *
     * @return CommonResponse<Map < String, Integer>>
     */
    @PostMapping(value = "/api/check/countBillNum")
    CommonResponse<Map<String, Integer>> countBillNum(@RequestBody JSONObject jsonObject);
    /**
     * 根据 项目 查询无合同 已生效的 材料验收入库单
     *
     * @return
     */
    @ApiOperation("根据 项目 查询无合同 已生效的 材料验收入库单 ")
    @RequestMapping(value = "/api/check/querycheckListByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<CheckVO>> querycheckListByProjectId(@RequestParam("projectId") Long projectId);


    /**
     * 根据 项目 查询无合同 已生效的 材料验收入库单 验收金额之和
     *
     * @return
     */
    @ApiOperation("根据 项目 查询无合同 已生效的 材料验收入库单 验收金额之和")
    @RequestMapping(value = "/api/check/querycheckMnyByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> querycheckMnyByProjectId(@RequestParam("projectId") Long projectId);
}
