package com.ejianc.business.promaterial.order.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.business.promaterial.plan.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 材料订单子表
 * 
 * @author generator
 * 
 */
@ApiModel("材料订单子表")
public class OrderDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("序号")
    private String detailIndex;
    @ApiModelProperty("parent_id")
    private Long parentId;
    @ApiModelProperty("是否末级")
    private Boolean leafFlag;
    @ApiModelProperty("订单主键ID")
    private Long orderId;
    @ApiModelProperty("来源主键ID")
    private Long sourceId;
    @ApiModelProperty("来源明细主键ID")
    private Long sourceDetailId;
    @ApiModelProperty("来源类型名称")
    private String sourceName;
    @ApiModelProperty("来源类型（0-需用计划，1-合同明细，2-合同大类）")
    private Integer sourceType;
    @ApiModelProperty("使用计划名称")
    private String planName;
    @ApiModelProperty("计划编码")
    private String planBillCode;
    @ApiModelProperty("计划编制人")
    private String planEmployeeName;
    @ApiModelProperty("施工部位")
    private String construction;
    @ApiModelProperty("物资主键")
    private Long materialId;
    @ApiModelProperty("物资名称")
    private String materialName;
    @ApiModelProperty("物资编码")
    private String materialCode;
    @ApiModelProperty("物资类别")
    private Long materialTypeId;
    @ApiModelProperty("物资类别名称")
    private String materialTypeName;
    @ApiModelProperty("单位")
    private String unit;
    @ApiModelProperty("单位id")
    private Long unitId;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("计划数量")
    private BigDecimal planNumsSum;
    @ApiModelProperty("接收数量")
    private BigDecimal receiveNumsSum;
    @ApiModelProperty("计划剩余数量")
    private BigDecimal surplusNumsSum;
    @ApiModelProperty("最新计划剩余数量")
    private BigDecimal newSurplusNumsSum;
    @ApiModelProperty("订单数量")
    private BigDecimal orderNumsSum;            // -- 数量
    @ApiModelProperty("发货数量")
    private BigDecimal deliverNumsSum;
    @ApiModelProperty("验收数量")
    private BigDecimal checkNumsSum;
    @ApiModelProperty("生产厂家")
    private String materialManufacturer;        // -- 产地/品牌
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("树形主键")
    private Long tid;
    @ApiModelProperty("（无税）单价")
    private BigDecimal price;
    @ApiModelProperty("（含税）单价")
    private BigDecimal taxPrice;
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    @ApiModelProperty("申请日期")          // -- 需用日期
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date planDate;
    @ApiModelProperty("合同数量")
    private BigDecimal contractNumsSum;
    private Integer detailAutomaticWeigh; //自动称重设置（0：自动称重，1非自动称重）
    private Integer oldDetailAutomaticWeigh; //带入自动称重设置（0：自动称重，1非自动称重）

    private String standard; // 技术要求
    private BigDecimal mny; // 金额(无税)
    private BigDecimal taxMny; // 金额
    private String texture; // 材质
    private String orderBillCode; // 订单编码（参照用）
    private Long financialId; // 财务科目主键
    private String financialCode; // 财务科目编码
    private String financialName; // 财务科目名称


    public String getOrderBillCode() {
        return orderBillCode;
    }

    public void setOrderBillCode(String orderBillCode) {
        this.orderBillCode = orderBillCode;
    }

    public Integer getDetailAutomaticWeigh() {
        return detailAutomaticWeigh;
    }

    public void setDetailAutomaticWeigh(Integer detailAutomaticWeigh) {
        this.detailAutomaticWeigh = detailAutomaticWeigh;
    }

    public Integer getOldDetailAutomaticWeigh() {
        return oldDetailAutomaticWeigh;
    }

    public void setOldDetailAutomaticWeigh(Integer oldDetailAutomaticWeigh) {
        this.oldDetailAutomaticWeigh = oldDetailAutomaticWeigh;
    }
    private List<OrderDetailVO> OrderDetailVOS = new ArrayList<>();

    public List<OrderDetailVO> getOrderDetailVOS() {
        return OrderDetailVOS;
    }

    public void setOrderDetailVOS(List<OrderDetailVO> orderDetailVOS) {
        OrderDetailVOS = orderDetailVOS;
    }

    public BigDecimal getNewSurplusNumsSum() {
        return newSurplusNumsSum;
    }

    public void setNewSurplusNumsSum(BigDecimal newSurplusNumsSum) {
        this.newSurplusNumsSum = newSurplusNumsSum;
    }

    /**
     * 序号
     */
    public String getDetailIndex() {
        return detailIndex;
    }

    /**
     * 序号
     */
    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }
    /**
     * parent_id
     */
    public Long getParentId() {
        return parentId;
    }

    /**
     * parent_id
     */
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    /**
     * 是否末级
     */
    public Boolean getLeafFlag() {
        return leafFlag;
    }

    /**
     * 是否末级
     */
    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }
    /**
     * 订单主键ID
     */
    public Long getOrderId() {
        return orderId;
    }

    /**
     * 订单主键ID
     */
    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }
    /**
     * 来源主键ID
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源主键ID
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 来源明细主键ID
     */
    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    /**
     * 来源明细主键ID
     */
    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }
    /**
     * 来源类型名称
     */
    public String getSourceName() {
        return sourceName;
    }

    /**
     * 来源类型名称
     */
    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }
    /**
     * 来源类型（0-需用计划，1-合同明细，2-合同大类）
     */
    public Integer getSourceType() {
        return sourceType;
    }

    /**
     * 来源类型（0-需用计划，1-合同明细，2-合同大类）
     */
    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }
    /**
     * 使用计划名称
     */
    public String getPlanName() {
        return planName;
    }

    /**
     * 使用计划名称
     */
    public void setPlanName(String planName) {
        this.planName = planName;
    }
    /**
     * 计划编码
     */
    public String getPlanBillCode() {
        return planBillCode;
    }

    /**
     * 计划编码
     */
    public void setPlanBillCode(String planBillCode) {
        this.planBillCode = planBillCode;
    }
    /**
     * 计划编制人
     */
    public String getPlanEmployeeName() {
        return planEmployeeName;
    }

    /**
     * 计划编制人
     */
    public void setPlanEmployeeName(String planEmployeeName) {
        this.planEmployeeName = planEmployeeName;
    }
    /**
     * 施工部位
     */
    public String getConstruction() {
        return construction;
    }

    /**
     * 施工部位
     */
    public void setConstruction(String construction) {
        this.construction = construction;
    }
    /**
     * 物资主键
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 物资主键
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 物资编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 物资编码
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 物资类别
     */
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    /**
     * 物资类别
     */
    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    /**
     * 物资类别名称
     */
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 物资类别名称
     */
    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 单位id
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 单位id
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 计划数量
     */
    public BigDecimal getPlanNumsSum() {
        return planNumsSum;
    }

    /**
     * 计划数量
     */
    public void setPlanNumsSum(BigDecimal planNumsSum) {
        this.planNumsSum = planNumsSum;
    }
    /**
     * 接收数量
     */
    public BigDecimal getReceiveNumsSum() {
        return receiveNumsSum;
    }

    /**
     * 接收数量
     */
    public void setReceiveNumsSum(BigDecimal receiveNumsSum) {
        this.receiveNumsSum = receiveNumsSum;
    }
    /**
     * 计划剩余数量
     */
    public BigDecimal getSurplusNumsSum() {
        return surplusNumsSum;
    }

    /**
     * 计划剩余数量
     */
    public void setSurplusNumsSum(BigDecimal surplusNumsSum) {
        this.surplusNumsSum = surplusNumsSum;
    }
    /**
     * 订单数量
     */
    public BigDecimal getOrderNumsSum() {
        return orderNumsSum;
    }

    /**
     * 订单数量
     */
    public void setOrderNumsSum(BigDecimal orderNumsSum) {
        this.orderNumsSum = orderNumsSum;
    }
    /**
     * 发货数量
     */
    public BigDecimal getDeliverNumsSum() {
        return deliverNumsSum;
    }

    /**
     * 发货数量
     */
    public void setDeliverNumsSum(BigDecimal deliverNumsSum) {
        this.deliverNumsSum = deliverNumsSum;
    }
    /**
     * 验收数量
     */
    public BigDecimal getCheckNumsSum() {
        return checkNumsSum;
    }

    /**
     * 验收数量
     */
    public void setCheckNumsSum(BigDecimal checkNumsSum) {
        this.checkNumsSum = checkNumsSum;
    }
    /**
     * 生产厂家
     */
    public String getMaterialManufacturer() {
        return materialManufacturer;
    }

    /**
     * 生产厂家
     */
    public void setMaterialManufacturer(String materialManufacturer) {
        this.materialManufacturer = materialManufacturer;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 树形主键
     */
    public Long getTid() {
        return tid;
    }

    /**
     * 树形主键
     */
    public void setTid(Long tid) {
        this.tid = tid;
    }
    /**
     * （无税）单价
     */
    public BigDecimal getPrice() {
        return price;
    }

    /**
     * （无税）单价
     */
    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    /**
     * （含税）单价
     */
    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    /**
     * （含税）单价
     */
    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }
    /**
     * 税率
     */
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 税率
     */
    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 申请日期
     */
    public Date getPlanDate() {
        return planDate;
    }

    /**
     * 申请日期
     */
    public void setPlanDate(Date planDate) {
        this.planDate = planDate;
    }
    /**
     * 合同数量
     */
    public BigDecimal getContractNumsSum() {
        return contractNumsSum;
    }

    /**
     * 合同数量
     */
    public void setContractNumsSum(BigDecimal contractNumsSum) {
        this.contractNumsSum = contractNumsSum;
    }

    public String getStandard() {
        return standard;
    }

    public void setStandard(String standard) {
        this.standard = standard;
    }

    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public String getTexture() {
        return texture;
    }

    public void setTexture(String texture) {
        this.texture = texture;
    }

    @ReferSerialTransfer(referCode = "financial-org-ref")
    public Long getFinancialId() {
        return financialId;
    }

    @ReferDeserialTransfer
    public void setFinancialId(Long financialId) {
        this.financialId = financialId;
    }

    public String getFinancialCode() {
        return financialCode;
    }

    public void setFinancialCode(String financialCode) {
        this.financialCode = financialCode;
    }

    public String getFinancialName() {
        return financialName;
    }

    public void setFinancialName(String financialName) {
        this.financialName = financialName;
    }
}
