package com.ejianc.business.promaterial.plan.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 消耗材-需用计划子表
 *
 * @author generator
 *
 */
@ApiModel("消耗材-需用计划子表")
public class PlanDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    private Long parentId; // parent_id
    private Long tid;
    @ApiModelProperty("主表主键")
    private Long planId;
    @ApiModelProperty("物资分类Id")
    private Long materialCategoryId;
    @ApiModelProperty("物资分类名称")
    private String materialCategoryName;
    @ApiModelProperty("物料Id")
    private Long materialId;
    @ApiModelProperty("物料名称")
    private String materialName;
    @ApiModelProperty("物料编码")
    private String materialCode;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("计量单位")
    private String unit;
    @ApiModelProperty("计量单位Id")
    private Long unitId;
    @ApiModelProperty("来源类型 0：总计划，1：月计划 2:物料档案")
    private Long sourceType;
    @ApiModelProperty("来源Id")
    private Long sourceId;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("占用数量")
    private BigDecimal occupyNums; // 占用数量
    @ApiModelProperty("剩余数量")
    private BigDecimal surplusNums; // 剩余数量
    @ApiModelProperty("需用数量")
    private BigDecimal nums; // 需用数量
    private BigDecimal planNumsSum; // 所有需求数量
    private BigDecimal occupyNumsAll; // 所有占用数量
    private BigDecimal surplusNumsSum; // 所有剩余数量
    @ApiModelProperty("累计进场数量")
    private BigDecimal checkNum; // 累计进场数量
    private BigDecimal planSurplusNums; // 计划剩余数量（总计划/月计划-数量）
    @ApiModelProperty("使用部位")
    private String construction;

    private BigDecimal price; // 单价

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planDate; // 需用日期
    private Integer firstState; // 是否为一级采购目录清单：0-否，1-是
    private String planCode; // 需用计划编码
    private String texture; // 材质


    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getPlanSurplusNums() {
        return planSurplusNums;
    }

    public void setPlanSurplusNums(BigDecimal planSurplusNums) {
        this.planSurplusNums = planSurplusNums;
    }

    private List<PlanDetailRefVO> planDetail = new ArrayList<>();

    public List<PlanDetailRefVO> getPlanDetail() {
        return planDetail;
    }

    public void setPlanDetail(List<PlanDetailRefVO> planDetail) {
        this.planDetail = planDetail;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Long getTid() {
        return tid;
    }

    public void setTid(Long tid) {
        this.tid = tid;
    }

    public BigDecimal getPlanNumsSum() {
        return planNumsSum;
    }

    public void setPlanNumsSum(BigDecimal planNumsSum) {
        this.planNumsSum = planNumsSum;
    }

    public BigDecimal getOccupyNumsAll() {
        return occupyNumsAll;
    }

    public void setOccupyNumsAll(BigDecimal occupyNumsAll) {
        this.occupyNumsAll = occupyNumsAll;
    }

    public BigDecimal getSurplusNumsSum() {
        return surplusNumsSum;
    }

    public void setSurplusNumsSum(BigDecimal surplusNumsSum) {
        this.surplusNumsSum = surplusNumsSum;
    }

    public BigDecimal getOccupyNums() {
        return occupyNums;
    }

    public void setOccupyNums(BigDecimal occupyNums) {
        this.occupyNums = occupyNums;
    }

    public BigDecimal getSurplusNums() {
        return surplusNums;
    }

    public void setSurplusNums(BigDecimal surplusNums) {
        this.surplusNums = surplusNums;
    }

    public BigDecimal getNums() {
        return nums;
    }

    public void setNums(BigDecimal nums) {
        this.nums = nums;
    }

    public BigDecimal getCheckNum() {
        return checkNum;
    }

    public void setCheckNum(BigDecimal checkNum) {
        this.checkNum = checkNum;
    }

    /**
     * 主表主键
     */
    public Long getPlanId() {
        return planId;
    }

    /**
     * 主表主键
     */
    public void setPlanId(Long planId) {
        this.planId = planId;
    }
    /**
     * 物资分类Id
     */
    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    /**
     * 物资分类Id
     */
    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }
    /**
     * 物资分类名称
     */
    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    /**
     * 物资分类名称
     */
    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }
    /**
     * 物料Id
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 物料Id
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 物料名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物料名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 物料编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 物料编码
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 计量单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 计量单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 计量单位Id
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 计量单位Id
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 来源类型 0：总计划，1：月计划 2:物料档案
     */
    public Long getSourceType() {
        return sourceType;
    }

    /**
     * 来源类型 0：总计划，1：月计划 2:物料档案
     */
    public void setSourceType(Long sourceType) {
        this.sourceType = sourceType;
    }
    /**
     * 来源Id
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源Id
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getConstruction() {
        return construction;
    }

    public void setConstruction(String construction) {
        this.construction = construction;
    }

    public Date getPlanDate() {
        return planDate;
    }

    public void setPlanDate(Date planDate) {
        this.planDate = planDate;
    }

    public Integer getFirstState() {
        return firstState;
    }

    public void setFirstState(Integer firstState) {
        this.firstState = firstState;
    }

    public String getPlanCode() {
        return planCode;
    }

    public void setPlanCode(String planCode) {
        this.planCode = planCode;
    }

    public String getTexture() {
        return texture;
    }

    public void setTexture(String texture) {
        this.texture = texture;
    }
}
