package com.ejianc.business.promaterial.check.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 消耗材-验收明细子表
 * 
 * @author generator
 * 
 */
@ApiModel("消耗材-验收明细子表")
public class CheckDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("验收主键ID")
    private Long checkId;
    @ApiModelProperty("发货主键ID")
    private Long deliveryId;
    @ApiModelProperty("发货明细主键ID")
    private Long deliveryDetailId;
    @ApiModelProperty("订单主键ID")
    private Long orderId;
    @ApiModelProperty("订单编码")
    private String orderCode;
    @ApiModelProperty("订单明细主键ID")
    private Long orderDetailId;
    @ApiModelProperty("物资主键")
    private Long materialId;
    @ApiModelProperty("物资名称")
    private String materialName;
    @ApiModelProperty("物资类别")
    private Long materialTypeId;
    @ApiModelProperty("物资类别名称")
    private String materialTypeName;
    @ApiModelProperty("物料编码")
    private String materialCode;
    @ApiModelProperty("单位名称")
    private String unit;
    @ApiModelProperty("单位主键")
    private Long unitId;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("发货数量")
    private BigDecimal deliverNum;
    @ApiModelProperty("验收数量")
    private BigDecimal checkNum;
    @ApiModelProperty("验收金额(无税)")
    private BigDecimal checkMny;
    @ApiModelProperty("验收金额(含税)")
    private BigDecimal checkTaxMny;
    @ApiModelProperty("验收单价(无税)")
    private BigDecimal checkPrice;
    @ApiModelProperty("验收单价(含税)")
    private BigDecimal checkTaxPrice;
    @ApiModelProperty("综合验收单价(无税)")
    private BigDecimal checkPriceOverall;
    @ApiModelProperty("综合验收单价(含税)")
    private BigDecimal checkTaxPriceOverall;
    @ApiModelProperty("税额")
    private BigDecimal taxMny;
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    @ApiModelProperty("使用部位")
    private String construction;
    @ApiModelProperty("备注")
    private String memo;
    @TableField(value="source_type")
    private String sourceType; //  0-合同 1-大类
    @TableField(value="source_id")
    private Long sourceId; // 来源ID
    private Long wbsId; // 核算对象主键
    private String wbsCode; // 核算对象编码
    private String wbsName; // 核算对象名称
    private Long subjectId; // 成本科目主键
    private String subjectCode; // 成本科目编码
    private String subjectName; // 成本科目名称
    @ApiModelProperty("合同物资数量")
    private BigDecimal contractNumsSum; //
    @ApiModelProperty("历史价格区间（无税）")
    private String historyPriceArea;
    @ApiModelProperty("历史价格区间（含税）")
    private String historyTaxPriceArea;
    @ApiModelProperty("是否合同内1-是,2-否")
    private Integer contractFlag;
    private BigDecimal detailCoefficient; // 换算系数
    private BigDecimal detailNetWeight; // 净重
    private BigDecimal detailNetWeightCoefficient; // 单位换算后净重（千克）
    private Integer detailAutomaticWeigh; // 自动称重设置（0：自动称重，1非自动称重）
    private String guidePriceArea; // 公司指导价区间（无税）
    private String guideTaxPriceArea; // 公司指导价区间（含税）
    @ApiModelProperty("是否低值易耗品标识，1-是，0-否")
    private Integer consumableFlag;

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date deliveryDate; // 配送时间


    private String materialQuality; // 材质
    private String manufacturer; // 生产厂家
    private Long financeId; // 财务科目主键
    private String financeCode; // 财务科目编码
    private String financeName; // 财务科目名称

    private BigDecimal orderNumsSum;            // -- 配送单数量


    private Long bpoLineId; // 合同行号
    private Long bpoOrderId; // 订单号
    private Long bpoOrderLineId; // 订单行号
    private BigDecimal qualifiedQty; // 合格数量(必须大于0)
    private BigDecimal unqualifiedQty; // 不合格数量

    //入库单有
    private String itemDesc; // 物料短描述
    private String itemDescMore; // 物料长描述

    private Long bpoDeliveryId; // 到货通知单号
    private Long bpoDeliveryLineId; // 到货通知单行号
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date accountTime; // 收货日期

    public Long getBpoOrderLineId() {
        return bpoOrderLineId;
    }

    public void setBpoOrderLineId(Long bpoOrderLineId) {
        this.bpoOrderLineId = bpoOrderLineId;
    }

    public String getItemDesc() {
        return itemDesc;
    }

    public void setItemDesc(String itemDesc) {
        this.itemDesc = itemDesc;
    }

    public String getItemDescMore() {
        return itemDescMore;
    }

    public void setItemDescMore(String itemDescMore) {
        this.itemDescMore = itemDescMore;
    }

    public Long getBpoDeliveryId() {
        return bpoDeliveryId;
    }

    public void setBpoDeliveryId(Long bpoDeliveryId) {
        this.bpoDeliveryId = bpoDeliveryId;
    }

    public Long getBpoDeliveryLineId() {
        return bpoDeliveryLineId;
    }

    public void setBpoDeliveryLineId(Long bpoDeliveryLineId) {
        this.bpoDeliveryLineId = bpoDeliveryLineId;
    }

    public Date getAccountTime() {
        return accountTime;
    }

    public void setAccountTime(Date accountTime) {
        this.accountTime = accountTime;
    }

    public Long getBpoLineId() {
        return bpoLineId;
    }

    public void setBpoLineId(Long bpoLineId) {
        this.bpoLineId = bpoLineId;
    }

    public Long getBpoOrderId() {
        return bpoOrderId;
    }

    public void setBpoOrderId(Long bpoOrderId) {
        this.bpoOrderId = bpoOrderId;
    }

    public BigDecimal getQualifiedQty() {
        return qualifiedQty;
    }

    public void setQualifiedQty(BigDecimal qualifiedQty) {
        this.qualifiedQty = qualifiedQty;
    }

    public BigDecimal getUnqualifiedQty() {
        return unqualifiedQty;
    }

    public void setUnqualifiedQty(BigDecimal unqualifiedQty) {
        this.unqualifiedQty = unqualifiedQty;
    }

    public BigDecimal getOrderNumsSum() {
        return orderNumsSum;
    }

    public void setOrderNumsSum(BigDecimal orderNumsSum) {
        this.orderNumsSum = orderNumsSum;
    }

    public Date getDeliveryDate() {
        return deliveryDate;
    }

    public void setDeliveryDate(Date deliveryDate) {
        this.deliveryDate = deliveryDate;
    }

    @ReferSerialTransfer(referCode = "financial-org-ref")
    public Long getFinanceId() {
        return financeId;
    }
    @ReferDeserialTransfer
    public void setFinanceId(Long financeId) {
        this.financeId = financeId;
    }

    public String getFinanceCode() {
        return financeCode;
    }

    public void setFinanceCode(String financeCode) {
        this.financeCode = financeCode;
    }

    public String getFinanceName() {
        return financeName;
    }

    public void setFinanceName(String financeName) {
        this.financeName = financeName;
    }

    public String getOrderCode() {
        return orderCode;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    public String getMaterialQuality() {
        return materialQuality;
    }

    public void setMaterialQuality(String materialQuality) {
        this.materialQuality = materialQuality;
    }

    public String getManufacturer() {
        return manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public Integer getConsumableFlag() {
        return consumableFlag;
    }

    public void setConsumableFlag(Integer consumableFlag) {
        this.consumableFlag = consumableFlag;
    }
    public String getGuidePriceArea() {
        return guidePriceArea;
    }

    public void setGuidePriceArea(String guidePriceArea) {
        this.guidePriceArea = guidePriceArea;
    }

    public String getGuideTaxPriceArea() {
        return guideTaxPriceArea;
    }

    public void setGuideTaxPriceArea(String guideTaxPriceArea) {
        this.guideTaxPriceArea = guideTaxPriceArea;
    }

    public Integer getDetailAutomaticWeigh() {
        return detailAutomaticWeigh;
    }

    public void setDetailAutomaticWeigh(Integer detailAutomaticWeigh) {
        this.detailAutomaticWeigh = detailAutomaticWeigh;
    }

    public BigDecimal getDetailNetWeightCoefficient() {
        return detailNetWeightCoefficient;
    }

    public void setDetailNetWeightCoefficient(BigDecimal detailNetWeightCoefficient) {
        this.detailNetWeightCoefficient = detailNetWeightCoefficient;
    }


    public BigDecimal getDetailCoefficient() {
        return detailCoefficient;
    }

    public void setDetailCoefficient(BigDecimal detailCoefficient) {
        this.detailCoefficient = detailCoefficient;
    }

    public BigDecimal getDetailNetWeight() {
        return detailNetWeight;
    }

    public void setDetailNetWeight(BigDecimal detailNetWeight) {
        this.detailNetWeight = detailNetWeight;
    }

    public Integer getContractFlag() {
        return contractFlag;
    }

    public void setContractFlag(Integer contractFlag) {
        this.contractFlag = contractFlag;
    }

    public String getHistoryPriceArea() {
        return historyPriceArea;
    }

    public void setHistoryPriceArea(String historyPriceArea) {
        this.historyPriceArea = historyPriceArea;
    }

    public String getHistoryTaxPriceArea() {
        return historyTaxPriceArea;
    }

    public void setHistoryTaxPriceArea(String historyTaxPriceArea) {
        this.historyTaxPriceArea = historyTaxPriceArea;
    }

    public BigDecimal getContractNumsSum() {
        return contractNumsSum;
    }

    public void setContractNumsSum(BigDecimal contractNumsSum) {
        this.contractNumsSum = contractNumsSum;
    }

    @ReferSerialTransfer(referCode = "subject-project-wbs-ref")
    public Long getWbsId() {
        return wbsId;
    }
    @ReferDeserialTransfer
    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }

    public String getWbsCode() {
        return wbsCode;
    }

    public void setWbsCode(String wbsCode) {
        this.wbsCode = wbsCode;
    }

    public String getWbsName() {
        return wbsName;
    }

    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }

    @ReferSerialTransfer(referCode = "subject-project-org-ref")
    public Long getSubjectId() {
        return subjectId;
    }
    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    /**
     * 验收主键ID
     */
    public Long getCheckId() {
        return checkId;
    }

    /**
     * 验收主键ID
     */
    public void setCheckId(Long checkId) {
        this.checkId = checkId;
    }
    /**
     * 发货主键ID
     */
    public Long getDeliveryId() {
        return deliveryId;
    }

    /**
     * 发货主键ID
     */
    public void setDeliveryId(Long deliveryId) {
        this.deliveryId = deliveryId;
    }
    /**
     * 发货明细主键ID
     */
    public Long getDeliveryDetailId() {
        return deliveryDetailId;
    }

    /**
     * 发货明细主键ID
     */
    public void setDeliveryDetailId(Long deliveryDetailId) {
        this.deliveryDetailId = deliveryDetailId;
    }
    /**
     * 订单主键ID
     */
    public Long getOrderId() {
        return orderId;
    }

    /**
     * 订单主键ID
     */
    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }
    /**
     * 订单明细主键ID
     */
    public Long getOrderDetailId() {
        return orderDetailId;
    }

    /**
     * 订单明细主键ID
     */
    public void setOrderDetailId(Long orderDetailId) {
        this.orderDetailId = orderDetailId;
    }
    /**
     * 物资主键
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 物资主键
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 物资类别
     */
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    /**
     * 物资类别
     */
    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    /**
     * 物资类别名称
     */
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 物资类别名称
     */
    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 物料编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 物料编码
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 单位名称
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 单位名称
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 单位主键
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 单位主键
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 发货数量
     */
    public BigDecimal getDeliverNum() {
        return deliverNum;
    }

    /**
     * 发货数量
     */
    public void setDeliverNum(BigDecimal deliverNum) {
        this.deliverNum = deliverNum;
    }
    /**
     * 验收数量
     */
    public BigDecimal getCheckNum() {
        return checkNum;
    }

    /**
     * 验收数量
     */
    public void setCheckNum(BigDecimal checkNum) {
        this.checkNum = checkNum;
    }
    /**
     * 验收金额(无税)
     */
    public BigDecimal getCheckMny() {
        return checkMny;
    }

    /**
     * 验收金额(无税)
     */
    public void setCheckMny(BigDecimal checkMny) {
        this.checkMny = checkMny;
    }
    /**
     * 验收金额(含税)
     */
    public BigDecimal getCheckTaxMny() {
        return checkTaxMny;
    }

    /**
     * 验收金额(含税)
     */
    public void setCheckTaxMny(BigDecimal checkTaxMny) {
        this.checkTaxMny = checkTaxMny;
    }
    /**
     * 验收单价(无税)
     */
    public BigDecimal getCheckPrice() {
        return checkPrice;
    }

    /**
     * 验收单价(无税)
     */
    public void setCheckPrice(BigDecimal checkPrice) {
        this.checkPrice = checkPrice;
    }
    /**
     * 验收单价(含税)
     */
    public BigDecimal getCheckTaxPrice() {
        return checkTaxPrice;
    }

    /**
     * 验收单价(含税)
     */
    public void setCheckTaxPrice(BigDecimal checkTaxPrice) {
        this.checkTaxPrice = checkTaxPrice;
    }
    /**
     * 综合验收单价(无税)
     */
    public BigDecimal getCheckPriceOverall() {
        return checkPriceOverall;
    }

    /**
     * 综合验收单价(无税)
     */
    public void setCheckPriceOverall(BigDecimal checkPriceOverall) {
        this.checkPriceOverall = checkPriceOverall;
    }
    /**
     * 综合验收单价(含税)
     */
    public BigDecimal getCheckTaxPriceOverall() {
        return checkTaxPriceOverall;
    }

    /**
     * 综合验收单价(含税)
     */
    public void setCheckTaxPriceOverall(BigDecimal checkTaxPriceOverall) {
        this.checkTaxPriceOverall = checkTaxPriceOverall;
    }
    /**
     * 税额
     */
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 税额
     */
    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    /**
     * 税率
     */
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 税率
     */
    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 使用部位
     */
    public String getConstruction() {
        return construction;
    }

    /**
     * 使用部位
     */
    public void setConstruction(String construction) {
        this.construction = construction;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
