package com.ejianc.business.promaterial.delivery.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 混凝土-发货主表--保存查看用
 * 
 * @author generator
 * 
 */
@ApiModel("混凝土-发货主表")
public class ConcreteDeliverySaveVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("来源发货单主键")
    private Long sourceId;
    @ApiModelProperty("订单主键")
    private Long orderId;
    @ApiModelProperty("订单单据编号")
    private String orderBillCode;
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("合同主键")
    private Long contractId;
    @ApiModelProperty("合同名称")
    private String contractName;
    @ApiModelProperty("合同code")
    private String contractCode;
    @ApiModelProperty("项目")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("项目code")
    private String projectCode;
    @ApiModelProperty("供应商主键")
    private Long supplierId;
    @ApiModelProperty("供应商名称")
    private String supplierName;
    @ApiModelProperty("经办人")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    private String employeeName;
    @ApiModelProperty("送货人名称")
    private String deliverName;
    @ApiModelProperty("送货人联系电话")
    private String deliverPhone;
    @ApiModelProperty("预计到货日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date arriveDate;
    @ApiModelProperty("车牌号")
    private String licensePlate;
    @ApiModelProperty("经办部门")
    private Long departmentId;
    @ApiModelProperty("经办部门名称")
    private String departmentName;
    @ApiModelProperty("是否关闭，0-否，1-是")
    private Integer closeFlag;
    @ApiModelProperty("验收状态，0-待接收,1-部分接收,2-全部接收")
    private Integer checkStatus;
    @ApiModelProperty("组织")
    private Long orgId;
    @ApiModelProperty("组织名称")
    private String orgName;
    private String checkType;
    private String checkTypeName;
    @ApiModelProperty("验收来源，0-自制验收,1-发货验收")
    private Integer sourceType;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("使用部位")
    private String construction;
    @ApiModelProperty("父级组织名称")
    private String parentOrgName;
    @ApiModelProperty("父级组织")
    private Long parentOrgId;
    @ApiModelProperty("小票数量")
    private BigDecimal ticketNum;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    private String isPushThird; // 推送第三方是否成功 sucPushed   unSucPush
    private String unSucReason;//失败原因
    private Integer automaticWeigh; // 自动称重设置（0：自动称重，1非自动称重）
    private Integer deliveryType; // 类型 1-自制，2-供方推送（订单）
    private Integer checkWeighNum; // 已验收磅单数量
    private Integer weighNum; // 磅单数量

    @ApiModelProperty("混凝土-发货子表")
    private List<ConcreteDeliveryDetailVO> concreteDeliveryDetailList = new ArrayList<>();

    private List<ConcreteDeliveryAdmixtureVO> concreteDeliveryAdmixtureList = new ArrayList<>(); // 混凝土-发货外加剂

    public List<ConcreteDeliveryAdmixtureVO> getConcreteDeliveryAdmixtureList() {
        return concreteDeliveryAdmixtureList;
    }

    public void setConcreteDeliveryAdmixtureList(List<ConcreteDeliveryAdmixtureVO> concreteDeliveryAdmixtureList) {
        this.concreteDeliveryAdmixtureList = concreteDeliveryAdmixtureList;
    }

    public Integer getCheckWeighNum() {
        return checkWeighNum;
    }

    public void setCheckWeighNum(Integer checkWeighNum) {
        this.checkWeighNum = checkWeighNum;
    }

    public Integer getWeighNum() {
        return weighNum;
    }

    public void setWeighNum(Integer weighNum) {
        this.weighNum = weighNum;
    }

    public Integer getDeliveryType() {
        return deliveryType;
    }

    public void setDeliveryType(Integer deliveryType) {
        this.deliveryType = deliveryType;
    }

    public String getUnSucReason() {
        return unSucReason;
    }

    public void setUnSucReason(String unSucReason) {
        this.unSucReason = unSucReason;
    }

    public Integer getAutomaticWeigh() {
        return automaticWeigh;
    }

    public void setAutomaticWeigh(Integer automaticWeigh) {
        this.automaticWeigh = automaticWeigh;
    }

    public String getIsPushThird() {
        return isPushThird;
    }

    public void setIsPushThird(String isPushThird) {
        this.isPushThird = isPushThird;
    }

    /**
     * 来源发货单主键
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源发货单主键
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 订单主键
     */
    public Long getOrderId() {
        return orderId;
    }

    /**
     * 订单主键
     */
    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }
    /**
     * 订单单据编号
     */
    public String getOrderBillCode() {
        return orderBillCode;
    }

    /**
     * 订单单据编号
     */
    public void setOrderBillCode(String orderBillCode) {
        this.orderBillCode = orderBillCode;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 合同主键
     */
    @ReferSerialTransfer(referCode = "contractMaterial")
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同code
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同code
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目code
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目code
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 供应商主键
     */
    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商主键
     */
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 经办人
     */
//    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
//    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 送货人名称
     */
    public String getDeliverName() {
        return deliverName;
    }

    /**
     * 送货人名称
     */
    public void setDeliverName(String deliverName) {
        this.deliverName = deliverName;
    }
    /**
     * 送货人联系电话
     */
    public String getDeliverPhone() {
        return deliverPhone;
    }

    /**
     * 送货人联系电话
     */
    public void setDeliverPhone(String deliverPhone) {
        this.deliverPhone = deliverPhone;
    }
    /**
     * 预计到货日期
     */
    public Date getArriveDate() {
        return arriveDate;
    }

    /**
     * 预计到货日期
     */
    public void setArriveDate(Date arriveDate) {
        this.arriveDate = arriveDate;
    }
    /**
     * 车牌号
     */
    public String getLicensePlate() {
        return licensePlate;
    }

    /**
     * 车牌号
     */
    public void setLicensePlate(String licensePlate) {
        this.licensePlate = licensePlate;
    }
    /**
     * 经办部门
     */
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办部门
     */
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办部门名称
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 是否关闭，0-否，1-是
     */
    public Integer getCloseFlag() {
        return closeFlag;
    }

    /**
     * 是否关闭，0-否，1-是
     */
    public void setCloseFlag(Integer closeFlag) {
        this.closeFlag = closeFlag;
    }
    /**
     * 验收状态，0-待接收,1-部分接收,2-全部接收
     */
    public Integer getCheckStatus() {
        return checkStatus;
    }

    /**
     * 验收状态，0-待接收,1-部分接收,2-全部接收
     */
    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 验收类型，proMaterial-1,大宗材
proMaterial-2,周转材
proMaterial-3,零星材料
proMaterial-4, 甲供材
     */
    public String getCheckType() {
        return checkType;
    }

    /**
     * 验收类型，proMaterial-1,大宗材
proMaterial-2,周转材
proMaterial-3,零星材料
proMaterial-4, 甲供材
     */
    public void setCheckType(String checkType) {
        this.checkType = checkType;
    }
    /**
     * 验收类型，proMaterial-1,大宗材
proMaterial-2,周转材
proMaterial-3,零星材料
proMaterial-4, 甲供材
     */
    public String getCheckTypeName() {
        return checkTypeName;
    }

    /**
     * 验收类型，proMaterial-1,大宗材
proMaterial-2,周转材
proMaterial-3,零星材料
proMaterial-4, 甲供材
     */
    public void setCheckTypeName(String checkTypeName) {
        this.checkTypeName = checkTypeName;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 使用部位
     */
    public String getConstruction() {
        return construction;
    }

    /**
     * 使用部位
     */
    public void setConstruction(String construction) {
        this.construction = construction;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 小票数量
     */
    public BigDecimal getTicketNum() {
        return ticketNum;
    }

    /**
     * 小票数量
     */
    public void setTicketNum(BigDecimal ticketNum) {
        this.ticketNum = ticketNum;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
     /**
      * 混凝土-发货子表
      */
      public List<ConcreteDeliveryDetailVO> getConcreteDeliveryDetailList() {
         return concreteDeliveryDetailList;
      }
     /**
      * 混凝土-发货子表
      */
     public void setConcreteDeliveryDetailList(List<ConcreteDeliveryDetailVO> concreteDeliveryDetailList) {
         this.concreteDeliveryDetailList = concreteDeliveryDetailList;
     }
}
