package com.ejianc.business.promaterial.different.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.ejianc.business.promaterial.different.vo.DifferentDetailVO;

/**
 * 调差单主表
 * 
 * @author generator
 * 
 */
@ApiModel("调差单主表")
public class DifferentVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("项目")
    private Long projectId;
    @ApiModelProperty("项目编码")
    private String projectCode;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("组织")
    private Long orgId;
    @ApiModelProperty("组织名称")
    private String orgName;
    @ApiModelProperty("项目部上级组织Id")
    private Long parentOrgId;
    @ApiModelProperty("项目部上级组织名称")
    private String parentOrgName;
    private String parentOrgCode; // 项目部上级组织名称
    @ApiModelProperty("合同主键")
    private Long contractId;
    @ApiModelProperty("合同名称")
    private String contractName;
    @ApiModelProperty("合同编号")
    private String contractCode;
    @ApiModelProperty("供应商")
    private Long supplierId;
    @ApiModelProperty("供应商名称")
    private String supplierName;
    @ApiModelProperty("经办人")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    private String employeeName;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty("调整日期")
    private Date differentDate;
    @ApiModelProperty("实际成本 0-未分摊，1-已分摊")
    private Integer costType;
    @ApiModelProperty("结算主键ID")
    private Long settlementId;
    @ApiModelProperty("结算单据编号")
    private String settlementCode;
    @ApiModelProperty("物资类别名称")
    private String materialTypeName;
    @ApiModelProperty("调差金额(无税)")
    private BigDecimal diffMny;
    @ApiModelProperty("调差金额")
    private BigDecimal diffTaxMny;
    @ApiModelProperty("调差税额")
    private BigDecimal diffTax;
    @ApiModelProperty("成本金额(无税)")
    private BigDecimal costMny;
    @ApiModelProperty("成本金额")
    private BigDecimal costTaxMny;
    @ApiModelProperty("对账单类型（0-物资采购结算单，1-混凝土结算单）")
    private Integer settlementType;
    private String relationFlag; // 关联状态(1:是，0：否)
    private String proportionFlag; // 分摊状态(1:是，0：否)
    @ApiModelProperty("调差单子表")
    private List<DifferentDetailVO> differentDetailList = new ArrayList<>();

    private String orgCode; // 组织名称

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }

    public Integer getSettlementType() {
        return settlementType;
    }

    public void setSettlementType(Integer settlementType) {
        this.settlementType = settlementType;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目编码
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编码
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部上级组织Id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部上级组织Id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目部上级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 项目部上级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 合同主键
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同编号
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编号
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 供应商
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 经办人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 调整日期
     */
    public Date getDifferentDate() {
        return differentDate;
    }

    /**
     * 调整日期
     */
    public void setDifferentDate(Date differentDate) {
        this.differentDate = differentDate;
    }
    /**
     * 实际成本 0-未分摊，1-已分摊
     */
    public Integer getCostType() {
        return costType;
    }

    /**
     * 实际成本 0-未分摊，1-已分摊
     */
    public void setCostType(Integer costType) {
        this.costType = costType;
    }
    /**
     * 结算主键ID
     */
    public Long getSettlementId() {
        return settlementId;
    }

    /**
     * 结算主键ID
     */
    public void setSettlementId(Long settlementId) {
        this.settlementId = settlementId;
    }
    /**
     * 结算单据编号
     */
    public String getSettlementCode() {
        return settlementCode;
    }

    /**
     * 结算单据编号
     */
    public void setSettlementCode(String settlementCode) {
        this.settlementCode = settlementCode;
    }
    /**
     * 物资类别名称
     */
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 物资类别名称
     */
    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 调差金额(无税)
     */
    public BigDecimal getDiffMny() {
        return diffMny;
    }

    /**
     * 调差金额(无税)
     */
    public void setDiffMny(BigDecimal diffMny) {
        this.diffMny = diffMny;
    }
    /**
     * 调差金额
     */
    public BigDecimal getDiffTaxMny() {
        return diffTaxMny;
    }

    /**
     * 调差金额
     */
    public void setDiffTaxMny(BigDecimal diffTaxMny) {
        this.diffTaxMny = diffTaxMny;
    }
    /**
     * 调差税额
     */
    public BigDecimal getDiffTax() {
        return diffTax;
    }

    /**
     * 调差税额
     */
    public void setDiffTax(BigDecimal diffTax) {
        this.diffTax = diffTax;
    }
    /**
     * 成本金额(无税)
     */
    public BigDecimal getCostMny() {
        return costMny;
    }

    /**
     * 成本金额(无税)
     */
    public void setCostMny(BigDecimal costMny) {
        this.costMny = costMny;
    }
    /**
     * 成本金额
     */
    public BigDecimal getCostTaxMny() {
        return costTaxMny;
    }

    /**
     * 成本金额
     */
    public void setCostTaxMny(BigDecimal costTaxMny) {
        this.costTaxMny = costTaxMny;
    }
    
     /**
      * 调差单子表
      */
      public List<DifferentDetailVO> getDifferentDetailList() {
         return differentDetailList;
      }
     /**
      * 调差单子表
      */
     public void setDifferentDetailList(List<DifferentDetailVO> differentDetailList) {
         this.differentDetailList = differentDetailList;
     }
}
